import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleKmsKeyRingImportJobConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_kms_key_ring_import_job#id GoogleKmsKeyRingImportJob#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * It must be unique within a KeyRing and match the regular expression [a-zA-Z0-9_-]{1,63}
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_kms_key_ring_import_job#import_job_id GoogleKmsKeyRingImportJob#import_job_id}
    */
    readonly importJobId: string;
    /**
    * The wrapping method to be used for incoming key material. Possible values: ["RSA_OAEP_3072_SHA1_AES_256", "RSA_OAEP_4096_SHA1_AES_256"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_kms_key_ring_import_job#import_method GoogleKmsKeyRingImportJob#import_method}
    */
    readonly importMethod: string;
    /**
    * The KeyRing that this import job belongs to.
  Format: ''projects/{{project}}/locations/{{location}}/keyRings/{{keyRing}}''.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_kms_key_ring_import_job#key_ring GoogleKmsKeyRingImportJob#key_ring}
    */
    readonly keyRing: string;
    /**
    * The protection level of the ImportJob. This must match the protectionLevel of the
  versionTemplate on the CryptoKey you attempt to import into. Possible values: ["SOFTWARE", "HSM", "EXTERNAL"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_kms_key_ring_import_job#protection_level GoogleKmsKeyRingImportJob#protection_level}
    */
    readonly protectionLevel: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_kms_key_ring_import_job#timeouts GoogleKmsKeyRingImportJob#timeouts}
    */
    readonly timeouts?: GoogleKmsKeyRingImportJobTimeouts;
}
export interface GoogleKmsKeyRingImportJobAttestation {
}
export declare function googleKmsKeyRingImportJobAttestationToTerraform(struct?: GoogleKmsKeyRingImportJobAttestation): any;
export declare class GoogleKmsKeyRingImportJobAttestationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleKmsKeyRingImportJobAttestation | undefined;
    set internalValue(value: GoogleKmsKeyRingImportJobAttestation | undefined);
    get content(): string;
    get format(): string;
}
export declare class GoogleKmsKeyRingImportJobAttestationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleKmsKeyRingImportJobAttestationOutputReference;
}
export interface GoogleKmsKeyRingImportJobPublicKey {
}
export declare function googleKmsKeyRingImportJobPublicKeyToTerraform(struct?: GoogleKmsKeyRingImportJobPublicKey): any;
export declare class GoogleKmsKeyRingImportJobPublicKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleKmsKeyRingImportJobPublicKey | undefined;
    set internalValue(value: GoogleKmsKeyRingImportJobPublicKey | undefined);
    get pem(): string;
}
export declare class GoogleKmsKeyRingImportJobPublicKeyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleKmsKeyRingImportJobPublicKeyOutputReference;
}
export interface GoogleKmsKeyRingImportJobTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_kms_key_ring_import_job#create GoogleKmsKeyRingImportJob#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_kms_key_ring_import_job#delete GoogleKmsKeyRingImportJob#delete}
    */
    readonly delete?: string;
}
export declare function googleKmsKeyRingImportJobTimeoutsToTerraform(struct?: GoogleKmsKeyRingImportJobTimeouts | cdktf.IResolvable): any;
export declare class GoogleKmsKeyRingImportJobTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleKmsKeyRingImportJobTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleKmsKeyRingImportJobTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_kms_key_ring_import_job google_kms_key_ring_import_job}
*/
export declare class GoogleKmsKeyRingImportJob extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_kms_key_ring_import_job";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_kms_key_ring_import_job google_kms_key_ring_import_job} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleKmsKeyRingImportJobConfig
    */
    constructor(scope: Construct, id: string, config: GoogleKmsKeyRingImportJobConfig);
    private _attestation;
    get attestation(): GoogleKmsKeyRingImportJobAttestationList;
    get expireTime(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _importJobId?;
    get importJobId(): string;
    set importJobId(value: string);
    get importJobIdInput(): string | undefined;
    private _importMethod?;
    get importMethod(): string;
    set importMethod(value: string);
    get importMethodInput(): string | undefined;
    private _keyRing?;
    get keyRing(): string;
    set keyRing(value: string);
    get keyRingInput(): string | undefined;
    get name(): string;
    private _protectionLevel?;
    get protectionLevel(): string;
    set protectionLevel(value: string);
    get protectionLevelInput(): string | undefined;
    private _publicKey;
    get publicKey(): GoogleKmsKeyRingImportJobPublicKeyList;
    get state(): string;
    private _timeouts;
    get timeouts(): GoogleKmsKeyRingImportJobTimeoutsOutputReference;
    putTimeouts(value: GoogleKmsKeyRingImportJobTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleKmsKeyRingImportJobTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
