import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleKmsKeyRingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_kms_key_ring#id GoogleKmsKeyRing#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The location for the KeyRing.
  A full list of valid locations can be found by running 'gcloud kms locations list'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_kms_key_ring#location GoogleKmsKeyRing#location}
    */
    readonly location: string;
    /**
    * The resource name for the KeyRing.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_kms_key_ring#name GoogleKmsKeyRing#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_kms_key_ring#project GoogleKmsKeyRing#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_kms_key_ring#timeouts GoogleKmsKeyRing#timeouts}
    */
    readonly timeouts?: GoogleKmsKeyRingTimeouts;
}
export interface GoogleKmsKeyRingTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_kms_key_ring#create GoogleKmsKeyRing#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_kms_key_ring#delete GoogleKmsKeyRing#delete}
    */
    readonly delete?: string;
}
export declare function googleKmsKeyRingTimeoutsToTerraform(struct?: GoogleKmsKeyRingTimeouts | cdktf.IResolvable): any;
export declare class GoogleKmsKeyRingTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleKmsKeyRingTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleKmsKeyRingTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_kms_key_ring google_kms_key_ring}
*/
export declare class GoogleKmsKeyRing extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_kms_key_ring";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_kms_key_ring google_kms_key_ring} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleKmsKeyRingConfig
    */
    constructor(scope: Construct, id: string, config: GoogleKmsKeyRingConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleKmsKeyRingTimeoutsOutputReference;
    putTimeouts(value: GoogleKmsKeyRingTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleKmsKeyRingTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
