import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleLoggingLinkedDatasetConfig extends cdktf.TerraformMetaArguments {
    /**
    * The bucket to which the linked dataset is attached.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_linked_dataset#bucket GoogleLoggingLinkedDataset#bucket}
    */
    readonly bucket: string;
    /**
    * Describes this link. The maximum length of the description is 8000 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_linked_dataset#description GoogleLoggingLinkedDataset#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_linked_dataset#id GoogleLoggingLinkedDataset#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The id of the linked dataset.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_linked_dataset#link_id GoogleLoggingLinkedDataset#link_id}
    */
    readonly linkId: string;
    /**
    * The location of the linked dataset.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_linked_dataset#location GoogleLoggingLinkedDataset#location}
    */
    readonly location?: string;
    /**
    * The parent of the linked dataset.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_linked_dataset#parent GoogleLoggingLinkedDataset#parent}
    */
    readonly parent?: string;
    /**
    * bigquery_dataset block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_linked_dataset#bigquery_dataset GoogleLoggingLinkedDataset#bigquery_dataset}
    */
    readonly bigqueryDataset?: GoogleLoggingLinkedDatasetBigqueryDataset[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_linked_dataset#timeouts GoogleLoggingLinkedDataset#timeouts}
    */
    readonly timeouts?: GoogleLoggingLinkedDatasetTimeouts;
}
export interface GoogleLoggingLinkedDatasetBigqueryDataset {
}
export declare function googleLoggingLinkedDatasetBigqueryDatasetToTerraform(struct?: GoogleLoggingLinkedDatasetBigqueryDataset | cdktf.IResolvable): any;
export declare class GoogleLoggingLinkedDatasetBigqueryDatasetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleLoggingLinkedDatasetBigqueryDataset | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleLoggingLinkedDatasetBigqueryDataset | cdktf.IResolvable | undefined);
    get datasetId(): string;
}
export declare class GoogleLoggingLinkedDatasetBigqueryDatasetList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleLoggingLinkedDatasetBigqueryDataset[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleLoggingLinkedDatasetBigqueryDatasetOutputReference;
}
export interface GoogleLoggingLinkedDatasetTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_linked_dataset#create GoogleLoggingLinkedDataset#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_linked_dataset#delete GoogleLoggingLinkedDataset#delete}
    */
    readonly delete?: string;
}
export declare function googleLoggingLinkedDatasetTimeoutsToTerraform(struct?: GoogleLoggingLinkedDatasetTimeouts | cdktf.IResolvable): any;
export declare class GoogleLoggingLinkedDatasetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleLoggingLinkedDatasetTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleLoggingLinkedDatasetTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_linked_dataset google_logging_linked_dataset}
*/
export declare class GoogleLoggingLinkedDataset extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_logging_linked_dataset";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_linked_dataset google_logging_linked_dataset} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleLoggingLinkedDatasetConfig
    */
    constructor(scope: Construct, id: string, config: GoogleLoggingLinkedDatasetConfig);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get lifecycleState(): string;
    private _linkId?;
    get linkId(): string;
    set linkId(value: string);
    get linkIdInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    get name(): string;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    resetParent(): void;
    get parentInput(): string | undefined;
    private _bigqueryDataset;
    get bigqueryDataset(): GoogleLoggingLinkedDatasetBigqueryDatasetList;
    putBigqueryDataset(value: GoogleLoggingLinkedDatasetBigqueryDataset[] | cdktf.IResolvable): void;
    resetBigqueryDataset(): void;
    get bigqueryDatasetInput(): cdktf.IResolvable | GoogleLoggingLinkedDatasetBigqueryDataset[] | undefined;
    private _timeouts;
    get timeouts(): GoogleLoggingLinkedDatasetTimeoutsOutputReference;
    putTimeouts(value: GoogleLoggingLinkedDatasetTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleLoggingLinkedDatasetTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
