import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleLoggingMetricConfig extends cdktf.TerraformMetaArguments {
    /**
    * The resource name of the Log Bucket that owns the Log Metric. Only Log Buckets in projects
  are supported. The bucket has to be in the same project as the metric.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_metric#bucket_name GoogleLoggingMetric#bucket_name}
    */
    readonly bucketName?: string;
    /**
    * A description of this metric, which is used in documentation. The maximum length of the
  description is 8000 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_metric#description GoogleLoggingMetric#description}
    */
    readonly description?: string;
    /**
    * If set to True, then this metric is disabled and it does not generate any points.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_metric#disabled GoogleLoggingMetric#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * An advanced logs filter (https://cloud.google.com/logging/docs/view/advanced-filters) which
  is used to match log entries.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_metric#filter GoogleLoggingMetric#filter}
    */
    readonly filter: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_metric#id GoogleLoggingMetric#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A map from a label key string to an extractor expression which is used to extract data from a log
  entry field and assign as the label value. Each label key specified in the LabelDescriptor must
  have an associated extractor expression in this map. The syntax of the extractor expression is
  the same as for the valueExtractor field.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_metric#label_extractors GoogleLoggingMetric#label_extractors}
    */
    readonly labelExtractors?: {
        [key: string]: string;
    };
    /**
    * The client-assigned metric identifier. Examples - "error_count", "nginx/requests".
  Metric identifiers are limited to 100 characters and can include only the following
  characters A-Z, a-z, 0-9, and the special characters _-.,+!*',()%/. The forward-slash
  character (/) denotes a hierarchy of name pieces, and it cannot be the first character
  of the name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_metric#name GoogleLoggingMetric#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_metric#project GoogleLoggingMetric#project}
    */
    readonly project?: string;
    /**
    * A valueExtractor is required when using a distribution logs-based metric to extract the values to
  record from a log entry. Two functions are supported for value extraction - EXTRACT(field) or
  REGEXP_EXTRACT(field, regex). The argument are 1. field - The name of the log entry field from which
  the value is to be extracted. 2. regex - A regular expression using the Google RE2 syntax
  (https://github.com/google/re2/wiki/Syntax) with a single capture group to extract data from the specified
  log entry field. The value of the field is converted to a string before applying the regex. It is an
  error to specify a regex that does not include exactly one capture group.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_metric#value_extractor GoogleLoggingMetric#value_extractor}
    */
    readonly valueExtractor?: string;
    /**
    * bucket_options block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_metric#bucket_options GoogleLoggingMetric#bucket_options}
    */
    readonly bucketOptions?: GoogleLoggingMetricBucketOptions;
    /**
    * metric_descriptor block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_metric#metric_descriptor GoogleLoggingMetric#metric_descriptor}
    */
    readonly metricDescriptor?: GoogleLoggingMetricMetricDescriptor;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_metric#timeouts GoogleLoggingMetric#timeouts}
    */
    readonly timeouts?: GoogleLoggingMetricTimeouts;
}
export interface GoogleLoggingMetricBucketOptionsExplicitBuckets {
    /**
    * The values must be monotonically increasing.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_metric#bounds GoogleLoggingMetric#bounds}
    */
    readonly bounds: number[];
}
export declare function googleLoggingMetricBucketOptionsExplicitBucketsToTerraform(struct?: GoogleLoggingMetricBucketOptionsExplicitBucketsOutputReference | GoogleLoggingMetricBucketOptionsExplicitBuckets): any;
export declare class GoogleLoggingMetricBucketOptionsExplicitBucketsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleLoggingMetricBucketOptionsExplicitBuckets | undefined;
    set internalValue(value: GoogleLoggingMetricBucketOptionsExplicitBuckets | undefined);
    private _bounds?;
    get bounds(): number[];
    set bounds(value: number[]);
    get boundsInput(): number[] | undefined;
}
export interface GoogleLoggingMetricBucketOptionsExponentialBuckets {
    /**
    * Must be greater than 1.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_metric#growth_factor GoogleLoggingMetric#growth_factor}
    */
    readonly growthFactor?: number;
    /**
    * Must be greater than 0.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_metric#num_finite_buckets GoogleLoggingMetric#num_finite_buckets}
    */
    readonly numFiniteBuckets?: number;
    /**
    * Must be greater than 0.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_metric#scale GoogleLoggingMetric#scale}
    */
    readonly scale?: number;
}
export declare function googleLoggingMetricBucketOptionsExponentialBucketsToTerraform(struct?: GoogleLoggingMetricBucketOptionsExponentialBucketsOutputReference | GoogleLoggingMetricBucketOptionsExponentialBuckets): any;
export declare class GoogleLoggingMetricBucketOptionsExponentialBucketsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleLoggingMetricBucketOptionsExponentialBuckets | undefined;
    set internalValue(value: GoogleLoggingMetricBucketOptionsExponentialBuckets | undefined);
    private _growthFactor?;
    get growthFactor(): number;
    set growthFactor(value: number);
    resetGrowthFactor(): void;
    get growthFactorInput(): number | undefined;
    private _numFiniteBuckets?;
    get numFiniteBuckets(): number;
    set numFiniteBuckets(value: number);
    resetNumFiniteBuckets(): void;
    get numFiniteBucketsInput(): number | undefined;
    private _scale?;
    get scale(): number;
    set scale(value: number);
    resetScale(): void;
    get scaleInput(): number | undefined;
}
export interface GoogleLoggingMetricBucketOptionsLinearBuckets {
    /**
    * Must be greater than 0.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_metric#num_finite_buckets GoogleLoggingMetric#num_finite_buckets}
    */
    readonly numFiniteBuckets?: number;
    /**
    * Lower bound of the first bucket.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_metric#offset GoogleLoggingMetric#offset}
    */
    readonly offset?: number;
    /**
    * Must be greater than 0.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_metric#width GoogleLoggingMetric#width}
    */
    readonly width?: number;
}
export declare function googleLoggingMetricBucketOptionsLinearBucketsToTerraform(struct?: GoogleLoggingMetricBucketOptionsLinearBucketsOutputReference | GoogleLoggingMetricBucketOptionsLinearBuckets): any;
export declare class GoogleLoggingMetricBucketOptionsLinearBucketsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleLoggingMetricBucketOptionsLinearBuckets | undefined;
    set internalValue(value: GoogleLoggingMetricBucketOptionsLinearBuckets | undefined);
    private _numFiniteBuckets?;
    get numFiniteBuckets(): number;
    set numFiniteBuckets(value: number);
    resetNumFiniteBuckets(): void;
    get numFiniteBucketsInput(): number | undefined;
    private _offset?;
    get offset(): number;
    set offset(value: number);
    resetOffset(): void;
    get offsetInput(): number | undefined;
    private _width?;
    get width(): number;
    set width(value: number);
    resetWidth(): void;
    get widthInput(): number | undefined;
}
export interface GoogleLoggingMetricBucketOptions {
    /**
    * explicit_buckets block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_metric#explicit_buckets GoogleLoggingMetric#explicit_buckets}
    */
    readonly explicitBuckets?: GoogleLoggingMetricBucketOptionsExplicitBuckets;
    /**
    * exponential_buckets block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_metric#exponential_buckets GoogleLoggingMetric#exponential_buckets}
    */
    readonly exponentialBuckets?: GoogleLoggingMetricBucketOptionsExponentialBuckets;
    /**
    * linear_buckets block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_metric#linear_buckets GoogleLoggingMetric#linear_buckets}
    */
    readonly linearBuckets?: GoogleLoggingMetricBucketOptionsLinearBuckets;
}
export declare function googleLoggingMetricBucketOptionsToTerraform(struct?: GoogleLoggingMetricBucketOptionsOutputReference | GoogleLoggingMetricBucketOptions): any;
export declare class GoogleLoggingMetricBucketOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleLoggingMetricBucketOptions | undefined;
    set internalValue(value: GoogleLoggingMetricBucketOptions | undefined);
    private _explicitBuckets;
    get explicitBuckets(): GoogleLoggingMetricBucketOptionsExplicitBucketsOutputReference;
    putExplicitBuckets(value: GoogleLoggingMetricBucketOptionsExplicitBuckets): void;
    resetExplicitBuckets(): void;
    get explicitBucketsInput(): GoogleLoggingMetricBucketOptionsExplicitBuckets | undefined;
    private _exponentialBuckets;
    get exponentialBuckets(): GoogleLoggingMetricBucketOptionsExponentialBucketsOutputReference;
    putExponentialBuckets(value: GoogleLoggingMetricBucketOptionsExponentialBuckets): void;
    resetExponentialBuckets(): void;
    get exponentialBucketsInput(): GoogleLoggingMetricBucketOptionsExponentialBuckets | undefined;
    private _linearBuckets;
    get linearBuckets(): GoogleLoggingMetricBucketOptionsLinearBucketsOutputReference;
    putLinearBuckets(value: GoogleLoggingMetricBucketOptionsLinearBuckets): void;
    resetLinearBuckets(): void;
    get linearBucketsInput(): GoogleLoggingMetricBucketOptionsLinearBuckets | undefined;
}
export interface GoogleLoggingMetricMetricDescriptorLabels {
    /**
    * A human-readable description for the label.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_metric#description GoogleLoggingMetric#description}
    */
    readonly description?: string;
    /**
    * The label key.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_metric#key GoogleLoggingMetric#key}
    */
    readonly key: string;
    /**
    * The type of data that can be assigned to the label. Default value: "STRING" Possible values: ["BOOL", "INT64", "STRING"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_metric#value_type GoogleLoggingMetric#value_type}
    */
    readonly valueType?: string;
}
export declare function googleLoggingMetricMetricDescriptorLabelsToTerraform(struct?: GoogleLoggingMetricMetricDescriptorLabels | cdktf.IResolvable): any;
export declare class GoogleLoggingMetricMetricDescriptorLabelsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleLoggingMetricMetricDescriptorLabels | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleLoggingMetricMetricDescriptorLabels | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _valueType?;
    get valueType(): string;
    set valueType(value: string);
    resetValueType(): void;
    get valueTypeInput(): string | undefined;
}
export declare class GoogleLoggingMetricMetricDescriptorLabelsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleLoggingMetricMetricDescriptorLabels[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleLoggingMetricMetricDescriptorLabelsOutputReference;
}
export interface GoogleLoggingMetricMetricDescriptor {
    /**
    * A concise name for the metric, which can be displayed in user interfaces. Use sentence case
  without an ending period, for example "Request count". This field is optional but it is
  recommended to be set for any metrics associated with user-visible concepts, such as Quota.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_metric#display_name GoogleLoggingMetric#display_name}
    */
    readonly displayName?: string;
    /**
    * Whether the metric records instantaneous values, changes to a value, etc.
  Some combinations of metricKind and valueType might not be supported.
  For counter metrics, set this to DELTA. Possible values: ["DELTA", "GAUGE", "CUMULATIVE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_metric#metric_kind GoogleLoggingMetric#metric_kind}
    */
    readonly metricKind: string;
    /**
    * The unit in which the metric value is reported. It is only applicable if the valueType is
  'INT64', 'DOUBLE', or 'DISTRIBUTION'. The supported units are a subset of
  [The Unified Code for Units of Measure](http://unitsofmeasure.org/ucum.html) standard
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_metric#unit GoogleLoggingMetric#unit}
    */
    readonly unit?: string;
    /**
    * Whether the measurement is an integer, a floating-point number, etc.
  Some combinations of metricKind and valueType might not be supported.
  For counter metrics, set this to INT64. Possible values: ["BOOL", "INT64", "DOUBLE", "STRING", "DISTRIBUTION", "MONEY"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_metric#value_type GoogleLoggingMetric#value_type}
    */
    readonly valueType: string;
    /**
    * labels block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_metric#labels GoogleLoggingMetric#labels}
    */
    readonly labels?: GoogleLoggingMetricMetricDescriptorLabels[] | cdktf.IResolvable;
}
export declare function googleLoggingMetricMetricDescriptorToTerraform(struct?: GoogleLoggingMetricMetricDescriptorOutputReference | GoogleLoggingMetricMetricDescriptor): any;
export declare class GoogleLoggingMetricMetricDescriptorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleLoggingMetricMetricDescriptor | undefined;
    set internalValue(value: GoogleLoggingMetricMetricDescriptor | undefined);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _metricKind?;
    get metricKind(): string;
    set metricKind(value: string);
    get metricKindInput(): string | undefined;
    private _unit?;
    get unit(): string;
    set unit(value: string);
    resetUnit(): void;
    get unitInput(): string | undefined;
    private _valueType?;
    get valueType(): string;
    set valueType(value: string);
    get valueTypeInput(): string | undefined;
    private _labels;
    get labels(): GoogleLoggingMetricMetricDescriptorLabelsList;
    putLabels(value: GoogleLoggingMetricMetricDescriptorLabels[] | cdktf.IResolvable): void;
    resetLabels(): void;
    get labelsInput(): cdktf.IResolvable | GoogleLoggingMetricMetricDescriptorLabels[] | undefined;
}
export interface GoogleLoggingMetricTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_metric#create GoogleLoggingMetric#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_metric#delete GoogleLoggingMetric#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_metric#update GoogleLoggingMetric#update}
    */
    readonly update?: string;
}
export declare function googleLoggingMetricTimeoutsToTerraform(struct?: GoogleLoggingMetricTimeouts | cdktf.IResolvable): any;
export declare class GoogleLoggingMetricTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleLoggingMetricTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleLoggingMetricTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_metric google_logging_metric}
*/
export declare class GoogleLoggingMetric extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_logging_metric";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_metric google_logging_metric} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleLoggingMetricConfig
    */
    constructor(scope: Construct, id: string, config: GoogleLoggingMetricConfig);
    private _bucketName?;
    get bucketName(): string;
    set bucketName(value: string);
    resetBucketName(): void;
    get bucketNameInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _filter?;
    get filter(): string;
    set filter(value: string);
    get filterInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labelExtractors?;
    get labelExtractors(): {
        [key: string]: string;
    };
    set labelExtractors(value: {
        [key: string]: string;
    });
    resetLabelExtractors(): void;
    get labelExtractorsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _valueExtractor?;
    get valueExtractor(): string;
    set valueExtractor(value: string);
    resetValueExtractor(): void;
    get valueExtractorInput(): string | undefined;
    private _bucketOptions;
    get bucketOptions(): GoogleLoggingMetricBucketOptionsOutputReference;
    putBucketOptions(value: GoogleLoggingMetricBucketOptions): void;
    resetBucketOptions(): void;
    get bucketOptionsInput(): GoogleLoggingMetricBucketOptions | undefined;
    private _metricDescriptor;
    get metricDescriptor(): GoogleLoggingMetricMetricDescriptorOutputReference;
    putMetricDescriptor(value: GoogleLoggingMetricMetricDescriptor): void;
    resetMetricDescriptor(): void;
    get metricDescriptorInput(): GoogleLoggingMetricMetricDescriptor | undefined;
    private _timeouts;
    get timeouts(): GoogleLoggingMetricTimeoutsOutputReference;
    putTimeouts(value: GoogleLoggingMetricTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleLoggingMetricTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
