import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleLoggingProjectExclusionConfig extends cdktf.TerraformMetaArguments {
    /**
    * A human-readable description.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_project_exclusion#description GoogleLoggingProjectExclusion#description}
    */
    readonly description?: string;
    /**
    * Whether this exclusion rule should be disabled or not. This defaults to false.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_project_exclusion#disabled GoogleLoggingProjectExclusion#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * The filter to apply when excluding logs. Only log entries that match the filter are excluded.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_project_exclusion#filter GoogleLoggingProjectExclusion#filter}
    */
    readonly filter: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_project_exclusion#id GoogleLoggingProjectExclusion#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the logging exclusion.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_project_exclusion#name GoogleLoggingProjectExclusion#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_project_exclusion#project GoogleLoggingProjectExclusion#project}
    */
    readonly project?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_project_exclusion google_logging_project_exclusion}
*/
export declare class GoogleLoggingProjectExclusion extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_logging_project_exclusion";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_project_exclusion google_logging_project_exclusion} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleLoggingProjectExclusionConfig
    */
    constructor(scope: Construct, id: string, config: GoogleLoggingProjectExclusionConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _filter?;
    get filter(): string;
    set filter(value: string);
    get filterInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
