import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleLoggingProjectSinkConfig extends cdktf.TerraformMetaArguments {
    /**
    * A description of this sink. The maximum length of the description is 8000 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_project_sink#description GoogleLoggingProjectSink#description}
    */
    readonly description?: string;
    /**
    * The destination of the sink (or, in other words, where logs are written to). Can be a Cloud Storage bucket, a PubSub topic, or a BigQuery dataset. Examples: "storage.googleapis.com/[GCS_BUCKET]" "bigquery.googleapis.com/projects/[PROJECT_ID]/datasets/[DATASET]" "pubsub.googleapis.com/projects/[PROJECT_ID]/topics/[TOPIC_ID]" The writer associated with the sink must have access to write to the above resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_project_sink#destination GoogleLoggingProjectSink#destination}
    */
    readonly destination: string;
    /**
    * If set to True, then this sink is disabled and it does not export any log entries.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_project_sink#disabled GoogleLoggingProjectSink#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * The filter to apply when exporting logs. Only log entries that match the filter are exported.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_project_sink#filter GoogleLoggingProjectSink#filter}
    */
    readonly filter?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_project_sink#id GoogleLoggingProjectSink#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the logging sink.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_project_sink#name GoogleLoggingProjectSink#name}
    */
    readonly name: string;
    /**
    * The ID of the project to create the sink in. If omitted, the project associated with the provider is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_project_sink#project GoogleLoggingProjectSink#project}
    */
    readonly project?: string;
    /**
    * Whether or not to create a unique identity associated with this sink. If false (the default), then the writer_identity used is serviceAccount:cloud-logs@system.gserviceaccount.com. If true, then a unique service account is created and used for this sink. If you wish to publish logs across projects, you must set unique_writer_identity to true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_project_sink#unique_writer_identity GoogleLoggingProjectSink#unique_writer_identity}
    */
    readonly uniqueWriterIdentity?: boolean | cdktf.IResolvable;
    /**
    * bigquery_options block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_project_sink#bigquery_options GoogleLoggingProjectSink#bigquery_options}
    */
    readonly bigqueryOptions?: GoogleLoggingProjectSinkBigqueryOptions;
    /**
    * exclusions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_project_sink#exclusions GoogleLoggingProjectSink#exclusions}
    */
    readonly exclusions?: GoogleLoggingProjectSinkExclusions[] | cdktf.IResolvable;
}
export interface GoogleLoggingProjectSinkBigqueryOptions {
    /**
    * Whether to use BigQuery's partition tables. By default, Logging creates dated tables based on the log entries' timestamps, e.g. syslog_20170523. With partitioned tables the date suffix is no longer present and special query syntax has to be used instead. In both cases, tables are sharded based on UTC timezone.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_project_sink#use_partitioned_tables GoogleLoggingProjectSink#use_partitioned_tables}
    */
    readonly usePartitionedTables: boolean | cdktf.IResolvable;
}
export declare function googleLoggingProjectSinkBigqueryOptionsToTerraform(struct?: GoogleLoggingProjectSinkBigqueryOptionsOutputReference | GoogleLoggingProjectSinkBigqueryOptions): any;
export declare class GoogleLoggingProjectSinkBigqueryOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleLoggingProjectSinkBigqueryOptions | undefined;
    set internalValue(value: GoogleLoggingProjectSinkBigqueryOptions | undefined);
    private _usePartitionedTables?;
    get usePartitionedTables(): boolean | cdktf.IResolvable;
    set usePartitionedTables(value: boolean | cdktf.IResolvable);
    get usePartitionedTablesInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleLoggingProjectSinkExclusions {
    /**
    * A description of this exclusion.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_project_sink#description GoogleLoggingProjectSink#description}
    */
    readonly description?: string;
    /**
    * If set to True, then this exclusion is disabled and it does not exclude any log entries
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_project_sink#disabled GoogleLoggingProjectSink#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * An advanced logs filter that matches the log entries to be excluded. By using the sample function, you can exclude less than 100% of the matching log entries
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_project_sink#filter GoogleLoggingProjectSink#filter}
    */
    readonly filter: string;
    /**
    * A client-assigned identifier, such as "load-balancer-exclusion". Identifiers are limited to 100 characters and can include only letters, digits, underscores, hyphens, and periods. First character has to be alphanumeric.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_project_sink#name GoogleLoggingProjectSink#name}
    */
    readonly name: string;
}
export declare function googleLoggingProjectSinkExclusionsToTerraform(struct?: GoogleLoggingProjectSinkExclusions | cdktf.IResolvable): any;
export declare class GoogleLoggingProjectSinkExclusionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleLoggingProjectSinkExclusions | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleLoggingProjectSinkExclusions | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _filter?;
    get filter(): string;
    set filter(value: string);
    get filterInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
}
export declare class GoogleLoggingProjectSinkExclusionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleLoggingProjectSinkExclusions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleLoggingProjectSinkExclusionsOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_project_sink google_logging_project_sink}
*/
export declare class GoogleLoggingProjectSink extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_logging_project_sink";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_logging_project_sink google_logging_project_sink} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleLoggingProjectSinkConfig
    */
    constructor(scope: Construct, id: string, config: GoogleLoggingProjectSinkConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _destination?;
    get destination(): string;
    set destination(value: string);
    get destinationInput(): string | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _filter?;
    get filter(): string;
    set filter(value: string);
    resetFilter(): void;
    get filterInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _uniqueWriterIdentity?;
    get uniqueWriterIdentity(): boolean | cdktf.IResolvable;
    set uniqueWriterIdentity(value: boolean | cdktf.IResolvable);
    resetUniqueWriterIdentity(): void;
    get uniqueWriterIdentityInput(): boolean | cdktf.IResolvable | undefined;
    get writerIdentity(): string;
    private _bigqueryOptions;
    get bigqueryOptions(): GoogleLoggingProjectSinkBigqueryOptionsOutputReference;
    putBigqueryOptions(value: GoogleLoggingProjectSinkBigqueryOptions): void;
    resetBigqueryOptions(): void;
    get bigqueryOptionsInput(): GoogleLoggingProjectSinkBigqueryOptions | undefined;
    private _exclusions;
    get exclusions(): GoogleLoggingProjectSinkExclusionsList;
    putExclusions(value: GoogleLoggingProjectSinkExclusions[] | cdktf.IResolvable): void;
    resetExclusions(): void;
    get exclusionsInput(): cdktf.IResolvable | GoogleLoggingProjectSinkExclusions[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
