import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleMemcacheInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
    * The full name of the GCE network to connect the instance to.  If not provided,
  'default' will be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_memcache_instance#authorized_network GoogleMemcacheInstance#authorized_network}
    */
    readonly authorizedNetwork?: string;
    /**
    * A user-visible name for the instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_memcache_instance#display_name GoogleMemcacheInstance#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_memcache_instance#id GoogleMemcacheInstance#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Resource labels to represent user-provided metadata.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_memcache_instance#labels GoogleMemcacheInstance#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The major version of Memcached software. If not provided, latest supported version will be used.
  Currently the latest supported major version is MEMCACHE_1_5. The minor version will be automatically
  determined by our system based on the latest supported minor version. Default value: "MEMCACHE_1_5" Possible values: ["MEMCACHE_1_5"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_memcache_instance#memcache_version GoogleMemcacheInstance#memcache_version}
    */
    readonly memcacheVersion?: string;
    /**
    * The resource name of the instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_memcache_instance#name GoogleMemcacheInstance#name}
    */
    readonly name: string;
    /**
    * Number of nodes in the memcache instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_memcache_instance#node_count GoogleMemcacheInstance#node_count}
    */
    readonly nodeCount: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_memcache_instance#project GoogleMemcacheInstance#project}
    */
    readonly project?: string;
    /**
    * The region of the Memcache instance. If it is not provided, the provider region is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_memcache_instance#region GoogleMemcacheInstance#region}
    */
    readonly region?: string;
    /**
    * Zones where memcache nodes should be provisioned.  If not
  provided, all zones will be used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_memcache_instance#zones GoogleMemcacheInstance#zones}
    */
    readonly zones?: string[];
    /**
    * maintenance_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_memcache_instance#maintenance_policy GoogleMemcacheInstance#maintenance_policy}
    */
    readonly maintenancePolicy?: GoogleMemcacheInstanceMaintenancePolicy;
    /**
    * memcache_parameters block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_memcache_instance#memcache_parameters GoogleMemcacheInstance#memcache_parameters}
    */
    readonly memcacheParameters?: GoogleMemcacheInstanceMemcacheParameters;
    /**
    * node_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_memcache_instance#node_config GoogleMemcacheInstance#node_config}
    */
    readonly nodeConfig: GoogleMemcacheInstanceNodeConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_memcache_instance#timeouts GoogleMemcacheInstance#timeouts}
    */
    readonly timeouts?: GoogleMemcacheInstanceTimeouts;
}
export interface GoogleMemcacheInstanceMaintenanceSchedule {
}
export declare function googleMemcacheInstanceMaintenanceScheduleToTerraform(struct?: GoogleMemcacheInstanceMaintenanceSchedule): any;
export declare class GoogleMemcacheInstanceMaintenanceScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleMemcacheInstanceMaintenanceSchedule | undefined;
    set internalValue(value: GoogleMemcacheInstanceMaintenanceSchedule | undefined);
    get endTime(): string;
    get scheduleDeadlineTime(): string;
    get startTime(): string;
}
export declare class GoogleMemcacheInstanceMaintenanceScheduleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleMemcacheInstanceMaintenanceScheduleOutputReference;
}
export interface GoogleMemcacheInstanceMemcacheNodes {
}
export declare function googleMemcacheInstanceMemcacheNodesToTerraform(struct?: GoogleMemcacheInstanceMemcacheNodes): any;
export declare class GoogleMemcacheInstanceMemcacheNodesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleMemcacheInstanceMemcacheNodes | undefined;
    set internalValue(value: GoogleMemcacheInstanceMemcacheNodes | undefined);
    get host(): string;
    get nodeId(): string;
    get port(): number;
    get state(): string;
    get zone(): string;
}
export declare class GoogleMemcacheInstanceMemcacheNodesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleMemcacheInstanceMemcacheNodesOutputReference;
}
export interface GoogleMemcacheInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTime {
    /**
    * Hours of day in 24 hour format. Should be from 0 to 23.
  An API may choose to allow the value "24:00:00" for scenarios like business closing time.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_memcache_instance#hours GoogleMemcacheInstance#hours}
    */
    readonly hours?: number;
    /**
    * Minutes of hour of day. Must be from 0 to 59.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_memcache_instance#minutes GoogleMemcacheInstance#minutes}
    */
    readonly minutes?: number;
    /**
    * Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_memcache_instance#nanos GoogleMemcacheInstance#nanos}
    */
    readonly nanos?: number;
    /**
    * Seconds of minutes of the time. Must normally be from 0 to 59.
  An API may allow the value 60 if it allows leap-seconds.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_memcache_instance#seconds GoogleMemcacheInstance#seconds}
    */
    readonly seconds?: number;
}
export declare function googleMemcacheInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeToTerraform(struct?: GoogleMemcacheInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeOutputReference | GoogleMemcacheInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTime): any;
export declare class GoogleMemcacheInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMemcacheInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTime | undefined;
    set internalValue(value: GoogleMemcacheInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTime | undefined);
    private _hours?;
    get hours(): number;
    set hours(value: number);
    resetHours(): void;
    get hoursInput(): number | undefined;
    private _minutes?;
    get minutes(): number;
    set minutes(value: number);
    resetMinutes(): void;
    get minutesInput(): number | undefined;
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    resetNanos(): void;
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): number;
    set seconds(value: number);
    resetSeconds(): void;
    get secondsInput(): number | undefined;
}
export interface GoogleMemcacheInstanceMaintenancePolicyWeeklyMaintenanceWindow {
    /**
    * Required. The day of week that maintenance updates occur.
  - DAY_OF_WEEK_UNSPECIFIED: The day of the week is unspecified.
  - MONDAY: Monday
  - TUESDAY: Tuesday
  - WEDNESDAY: Wednesday
  - THURSDAY: Thursday
  - FRIDAY: Friday
  - SATURDAY: Saturday
  - SUNDAY: Sunday Possible values: ["DAY_OF_WEEK_UNSPECIFIED", "MONDAY", "TUESDAY", "WEDNESDAY", "THURSDAY", "FRIDAY", "SATURDAY", "SUNDAY"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_memcache_instance#day GoogleMemcacheInstance#day}
    */
    readonly day: string;
    /**
    * Required. The length of the maintenance window, ranging from 3 hours to 8 hours.
  A duration in seconds with up to nine fractional digits,
  terminated by 's'. Example: "3.5s".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_memcache_instance#duration GoogleMemcacheInstance#duration}
    */
    readonly duration: string;
    /**
    * start_time block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_memcache_instance#start_time GoogleMemcacheInstance#start_time}
    */
    readonly startTime: GoogleMemcacheInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTime;
}
export declare function googleMemcacheInstanceMaintenancePolicyWeeklyMaintenanceWindowToTerraform(struct?: GoogleMemcacheInstanceMaintenancePolicyWeeklyMaintenanceWindow | cdktf.IResolvable): any;
export declare class GoogleMemcacheInstanceMaintenancePolicyWeeklyMaintenanceWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleMemcacheInstanceMaintenancePolicyWeeklyMaintenanceWindow | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleMemcacheInstanceMaintenancePolicyWeeklyMaintenanceWindow | cdktf.IResolvable | undefined);
    private _day?;
    get day(): string;
    set day(value: string);
    get dayInput(): string | undefined;
    private _duration?;
    get duration(): string;
    set duration(value: string);
    get durationInput(): string | undefined;
    private _startTime;
    get startTime(): GoogleMemcacheInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTimeOutputReference;
    putStartTime(value: GoogleMemcacheInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTime): void;
    get startTimeInput(): GoogleMemcacheInstanceMaintenancePolicyWeeklyMaintenanceWindowStartTime | undefined;
}
export declare class GoogleMemcacheInstanceMaintenancePolicyWeeklyMaintenanceWindowList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleMemcacheInstanceMaintenancePolicyWeeklyMaintenanceWindow[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleMemcacheInstanceMaintenancePolicyWeeklyMaintenanceWindowOutputReference;
}
export interface GoogleMemcacheInstanceMaintenancePolicy {
    /**
    * Optional. Description of what this policy is for.
  Create/Update methods return INVALID_ARGUMENT if the
  length is greater than 512.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_memcache_instance#description GoogleMemcacheInstance#description}
    */
    readonly description?: string;
    /**
    * weekly_maintenance_window block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_memcache_instance#weekly_maintenance_window GoogleMemcacheInstance#weekly_maintenance_window}
    */
    readonly weeklyMaintenanceWindow: GoogleMemcacheInstanceMaintenancePolicyWeeklyMaintenanceWindow[] | cdktf.IResolvable;
}
export declare function googleMemcacheInstanceMaintenancePolicyToTerraform(struct?: GoogleMemcacheInstanceMaintenancePolicyOutputReference | GoogleMemcacheInstanceMaintenancePolicy): any;
export declare class GoogleMemcacheInstanceMaintenancePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMemcacheInstanceMaintenancePolicy | undefined;
    set internalValue(value: GoogleMemcacheInstanceMaintenancePolicy | undefined);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get updateTime(): string;
    private _weeklyMaintenanceWindow;
    get weeklyMaintenanceWindow(): GoogleMemcacheInstanceMaintenancePolicyWeeklyMaintenanceWindowList;
    putWeeklyMaintenanceWindow(value: GoogleMemcacheInstanceMaintenancePolicyWeeklyMaintenanceWindow[] | cdktf.IResolvable): void;
    get weeklyMaintenanceWindowInput(): cdktf.IResolvable | GoogleMemcacheInstanceMaintenancePolicyWeeklyMaintenanceWindow[] | undefined;
}
export interface GoogleMemcacheInstanceMemcacheParameters {
    /**
    * User-defined set of parameters to use in the memcache process.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_memcache_instance#params GoogleMemcacheInstance#params}
    */
    readonly params?: {
        [key: string]: string;
    };
}
export declare function googleMemcacheInstanceMemcacheParametersToTerraform(struct?: GoogleMemcacheInstanceMemcacheParametersOutputReference | GoogleMemcacheInstanceMemcacheParameters): any;
export declare class GoogleMemcacheInstanceMemcacheParametersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMemcacheInstanceMemcacheParameters | undefined;
    set internalValue(value: GoogleMemcacheInstanceMemcacheParameters | undefined);
    get id(): string;
    private _params?;
    get params(): {
        [key: string]: string;
    };
    set params(value: {
        [key: string]: string;
    });
    resetParams(): void;
    get paramsInput(): {
        [key: string]: string;
    } | undefined;
}
export interface GoogleMemcacheInstanceNodeConfig {
    /**
    * Number of CPUs per node.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_memcache_instance#cpu_count GoogleMemcacheInstance#cpu_count}
    */
    readonly cpuCount: number;
    /**
    * Memory size in Mebibytes for each memcache node.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_memcache_instance#memory_size_mb GoogleMemcacheInstance#memory_size_mb}
    */
    readonly memorySizeMb: number;
}
export declare function googleMemcacheInstanceNodeConfigToTerraform(struct?: GoogleMemcacheInstanceNodeConfigOutputReference | GoogleMemcacheInstanceNodeConfig): any;
export declare class GoogleMemcacheInstanceNodeConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMemcacheInstanceNodeConfig | undefined;
    set internalValue(value: GoogleMemcacheInstanceNodeConfig | undefined);
    private _cpuCount?;
    get cpuCount(): number;
    set cpuCount(value: number);
    get cpuCountInput(): number | undefined;
    private _memorySizeMb?;
    get memorySizeMb(): number;
    set memorySizeMb(value: number);
    get memorySizeMbInput(): number | undefined;
}
export interface GoogleMemcacheInstanceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_memcache_instance#create GoogleMemcacheInstance#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_memcache_instance#delete GoogleMemcacheInstance#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_memcache_instance#update GoogleMemcacheInstance#update}
    */
    readonly update?: string;
}
export declare function googleMemcacheInstanceTimeoutsToTerraform(struct?: GoogleMemcacheInstanceTimeouts | cdktf.IResolvable): any;
export declare class GoogleMemcacheInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMemcacheInstanceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleMemcacheInstanceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_memcache_instance google_memcache_instance}
*/
export declare class GoogleMemcacheInstance extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_memcache_instance";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_memcache_instance google_memcache_instance} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleMemcacheInstanceConfig
    */
    constructor(scope: Construct, id: string, config: GoogleMemcacheInstanceConfig);
    private _authorizedNetwork?;
    get authorizedNetwork(): string;
    set authorizedNetwork(value: string);
    resetAuthorizedNetwork(): void;
    get authorizedNetworkInput(): string | undefined;
    get createTime(): string;
    get discoveryEndpoint(): string;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _maintenanceSchedule;
    get maintenanceSchedule(): GoogleMemcacheInstanceMaintenanceScheduleList;
    get memcacheFullVersion(): string;
    private _memcacheNodes;
    get memcacheNodes(): GoogleMemcacheInstanceMemcacheNodesList;
    private _memcacheVersion?;
    get memcacheVersion(): string;
    set memcacheVersion(value: string);
    resetMemcacheVersion(): void;
    get memcacheVersionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nodeCount?;
    get nodeCount(): number;
    set nodeCount(value: number);
    get nodeCountInput(): number | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _zones?;
    get zones(): string[];
    set zones(value: string[]);
    resetZones(): void;
    get zonesInput(): string[] | undefined;
    private _maintenancePolicy;
    get maintenancePolicy(): GoogleMemcacheInstanceMaintenancePolicyOutputReference;
    putMaintenancePolicy(value: GoogleMemcacheInstanceMaintenancePolicy): void;
    resetMaintenancePolicy(): void;
    get maintenancePolicyInput(): GoogleMemcacheInstanceMaintenancePolicy | undefined;
    private _memcacheParameters;
    get memcacheParameters(): GoogleMemcacheInstanceMemcacheParametersOutputReference;
    putMemcacheParameters(value: GoogleMemcacheInstanceMemcacheParameters): void;
    resetMemcacheParameters(): void;
    get memcacheParametersInput(): GoogleMemcacheInstanceMemcacheParameters | undefined;
    private _nodeConfig;
    get nodeConfig(): GoogleMemcacheInstanceNodeConfigOutputReference;
    putNodeConfig(value: GoogleMemcacheInstanceNodeConfig): void;
    get nodeConfigInput(): GoogleMemcacheInstanceNodeConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleMemcacheInstanceTimeoutsOutputReference;
    putTimeouts(value: GoogleMemcacheInstanceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleMemcacheInstanceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
