import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleMonitoringDashboardConfig extends cdktf.TerraformMetaArguments {
    /**
    * The JSON representation of a dashboard, following the format at https://cloud.google.com/monitoring/api/ref_v3/rest/v1/projects.dashboards.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_dashboard#dashboard_json GoogleMonitoringDashboard#dashboard_json}
    */
    readonly dashboardJson: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_dashboard#id GoogleMonitoringDashboard#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_dashboard#project GoogleMonitoringDashboard#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_dashboard#timeouts GoogleMonitoringDashboard#timeouts}
    */
    readonly timeouts?: GoogleMonitoringDashboardTimeouts;
}
export interface GoogleMonitoringDashboardTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_dashboard#create GoogleMonitoringDashboard#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_dashboard#delete GoogleMonitoringDashboard#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_dashboard#update GoogleMonitoringDashboard#update}
    */
    readonly update?: string;
}
export declare function googleMonitoringDashboardTimeoutsToTerraform(struct?: GoogleMonitoringDashboardTimeouts | cdktf.IResolvable): any;
export declare class GoogleMonitoringDashboardTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMonitoringDashboardTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleMonitoringDashboardTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_dashboard google_monitoring_dashboard}
*/
export declare class GoogleMonitoringDashboard extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_monitoring_dashboard";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_dashboard google_monitoring_dashboard} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleMonitoringDashboardConfig
    */
    constructor(scope: Construct, id: string, config: GoogleMonitoringDashboardConfig);
    private _dashboardJson?;
    get dashboardJson(): string;
    set dashboardJson(value: string);
    get dashboardJsonInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleMonitoringDashboardTimeoutsOutputReference;
    putTimeouts(value: GoogleMonitoringDashboardTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleMonitoringDashboardTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
