import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleMonitoringServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Name used for UI elements listing this Service.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_service#display_name GoogleMonitoringService#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_service#id GoogleMonitoringService#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_service#project GoogleMonitoringService#project}
    */
    readonly project?: string;
    /**
    * An optional service ID to use. If not given, the server will generate a
  service ID.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_service#service_id GoogleMonitoringService#service_id}
    */
    readonly serviceId: string;
    /**
    * Labels which have been used to annotate the service. Label keys must start
  with a letter. Label keys and values may contain lowercase letters,
  numbers, underscores, and dashes. Label keys and values have a maximum
  length of 63 characters, and must be less than 128 bytes in size. Up to 64
  label entries may be stored. For labels which do not have a semantic value,
  the empty string may be supplied for the label value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_service#user_labels GoogleMonitoringService#user_labels}
    */
    readonly userLabels?: {
        [key: string]: string;
    };
    /**
    * basic_service block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_service#basic_service GoogleMonitoringService#basic_service}
    */
    readonly basicService?: GoogleMonitoringServiceBasicService;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_service#timeouts GoogleMonitoringService#timeouts}
    */
    readonly timeouts?: GoogleMonitoringServiceTimeouts;
}
export interface GoogleMonitoringServiceTelemetry {
}
export declare function googleMonitoringServiceTelemetryToTerraform(struct?: GoogleMonitoringServiceTelemetry): any;
export declare class GoogleMonitoringServiceTelemetryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleMonitoringServiceTelemetry | undefined;
    set internalValue(value: GoogleMonitoringServiceTelemetry | undefined);
    get resourceName(): string;
}
export declare class GoogleMonitoringServiceTelemetryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleMonitoringServiceTelemetryOutputReference;
}
export interface GoogleMonitoringServiceBasicService {
    /**
    * Labels that specify the resource that emits the monitoring data
  which is used for SLO reporting of this 'Service'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_service#service_labels GoogleMonitoringService#service_labels}
    */
    readonly serviceLabels?: {
        [key: string]: string;
    };
    /**
    * The type of service that this basic service defines, e.g.
  APP_ENGINE service type
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_service#service_type GoogleMonitoringService#service_type}
    */
    readonly serviceType?: string;
}
export declare function googleMonitoringServiceBasicServiceToTerraform(struct?: GoogleMonitoringServiceBasicServiceOutputReference | GoogleMonitoringServiceBasicService): any;
export declare class GoogleMonitoringServiceBasicServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMonitoringServiceBasicService | undefined;
    set internalValue(value: GoogleMonitoringServiceBasicService | undefined);
    private _serviceLabels?;
    get serviceLabels(): {
        [key: string]: string;
    };
    set serviceLabels(value: {
        [key: string]: string;
    });
    resetServiceLabels(): void;
    get serviceLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _serviceType?;
    get serviceType(): string;
    set serviceType(value: string);
    resetServiceType(): void;
    get serviceTypeInput(): string | undefined;
}
export interface GoogleMonitoringServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_service#create GoogleMonitoringService#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_service#delete GoogleMonitoringService#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_service#update GoogleMonitoringService#update}
    */
    readonly update?: string;
}
export declare function googleMonitoringServiceTimeoutsToTerraform(struct?: GoogleMonitoringServiceTimeouts | cdktf.IResolvable): any;
export declare class GoogleMonitoringServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMonitoringServiceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleMonitoringServiceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_service google_monitoring_service}
*/
export declare class GoogleMonitoringService extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_monitoring_service";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_service google_monitoring_service} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleMonitoringServiceConfig
    */
    constructor(scope: Construct, id: string, config: GoogleMonitoringServiceConfig);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _serviceId?;
    get serviceId(): string;
    set serviceId(value: string);
    get serviceIdInput(): string | undefined;
    private _telemetry;
    get telemetry(): GoogleMonitoringServiceTelemetryList;
    private _userLabels?;
    get userLabels(): {
        [key: string]: string;
    };
    set userLabels(value: {
        [key: string]: string;
    });
    resetUserLabels(): void;
    get userLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _basicService;
    get basicService(): GoogleMonitoringServiceBasicServiceOutputReference;
    putBasicService(value: GoogleMonitoringServiceBasicService): void;
    resetBasicService(): void;
    get basicServiceInput(): GoogleMonitoringServiceBasicService | undefined;
    private _timeouts;
    get timeouts(): GoogleMonitoringServiceTimeoutsOutputReference;
    putTimeouts(value: GoogleMonitoringServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleMonitoringServiceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
