import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleMonitoringSloConfig extends cdktf.TerraformMetaArguments {
    /**
    * A calendar period, semantically "since the start of the current
  <calendarPeriod>". Possible values: ["DAY", "WEEK", "FORTNIGHT", "MONTH"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#calendar_period GoogleMonitoringSlo#calendar_period}
    */
    readonly calendarPeriod?: string;
    /**
    * Name used for UI elements listing this SLO.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#display_name GoogleMonitoringSlo#display_name}
    */
    readonly displayName?: string;
    /**
    * The fraction of service that must be good in order for this objective
  to be met. 0 < goal <= 0.999
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#goal GoogleMonitoringSlo#goal}
    */
    readonly goal: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#id GoogleMonitoringSlo#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#project GoogleMonitoringSlo#project}
    */
    readonly project?: string;
    /**
    * A rolling time period, semantically "in the past X days".
  Must be between 1 to 30 days, inclusive.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#rolling_period_days GoogleMonitoringSlo#rolling_period_days}
    */
    readonly rollingPeriodDays?: number;
    /**
    * ID of the service to which this SLO belongs.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#service GoogleMonitoringSlo#service}
    */
    readonly service: string;
    /**
    * The id to use for this ServiceLevelObjective. If omitted, an id will be generated instead.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#slo_id GoogleMonitoringSlo#slo_id}
    */
    readonly sloId?: string;
    /**
    * This field is intended to be used for organizing and identifying the AlertPolicy
  objects.The field can contain up to 64 entries. Each key and value is limited
  to 63 Unicode characters or 128 bytes, whichever is smaller. Labels and values
  can contain only lowercase letters, numerals, underscores, and dashes. Keys
  must begin with a letter.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#user_labels GoogleMonitoringSlo#user_labels}
    */
    readonly userLabels?: {
        [key: string]: string;
    };
    /**
    * basic_sli block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#basic_sli GoogleMonitoringSlo#basic_sli}
    */
    readonly basicSli?: GoogleMonitoringSloBasicSli;
    /**
    * request_based_sli block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#request_based_sli GoogleMonitoringSlo#request_based_sli}
    */
    readonly requestBasedSli?: GoogleMonitoringSloRequestBasedSli;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#timeouts GoogleMonitoringSlo#timeouts}
    */
    readonly timeouts?: GoogleMonitoringSloTimeouts;
    /**
    * windows_based_sli block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#windows_based_sli GoogleMonitoringSlo#windows_based_sli}
    */
    readonly windowsBasedSli?: GoogleMonitoringSloWindowsBasedSli;
}
export interface GoogleMonitoringSloBasicSliAvailability {
    /**
    * Whether an availability SLI is enabled or not. Must be set to true. Defaults to 'true'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#enabled GoogleMonitoringSlo#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function googleMonitoringSloBasicSliAvailabilityToTerraform(struct?: GoogleMonitoringSloBasicSliAvailabilityOutputReference | GoogleMonitoringSloBasicSliAvailability): any;
export declare class GoogleMonitoringSloBasicSliAvailabilityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMonitoringSloBasicSliAvailability | undefined;
    set internalValue(value: GoogleMonitoringSloBasicSliAvailability | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleMonitoringSloBasicSliLatency {
    /**
    * A duration string, e.g. 10s.
  Good service is defined to be the count of requests made to
  this service that return in no more than threshold.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#threshold GoogleMonitoringSlo#threshold}
    */
    readonly threshold: string;
}
export declare function googleMonitoringSloBasicSliLatencyToTerraform(struct?: GoogleMonitoringSloBasicSliLatencyOutputReference | GoogleMonitoringSloBasicSliLatency): any;
export declare class GoogleMonitoringSloBasicSliLatencyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMonitoringSloBasicSliLatency | undefined;
    set internalValue(value: GoogleMonitoringSloBasicSliLatency | undefined);
    private _threshold?;
    get threshold(): string;
    set threshold(value: string);
    get thresholdInput(): string | undefined;
}
export interface GoogleMonitoringSloBasicSli {
    /**
    * An optional set of locations to which this SLI is relevant.
  Telemetry from other locations will not be used to calculate
  performance for this SLI. If omitted, this SLI applies to all
  locations in which the Service has activity. For service types
  that don't support breaking down by location, setting this
  field will result in an error.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#location GoogleMonitoringSlo#location}
    */
    readonly location?: string[];
    /**
    * An optional set of RPCs to which this SLI is relevant.
  Telemetry from other methods will not be used to calculate
  performance for this SLI. If omitted, this SLI applies to all
  the Service's methods. For service types that don't support
  breaking down by method, setting this field will result in an
  error.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#method GoogleMonitoringSlo#method}
    */
    readonly method?: string[];
    /**
    * The set of API versions to which this SLI is relevant.
  Telemetry from other API versions will not be used to
  calculate performance for this SLI. If omitted,
  this SLI applies to all API versions. For service types
  that don't support breaking down by version, setting this
  field will result in an error.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#version GoogleMonitoringSlo#version}
    */
    readonly version?: string[];
    /**
    * availability block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#availability GoogleMonitoringSlo#availability}
    */
    readonly availability?: GoogleMonitoringSloBasicSliAvailability;
    /**
    * latency block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#latency GoogleMonitoringSlo#latency}
    */
    readonly latency?: GoogleMonitoringSloBasicSliLatency;
}
export declare function googleMonitoringSloBasicSliToTerraform(struct?: GoogleMonitoringSloBasicSliOutputReference | GoogleMonitoringSloBasicSli): any;
export declare class GoogleMonitoringSloBasicSliOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMonitoringSloBasicSli | undefined;
    set internalValue(value: GoogleMonitoringSloBasicSli | undefined);
    private _location?;
    get location(): string[];
    set location(value: string[]);
    resetLocation(): void;
    get locationInput(): string[] | undefined;
    private _method?;
    get method(): string[];
    set method(value: string[]);
    resetMethod(): void;
    get methodInput(): string[] | undefined;
    private _version?;
    get version(): string[];
    set version(value: string[]);
    resetVersion(): void;
    get versionInput(): string[] | undefined;
    private _availability;
    get availability(): GoogleMonitoringSloBasicSliAvailabilityOutputReference;
    putAvailability(value: GoogleMonitoringSloBasicSliAvailability): void;
    resetAvailability(): void;
    get availabilityInput(): GoogleMonitoringSloBasicSliAvailability | undefined;
    private _latency;
    get latency(): GoogleMonitoringSloBasicSliLatencyOutputReference;
    putLatency(value: GoogleMonitoringSloBasicSliLatency): void;
    resetLatency(): void;
    get latencyInput(): GoogleMonitoringSloBasicSliLatency | undefined;
}
export interface GoogleMonitoringSloRequestBasedSliDistributionCutRange {
    /**
    * max value for the range (inclusive). If not given,
  will be set to 0
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#max GoogleMonitoringSlo#max}
    */
    readonly max?: number;
    /**
    * Min value for the range (inclusive). If not given,
  will be set to 0
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#min GoogleMonitoringSlo#min}
    */
    readonly min?: number;
}
export declare function googleMonitoringSloRequestBasedSliDistributionCutRangeToTerraform(struct?: GoogleMonitoringSloRequestBasedSliDistributionCutRangeOutputReference | GoogleMonitoringSloRequestBasedSliDistributionCutRange): any;
export declare class GoogleMonitoringSloRequestBasedSliDistributionCutRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMonitoringSloRequestBasedSliDistributionCutRange | undefined;
    set internalValue(value: GoogleMonitoringSloRequestBasedSliDistributionCutRange | undefined);
    private _max?;
    get max(): number;
    set max(value: number);
    resetMax(): void;
    get maxInput(): number | undefined;
    private _min?;
    get min(): number;
    set min(value: number);
    resetMin(): void;
    get minInput(): number | undefined;
}
export interface GoogleMonitoringSloRequestBasedSliDistributionCut {
    /**
    * A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
  aggregating values to quantify the good service provided.
  
  Must have ValueType = DISTRIBUTION and
  MetricKind = DELTA or MetricKind = CUMULATIVE.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#distribution_filter GoogleMonitoringSlo#distribution_filter}
    */
    readonly distributionFilter: string;
    /**
    * range block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#range GoogleMonitoringSlo#range}
    */
    readonly range: GoogleMonitoringSloRequestBasedSliDistributionCutRange;
}
export declare function googleMonitoringSloRequestBasedSliDistributionCutToTerraform(struct?: GoogleMonitoringSloRequestBasedSliDistributionCutOutputReference | GoogleMonitoringSloRequestBasedSliDistributionCut): any;
export declare class GoogleMonitoringSloRequestBasedSliDistributionCutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMonitoringSloRequestBasedSliDistributionCut | undefined;
    set internalValue(value: GoogleMonitoringSloRequestBasedSliDistributionCut | undefined);
    private _distributionFilter?;
    get distributionFilter(): string;
    set distributionFilter(value: string);
    get distributionFilterInput(): string | undefined;
    private _range;
    get range(): GoogleMonitoringSloRequestBasedSliDistributionCutRangeOutputReference;
    putRange(value: GoogleMonitoringSloRequestBasedSliDistributionCutRange): void;
    get rangeInput(): GoogleMonitoringSloRequestBasedSliDistributionCutRange | undefined;
}
export interface GoogleMonitoringSloRequestBasedSliGoodTotalRatio {
    /**
    * A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
  quantifying bad service provided, either demanded service that
  was not provided or demanded service that was of inadequate
  quality.
  
  Must have ValueType = DOUBLE or ValueType = INT64 and
  must have MetricKind = DELTA or MetricKind = CUMULATIVE.
  
  Exactly two of 'good_service_filter','bad_service_filter','total_service_filter'
  must be set (good + bad = total is assumed).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#bad_service_filter GoogleMonitoringSlo#bad_service_filter}
    */
    readonly badServiceFilter?: string;
    /**
    * A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
  quantifying good service provided.
  Must have ValueType = DOUBLE or ValueType = INT64 and
  must have MetricKind = DELTA or MetricKind = CUMULATIVE.
  
  Exactly two of 'good_service_filter','bad_service_filter','total_service_filter'
  must be set (good + bad = total is assumed).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#good_service_filter GoogleMonitoringSlo#good_service_filter}
    */
    readonly goodServiceFilter?: string;
    /**
    * A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
  quantifying total demanded service.
  
  Must have ValueType = DOUBLE or ValueType = INT64 and
  must have MetricKind = DELTA or MetricKind = CUMULATIVE.
  
  Exactly two of 'good_service_filter','bad_service_filter','total_service_filter'
  must be set (good + bad = total is assumed).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#total_service_filter GoogleMonitoringSlo#total_service_filter}
    */
    readonly totalServiceFilter?: string;
}
export declare function googleMonitoringSloRequestBasedSliGoodTotalRatioToTerraform(struct?: GoogleMonitoringSloRequestBasedSliGoodTotalRatioOutputReference | GoogleMonitoringSloRequestBasedSliGoodTotalRatio): any;
export declare class GoogleMonitoringSloRequestBasedSliGoodTotalRatioOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMonitoringSloRequestBasedSliGoodTotalRatio | undefined;
    set internalValue(value: GoogleMonitoringSloRequestBasedSliGoodTotalRatio | undefined);
    private _badServiceFilter?;
    get badServiceFilter(): string;
    set badServiceFilter(value: string);
    resetBadServiceFilter(): void;
    get badServiceFilterInput(): string | undefined;
    private _goodServiceFilter?;
    get goodServiceFilter(): string;
    set goodServiceFilter(value: string);
    resetGoodServiceFilter(): void;
    get goodServiceFilterInput(): string | undefined;
    private _totalServiceFilter?;
    get totalServiceFilter(): string;
    set totalServiceFilter(value: string);
    resetTotalServiceFilter(): void;
    get totalServiceFilterInput(): string | undefined;
}
export interface GoogleMonitoringSloRequestBasedSli {
    /**
    * distribution_cut block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#distribution_cut GoogleMonitoringSlo#distribution_cut}
    */
    readonly distributionCut?: GoogleMonitoringSloRequestBasedSliDistributionCut;
    /**
    * good_total_ratio block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#good_total_ratio GoogleMonitoringSlo#good_total_ratio}
    */
    readonly goodTotalRatio?: GoogleMonitoringSloRequestBasedSliGoodTotalRatio;
}
export declare function googleMonitoringSloRequestBasedSliToTerraform(struct?: GoogleMonitoringSloRequestBasedSliOutputReference | GoogleMonitoringSloRequestBasedSli): any;
export declare class GoogleMonitoringSloRequestBasedSliOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMonitoringSloRequestBasedSli | undefined;
    set internalValue(value: GoogleMonitoringSloRequestBasedSli | undefined);
    private _distributionCut;
    get distributionCut(): GoogleMonitoringSloRequestBasedSliDistributionCutOutputReference;
    putDistributionCut(value: GoogleMonitoringSloRequestBasedSliDistributionCut): void;
    resetDistributionCut(): void;
    get distributionCutInput(): GoogleMonitoringSloRequestBasedSliDistributionCut | undefined;
    private _goodTotalRatio;
    get goodTotalRatio(): GoogleMonitoringSloRequestBasedSliGoodTotalRatioOutputReference;
    putGoodTotalRatio(value: GoogleMonitoringSloRequestBasedSliGoodTotalRatio): void;
    resetGoodTotalRatio(): void;
    get goodTotalRatioInput(): GoogleMonitoringSloRequestBasedSliGoodTotalRatio | undefined;
}
export interface GoogleMonitoringSloTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#create GoogleMonitoringSlo#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#delete GoogleMonitoringSlo#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#update GoogleMonitoringSlo#update}
    */
    readonly update?: string;
}
export declare function googleMonitoringSloTimeoutsToTerraform(struct?: GoogleMonitoringSloTimeouts | cdktf.IResolvable): any;
export declare class GoogleMonitoringSloTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMonitoringSloTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleMonitoringSloTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceAvailability {
    /**
    * Whether an availability SLI is enabled or not. Must be set to 'true. Defaults to 'true'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#enabled GoogleMonitoringSlo#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function googleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceAvailabilityToTerraform(struct?: GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceAvailabilityOutputReference | GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceAvailability): any;
export declare class GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceAvailabilityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceAvailability | undefined;
    set internalValue(value: GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceAvailability | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceLatency {
    /**
    * A duration string, e.g. 10s.
  Good service is defined to be the count of requests made to
  this service that return in no more than threshold.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#threshold GoogleMonitoringSlo#threshold}
    */
    readonly threshold: string;
}
export declare function googleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceLatencyToTerraform(struct?: GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceLatencyOutputReference | GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceLatency): any;
export declare class GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceLatencyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceLatency | undefined;
    set internalValue(value: GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceLatency | undefined);
    private _threshold?;
    get threshold(): string;
    set threshold(value: string);
    get thresholdInput(): string | undefined;
}
export interface GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformance {
    /**
    * An optional set of locations to which this SLI is relevant.
  Telemetry from other locations will not be used to calculate
  performance for this SLI. If omitted, this SLI applies to all
  locations in which the Service has activity. For service types
  that don't support breaking down by location, setting this
  field will result in an error.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#location GoogleMonitoringSlo#location}
    */
    readonly location?: string[];
    /**
    * An optional set of RPCs to which this SLI is relevant.
  Telemetry from other methods will not be used to calculate
  performance for this SLI. If omitted, this SLI applies to all
  the Service's methods. For service types that don't support
  breaking down by method, setting this field will result in an
  error.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#method GoogleMonitoringSlo#method}
    */
    readonly method?: string[];
    /**
    * The set of API versions to which this SLI is relevant.
  Telemetry from other API versions will not be used to
  calculate performance for this SLI. If omitted,
  this SLI applies to all API versions. For service types
  that don't support breaking down by version, setting this
  field will result in an error.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#version GoogleMonitoringSlo#version}
    */
    readonly version?: string[];
    /**
    * availability block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#availability GoogleMonitoringSlo#availability}
    */
    readonly availability?: GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceAvailability;
    /**
    * latency block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#latency GoogleMonitoringSlo#latency}
    */
    readonly latency?: GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceLatency;
}
export declare function googleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceToTerraform(struct?: GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceOutputReference | GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformance): any;
export declare class GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformance | undefined;
    set internalValue(value: GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformance | undefined);
    private _location?;
    get location(): string[];
    set location(value: string[]);
    resetLocation(): void;
    get locationInput(): string[] | undefined;
    private _method?;
    get method(): string[];
    set method(value: string[]);
    resetMethod(): void;
    get methodInput(): string[] | undefined;
    private _version?;
    get version(): string[];
    set version(value: string[]);
    resetVersion(): void;
    get versionInput(): string[] | undefined;
    private _availability;
    get availability(): GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceAvailabilityOutputReference;
    putAvailability(value: GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceAvailability): void;
    resetAvailability(): void;
    get availabilityInput(): GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceAvailability | undefined;
    private _latency;
    get latency(): GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceLatencyOutputReference;
    putLatency(value: GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceLatency): void;
    resetLatency(): void;
    get latencyInput(): GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceLatency | undefined;
}
export interface GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutRange {
    /**
    * max value for the range (inclusive). If not given,
  will be set to 0
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#max GoogleMonitoringSlo#max}
    */
    readonly max?: number;
    /**
    * Min value for the range (inclusive). If not given,
  will be set to 0
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#min GoogleMonitoringSlo#min}
    */
    readonly min?: number;
}
export declare function googleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutRangeToTerraform(struct?: GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutRangeOutputReference | GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutRange): any;
export declare class GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutRange | undefined;
    set internalValue(value: GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutRange | undefined);
    private _max?;
    get max(): number;
    set max(value: number);
    resetMax(): void;
    get maxInput(): number | undefined;
    private _min?;
    get min(): number;
    set min(value: number);
    resetMin(): void;
    get minInput(): number | undefined;
}
export interface GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCut {
    /**
    * A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
  aggregating values to quantify the good service provided.
  
  Must have ValueType = DISTRIBUTION and
  MetricKind = DELTA or MetricKind = CUMULATIVE.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#distribution_filter GoogleMonitoringSlo#distribution_filter}
    */
    readonly distributionFilter: string;
    /**
    * range block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#range GoogleMonitoringSlo#range}
    */
    readonly range: GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutRange;
}
export declare function googleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutToTerraform(struct?: GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutOutputReference | GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCut): any;
export declare class GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCut | undefined;
    set internalValue(value: GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCut | undefined);
    private _distributionFilter?;
    get distributionFilter(): string;
    set distributionFilter(value: string);
    get distributionFilterInput(): string | undefined;
    private _range;
    get range(): GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutRangeOutputReference;
    putRange(value: GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutRange): void;
    get rangeInput(): GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutRange | undefined;
}
export interface GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatio {
    /**
    * A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
  quantifying bad service provided, either demanded service that
  was not provided or demanded service that was of inadequate
  quality. Exactly two of
  good, bad, or total service filter must be defined (where
  good + bad = total is assumed)
  
  Must have ValueType = DOUBLE or ValueType = INT64 and
  must have MetricKind = DELTA or MetricKind = CUMULATIVE.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#bad_service_filter GoogleMonitoringSlo#bad_service_filter}
    */
    readonly badServiceFilter?: string;
    /**
    * A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
  quantifying good service provided. Exactly two of
  good, bad, or total service filter must be defined (where
  good + bad = total is assumed)
  
  Must have ValueType = DOUBLE or ValueType = INT64 and
  must have MetricKind = DELTA or MetricKind = CUMULATIVE.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#good_service_filter GoogleMonitoringSlo#good_service_filter}
    */
    readonly goodServiceFilter?: string;
    /**
    * A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
  quantifying total demanded service. Exactly two of
  good, bad, or total service filter must be defined (where
  good + bad = total is assumed)
  
  Must have ValueType = DOUBLE or ValueType = INT64 and
  must have MetricKind = DELTA or MetricKind = CUMULATIVE.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#total_service_filter GoogleMonitoringSlo#total_service_filter}
    */
    readonly totalServiceFilter?: string;
}
export declare function googleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatioToTerraform(struct?: GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatioOutputReference | GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatio): any;
export declare class GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatioOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatio | undefined;
    set internalValue(value: GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatio | undefined);
    private _badServiceFilter?;
    get badServiceFilter(): string;
    set badServiceFilter(value: string);
    resetBadServiceFilter(): void;
    get badServiceFilterInput(): string | undefined;
    private _goodServiceFilter?;
    get goodServiceFilter(): string;
    set goodServiceFilter(value: string);
    resetGoodServiceFilter(): void;
    get goodServiceFilterInput(): string | undefined;
    private _totalServiceFilter?;
    get totalServiceFilter(): string;
    set totalServiceFilter(value: string);
    resetTotalServiceFilter(): void;
    get totalServiceFilterInput(): string | undefined;
}
export interface GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformance {
    /**
    * distribution_cut block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#distribution_cut GoogleMonitoringSlo#distribution_cut}
    */
    readonly distributionCut?: GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCut;
    /**
    * good_total_ratio block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#good_total_ratio GoogleMonitoringSlo#good_total_ratio}
    */
    readonly goodTotalRatio?: GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatio;
}
export declare function googleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceToTerraform(struct?: GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceOutputReference | GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformance): any;
export declare class GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformance | undefined;
    set internalValue(value: GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformance | undefined);
    private _distributionCut;
    get distributionCut(): GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCutOutputReference;
    putDistributionCut(value: GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCut): void;
    resetDistributionCut(): void;
    get distributionCutInput(): GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceDistributionCut | undefined;
    private _goodTotalRatio;
    get goodTotalRatio(): GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatioOutputReference;
    putGoodTotalRatio(value: GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatio): void;
    resetGoodTotalRatio(): void;
    get goodTotalRatioInput(): GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceGoodTotalRatio | undefined;
}
export interface GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThreshold {
    /**
    * If window performance >= threshold, the window is counted
  as good.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#threshold GoogleMonitoringSlo#threshold}
    */
    readonly threshold?: number;
    /**
    * basic_sli_performance block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#basic_sli_performance GoogleMonitoringSlo#basic_sli_performance}
    */
    readonly basicSliPerformance?: GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformance;
    /**
    * performance block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#performance GoogleMonitoringSlo#performance}
    */
    readonly performance?: GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformance;
}
export declare function googleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdToTerraform(struct?: GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdOutputReference | GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThreshold): any;
export declare class GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThreshold | undefined;
    set internalValue(value: GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThreshold | undefined);
    private _threshold?;
    get threshold(): number;
    set threshold(value: number);
    resetThreshold(): void;
    get thresholdInput(): number | undefined;
    private _basicSliPerformance;
    get basicSliPerformance(): GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformanceOutputReference;
    putBasicSliPerformance(value: GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformance): void;
    resetBasicSliPerformance(): void;
    get basicSliPerformanceInput(): GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdBasicSliPerformance | undefined;
    private _performance;
    get performance(): GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformanceOutputReference;
    putPerformance(value: GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformance): void;
    resetPerformance(): void;
    get performanceInput(): GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdPerformance | undefined;
}
export interface GoogleMonitoringSloWindowsBasedSliMetricMeanInRangeRange {
    /**
    * max value for the range (inclusive). If not given,
  will be set to "infinity", defining an open range
  ">= range.min"
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#max GoogleMonitoringSlo#max}
    */
    readonly max?: number;
    /**
    * Min value for the range (inclusive). If not given,
  will be set to "-infinity", defining an open range
  "< range.max"
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#min GoogleMonitoringSlo#min}
    */
    readonly min?: number;
}
export declare function googleMonitoringSloWindowsBasedSliMetricMeanInRangeRangeToTerraform(struct?: GoogleMonitoringSloWindowsBasedSliMetricMeanInRangeRangeOutputReference | GoogleMonitoringSloWindowsBasedSliMetricMeanInRangeRange): any;
export declare class GoogleMonitoringSloWindowsBasedSliMetricMeanInRangeRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMonitoringSloWindowsBasedSliMetricMeanInRangeRange | undefined;
    set internalValue(value: GoogleMonitoringSloWindowsBasedSliMetricMeanInRangeRange | undefined);
    private _max?;
    get max(): number;
    set max(value: number);
    resetMax(): void;
    get maxInput(): number | undefined;
    private _min?;
    get min(): number;
    set min(value: number);
    resetMin(): void;
    get minInput(): number | undefined;
}
export interface GoogleMonitoringSloWindowsBasedSliMetricMeanInRange {
    /**
    * A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
  specifying the TimeSeries to use for evaluating window
  The provided TimeSeries must have ValueType = INT64 or
  ValueType = DOUBLE and MetricKind = GAUGE. Mean value 'X'
  should satisfy 'range.min <= X <= range.max'
  under good service.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#time_series GoogleMonitoringSlo#time_series}
    */
    readonly timeSeries: string;
    /**
    * range block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#range GoogleMonitoringSlo#range}
    */
    readonly range: GoogleMonitoringSloWindowsBasedSliMetricMeanInRangeRange;
}
export declare function googleMonitoringSloWindowsBasedSliMetricMeanInRangeToTerraform(struct?: GoogleMonitoringSloWindowsBasedSliMetricMeanInRangeOutputReference | GoogleMonitoringSloWindowsBasedSliMetricMeanInRange): any;
export declare class GoogleMonitoringSloWindowsBasedSliMetricMeanInRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMonitoringSloWindowsBasedSliMetricMeanInRange | undefined;
    set internalValue(value: GoogleMonitoringSloWindowsBasedSliMetricMeanInRange | undefined);
    private _timeSeries?;
    get timeSeries(): string;
    set timeSeries(value: string);
    get timeSeriesInput(): string | undefined;
    private _range;
    get range(): GoogleMonitoringSloWindowsBasedSliMetricMeanInRangeRangeOutputReference;
    putRange(value: GoogleMonitoringSloWindowsBasedSliMetricMeanInRangeRange): void;
    get rangeInput(): GoogleMonitoringSloWindowsBasedSliMetricMeanInRangeRange | undefined;
}
export interface GoogleMonitoringSloWindowsBasedSliMetricSumInRangeRange {
    /**
    * max value for the range (inclusive). If not given,
  will be set to "infinity", defining an open range
  ">= range.min"
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#max GoogleMonitoringSlo#max}
    */
    readonly max?: number;
    /**
    * Min value for the range (inclusive). If not given,
  will be set to "-infinity", defining an open range
  "< range.max"
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#min GoogleMonitoringSlo#min}
    */
    readonly min?: number;
}
export declare function googleMonitoringSloWindowsBasedSliMetricSumInRangeRangeToTerraform(struct?: GoogleMonitoringSloWindowsBasedSliMetricSumInRangeRangeOutputReference | GoogleMonitoringSloWindowsBasedSliMetricSumInRangeRange): any;
export declare class GoogleMonitoringSloWindowsBasedSliMetricSumInRangeRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMonitoringSloWindowsBasedSliMetricSumInRangeRange | undefined;
    set internalValue(value: GoogleMonitoringSloWindowsBasedSliMetricSumInRangeRange | undefined);
    private _max?;
    get max(): number;
    set max(value: number);
    resetMax(): void;
    get maxInput(): number | undefined;
    private _min?;
    get min(): number;
    set min(value: number);
    resetMin(): void;
    get minInput(): number | undefined;
}
export interface GoogleMonitoringSloWindowsBasedSliMetricSumInRange {
    /**
    * A [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
  specifying the TimeSeries to use for evaluating window
  quality. The provided TimeSeries must have
  ValueType = INT64 or ValueType = DOUBLE and
  MetricKind = GAUGE.
  
  Summed value 'X' should satisfy
  'range.min <= X <= range.max' for a good window.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#time_series GoogleMonitoringSlo#time_series}
    */
    readonly timeSeries: string;
    /**
    * range block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#range GoogleMonitoringSlo#range}
    */
    readonly range: GoogleMonitoringSloWindowsBasedSliMetricSumInRangeRange;
}
export declare function googleMonitoringSloWindowsBasedSliMetricSumInRangeToTerraform(struct?: GoogleMonitoringSloWindowsBasedSliMetricSumInRangeOutputReference | GoogleMonitoringSloWindowsBasedSliMetricSumInRange): any;
export declare class GoogleMonitoringSloWindowsBasedSliMetricSumInRangeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMonitoringSloWindowsBasedSliMetricSumInRange | undefined;
    set internalValue(value: GoogleMonitoringSloWindowsBasedSliMetricSumInRange | undefined);
    private _timeSeries?;
    get timeSeries(): string;
    set timeSeries(value: string);
    get timeSeriesInput(): string | undefined;
    private _range;
    get range(): GoogleMonitoringSloWindowsBasedSliMetricSumInRangeRangeOutputReference;
    putRange(value: GoogleMonitoringSloWindowsBasedSliMetricSumInRangeRange): void;
    get rangeInput(): GoogleMonitoringSloWindowsBasedSliMetricSumInRangeRange | undefined;
}
export interface GoogleMonitoringSloWindowsBasedSli {
    /**
    * A TimeSeries [monitoring filter](https://cloud.google.com/monitoring/api/v3/filters)
  with ValueType = BOOL. The window is good if any true values
  appear in the window. One of 'good_bad_metric_filter',
  'good_total_ratio_threshold', 'metric_mean_in_range',
  'metric_sum_in_range' must be set for 'windows_based_sli'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#good_bad_metric_filter GoogleMonitoringSlo#good_bad_metric_filter}
    */
    readonly goodBadMetricFilter?: string;
    /**
    * Duration over which window quality is evaluated, given as a
  duration string "{X}s" representing X seconds. Must be an
  integer fraction of a day and at least 60s.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#window_period GoogleMonitoringSlo#window_period}
    */
    readonly windowPeriod?: string;
    /**
    * good_total_ratio_threshold block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#good_total_ratio_threshold GoogleMonitoringSlo#good_total_ratio_threshold}
    */
    readonly goodTotalRatioThreshold?: GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThreshold;
    /**
    * metric_mean_in_range block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#metric_mean_in_range GoogleMonitoringSlo#metric_mean_in_range}
    */
    readonly metricMeanInRange?: GoogleMonitoringSloWindowsBasedSliMetricMeanInRange;
    /**
    * metric_sum_in_range block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo#metric_sum_in_range GoogleMonitoringSlo#metric_sum_in_range}
    */
    readonly metricSumInRange?: GoogleMonitoringSloWindowsBasedSliMetricSumInRange;
}
export declare function googleMonitoringSloWindowsBasedSliToTerraform(struct?: GoogleMonitoringSloWindowsBasedSliOutputReference | GoogleMonitoringSloWindowsBasedSli): any;
export declare class GoogleMonitoringSloWindowsBasedSliOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMonitoringSloWindowsBasedSli | undefined;
    set internalValue(value: GoogleMonitoringSloWindowsBasedSli | undefined);
    private _goodBadMetricFilter?;
    get goodBadMetricFilter(): string;
    set goodBadMetricFilter(value: string);
    resetGoodBadMetricFilter(): void;
    get goodBadMetricFilterInput(): string | undefined;
    private _windowPeriod?;
    get windowPeriod(): string;
    set windowPeriod(value: string);
    resetWindowPeriod(): void;
    get windowPeriodInput(): string | undefined;
    private _goodTotalRatioThreshold;
    get goodTotalRatioThreshold(): GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThresholdOutputReference;
    putGoodTotalRatioThreshold(value: GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThreshold): void;
    resetGoodTotalRatioThreshold(): void;
    get goodTotalRatioThresholdInput(): GoogleMonitoringSloWindowsBasedSliGoodTotalRatioThreshold | undefined;
    private _metricMeanInRange;
    get metricMeanInRange(): GoogleMonitoringSloWindowsBasedSliMetricMeanInRangeOutputReference;
    putMetricMeanInRange(value: GoogleMonitoringSloWindowsBasedSliMetricMeanInRange): void;
    resetMetricMeanInRange(): void;
    get metricMeanInRangeInput(): GoogleMonitoringSloWindowsBasedSliMetricMeanInRange | undefined;
    private _metricSumInRange;
    get metricSumInRange(): GoogleMonitoringSloWindowsBasedSliMetricSumInRangeOutputReference;
    putMetricSumInRange(value: GoogleMonitoringSloWindowsBasedSliMetricSumInRange): void;
    resetMetricSumInRange(): void;
    get metricSumInRangeInput(): GoogleMonitoringSloWindowsBasedSliMetricSumInRange | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo google_monitoring_slo}
*/
export declare class GoogleMonitoringSlo extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_monitoring_slo";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_slo google_monitoring_slo} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleMonitoringSloConfig
    */
    constructor(scope: Construct, id: string, config: GoogleMonitoringSloConfig);
    private _calendarPeriod?;
    get calendarPeriod(): string;
    set calendarPeriod(value: string);
    resetCalendarPeriod(): void;
    get calendarPeriodInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _goal?;
    get goal(): number;
    set goal(value: number);
    get goalInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _rollingPeriodDays?;
    get rollingPeriodDays(): number;
    set rollingPeriodDays(value: number);
    resetRollingPeriodDays(): void;
    get rollingPeriodDaysInput(): number | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
    private _sloId?;
    get sloId(): string;
    set sloId(value: string);
    resetSloId(): void;
    get sloIdInput(): string | undefined;
    private _userLabels?;
    get userLabels(): {
        [key: string]: string;
    };
    set userLabels(value: {
        [key: string]: string;
    });
    resetUserLabels(): void;
    get userLabelsInput(): {
        [key: string]: string;
    } | undefined;
    private _basicSli;
    get basicSli(): GoogleMonitoringSloBasicSliOutputReference;
    putBasicSli(value: GoogleMonitoringSloBasicSli): void;
    resetBasicSli(): void;
    get basicSliInput(): GoogleMonitoringSloBasicSli | undefined;
    private _requestBasedSli;
    get requestBasedSli(): GoogleMonitoringSloRequestBasedSliOutputReference;
    putRequestBasedSli(value: GoogleMonitoringSloRequestBasedSli): void;
    resetRequestBasedSli(): void;
    get requestBasedSliInput(): GoogleMonitoringSloRequestBasedSli | undefined;
    private _timeouts;
    get timeouts(): GoogleMonitoringSloTimeoutsOutputReference;
    putTimeouts(value: GoogleMonitoringSloTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleMonitoringSloTimeouts | undefined;
    private _windowsBasedSli;
    get windowsBasedSli(): GoogleMonitoringSloWindowsBasedSliOutputReference;
    putWindowsBasedSli(value: GoogleMonitoringSloWindowsBasedSli): void;
    resetWindowsBasedSli(): void;
    get windowsBasedSliInput(): GoogleMonitoringSloWindowsBasedSli | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
