import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleMonitoringUptimeCheckConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * The checker type to use for the check. If the monitored resource type is servicedirectory_service, checkerType must be set to VPC_CHECKERS. Possible values: ["STATIC_IP_CHECKERS", "VPC_CHECKERS"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_uptime_check_config#checker_type GoogleMonitoringUptimeCheckConfig#checker_type}
    */
    readonly checkerType?: string;
    /**
    * A human-friendly name for the uptime check configuration. The display name should be unique within a Stackdriver Workspace in order to make it easier to identify; however, uniqueness is not enforced.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_uptime_check_config#display_name GoogleMonitoringUptimeCheckConfig#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_uptime_check_config#id GoogleMonitoringUptimeCheckConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * How often, in seconds, the uptime check is performed. Currently, the only supported values are 60s (1 minute), 300s (5 minutes), 600s (10 minutes), and 900s (15 minutes). Optional, defaults to 300s.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_uptime_check_config#period GoogleMonitoringUptimeCheckConfig#period}
    */
    readonly period?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_uptime_check_config#project GoogleMonitoringUptimeCheckConfig#project}
    */
    readonly project?: string;
    /**
    * The list of regions from which the check will be run. Some regions contain one location, and others contain more than one. If this field is specified, enough regions to include a minimum of 3 locations must be provided, or an error message is returned. Not specifying this field will result in uptime checks running from all regions.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_uptime_check_config#selected_regions GoogleMonitoringUptimeCheckConfig#selected_regions}
    */
    readonly selectedRegions?: string[];
    /**
    * The maximum amount of time to wait for the request to complete (must be between 1 and 60 seconds). Accepted formats https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#google.protobuf.Duration
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_uptime_check_config#timeout GoogleMonitoringUptimeCheckConfig#timeout}
    */
    readonly timeout: string;
    /**
    * content_matchers block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_uptime_check_config#content_matchers GoogleMonitoringUptimeCheckConfig#content_matchers}
    */
    readonly contentMatchers?: GoogleMonitoringUptimeCheckConfigContentMatchers[] | cdktf.IResolvable;
    /**
    * http_check block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_uptime_check_config#http_check GoogleMonitoringUptimeCheckConfig#http_check}
    */
    readonly httpCheck?: GoogleMonitoringUptimeCheckConfigHttpCheck;
    /**
    * monitored_resource block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_uptime_check_config#monitored_resource GoogleMonitoringUptimeCheckConfig#monitored_resource}
    */
    readonly monitoredResource?: GoogleMonitoringUptimeCheckConfigMonitoredResource;
    /**
    * resource_group block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_uptime_check_config#resource_group GoogleMonitoringUptimeCheckConfig#resource_group}
    */
    readonly resourceGroup?: GoogleMonitoringUptimeCheckConfigResourceGroup;
    /**
    * tcp_check block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_uptime_check_config#tcp_check GoogleMonitoringUptimeCheckConfig#tcp_check}
    */
    readonly tcpCheck?: GoogleMonitoringUptimeCheckConfigTcpCheck;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_uptime_check_config#timeouts GoogleMonitoringUptimeCheckConfig#timeouts}
    */
    readonly timeouts?: GoogleMonitoringUptimeCheckConfigTimeouts;
}
export interface GoogleMonitoringUptimeCheckConfigContentMatchersJsonPathMatcher {
    /**
    * Options to perform JSONPath content matching. Default value: "EXACT_MATCH" Possible values: ["EXACT_MATCH", "REGEX_MATCH"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_uptime_check_config#json_matcher GoogleMonitoringUptimeCheckConfig#json_matcher}
    */
    readonly jsonMatcher?: string;
    /**
    * JSONPath within the response output pointing to the expected 'ContentMatcher::content' to match against.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_uptime_check_config#json_path GoogleMonitoringUptimeCheckConfig#json_path}
    */
    readonly jsonPath: string;
}
export declare function googleMonitoringUptimeCheckConfigContentMatchersJsonPathMatcherToTerraform(struct?: GoogleMonitoringUptimeCheckConfigContentMatchersJsonPathMatcherOutputReference | GoogleMonitoringUptimeCheckConfigContentMatchersJsonPathMatcher): any;
export declare class GoogleMonitoringUptimeCheckConfigContentMatchersJsonPathMatcherOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMonitoringUptimeCheckConfigContentMatchersJsonPathMatcher | undefined;
    set internalValue(value: GoogleMonitoringUptimeCheckConfigContentMatchersJsonPathMatcher | undefined);
    private _jsonMatcher?;
    get jsonMatcher(): string;
    set jsonMatcher(value: string);
    resetJsonMatcher(): void;
    get jsonMatcherInput(): string | undefined;
    private _jsonPath?;
    get jsonPath(): string;
    set jsonPath(value: string);
    get jsonPathInput(): string | undefined;
}
export interface GoogleMonitoringUptimeCheckConfigContentMatchers {
    /**
    * String or regex content to match (max 1024 bytes)
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_uptime_check_config#content GoogleMonitoringUptimeCheckConfig#content}
    */
    readonly content: string;
    /**
    * The type of content matcher that will be applied to the server output, compared to the content string when the check is run. Default value: "CONTAINS_STRING" Possible values: ["CONTAINS_STRING", "NOT_CONTAINS_STRING", "MATCHES_REGEX", "NOT_MATCHES_REGEX", "MATCHES_JSON_PATH", "NOT_MATCHES_JSON_PATH"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_uptime_check_config#matcher GoogleMonitoringUptimeCheckConfig#matcher}
    */
    readonly matcher?: string;
    /**
    * json_path_matcher block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_uptime_check_config#json_path_matcher GoogleMonitoringUptimeCheckConfig#json_path_matcher}
    */
    readonly jsonPathMatcher?: GoogleMonitoringUptimeCheckConfigContentMatchersJsonPathMatcher;
}
export declare function googleMonitoringUptimeCheckConfigContentMatchersToTerraform(struct?: GoogleMonitoringUptimeCheckConfigContentMatchers | cdktf.IResolvable): any;
export declare class GoogleMonitoringUptimeCheckConfigContentMatchersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleMonitoringUptimeCheckConfigContentMatchers | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleMonitoringUptimeCheckConfigContentMatchers | cdktf.IResolvable | undefined);
    private _content?;
    get content(): string;
    set content(value: string);
    get contentInput(): string | undefined;
    private _matcher?;
    get matcher(): string;
    set matcher(value: string);
    resetMatcher(): void;
    get matcherInput(): string | undefined;
    private _jsonPathMatcher;
    get jsonPathMatcher(): GoogleMonitoringUptimeCheckConfigContentMatchersJsonPathMatcherOutputReference;
    putJsonPathMatcher(value: GoogleMonitoringUptimeCheckConfigContentMatchersJsonPathMatcher): void;
    resetJsonPathMatcher(): void;
    get jsonPathMatcherInput(): GoogleMonitoringUptimeCheckConfigContentMatchersJsonPathMatcher | undefined;
}
export declare class GoogleMonitoringUptimeCheckConfigContentMatchersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleMonitoringUptimeCheckConfigContentMatchers[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleMonitoringUptimeCheckConfigContentMatchersOutputReference;
}
export interface GoogleMonitoringUptimeCheckConfigHttpCheckAcceptedResponseStatusCodes {
    /**
    * A class of status codes to accept. Possible values: ["STATUS_CLASS_1XX", "STATUS_CLASS_2XX", "STATUS_CLASS_3XX", "STATUS_CLASS_4XX", "STATUS_CLASS_5XX", "STATUS_CLASS_ANY"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_uptime_check_config#status_class GoogleMonitoringUptimeCheckConfig#status_class}
    */
    readonly statusClass?: string;
    /**
    * A status code to accept.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_uptime_check_config#status_value GoogleMonitoringUptimeCheckConfig#status_value}
    */
    readonly statusValue?: number;
}
export declare function googleMonitoringUptimeCheckConfigHttpCheckAcceptedResponseStatusCodesToTerraform(struct?: GoogleMonitoringUptimeCheckConfigHttpCheckAcceptedResponseStatusCodes | cdktf.IResolvable): any;
export declare class GoogleMonitoringUptimeCheckConfigHttpCheckAcceptedResponseStatusCodesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleMonitoringUptimeCheckConfigHttpCheckAcceptedResponseStatusCodes | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleMonitoringUptimeCheckConfigHttpCheckAcceptedResponseStatusCodes | cdktf.IResolvable | undefined);
    private _statusClass?;
    get statusClass(): string;
    set statusClass(value: string);
    resetStatusClass(): void;
    get statusClassInput(): string | undefined;
    private _statusValue?;
    get statusValue(): number;
    set statusValue(value: number);
    resetStatusValue(): void;
    get statusValueInput(): number | undefined;
}
export declare class GoogleMonitoringUptimeCheckConfigHttpCheckAcceptedResponseStatusCodesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleMonitoringUptimeCheckConfigHttpCheckAcceptedResponseStatusCodes[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleMonitoringUptimeCheckConfigHttpCheckAcceptedResponseStatusCodesOutputReference;
}
export interface GoogleMonitoringUptimeCheckConfigHttpCheckAuthInfo {
    /**
    * The password to authenticate.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_uptime_check_config#password GoogleMonitoringUptimeCheckConfig#password}
    */
    readonly password: string;
    /**
    * The username to authenticate.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_uptime_check_config#username GoogleMonitoringUptimeCheckConfig#username}
    */
    readonly username: string;
}
export declare function googleMonitoringUptimeCheckConfigHttpCheckAuthInfoToTerraform(struct?: GoogleMonitoringUptimeCheckConfigHttpCheckAuthInfoOutputReference | GoogleMonitoringUptimeCheckConfigHttpCheckAuthInfo): any;
export declare class GoogleMonitoringUptimeCheckConfigHttpCheckAuthInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMonitoringUptimeCheckConfigHttpCheckAuthInfo | undefined;
    set internalValue(value: GoogleMonitoringUptimeCheckConfigHttpCheckAuthInfo | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface GoogleMonitoringUptimeCheckConfigHttpCheck {
    /**
    * The request body associated with the HTTP POST request. If contentType is URL_ENCODED, the body passed in must be URL-encoded. Users can provide a Content-Length header via the headers field or the API will do so. If the requestMethod is GET and body is not empty, the API will return an error. The maximum byte size is 1 megabyte. Note - As with all bytes fields JSON representations are base64 encoded. e.g. "foo=bar" in URL-encoded form is "foo%3Dbar" and in base64 encoding is "Zm9vJTI1M0RiYXI=".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_uptime_check_config#body GoogleMonitoringUptimeCheckConfig#body}
    */
    readonly body?: string;
    /**
    * The content type to use for the check. Possible values: ["TYPE_UNSPECIFIED", "URL_ENCODED"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_uptime_check_config#content_type GoogleMonitoringUptimeCheckConfig#content_type}
    */
    readonly contentType?: string;
    /**
    * The list of headers to send as part of the uptime check request. If two headers have the same key and different values, they should be entered as a single header, with the value being a comma-separated list of all the desired values as described at https://www.w3.org/Protocols/rfc2616/rfc2616.txt (page 31). Entering two separate headers with the same key in a Create call will cause the first to be overwritten by the second. The maximum number of headers allowed is 100.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_uptime_check_config#headers GoogleMonitoringUptimeCheckConfig#headers}
    */
    readonly headers?: {
        [key: string]: string;
    };
    /**
    * Boolean specifying whether to encrypt the header information. Encryption should be specified for any headers related to authentication that you do not wish to be seen when retrieving the configuration. The server will be responsible for encrypting the headers. On Get/List calls, if mask_headers is set to True then the headers will be obscured with ******.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_uptime_check_config#mask_headers GoogleMonitoringUptimeCheckConfig#mask_headers}
    */
    readonly maskHeaders?: boolean | cdktf.IResolvable;
    /**
    * The path to the page to run the check against. Will be combined with the host (specified within the MonitoredResource) and port to construct the full URL. If the provided path does not begin with "/", a "/" will be prepended automatically. Optional (defaults to "/").
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_uptime_check_config#path GoogleMonitoringUptimeCheckConfig#path}
    */
    readonly path?: string;
    /**
    * The port to the page to run the check against. Will be combined with host (specified within the MonitoredResource) and path to construct the full URL. Optional (defaults to 80 without SSL, or 443 with SSL).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_uptime_check_config#port GoogleMonitoringUptimeCheckConfig#port}
    */
    readonly port?: number;
    /**
    * The HTTP request method to use for the check. If set to METHOD_UNSPECIFIED then requestMethod defaults to GET. Default value: "GET" Possible values: ["METHOD_UNSPECIFIED", "GET", "POST"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_uptime_check_config#request_method GoogleMonitoringUptimeCheckConfig#request_method}
    */
    readonly requestMethod?: string;
    /**
    * If true, use HTTPS instead of HTTP to run the check.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_uptime_check_config#use_ssl GoogleMonitoringUptimeCheckConfig#use_ssl}
    */
    readonly useSsl?: boolean | cdktf.IResolvable;
    /**
    * Boolean specifying whether to include SSL certificate validation as a part of the Uptime check. Only applies to checks where monitoredResource is set to uptime_url. If useSsl is false, setting validateSsl to true has no effect.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_uptime_check_config#validate_ssl GoogleMonitoringUptimeCheckConfig#validate_ssl}
    */
    readonly validateSsl?: boolean | cdktf.IResolvable;
    /**
    * accepted_response_status_codes block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_uptime_check_config#accepted_response_status_codes GoogleMonitoringUptimeCheckConfig#accepted_response_status_codes}
    */
    readonly acceptedResponseStatusCodes?: GoogleMonitoringUptimeCheckConfigHttpCheckAcceptedResponseStatusCodes[] | cdktf.IResolvable;
    /**
    * auth_info block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_uptime_check_config#auth_info GoogleMonitoringUptimeCheckConfig#auth_info}
    */
    readonly authInfo?: GoogleMonitoringUptimeCheckConfigHttpCheckAuthInfo;
}
export declare function googleMonitoringUptimeCheckConfigHttpCheckToTerraform(struct?: GoogleMonitoringUptimeCheckConfigHttpCheckOutputReference | GoogleMonitoringUptimeCheckConfigHttpCheck): any;
export declare class GoogleMonitoringUptimeCheckConfigHttpCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMonitoringUptimeCheckConfigHttpCheck | undefined;
    set internalValue(value: GoogleMonitoringUptimeCheckConfigHttpCheck | undefined);
    private _body?;
    get body(): string;
    set body(value: string);
    resetBody(): void;
    get bodyInput(): string | undefined;
    private _contentType?;
    get contentType(): string;
    set contentType(value: string);
    resetContentType(): void;
    get contentTypeInput(): string | undefined;
    private _headers?;
    get headers(): {
        [key: string]: string;
    };
    set headers(value: {
        [key: string]: string;
    });
    resetHeaders(): void;
    get headersInput(): {
        [key: string]: string;
    } | undefined;
    private _maskHeaders?;
    get maskHeaders(): boolean | cdktf.IResolvable;
    set maskHeaders(value: boolean | cdktf.IResolvable);
    resetMaskHeaders(): void;
    get maskHeadersInput(): boolean | cdktf.IResolvable | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _port?;
    get port(): number;
    set port(value: number);
    resetPort(): void;
    get portInput(): number | undefined;
    private _requestMethod?;
    get requestMethod(): string;
    set requestMethod(value: string);
    resetRequestMethod(): void;
    get requestMethodInput(): string | undefined;
    private _useSsl?;
    get useSsl(): boolean | cdktf.IResolvable;
    set useSsl(value: boolean | cdktf.IResolvable);
    resetUseSsl(): void;
    get useSslInput(): boolean | cdktf.IResolvable | undefined;
    private _validateSsl?;
    get validateSsl(): boolean | cdktf.IResolvable;
    set validateSsl(value: boolean | cdktf.IResolvable);
    resetValidateSsl(): void;
    get validateSslInput(): boolean | cdktf.IResolvable | undefined;
    private _acceptedResponseStatusCodes;
    get acceptedResponseStatusCodes(): GoogleMonitoringUptimeCheckConfigHttpCheckAcceptedResponseStatusCodesList;
    putAcceptedResponseStatusCodes(value: GoogleMonitoringUptimeCheckConfigHttpCheckAcceptedResponseStatusCodes[] | cdktf.IResolvable): void;
    resetAcceptedResponseStatusCodes(): void;
    get acceptedResponseStatusCodesInput(): cdktf.IResolvable | GoogleMonitoringUptimeCheckConfigHttpCheckAcceptedResponseStatusCodes[] | undefined;
    private _authInfo;
    get authInfo(): GoogleMonitoringUptimeCheckConfigHttpCheckAuthInfoOutputReference;
    putAuthInfo(value: GoogleMonitoringUptimeCheckConfigHttpCheckAuthInfo): void;
    resetAuthInfo(): void;
    get authInfoInput(): GoogleMonitoringUptimeCheckConfigHttpCheckAuthInfo | undefined;
}
export interface GoogleMonitoringUptimeCheckConfigMonitoredResource {
    /**
    * Values for all of the labels listed in the associated monitored resource descriptor. For example, Compute Engine VM instances use the labels "project_id", "instance_id", and "zone".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_uptime_check_config#labels GoogleMonitoringUptimeCheckConfig#labels}
    */
    readonly labels: {
        [key: string]: string;
    };
    /**
    * The monitored resource type. This field must match the type field of a MonitoredResourceDescriptor (https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.monitoredResourceDescriptors#MonitoredResourceDescriptor) object. For example, the type of a Compute Engine VM instance is gce_instance. For a list of types, see Monitoring resource types (https://cloud.google.com/monitoring/api/resources) and Logging resource types (https://cloud.google.com/logging/docs/api/v2/resource-list).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_uptime_check_config#type GoogleMonitoringUptimeCheckConfig#type}
    */
    readonly type: string;
}
export declare function googleMonitoringUptimeCheckConfigMonitoredResourceToTerraform(struct?: GoogleMonitoringUptimeCheckConfigMonitoredResourceOutputReference | GoogleMonitoringUptimeCheckConfigMonitoredResource): any;
export declare class GoogleMonitoringUptimeCheckConfigMonitoredResourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMonitoringUptimeCheckConfigMonitoredResource | undefined;
    set internalValue(value: GoogleMonitoringUptimeCheckConfigMonitoredResource | undefined);
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface GoogleMonitoringUptimeCheckConfigResourceGroup {
    /**
    * The group of resources being monitored. Should be the 'name' of a group
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_uptime_check_config#group_id GoogleMonitoringUptimeCheckConfig#group_id}
    */
    readonly groupId?: string;
    /**
    * The resource type of the group members. Possible values: ["RESOURCE_TYPE_UNSPECIFIED", "INSTANCE", "AWS_ELB_LOAD_BALANCER"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_uptime_check_config#resource_type GoogleMonitoringUptimeCheckConfig#resource_type}
    */
    readonly resourceType?: string;
}
export declare function googleMonitoringUptimeCheckConfigResourceGroupToTerraform(struct?: GoogleMonitoringUptimeCheckConfigResourceGroupOutputReference | GoogleMonitoringUptimeCheckConfigResourceGroup): any;
export declare class GoogleMonitoringUptimeCheckConfigResourceGroupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMonitoringUptimeCheckConfigResourceGroup | undefined;
    set internalValue(value: GoogleMonitoringUptimeCheckConfigResourceGroup | undefined);
    private _groupId?;
    get groupId(): string;
    set groupId(value: string);
    resetGroupId(): void;
    get groupIdInput(): string | undefined;
    private _resourceType?;
    get resourceType(): string;
    set resourceType(value: string);
    resetResourceType(): void;
    get resourceTypeInput(): string | undefined;
}
export interface GoogleMonitoringUptimeCheckConfigTcpCheck {
    /**
    * The port to the page to run the check against. Will be combined with host (specified within the MonitoredResource) to construct the full URL.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_uptime_check_config#port GoogleMonitoringUptimeCheckConfig#port}
    */
    readonly port: number;
}
export declare function googleMonitoringUptimeCheckConfigTcpCheckToTerraform(struct?: GoogleMonitoringUptimeCheckConfigTcpCheckOutputReference | GoogleMonitoringUptimeCheckConfigTcpCheck): any;
export declare class GoogleMonitoringUptimeCheckConfigTcpCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMonitoringUptimeCheckConfigTcpCheck | undefined;
    set internalValue(value: GoogleMonitoringUptimeCheckConfigTcpCheck | undefined);
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
}
export interface GoogleMonitoringUptimeCheckConfigTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_uptime_check_config#create GoogleMonitoringUptimeCheckConfig#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_uptime_check_config#delete GoogleMonitoringUptimeCheckConfig#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_uptime_check_config#update GoogleMonitoringUptimeCheckConfig#update}
    */
    readonly update?: string;
}
export declare function googleMonitoringUptimeCheckConfigTimeoutsToTerraform(struct?: GoogleMonitoringUptimeCheckConfigTimeouts | cdktf.IResolvable): any;
export declare class GoogleMonitoringUptimeCheckConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleMonitoringUptimeCheckConfigTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleMonitoringUptimeCheckConfigTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_uptime_check_config google_monitoring_uptime_check_config}
*/
export declare class GoogleMonitoringUptimeCheckConfig extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_monitoring_uptime_check_config";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_monitoring_uptime_check_config google_monitoring_uptime_check_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleMonitoringUptimeCheckConfigConfig
    */
    constructor(scope: Construct, id: string, config: GoogleMonitoringUptimeCheckConfigConfig);
    private _checkerType?;
    get checkerType(): string;
    set checkerType(value: string);
    resetCheckerType(): void;
    get checkerTypeInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _period?;
    get period(): string;
    set period(value: string);
    resetPeriod(): void;
    get periodInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _selectedRegions?;
    get selectedRegions(): string[];
    set selectedRegions(value: string[]);
    resetSelectedRegions(): void;
    get selectedRegionsInput(): string[] | undefined;
    private _timeout?;
    get timeout(): string;
    set timeout(value: string);
    get timeoutInput(): string | undefined;
    get uptimeCheckId(): string;
    private _contentMatchers;
    get contentMatchers(): GoogleMonitoringUptimeCheckConfigContentMatchersList;
    putContentMatchers(value: GoogleMonitoringUptimeCheckConfigContentMatchers[] | cdktf.IResolvable): void;
    resetContentMatchers(): void;
    get contentMatchersInput(): cdktf.IResolvable | GoogleMonitoringUptimeCheckConfigContentMatchers[] | undefined;
    private _httpCheck;
    get httpCheck(): GoogleMonitoringUptimeCheckConfigHttpCheckOutputReference;
    putHttpCheck(value: GoogleMonitoringUptimeCheckConfigHttpCheck): void;
    resetHttpCheck(): void;
    get httpCheckInput(): GoogleMonitoringUptimeCheckConfigHttpCheck | undefined;
    private _monitoredResource;
    get monitoredResource(): GoogleMonitoringUptimeCheckConfigMonitoredResourceOutputReference;
    putMonitoredResource(value: GoogleMonitoringUptimeCheckConfigMonitoredResource): void;
    resetMonitoredResource(): void;
    get monitoredResourceInput(): GoogleMonitoringUptimeCheckConfigMonitoredResource | undefined;
    private _resourceGroup;
    get resourceGroup(): GoogleMonitoringUptimeCheckConfigResourceGroupOutputReference;
    putResourceGroup(value: GoogleMonitoringUptimeCheckConfigResourceGroup): void;
    resetResourceGroup(): void;
    get resourceGroupInput(): GoogleMonitoringUptimeCheckConfigResourceGroup | undefined;
    private _tcpCheck;
    get tcpCheck(): GoogleMonitoringUptimeCheckConfigTcpCheckOutputReference;
    putTcpCheck(value: GoogleMonitoringUptimeCheckConfigTcpCheck): void;
    resetTcpCheck(): void;
    get tcpCheckInput(): GoogleMonitoringUptimeCheckConfigTcpCheck | undefined;
    private _timeouts;
    get timeouts(): GoogleMonitoringUptimeCheckConfigTimeoutsOutputReference;
    putTimeouts(value: GoogleMonitoringUptimeCheckConfigTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleMonitoringUptimeCheckConfigTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
