import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleNetworkServicesGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
    * A free-text description of the resource. Max length 1024 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_network_services_gateway#description GoogleNetworkServicesGateway#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_network_services_gateway#id GoogleNetworkServicesGateway#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Set of label tags associated with the Gateway resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_network_services_gateway#labels GoogleNetworkServicesGateway#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The location of the gateway.
  The default value is 'global'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_network_services_gateway#location GoogleNetworkServicesGateway#location}
    */
    readonly location?: string;
    /**
    * Short name of the Gateway resource to be created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_network_services_gateway#name GoogleNetworkServicesGateway#name}
    */
    readonly name: string;
    /**
    * One or more port numbers (1-65535), on which the Gateway will receive traffic.
  The proxy binds to the specified ports. Gateways of type 'SECURE_WEB_GATEWAY' are
  limited to 1 port. Gateways of type 'OPEN_MESH' listen on 0.0.0.0 and support multiple ports.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_network_services_gateway#ports GoogleNetworkServicesGateway#ports}
    */
    readonly ports: number[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_network_services_gateway#project GoogleNetworkServicesGateway#project}
    */
    readonly project?: string;
    /**
    * Immutable. Scope determines how configuration across multiple Gateway instances are merged.
  The configuration for multiple Gateway instances with the same scope will be merged as presented as
  a single coniguration to the proxy/load balancer.
  Max length 64 characters. Scope should start with a letter and can only have letters, numbers, hyphens.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_network_services_gateway#scope GoogleNetworkServicesGateway#scope}
    */
    readonly scope: string;
    /**
    * A fully-qualified ServerTLSPolicy URL reference. Specifies how TLS traffic is terminated.
  If empty, TLS termination is disabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_network_services_gateway#server_tls_policy GoogleNetworkServicesGateway#server_tls_policy}
    */
    readonly serverTlsPolicy?: string;
    /**
    * Immutable. The type of the customer-managed gateway. Possible values are: * OPEN_MESH * SECURE_WEB_GATEWAY. Possible values: ["TYPE_UNSPECIFIED", "OPEN_MESH", "SECURE_WEB_GATEWAY"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_network_services_gateway#type GoogleNetworkServicesGateway#type}
    */
    readonly type: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_network_services_gateway#timeouts GoogleNetworkServicesGateway#timeouts}
    */
    readonly timeouts?: GoogleNetworkServicesGatewayTimeouts;
}
export interface GoogleNetworkServicesGatewayTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_network_services_gateway#create GoogleNetworkServicesGateway#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_network_services_gateway#delete GoogleNetworkServicesGateway#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_network_services_gateway#update GoogleNetworkServicesGateway#update}
    */
    readonly update?: string;
}
export declare function googleNetworkServicesGatewayTimeoutsToTerraform(struct?: GoogleNetworkServicesGatewayTimeouts | cdktf.IResolvable): any;
export declare class GoogleNetworkServicesGatewayTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleNetworkServicesGatewayTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleNetworkServicesGatewayTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_network_services_gateway google_network_services_gateway}
*/
export declare class GoogleNetworkServicesGateway extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_network_services_gateway";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_network_services_gateway google_network_services_gateway} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleNetworkServicesGatewayConfig
    */
    constructor(scope: Construct, id: string, config: GoogleNetworkServicesGatewayConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _ports?;
    get ports(): number[];
    set ports(value: number[]);
    get portsInput(): number[] | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    get scopeInput(): string | undefined;
    get selfLink(): string;
    private _serverTlsPolicy?;
    get serverTlsPolicy(): string;
    set serverTlsPolicy(value: string);
    resetServerTlsPolicy(): void;
    get serverTlsPolicyInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    get updateTime(): string;
    private _timeouts;
    get timeouts(): GoogleNetworkServicesGatewayTimeoutsOutputReference;
    putTimeouts(value: GoogleNetworkServicesGatewayTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleNetworkServicesGatewayTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
