import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleOsLoginSshPublicKeyConfig extends cdktf.TerraformMetaArguments {
    /**
    * An expiration time in microseconds since epoch.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_os_login_ssh_public_key#expiration_time_usec GoogleOsLoginSshPublicKey#expiration_time_usec}
    */
    readonly expirationTimeUsec?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_os_login_ssh_public_key#id GoogleOsLoginSshPublicKey#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Public key text in SSH format, defined by RFC4253 section 6.6.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_os_login_ssh_public_key#key GoogleOsLoginSshPublicKey#key}
    */
    readonly key: string;
    /**
    * The project ID of the Google Cloud Platform project.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_os_login_ssh_public_key#project GoogleOsLoginSshPublicKey#project}
    */
    readonly project?: string;
    /**
    * The user email.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_os_login_ssh_public_key#user GoogleOsLoginSshPublicKey#user}
    */
    readonly user: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_os_login_ssh_public_key#timeouts GoogleOsLoginSshPublicKey#timeouts}
    */
    readonly timeouts?: GoogleOsLoginSshPublicKeyTimeouts;
}
export interface GoogleOsLoginSshPublicKeyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_os_login_ssh_public_key#create GoogleOsLoginSshPublicKey#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_os_login_ssh_public_key#delete GoogleOsLoginSshPublicKey#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_os_login_ssh_public_key#update GoogleOsLoginSshPublicKey#update}
    */
    readonly update?: string;
}
export declare function googleOsLoginSshPublicKeyTimeoutsToTerraform(struct?: GoogleOsLoginSshPublicKeyTimeouts | cdktf.IResolvable): any;
export declare class GoogleOsLoginSshPublicKeyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleOsLoginSshPublicKeyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleOsLoginSshPublicKeyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_os_login_ssh_public_key google_os_login_ssh_public_key}
*/
export declare class GoogleOsLoginSshPublicKey extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_os_login_ssh_public_key";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_os_login_ssh_public_key google_os_login_ssh_public_key} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleOsLoginSshPublicKeyConfig
    */
    constructor(scope: Construct, id: string, config: GoogleOsLoginSshPublicKeyConfig);
    private _expirationTimeUsec?;
    get expirationTimeUsec(): string;
    set expirationTimeUsec(value: string);
    resetExpirationTimeUsec(): void;
    get expirationTimeUsecInput(): string | undefined;
    get fingerprint(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _user?;
    get user(): string;
    set user(value: string);
    get userInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleOsLoginSshPublicKeyTimeoutsOutputReference;
    putTimeouts(value: GoogleOsLoginSshPublicKeyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleOsLoginSshPublicKeyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
