import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GooglePrivatecaCaPoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#id GooglePrivatecaCaPool#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Labels with user-defined metadata.
  
  An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass":
  "1.3kg", "count": "3" }.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#labels GooglePrivatecaCaPool#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Location of the CaPool. A full list of valid locations can be found by
  running 'gcloud privateca locations list'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#location GooglePrivatecaCaPool#location}
    */
    readonly location: string;
    /**
    * The name for this CaPool.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#name GooglePrivatecaCaPool#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#project GooglePrivatecaCaPool#project}
    */
    readonly project?: string;
    /**
    * The Tier of this CaPool. Possible values: ["ENTERPRISE", "DEVOPS"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#tier GooglePrivatecaCaPool#tier}
    */
    readonly tier: string;
    /**
    * issuance_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#issuance_policy GooglePrivatecaCaPool#issuance_policy}
    */
    readonly issuancePolicy?: GooglePrivatecaCaPoolIssuancePolicy;
    /**
    * publishing_options block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#publishing_options GooglePrivatecaCaPool#publishing_options}
    */
    readonly publishingOptions?: GooglePrivatecaCaPoolPublishingOptions;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#timeouts GooglePrivatecaCaPool#timeouts}
    */
    readonly timeouts?: GooglePrivatecaCaPoolTimeouts;
}
export interface GooglePrivatecaCaPoolIssuancePolicyAllowedIssuanceModes {
    /**
    * When true, allows callers to create Certificates by specifying a CertificateConfig.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#allow_config_based_issuance GooglePrivatecaCaPool#allow_config_based_issuance}
    */
    readonly allowConfigBasedIssuance: boolean | cdktf.IResolvable;
    /**
    * When true, allows callers to create Certificates by specifying a CSR.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#allow_csr_based_issuance GooglePrivatecaCaPool#allow_csr_based_issuance}
    */
    readonly allowCsrBasedIssuance: boolean | cdktf.IResolvable;
}
export declare function googlePrivatecaCaPoolIssuancePolicyAllowedIssuanceModesToTerraform(struct?: GooglePrivatecaCaPoolIssuancePolicyAllowedIssuanceModesOutputReference | GooglePrivatecaCaPoolIssuancePolicyAllowedIssuanceModes): any;
export declare class GooglePrivatecaCaPoolIssuancePolicyAllowedIssuanceModesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePrivatecaCaPoolIssuancePolicyAllowedIssuanceModes | undefined;
    set internalValue(value: GooglePrivatecaCaPoolIssuancePolicyAllowedIssuanceModes | undefined);
    private _allowConfigBasedIssuance?;
    get allowConfigBasedIssuance(): boolean | cdktf.IResolvable;
    set allowConfigBasedIssuance(value: boolean | cdktf.IResolvable);
    get allowConfigBasedIssuanceInput(): boolean | cdktf.IResolvable | undefined;
    private _allowCsrBasedIssuance?;
    get allowCsrBasedIssuance(): boolean | cdktf.IResolvable;
    set allowCsrBasedIssuance(value: boolean | cdktf.IResolvable);
    get allowCsrBasedIssuanceInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GooglePrivatecaCaPoolIssuancePolicyAllowedKeyTypesEllipticCurve {
    /**
    * The algorithm used. Possible values: ["ECDSA_P256", "ECDSA_P384", "EDDSA_25519"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#signature_algorithm GooglePrivatecaCaPool#signature_algorithm}
    */
    readonly signatureAlgorithm: string;
}
export declare function googlePrivatecaCaPoolIssuancePolicyAllowedKeyTypesEllipticCurveToTerraform(struct?: GooglePrivatecaCaPoolIssuancePolicyAllowedKeyTypesEllipticCurveOutputReference | GooglePrivatecaCaPoolIssuancePolicyAllowedKeyTypesEllipticCurve): any;
export declare class GooglePrivatecaCaPoolIssuancePolicyAllowedKeyTypesEllipticCurveOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePrivatecaCaPoolIssuancePolicyAllowedKeyTypesEllipticCurve | undefined;
    set internalValue(value: GooglePrivatecaCaPoolIssuancePolicyAllowedKeyTypesEllipticCurve | undefined);
    private _signatureAlgorithm?;
    get signatureAlgorithm(): string;
    set signatureAlgorithm(value: string);
    get signatureAlgorithmInput(): string | undefined;
}
export interface GooglePrivatecaCaPoolIssuancePolicyAllowedKeyTypesRsa {
    /**
    * The maximum allowed RSA modulus size, in bits. If this is not set, or if set to zero, the
  service will not enforce an explicit upper bound on RSA modulus sizes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#max_modulus_size GooglePrivatecaCaPool#max_modulus_size}
    */
    readonly maxModulusSize?: string;
    /**
    * The minimum allowed RSA modulus size, in bits. If this is not set, or if set to zero, the
  service-level min RSA modulus size will continue to apply.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#min_modulus_size GooglePrivatecaCaPool#min_modulus_size}
    */
    readonly minModulusSize?: string;
}
export declare function googlePrivatecaCaPoolIssuancePolicyAllowedKeyTypesRsaToTerraform(struct?: GooglePrivatecaCaPoolIssuancePolicyAllowedKeyTypesRsaOutputReference | GooglePrivatecaCaPoolIssuancePolicyAllowedKeyTypesRsa): any;
export declare class GooglePrivatecaCaPoolIssuancePolicyAllowedKeyTypesRsaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePrivatecaCaPoolIssuancePolicyAllowedKeyTypesRsa | undefined;
    set internalValue(value: GooglePrivatecaCaPoolIssuancePolicyAllowedKeyTypesRsa | undefined);
    private _maxModulusSize?;
    get maxModulusSize(): string;
    set maxModulusSize(value: string);
    resetMaxModulusSize(): void;
    get maxModulusSizeInput(): string | undefined;
    private _minModulusSize?;
    get minModulusSize(): string;
    set minModulusSize(value: string);
    resetMinModulusSize(): void;
    get minModulusSizeInput(): string | undefined;
}
export interface GooglePrivatecaCaPoolIssuancePolicyAllowedKeyTypes {
    /**
    * elliptic_curve block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#elliptic_curve GooglePrivatecaCaPool#elliptic_curve}
    */
    readonly ellipticCurve?: GooglePrivatecaCaPoolIssuancePolicyAllowedKeyTypesEllipticCurve;
    /**
    * rsa block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#rsa GooglePrivatecaCaPool#rsa}
    */
    readonly rsa?: GooglePrivatecaCaPoolIssuancePolicyAllowedKeyTypesRsa;
}
export declare function googlePrivatecaCaPoolIssuancePolicyAllowedKeyTypesToTerraform(struct?: GooglePrivatecaCaPoolIssuancePolicyAllowedKeyTypes | cdktf.IResolvable): any;
export declare class GooglePrivatecaCaPoolIssuancePolicyAllowedKeyTypesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GooglePrivatecaCaPoolIssuancePolicyAllowedKeyTypes | cdktf.IResolvable | undefined;
    set internalValue(value: GooglePrivatecaCaPoolIssuancePolicyAllowedKeyTypes | cdktf.IResolvable | undefined);
    private _ellipticCurve;
    get ellipticCurve(): GooglePrivatecaCaPoolIssuancePolicyAllowedKeyTypesEllipticCurveOutputReference;
    putEllipticCurve(value: GooglePrivatecaCaPoolIssuancePolicyAllowedKeyTypesEllipticCurve): void;
    resetEllipticCurve(): void;
    get ellipticCurveInput(): GooglePrivatecaCaPoolIssuancePolicyAllowedKeyTypesEllipticCurve | undefined;
    private _rsa;
    get rsa(): GooglePrivatecaCaPoolIssuancePolicyAllowedKeyTypesRsaOutputReference;
    putRsa(value: GooglePrivatecaCaPoolIssuancePolicyAllowedKeyTypesRsa): void;
    resetRsa(): void;
    get rsaInput(): GooglePrivatecaCaPoolIssuancePolicyAllowedKeyTypesRsa | undefined;
}
export declare class GooglePrivatecaCaPoolIssuancePolicyAllowedKeyTypesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GooglePrivatecaCaPoolIssuancePolicyAllowedKeyTypes[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GooglePrivatecaCaPoolIssuancePolicyAllowedKeyTypesOutputReference;
}
export interface GooglePrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensionsObjectId {
    /**
    * An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#object_id_path GooglePrivatecaCaPool#object_id_path}
    */
    readonly objectIdPath: number[];
}
export declare function googlePrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensionsObjectIdToTerraform(struct?: GooglePrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensionsObjectIdOutputReference | GooglePrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensionsObjectId): any;
export declare class GooglePrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensionsObjectIdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensionsObjectId | undefined;
    set internalValue(value: GooglePrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensionsObjectId | undefined);
    private _objectIdPath?;
    get objectIdPath(): number[];
    set objectIdPath(value: number[]);
    get objectIdPathInput(): number[] | undefined;
}
export interface GooglePrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensions {
    /**
    * Indicates whether or not this extension is critical (i.e., if the client does not know how to
  handle this extension, the client should consider this to be an error).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#critical GooglePrivatecaCaPool#critical}
    */
    readonly critical: boolean | cdktf.IResolvable;
    /**
    * The value of this X.509 extension. A base64-encoded string.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#value GooglePrivatecaCaPool#value}
    */
    readonly value: string;
    /**
    * object_id block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#object_id GooglePrivatecaCaPool#object_id}
    */
    readonly objectId: GooglePrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensionsObjectId;
}
export declare function googlePrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensionsToTerraform(struct?: GooglePrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensions | cdktf.IResolvable): any;
export declare class GooglePrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GooglePrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensions | cdktf.IResolvable | undefined;
    set internalValue(value: GooglePrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensions | cdktf.IResolvable | undefined);
    private _critical?;
    get critical(): boolean | cdktf.IResolvable;
    set critical(value: boolean | cdktf.IResolvable);
    get criticalInput(): boolean | cdktf.IResolvable | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
    private _objectId;
    get objectId(): GooglePrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensionsObjectIdOutputReference;
    putObjectId(value: GooglePrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensionsObjectId): void;
    get objectIdInput(): GooglePrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensionsObjectId | undefined;
}
export declare class GooglePrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GooglePrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GooglePrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensionsOutputReference;
}
export interface GooglePrivatecaCaPoolIssuancePolicyBaselineValuesCaOptions {
    /**
    * When true, the "CA" in Basic Constraints extension will be set to true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#is_ca GooglePrivatecaCaPool#is_ca}
    */
    readonly isCa?: boolean | cdktf.IResolvable;
    /**
    * Refers to the "path length constraint" in Basic Constraints extension. For a CA certificate, this value describes the depth of
  subordinate CA certificates that are allowed. If this value is less than 0, the request will fail.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#max_issuer_path_length GooglePrivatecaCaPool#max_issuer_path_length}
    */
    readonly maxIssuerPathLength?: number;
    /**
    * When true, the "CA" in Basic Constraints extension will be set to false.
  If both 'is_ca' and 'non_ca' are unset, the extension will be omitted from the CA certificate.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#non_ca GooglePrivatecaCaPool#non_ca}
    */
    readonly nonCa?: boolean | cdktf.IResolvable;
    /**
    * When true, the "path length constraint" in Basic Constraints extension will be set to 0.
  if both 'max_issuer_path_length' and 'zero_max_issuer_path_length' are unset,
  the max path length will be omitted from the CA certificate.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#zero_max_issuer_path_length GooglePrivatecaCaPool#zero_max_issuer_path_length}
    */
    readonly zeroMaxIssuerPathLength?: boolean | cdktf.IResolvable;
}
export declare function googlePrivatecaCaPoolIssuancePolicyBaselineValuesCaOptionsToTerraform(struct?: GooglePrivatecaCaPoolIssuancePolicyBaselineValuesCaOptionsOutputReference | GooglePrivatecaCaPoolIssuancePolicyBaselineValuesCaOptions): any;
export declare class GooglePrivatecaCaPoolIssuancePolicyBaselineValuesCaOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePrivatecaCaPoolIssuancePolicyBaselineValuesCaOptions | undefined;
    set internalValue(value: GooglePrivatecaCaPoolIssuancePolicyBaselineValuesCaOptions | undefined);
    private _isCa?;
    get isCa(): boolean | cdktf.IResolvable;
    set isCa(value: boolean | cdktf.IResolvable);
    resetIsCa(): void;
    get isCaInput(): boolean | cdktf.IResolvable | undefined;
    private _maxIssuerPathLength?;
    get maxIssuerPathLength(): number;
    set maxIssuerPathLength(value: number);
    resetMaxIssuerPathLength(): void;
    get maxIssuerPathLengthInput(): number | undefined;
    private _nonCa?;
    get nonCa(): boolean | cdktf.IResolvable;
    set nonCa(value: boolean | cdktf.IResolvable);
    resetNonCa(): void;
    get nonCaInput(): boolean | cdktf.IResolvable | undefined;
    private _zeroMaxIssuerPathLength?;
    get zeroMaxIssuerPathLength(): boolean | cdktf.IResolvable;
    set zeroMaxIssuerPathLength(value: boolean | cdktf.IResolvable);
    resetZeroMaxIssuerPathLength(): void;
    get zeroMaxIssuerPathLengthInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GooglePrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsage {
    /**
    * The key may be used to sign certificates.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#cert_sign GooglePrivatecaCaPool#cert_sign}
    */
    readonly certSign?: boolean | cdktf.IResolvable;
    /**
    * The key may be used for cryptographic commitments. Note that this may also be referred to as "non-repudiation".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#content_commitment GooglePrivatecaCaPool#content_commitment}
    */
    readonly contentCommitment?: boolean | cdktf.IResolvable;
    /**
    * The key may be used sign certificate revocation lists.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#crl_sign GooglePrivatecaCaPool#crl_sign}
    */
    readonly crlSign?: boolean | cdktf.IResolvable;
    /**
    * The key may be used to encipher data.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#data_encipherment GooglePrivatecaCaPool#data_encipherment}
    */
    readonly dataEncipherment?: boolean | cdktf.IResolvable;
    /**
    * The key may be used to decipher only.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#decipher_only GooglePrivatecaCaPool#decipher_only}
    */
    readonly decipherOnly?: boolean | cdktf.IResolvable;
    /**
    * The key may be used for digital signatures.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#digital_signature GooglePrivatecaCaPool#digital_signature}
    */
    readonly digitalSignature?: boolean | cdktf.IResolvable;
    /**
    * The key may be used to encipher only.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#encipher_only GooglePrivatecaCaPool#encipher_only}
    */
    readonly encipherOnly?: boolean | cdktf.IResolvable;
    /**
    * The key may be used in a key agreement protocol.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#key_agreement GooglePrivatecaCaPool#key_agreement}
    */
    readonly keyAgreement?: boolean | cdktf.IResolvable;
    /**
    * The key may be used to encipher other keys.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#key_encipherment GooglePrivatecaCaPool#key_encipherment}
    */
    readonly keyEncipherment?: boolean | cdktf.IResolvable;
}
export declare function googlePrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsageToTerraform(struct?: GooglePrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsageOutputReference | GooglePrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsage): any;
export declare class GooglePrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsage | undefined;
    set internalValue(value: GooglePrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsage | undefined);
    private _certSign?;
    get certSign(): boolean | cdktf.IResolvable;
    set certSign(value: boolean | cdktf.IResolvable);
    resetCertSign(): void;
    get certSignInput(): boolean | cdktf.IResolvable | undefined;
    private _contentCommitment?;
    get contentCommitment(): boolean | cdktf.IResolvable;
    set contentCommitment(value: boolean | cdktf.IResolvable);
    resetContentCommitment(): void;
    get contentCommitmentInput(): boolean | cdktf.IResolvable | undefined;
    private _crlSign?;
    get crlSign(): boolean | cdktf.IResolvable;
    set crlSign(value: boolean | cdktf.IResolvable);
    resetCrlSign(): void;
    get crlSignInput(): boolean | cdktf.IResolvable | undefined;
    private _dataEncipherment?;
    get dataEncipherment(): boolean | cdktf.IResolvable;
    set dataEncipherment(value: boolean | cdktf.IResolvable);
    resetDataEncipherment(): void;
    get dataEnciphermentInput(): boolean | cdktf.IResolvable | undefined;
    private _decipherOnly?;
    get decipherOnly(): boolean | cdktf.IResolvable;
    set decipherOnly(value: boolean | cdktf.IResolvable);
    resetDecipherOnly(): void;
    get decipherOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _digitalSignature?;
    get digitalSignature(): boolean | cdktf.IResolvable;
    set digitalSignature(value: boolean | cdktf.IResolvable);
    resetDigitalSignature(): void;
    get digitalSignatureInput(): boolean | cdktf.IResolvable | undefined;
    private _encipherOnly?;
    get encipherOnly(): boolean | cdktf.IResolvable;
    set encipherOnly(value: boolean | cdktf.IResolvable);
    resetEncipherOnly(): void;
    get encipherOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _keyAgreement?;
    get keyAgreement(): boolean | cdktf.IResolvable;
    set keyAgreement(value: boolean | cdktf.IResolvable);
    resetKeyAgreement(): void;
    get keyAgreementInput(): boolean | cdktf.IResolvable | undefined;
    private _keyEncipherment?;
    get keyEncipherment(): boolean | cdktf.IResolvable;
    set keyEncipherment(value: boolean | cdktf.IResolvable);
    resetKeyEncipherment(): void;
    get keyEnciphermentInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GooglePrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsage {
    /**
    * Corresponds to OID 1.3.6.1.5.5.7.3.2. Officially described as "TLS WWW client authentication", though regularly used for non-WWW TLS.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#client_auth GooglePrivatecaCaPool#client_auth}
    */
    readonly clientAuth?: boolean | cdktf.IResolvable;
    /**
    * Corresponds to OID 1.3.6.1.5.5.7.3.3. Officially described as "Signing of downloadable executable code client authentication".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#code_signing GooglePrivatecaCaPool#code_signing}
    */
    readonly codeSigning?: boolean | cdktf.IResolvable;
    /**
    * Corresponds to OID 1.3.6.1.5.5.7.3.4. Officially described as "Email protection".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#email_protection GooglePrivatecaCaPool#email_protection}
    */
    readonly emailProtection?: boolean | cdktf.IResolvable;
    /**
    * Corresponds to OID 1.3.6.1.5.5.7.3.9. Officially described as "Signing OCSP responses".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#ocsp_signing GooglePrivatecaCaPool#ocsp_signing}
    */
    readonly ocspSigning?: boolean | cdktf.IResolvable;
    /**
    * Corresponds to OID 1.3.6.1.5.5.7.3.1. Officially described as "TLS WWW server authentication", though regularly used for non-WWW TLS.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#server_auth GooglePrivatecaCaPool#server_auth}
    */
    readonly serverAuth?: boolean | cdktf.IResolvable;
    /**
    * Corresponds to OID 1.3.6.1.5.5.7.3.8. Officially described as "Binding the hash of an object to a time".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#time_stamping GooglePrivatecaCaPool#time_stamping}
    */
    readonly timeStamping?: boolean | cdktf.IResolvable;
}
export declare function googlePrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsageToTerraform(struct?: GooglePrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsageOutputReference | GooglePrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsage): any;
export declare class GooglePrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsage | undefined;
    set internalValue(value: GooglePrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsage | undefined);
    private _clientAuth?;
    get clientAuth(): boolean | cdktf.IResolvable;
    set clientAuth(value: boolean | cdktf.IResolvable);
    resetClientAuth(): void;
    get clientAuthInput(): boolean | cdktf.IResolvable | undefined;
    private _codeSigning?;
    get codeSigning(): boolean | cdktf.IResolvable;
    set codeSigning(value: boolean | cdktf.IResolvable);
    resetCodeSigning(): void;
    get codeSigningInput(): boolean | cdktf.IResolvable | undefined;
    private _emailProtection?;
    get emailProtection(): boolean | cdktf.IResolvable;
    set emailProtection(value: boolean | cdktf.IResolvable);
    resetEmailProtection(): void;
    get emailProtectionInput(): boolean | cdktf.IResolvable | undefined;
    private _ocspSigning?;
    get ocspSigning(): boolean | cdktf.IResolvable;
    set ocspSigning(value: boolean | cdktf.IResolvable);
    resetOcspSigning(): void;
    get ocspSigningInput(): boolean | cdktf.IResolvable | undefined;
    private _serverAuth?;
    get serverAuth(): boolean | cdktf.IResolvable;
    set serverAuth(value: boolean | cdktf.IResolvable);
    resetServerAuth(): void;
    get serverAuthInput(): boolean | cdktf.IResolvable | undefined;
    private _timeStamping?;
    get timeStamping(): boolean | cdktf.IResolvable;
    set timeStamping(value: boolean | cdktf.IResolvable);
    resetTimeStamping(): void;
    get timeStampingInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GooglePrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageUnknownExtendedKeyUsages {
    /**
    * An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#object_id_path GooglePrivatecaCaPool#object_id_path}
    */
    readonly objectIdPath: number[];
}
export declare function googlePrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageUnknownExtendedKeyUsagesToTerraform(struct?: GooglePrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageUnknownExtendedKeyUsages | cdktf.IResolvable): any;
export declare class GooglePrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageUnknownExtendedKeyUsagesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GooglePrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageUnknownExtendedKeyUsages | cdktf.IResolvable | undefined;
    set internalValue(value: GooglePrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageUnknownExtendedKeyUsages | cdktf.IResolvable | undefined);
    private _objectIdPath?;
    get objectIdPath(): number[];
    set objectIdPath(value: number[]);
    get objectIdPathInput(): number[] | undefined;
}
export declare class GooglePrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageUnknownExtendedKeyUsagesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GooglePrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageUnknownExtendedKeyUsages[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GooglePrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageUnknownExtendedKeyUsagesOutputReference;
}
export interface GooglePrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsage {
    /**
    * base_key_usage block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#base_key_usage GooglePrivatecaCaPool#base_key_usage}
    */
    readonly baseKeyUsage: GooglePrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsage;
    /**
    * extended_key_usage block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#extended_key_usage GooglePrivatecaCaPool#extended_key_usage}
    */
    readonly extendedKeyUsage: GooglePrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsage;
    /**
    * unknown_extended_key_usages block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#unknown_extended_key_usages GooglePrivatecaCaPool#unknown_extended_key_usages}
    */
    readonly unknownExtendedKeyUsages?: GooglePrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageUnknownExtendedKeyUsages[] | cdktf.IResolvable;
}
export declare function googlePrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageToTerraform(struct?: GooglePrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageOutputReference | GooglePrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsage): any;
export declare class GooglePrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsage | undefined;
    set internalValue(value: GooglePrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsage | undefined);
    private _baseKeyUsage;
    get baseKeyUsage(): GooglePrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsageOutputReference;
    putBaseKeyUsage(value: GooglePrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsage): void;
    get baseKeyUsageInput(): GooglePrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageBaseKeyUsage | undefined;
    private _extendedKeyUsage;
    get extendedKeyUsage(): GooglePrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsageOutputReference;
    putExtendedKeyUsage(value: GooglePrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsage): void;
    get extendedKeyUsageInput(): GooglePrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageExtendedKeyUsage | undefined;
    private _unknownExtendedKeyUsages;
    get unknownExtendedKeyUsages(): GooglePrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageUnknownExtendedKeyUsagesList;
    putUnknownExtendedKeyUsages(value: GooglePrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageUnknownExtendedKeyUsages[] | cdktf.IResolvable): void;
    resetUnknownExtendedKeyUsages(): void;
    get unknownExtendedKeyUsagesInput(): cdktf.IResolvable | GooglePrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageUnknownExtendedKeyUsages[] | undefined;
}
export interface GooglePrivatecaCaPoolIssuancePolicyBaselineValuesNameConstraints {
    /**
    * Indicates whether or not the name constraints are marked critical.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#critical GooglePrivatecaCaPool#critical}
    */
    readonly critical: boolean | cdktf.IResolvable;
    /**
    * Contains excluded DNS names. Any DNS name that can be
  constructed by simply adding zero or more labels to
  the left-hand side of the name satisfies the name constraint.
  For example, 'example.com', 'www.example.com', 'www.sub.example.com'
  would satisfy 'example.com' while 'example1.com' does not.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#excluded_dns_names GooglePrivatecaCaPool#excluded_dns_names}
    */
    readonly excludedDnsNames?: string[];
    /**
    * Contains the excluded email addresses. The value can be a particular
  email address, a hostname to indicate all email addresses on that host or
  a domain with a leading period (e.g. '.example.com') to indicate
  all email addresses in that domain.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#excluded_email_addresses GooglePrivatecaCaPool#excluded_email_addresses}
    */
    readonly excludedEmailAddresses?: string[];
    /**
    * Contains the excluded IP ranges. For IPv4 addresses, the ranges
  are expressed using CIDR notation as specified in RFC 4632.
  For IPv6 addresses, the ranges are expressed in similar encoding as IPv4
  addresses.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#excluded_ip_ranges GooglePrivatecaCaPool#excluded_ip_ranges}
    */
    readonly excludedIpRanges?: string[];
    /**
    * Contains the excluded URIs that apply to the host part of the name.
  The value can be a hostname or a domain with a
  leading period (like '.example.com')
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#excluded_uris GooglePrivatecaCaPool#excluded_uris}
    */
    readonly excludedUris?: string[];
    /**
    * Contains permitted DNS names. Any DNS name that can be
  constructed by simply adding zero or more labels to
  the left-hand side of the name satisfies the name constraint.
  For example, 'example.com', 'www.example.com', 'www.sub.example.com'
  would satisfy 'example.com' while 'example1.com' does not.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#permitted_dns_names GooglePrivatecaCaPool#permitted_dns_names}
    */
    readonly permittedDnsNames?: string[];
    /**
    * Contains the permitted email addresses. The value can be a particular
  email address, a hostname to indicate all email addresses on that host or
  a domain with a leading period (e.g. '.example.com') to indicate
  all email addresses in that domain.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#permitted_email_addresses GooglePrivatecaCaPool#permitted_email_addresses}
    */
    readonly permittedEmailAddresses?: string[];
    /**
    * Contains the permitted IP ranges. For IPv4 addresses, the ranges
  are expressed using CIDR notation as specified in RFC 4632.
  For IPv6 addresses, the ranges are expressed in similar encoding as IPv4
  addresses.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#permitted_ip_ranges GooglePrivatecaCaPool#permitted_ip_ranges}
    */
    readonly permittedIpRanges?: string[];
    /**
    * Contains the permitted URIs that apply to the host part of the name.
  The value can be a hostname or a domain with a
  leading period (like '.example.com')
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#permitted_uris GooglePrivatecaCaPool#permitted_uris}
    */
    readonly permittedUris?: string[];
}
export declare function googlePrivatecaCaPoolIssuancePolicyBaselineValuesNameConstraintsToTerraform(struct?: GooglePrivatecaCaPoolIssuancePolicyBaselineValuesNameConstraintsOutputReference | GooglePrivatecaCaPoolIssuancePolicyBaselineValuesNameConstraints): any;
export declare class GooglePrivatecaCaPoolIssuancePolicyBaselineValuesNameConstraintsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePrivatecaCaPoolIssuancePolicyBaselineValuesNameConstraints | undefined;
    set internalValue(value: GooglePrivatecaCaPoolIssuancePolicyBaselineValuesNameConstraints | undefined);
    private _critical?;
    get critical(): boolean | cdktf.IResolvable;
    set critical(value: boolean | cdktf.IResolvable);
    get criticalInput(): boolean | cdktf.IResolvable | undefined;
    private _excludedDnsNames?;
    get excludedDnsNames(): string[];
    set excludedDnsNames(value: string[]);
    resetExcludedDnsNames(): void;
    get excludedDnsNamesInput(): string[] | undefined;
    private _excludedEmailAddresses?;
    get excludedEmailAddresses(): string[];
    set excludedEmailAddresses(value: string[]);
    resetExcludedEmailAddresses(): void;
    get excludedEmailAddressesInput(): string[] | undefined;
    private _excludedIpRanges?;
    get excludedIpRanges(): string[];
    set excludedIpRanges(value: string[]);
    resetExcludedIpRanges(): void;
    get excludedIpRangesInput(): string[] | undefined;
    private _excludedUris?;
    get excludedUris(): string[];
    set excludedUris(value: string[]);
    resetExcludedUris(): void;
    get excludedUrisInput(): string[] | undefined;
    private _permittedDnsNames?;
    get permittedDnsNames(): string[];
    set permittedDnsNames(value: string[]);
    resetPermittedDnsNames(): void;
    get permittedDnsNamesInput(): string[] | undefined;
    private _permittedEmailAddresses?;
    get permittedEmailAddresses(): string[];
    set permittedEmailAddresses(value: string[]);
    resetPermittedEmailAddresses(): void;
    get permittedEmailAddressesInput(): string[] | undefined;
    private _permittedIpRanges?;
    get permittedIpRanges(): string[];
    set permittedIpRanges(value: string[]);
    resetPermittedIpRanges(): void;
    get permittedIpRangesInput(): string[] | undefined;
    private _permittedUris?;
    get permittedUris(): string[];
    set permittedUris(value: string[]);
    resetPermittedUris(): void;
    get permittedUrisInput(): string[] | undefined;
}
export interface GooglePrivatecaCaPoolIssuancePolicyBaselineValuesPolicyIds {
    /**
    * An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#object_id_path GooglePrivatecaCaPool#object_id_path}
    */
    readonly objectIdPath: number[];
}
export declare function googlePrivatecaCaPoolIssuancePolicyBaselineValuesPolicyIdsToTerraform(struct?: GooglePrivatecaCaPoolIssuancePolicyBaselineValuesPolicyIds | cdktf.IResolvable): any;
export declare class GooglePrivatecaCaPoolIssuancePolicyBaselineValuesPolicyIdsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GooglePrivatecaCaPoolIssuancePolicyBaselineValuesPolicyIds | cdktf.IResolvable | undefined;
    set internalValue(value: GooglePrivatecaCaPoolIssuancePolicyBaselineValuesPolicyIds | cdktf.IResolvable | undefined);
    private _objectIdPath?;
    get objectIdPath(): number[];
    set objectIdPath(value: number[]);
    get objectIdPathInput(): number[] | undefined;
}
export declare class GooglePrivatecaCaPoolIssuancePolicyBaselineValuesPolicyIdsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GooglePrivatecaCaPoolIssuancePolicyBaselineValuesPolicyIds[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GooglePrivatecaCaPoolIssuancePolicyBaselineValuesPolicyIdsOutputReference;
}
export interface GooglePrivatecaCaPoolIssuancePolicyBaselineValues {
    /**
    * Describes Online Certificate Status Protocol (OCSP) endpoint addresses that appear in the
  "Authority Information Access" extension in the certificate.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#aia_ocsp_servers GooglePrivatecaCaPool#aia_ocsp_servers}
    */
    readonly aiaOcspServers?: string[];
    /**
    * additional_extensions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#additional_extensions GooglePrivatecaCaPool#additional_extensions}
    */
    readonly additionalExtensions?: GooglePrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensions[] | cdktf.IResolvable;
    /**
    * ca_options block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#ca_options GooglePrivatecaCaPool#ca_options}
    */
    readonly caOptions: GooglePrivatecaCaPoolIssuancePolicyBaselineValuesCaOptions;
    /**
    * key_usage block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#key_usage GooglePrivatecaCaPool#key_usage}
    */
    readonly keyUsage: GooglePrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsage;
    /**
    * name_constraints block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#name_constraints GooglePrivatecaCaPool#name_constraints}
    */
    readonly nameConstraints?: GooglePrivatecaCaPoolIssuancePolicyBaselineValuesNameConstraints;
    /**
    * policy_ids block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#policy_ids GooglePrivatecaCaPool#policy_ids}
    */
    readonly policyIds?: GooglePrivatecaCaPoolIssuancePolicyBaselineValuesPolicyIds[] | cdktf.IResolvable;
}
export declare function googlePrivatecaCaPoolIssuancePolicyBaselineValuesToTerraform(struct?: GooglePrivatecaCaPoolIssuancePolicyBaselineValuesOutputReference | GooglePrivatecaCaPoolIssuancePolicyBaselineValues): any;
export declare class GooglePrivatecaCaPoolIssuancePolicyBaselineValuesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePrivatecaCaPoolIssuancePolicyBaselineValues | undefined;
    set internalValue(value: GooglePrivatecaCaPoolIssuancePolicyBaselineValues | undefined);
    private _aiaOcspServers?;
    get aiaOcspServers(): string[];
    set aiaOcspServers(value: string[]);
    resetAiaOcspServers(): void;
    get aiaOcspServersInput(): string[] | undefined;
    private _additionalExtensions;
    get additionalExtensions(): GooglePrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensionsList;
    putAdditionalExtensions(value: GooglePrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensions[] | cdktf.IResolvable): void;
    resetAdditionalExtensions(): void;
    get additionalExtensionsInput(): cdktf.IResolvable | GooglePrivatecaCaPoolIssuancePolicyBaselineValuesAdditionalExtensions[] | undefined;
    private _caOptions;
    get caOptions(): GooglePrivatecaCaPoolIssuancePolicyBaselineValuesCaOptionsOutputReference;
    putCaOptions(value: GooglePrivatecaCaPoolIssuancePolicyBaselineValuesCaOptions): void;
    get caOptionsInput(): GooglePrivatecaCaPoolIssuancePolicyBaselineValuesCaOptions | undefined;
    private _keyUsage;
    get keyUsage(): GooglePrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsageOutputReference;
    putKeyUsage(value: GooglePrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsage): void;
    get keyUsageInput(): GooglePrivatecaCaPoolIssuancePolicyBaselineValuesKeyUsage | undefined;
    private _nameConstraints;
    get nameConstraints(): GooglePrivatecaCaPoolIssuancePolicyBaselineValuesNameConstraintsOutputReference;
    putNameConstraints(value: GooglePrivatecaCaPoolIssuancePolicyBaselineValuesNameConstraints): void;
    resetNameConstraints(): void;
    get nameConstraintsInput(): GooglePrivatecaCaPoolIssuancePolicyBaselineValuesNameConstraints | undefined;
    private _policyIds;
    get policyIds(): GooglePrivatecaCaPoolIssuancePolicyBaselineValuesPolicyIdsList;
    putPolicyIds(value: GooglePrivatecaCaPoolIssuancePolicyBaselineValuesPolicyIds[] | cdktf.IResolvable): void;
    resetPolicyIds(): void;
    get policyIdsInput(): cdktf.IResolvable | GooglePrivatecaCaPoolIssuancePolicyBaselineValuesPolicyIds[] | undefined;
}
export interface GooglePrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpression {
    /**
    * Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#description GooglePrivatecaCaPool#description}
    */
    readonly description?: string;
    /**
    * Textual representation of an expression in Common Expression Language syntax.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#expression GooglePrivatecaCaPool#expression}
    */
    readonly expression: string;
    /**
    * String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#location GooglePrivatecaCaPool#location}
    */
    readonly location?: string;
    /**
    * Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#title GooglePrivatecaCaPool#title}
    */
    readonly title?: string;
}
export declare function googlePrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpressionToTerraform(struct?: GooglePrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpressionOutputReference | GooglePrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpression): any;
export declare class GooglePrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpressionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpression | undefined;
    set internalValue(value: GooglePrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpression | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
}
export interface GooglePrivatecaCaPoolIssuancePolicyIdentityConstraints {
    /**
    * If this is set, the SubjectAltNames extension may be copied from a certificate request into the signed certificate.
  Otherwise, the requested SubjectAltNames will be discarded.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#allow_subject_alt_names_passthrough GooglePrivatecaCaPool#allow_subject_alt_names_passthrough}
    */
    readonly allowSubjectAltNamesPassthrough: boolean | cdktf.IResolvable;
    /**
    * If this is set, the Subject field may be copied from a certificate request into the signed certificate.
  Otherwise, the requested Subject will be discarded.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#allow_subject_passthrough GooglePrivatecaCaPool#allow_subject_passthrough}
    */
    readonly allowSubjectPassthrough: boolean | cdktf.IResolvable;
    /**
    * cel_expression block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#cel_expression GooglePrivatecaCaPool#cel_expression}
    */
    readonly celExpression?: GooglePrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpression;
}
export declare function googlePrivatecaCaPoolIssuancePolicyIdentityConstraintsToTerraform(struct?: GooglePrivatecaCaPoolIssuancePolicyIdentityConstraintsOutputReference | GooglePrivatecaCaPoolIssuancePolicyIdentityConstraints): any;
export declare class GooglePrivatecaCaPoolIssuancePolicyIdentityConstraintsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePrivatecaCaPoolIssuancePolicyIdentityConstraints | undefined;
    set internalValue(value: GooglePrivatecaCaPoolIssuancePolicyIdentityConstraints | undefined);
    private _allowSubjectAltNamesPassthrough?;
    get allowSubjectAltNamesPassthrough(): boolean | cdktf.IResolvable;
    set allowSubjectAltNamesPassthrough(value: boolean | cdktf.IResolvable);
    get allowSubjectAltNamesPassthroughInput(): boolean | cdktf.IResolvable | undefined;
    private _allowSubjectPassthrough?;
    get allowSubjectPassthrough(): boolean | cdktf.IResolvable;
    set allowSubjectPassthrough(value: boolean | cdktf.IResolvable);
    get allowSubjectPassthroughInput(): boolean | cdktf.IResolvable | undefined;
    private _celExpression;
    get celExpression(): GooglePrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpressionOutputReference;
    putCelExpression(value: GooglePrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpression): void;
    resetCelExpression(): void;
    get celExpressionInput(): GooglePrivatecaCaPoolIssuancePolicyIdentityConstraintsCelExpression | undefined;
}
export interface GooglePrivatecaCaPoolIssuancePolicy {
    /**
    * The maximum lifetime allowed for issued Certificates. Note that if the issuing CertificateAuthority
  expires before a Certificate's requested maximumLifetime, the effective lifetime will be explicitly truncated to match it.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#maximum_lifetime GooglePrivatecaCaPool#maximum_lifetime}
    */
    readonly maximumLifetime?: string;
    /**
    * allowed_issuance_modes block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#allowed_issuance_modes GooglePrivatecaCaPool#allowed_issuance_modes}
    */
    readonly allowedIssuanceModes?: GooglePrivatecaCaPoolIssuancePolicyAllowedIssuanceModes;
    /**
    * allowed_key_types block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#allowed_key_types GooglePrivatecaCaPool#allowed_key_types}
    */
    readonly allowedKeyTypes?: GooglePrivatecaCaPoolIssuancePolicyAllowedKeyTypes[] | cdktf.IResolvable;
    /**
    * baseline_values block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#baseline_values GooglePrivatecaCaPool#baseline_values}
    */
    readonly baselineValues?: GooglePrivatecaCaPoolIssuancePolicyBaselineValues;
    /**
    * identity_constraints block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#identity_constraints GooglePrivatecaCaPool#identity_constraints}
    */
    readonly identityConstraints?: GooglePrivatecaCaPoolIssuancePolicyIdentityConstraints;
}
export declare function googlePrivatecaCaPoolIssuancePolicyToTerraform(struct?: GooglePrivatecaCaPoolIssuancePolicyOutputReference | GooglePrivatecaCaPoolIssuancePolicy): any;
export declare class GooglePrivatecaCaPoolIssuancePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePrivatecaCaPoolIssuancePolicy | undefined;
    set internalValue(value: GooglePrivatecaCaPoolIssuancePolicy | undefined);
    private _maximumLifetime?;
    get maximumLifetime(): string;
    set maximumLifetime(value: string);
    resetMaximumLifetime(): void;
    get maximumLifetimeInput(): string | undefined;
    private _allowedIssuanceModes;
    get allowedIssuanceModes(): GooglePrivatecaCaPoolIssuancePolicyAllowedIssuanceModesOutputReference;
    putAllowedIssuanceModes(value: GooglePrivatecaCaPoolIssuancePolicyAllowedIssuanceModes): void;
    resetAllowedIssuanceModes(): void;
    get allowedIssuanceModesInput(): GooglePrivatecaCaPoolIssuancePolicyAllowedIssuanceModes | undefined;
    private _allowedKeyTypes;
    get allowedKeyTypes(): GooglePrivatecaCaPoolIssuancePolicyAllowedKeyTypesList;
    putAllowedKeyTypes(value: GooglePrivatecaCaPoolIssuancePolicyAllowedKeyTypes[] | cdktf.IResolvable): void;
    resetAllowedKeyTypes(): void;
    get allowedKeyTypesInput(): cdktf.IResolvable | GooglePrivatecaCaPoolIssuancePolicyAllowedKeyTypes[] | undefined;
    private _baselineValues;
    get baselineValues(): GooglePrivatecaCaPoolIssuancePolicyBaselineValuesOutputReference;
    putBaselineValues(value: GooglePrivatecaCaPoolIssuancePolicyBaselineValues): void;
    resetBaselineValues(): void;
    get baselineValuesInput(): GooglePrivatecaCaPoolIssuancePolicyBaselineValues | undefined;
    private _identityConstraints;
    get identityConstraints(): GooglePrivatecaCaPoolIssuancePolicyIdentityConstraintsOutputReference;
    putIdentityConstraints(value: GooglePrivatecaCaPoolIssuancePolicyIdentityConstraints): void;
    resetIdentityConstraints(): void;
    get identityConstraintsInput(): GooglePrivatecaCaPoolIssuancePolicyIdentityConstraints | undefined;
}
export interface GooglePrivatecaCaPoolPublishingOptions {
    /**
    * When true, publishes each CertificateAuthority's CA certificate and includes its URL in the "Authority Information Access"
  X.509 extension in all issued Certificates. If this is false, the CA certificate will not be published and the corresponding
  X.509 extension will not be written in issued certificates.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#publish_ca_cert GooglePrivatecaCaPool#publish_ca_cert}
    */
    readonly publishCaCert: boolean | cdktf.IResolvable;
    /**
    * When true, publishes each CertificateAuthority's CRL and includes its URL in the "CRL Distribution Points" X.509 extension
  in all issued Certificates. If this is false, CRLs will not be published and the corresponding X.509 extension will not
  be written in issued certificates. CRLs will expire 7 days from their creation. However, we will rebuild daily. CRLs are
  also rebuilt shortly after a certificate is revoked.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#publish_crl GooglePrivatecaCaPool#publish_crl}
    */
    readonly publishCrl: boolean | cdktf.IResolvable;
}
export declare function googlePrivatecaCaPoolPublishingOptionsToTerraform(struct?: GooglePrivatecaCaPoolPublishingOptionsOutputReference | GooglePrivatecaCaPoolPublishingOptions): any;
export declare class GooglePrivatecaCaPoolPublishingOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePrivatecaCaPoolPublishingOptions | undefined;
    set internalValue(value: GooglePrivatecaCaPoolPublishingOptions | undefined);
    private _publishCaCert?;
    get publishCaCert(): boolean | cdktf.IResolvable;
    set publishCaCert(value: boolean | cdktf.IResolvable);
    get publishCaCertInput(): boolean | cdktf.IResolvable | undefined;
    private _publishCrl?;
    get publishCrl(): boolean | cdktf.IResolvable;
    set publishCrl(value: boolean | cdktf.IResolvable);
    get publishCrlInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GooglePrivatecaCaPoolTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#create GooglePrivatecaCaPool#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#delete GooglePrivatecaCaPool#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool#update GooglePrivatecaCaPool#update}
    */
    readonly update?: string;
}
export declare function googlePrivatecaCaPoolTimeoutsToTerraform(struct?: GooglePrivatecaCaPoolTimeouts | cdktf.IResolvable): any;
export declare class GooglePrivatecaCaPoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePrivatecaCaPoolTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GooglePrivatecaCaPoolTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool google_privateca_ca_pool}
*/
export declare class GooglePrivatecaCaPool extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_privateca_ca_pool";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_ca_pool google_privateca_ca_pool} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GooglePrivatecaCaPoolConfig
    */
    constructor(scope: Construct, id: string, config: GooglePrivatecaCaPoolConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _tier?;
    get tier(): string;
    set tier(value: string);
    get tierInput(): string | undefined;
    private _issuancePolicy;
    get issuancePolicy(): GooglePrivatecaCaPoolIssuancePolicyOutputReference;
    putIssuancePolicy(value: GooglePrivatecaCaPoolIssuancePolicy): void;
    resetIssuancePolicy(): void;
    get issuancePolicyInput(): GooglePrivatecaCaPoolIssuancePolicy | undefined;
    private _publishingOptions;
    get publishingOptions(): GooglePrivatecaCaPoolPublishingOptionsOutputReference;
    putPublishingOptions(value: GooglePrivatecaCaPoolPublishingOptions): void;
    resetPublishingOptions(): void;
    get publishingOptionsInput(): GooglePrivatecaCaPoolPublishingOptions | undefined;
    private _timeouts;
    get timeouts(): GooglePrivatecaCaPoolTimeoutsOutputReference;
    putTimeouts(value: GooglePrivatecaCaPoolTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GooglePrivatecaCaPoolTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
