import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GooglePrivatecaCertificateAuthorityConfig extends cdktf.TerraformMetaArguments {
    /**
    * The user provided Resource ID for this Certificate Authority.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#certificate_authority_id GooglePrivatecaCertificateAuthority#certificate_authority_id}
    */
    readonly certificateAuthorityId: string;
    /**
    * Whether or not to allow Terraform to destroy the CertificateAuthority. Unless this field is set to false
  in Terraform state, a 'terraform destroy' or 'terraform apply' that would delete the instance will fail.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#deletion_protection GooglePrivatecaCertificateAuthority#deletion_protection}
    */
    readonly deletionProtection?: boolean | cdktf.IResolvable;
    /**
    * Desired state of the CertificateAuthority. Set this field to 'STAGED' to create a 'STAGED' root CA.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#desired_state GooglePrivatecaCertificateAuthority#desired_state}
    */
    readonly desiredState?: string;
    /**
    * The name of a Cloud Storage bucket where this CertificateAuthority will publish content,
  such as the CA certificate and CRLs. This must be a bucket name, without any prefixes
  (such as 'gs://') or suffixes (such as '.googleapis.com'). For example, to use a bucket named
  my-bucket, you would simply specify 'my-bucket'. If not specified, a managed bucket will be
  created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#gcs_bucket GooglePrivatecaCertificateAuthority#gcs_bucket}
    */
    readonly gcsBucket?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#id GooglePrivatecaCertificateAuthority#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * This field allows the CA to be deleted even if the CA has active certs. Active certs include both unrevoked and unexpired certs.
  Use with care. Defaults to 'false'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#ignore_active_certificates_on_deletion GooglePrivatecaCertificateAuthority#ignore_active_certificates_on_deletion}
    */
    readonly ignoreActiveCertificatesOnDeletion?: boolean | cdktf.IResolvable;
    /**
    * Labels with user-defined metadata.
  
  An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass":
  "1.3kg", "count": "3" }.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#labels GooglePrivatecaCertificateAuthority#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The desired lifetime of the CA certificate. Used to create the "notBeforeTime" and
  "notAfterTime" fields inside an X.509 certificate. A duration in seconds with up to nine
  fractional digits, terminated by 's'. Example: "3.5s".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#lifetime GooglePrivatecaCertificateAuthority#lifetime}
    */
    readonly lifetime?: string;
    /**
    * Location of the CertificateAuthority. A full list of valid locations can be found by
  running 'gcloud privateca locations list'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#location GooglePrivatecaCertificateAuthority#location}
    */
    readonly location: string;
    /**
    * The signed CA certificate issued from the subordinated CA's CSR. This is needed when activating the subordiante CA with a third party issuer.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#pem_ca_certificate GooglePrivatecaCertificateAuthority#pem_ca_certificate}
    */
    readonly pemCaCertificate?: string;
    /**
    * The name of the CaPool this Certificate Authority belongs to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#pool GooglePrivatecaCertificateAuthority#pool}
    */
    readonly pool: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#project GooglePrivatecaCertificateAuthority#project}
    */
    readonly project?: string;
    /**
    * If this flag is set, the Certificate Authority will be deleted as soon as
  possible without a 30-day grace period where undeletion would have been
  allowed. If you proceed, there will be no way to recover this CA.
  Use with care. Defaults to 'false'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#skip_grace_period GooglePrivatecaCertificateAuthority#skip_grace_period}
    */
    readonly skipGracePeriod?: boolean | cdktf.IResolvable;
    /**
    * The Type of this CertificateAuthority.
  
  ~> **Note:** For 'SUBORDINATE' Certificate Authorities, they need to
  be activated before they can issue certificates. Default value: "SELF_SIGNED" Possible values: ["SELF_SIGNED", "SUBORDINATE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#type GooglePrivatecaCertificateAuthority#type}
    */
    readonly type?: string;
    /**
    * config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#config GooglePrivatecaCertificateAuthority#config}
    */
    readonly config: GooglePrivatecaCertificateAuthorityConfigA;
    /**
    * key_spec block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#key_spec GooglePrivatecaCertificateAuthority#key_spec}
    */
    readonly keySpec: GooglePrivatecaCertificateAuthorityKeySpec;
    /**
    * subordinate_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#subordinate_config GooglePrivatecaCertificateAuthority#subordinate_config}
    */
    readonly subordinateConfig?: GooglePrivatecaCertificateAuthoritySubordinateConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#timeouts GooglePrivatecaCertificateAuthority#timeouts}
    */
    readonly timeouts?: GooglePrivatecaCertificateAuthorityTimeouts;
}
export interface GooglePrivatecaCertificateAuthorityAccessUrls {
}
export declare function googlePrivatecaCertificateAuthorityAccessUrlsToTerraform(struct?: GooglePrivatecaCertificateAuthorityAccessUrls): any;
export declare class GooglePrivatecaCertificateAuthorityAccessUrlsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GooglePrivatecaCertificateAuthorityAccessUrls | undefined;
    set internalValue(value: GooglePrivatecaCertificateAuthorityAccessUrls | undefined);
    get caCertificateAccessUrl(): string;
    get crlAccessUrls(): string[];
}
export declare class GooglePrivatecaCertificateAuthorityAccessUrlsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GooglePrivatecaCertificateAuthorityAccessUrlsOutputReference;
}
export interface GooglePrivatecaCertificateAuthorityConfigSubjectConfigSubject {
    /**
    * The common name of the distinguished name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#common_name GooglePrivatecaCertificateAuthority#common_name}
    */
    readonly commonName: string;
    /**
    * The country code of the subject.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#country_code GooglePrivatecaCertificateAuthority#country_code}
    */
    readonly countryCode?: string;
    /**
    * The locality or city of the subject.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#locality GooglePrivatecaCertificateAuthority#locality}
    */
    readonly locality?: string;
    /**
    * The organization of the subject.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#organization GooglePrivatecaCertificateAuthority#organization}
    */
    readonly organization: string;
    /**
    * The organizational unit of the subject.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#organizational_unit GooglePrivatecaCertificateAuthority#organizational_unit}
    */
    readonly organizationalUnit?: string;
    /**
    * The postal code of the subject.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#postal_code GooglePrivatecaCertificateAuthority#postal_code}
    */
    readonly postalCode?: string;
    /**
    * The province, territory, or regional state of the subject.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#province GooglePrivatecaCertificateAuthority#province}
    */
    readonly province?: string;
    /**
    * The street address of the subject.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#street_address GooglePrivatecaCertificateAuthority#street_address}
    */
    readonly streetAddress?: string;
}
export declare function googlePrivatecaCertificateAuthorityConfigSubjectConfigSubjectToTerraform(struct?: GooglePrivatecaCertificateAuthorityConfigSubjectConfigSubjectOutputReference | GooglePrivatecaCertificateAuthorityConfigSubjectConfigSubject): any;
export declare class GooglePrivatecaCertificateAuthorityConfigSubjectConfigSubjectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePrivatecaCertificateAuthorityConfigSubjectConfigSubject | undefined;
    set internalValue(value: GooglePrivatecaCertificateAuthorityConfigSubjectConfigSubject | undefined);
    private _commonName?;
    get commonName(): string;
    set commonName(value: string);
    get commonNameInput(): string | undefined;
    private _countryCode?;
    get countryCode(): string;
    set countryCode(value: string);
    resetCountryCode(): void;
    get countryCodeInput(): string | undefined;
    private _locality?;
    get locality(): string;
    set locality(value: string);
    resetLocality(): void;
    get localityInput(): string | undefined;
    private _organization?;
    get organization(): string;
    set organization(value: string);
    get organizationInput(): string | undefined;
    private _organizationalUnit?;
    get organizationalUnit(): string;
    set organizationalUnit(value: string);
    resetOrganizationalUnit(): void;
    get organizationalUnitInput(): string | undefined;
    private _postalCode?;
    get postalCode(): string;
    set postalCode(value: string);
    resetPostalCode(): void;
    get postalCodeInput(): string | undefined;
    private _province?;
    get province(): string;
    set province(value: string);
    resetProvince(): void;
    get provinceInput(): string | undefined;
    private _streetAddress?;
    get streetAddress(): string;
    set streetAddress(value: string);
    resetStreetAddress(): void;
    get streetAddressInput(): string | undefined;
}
export interface GooglePrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltName {
    /**
    * Contains only valid, fully-qualified host names.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#dns_names GooglePrivatecaCertificateAuthority#dns_names}
    */
    readonly dnsNames?: string[];
    /**
    * Contains only valid RFC 2822 E-mail addresses.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#email_addresses GooglePrivatecaCertificateAuthority#email_addresses}
    */
    readonly emailAddresses?: string[];
    /**
    * Contains only valid 32-bit IPv4 addresses or RFC 4291 IPv6 addresses.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#ip_addresses GooglePrivatecaCertificateAuthority#ip_addresses}
    */
    readonly ipAddresses?: string[];
    /**
    * Contains only valid RFC 3986 URIs.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#uris GooglePrivatecaCertificateAuthority#uris}
    */
    readonly uris?: string[];
}
export declare function googlePrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltNameToTerraform(struct?: GooglePrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltNameOutputReference | GooglePrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltName): any;
export declare class GooglePrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltNameOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltName | undefined;
    set internalValue(value: GooglePrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltName | undefined);
    private _dnsNames?;
    get dnsNames(): string[];
    set dnsNames(value: string[]);
    resetDnsNames(): void;
    get dnsNamesInput(): string[] | undefined;
    private _emailAddresses?;
    get emailAddresses(): string[];
    set emailAddresses(value: string[]);
    resetEmailAddresses(): void;
    get emailAddressesInput(): string[] | undefined;
    private _ipAddresses?;
    get ipAddresses(): string[];
    set ipAddresses(value: string[]);
    resetIpAddresses(): void;
    get ipAddressesInput(): string[] | undefined;
    private _uris?;
    get uris(): string[];
    set uris(value: string[]);
    resetUris(): void;
    get urisInput(): string[] | undefined;
}
export interface GooglePrivatecaCertificateAuthorityConfigSubjectConfig {
    /**
    * subject block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#subject GooglePrivatecaCertificateAuthority#subject}
    */
    readonly subject: GooglePrivatecaCertificateAuthorityConfigSubjectConfigSubject;
    /**
    * subject_alt_name block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#subject_alt_name GooglePrivatecaCertificateAuthority#subject_alt_name}
    */
    readonly subjectAltName?: GooglePrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltName;
}
export declare function googlePrivatecaCertificateAuthorityConfigSubjectConfigToTerraform(struct?: GooglePrivatecaCertificateAuthorityConfigSubjectConfigOutputReference | GooglePrivatecaCertificateAuthorityConfigSubjectConfig): any;
export declare class GooglePrivatecaCertificateAuthorityConfigSubjectConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePrivatecaCertificateAuthorityConfigSubjectConfig | undefined;
    set internalValue(value: GooglePrivatecaCertificateAuthorityConfigSubjectConfig | undefined);
    private _subject;
    get subject(): GooglePrivatecaCertificateAuthorityConfigSubjectConfigSubjectOutputReference;
    putSubject(value: GooglePrivatecaCertificateAuthorityConfigSubjectConfigSubject): void;
    get subjectInput(): GooglePrivatecaCertificateAuthorityConfigSubjectConfigSubject | undefined;
    private _subjectAltName;
    get subjectAltName(): GooglePrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltNameOutputReference;
    putSubjectAltName(value: GooglePrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltName): void;
    resetSubjectAltName(): void;
    get subjectAltNameInput(): GooglePrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltName | undefined;
}
export interface GooglePrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsObjectId {
    /**
    * An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#object_id_path GooglePrivatecaCertificateAuthority#object_id_path}
    */
    readonly objectIdPath: number[];
}
export declare function googlePrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsObjectIdToTerraform(struct?: GooglePrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsObjectIdOutputReference | GooglePrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsObjectId): any;
export declare class GooglePrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsObjectIdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsObjectId | undefined;
    set internalValue(value: GooglePrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsObjectId | undefined);
    private _objectIdPath?;
    get objectIdPath(): number[];
    set objectIdPath(value: number[]);
    get objectIdPathInput(): number[] | undefined;
}
export interface GooglePrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensions {
    /**
    * Indicates whether or not this extension is critical (i.e., if the client does not know how to
  handle this extension, the client should consider this to be an error).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#critical GooglePrivatecaCertificateAuthority#critical}
    */
    readonly critical: boolean | cdktf.IResolvable;
    /**
    * The value of this X.509 extension. A base64-encoded string.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#value GooglePrivatecaCertificateAuthority#value}
    */
    readonly value: string;
    /**
    * object_id block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#object_id GooglePrivatecaCertificateAuthority#object_id}
    */
    readonly objectId: GooglePrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsObjectId;
}
export declare function googlePrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsToTerraform(struct?: GooglePrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensions | cdktf.IResolvable): any;
export declare class GooglePrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GooglePrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensions | cdktf.IResolvable | undefined;
    set internalValue(value: GooglePrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensions | cdktf.IResolvable | undefined);
    private _critical?;
    get critical(): boolean | cdktf.IResolvable;
    set critical(value: boolean | cdktf.IResolvable);
    get criticalInput(): boolean | cdktf.IResolvable | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
    private _objectId;
    get objectId(): GooglePrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsObjectIdOutputReference;
    putObjectId(value: GooglePrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsObjectId): void;
    get objectIdInput(): GooglePrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsObjectId | undefined;
}
export declare class GooglePrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GooglePrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GooglePrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsOutputReference;
}
export interface GooglePrivatecaCertificateAuthorityConfigX509ConfigCaOptions {
    /**
    * When true, the "CA" in Basic Constraints extension will be set to true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#is_ca GooglePrivatecaCertificateAuthority#is_ca}
    */
    readonly isCa: boolean | cdktf.IResolvable;
    /**
    * Refers to the "path length constraint" in Basic Constraints extension. For a CA certificate, this value describes the depth of
  subordinate CA certificates that are allowed. If this value is less than 0, the request will fail. Setting the value to 0
  requires setting 'zero_max_issuer_path_length = true'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#max_issuer_path_length GooglePrivatecaCertificateAuthority#max_issuer_path_length}
    */
    readonly maxIssuerPathLength?: number;
    /**
    * When true, the "CA" in Basic Constraints extension will be set to false.
  If both 'is_ca' and 'non_ca' are unset, the extension will be omitted from the CA certificate.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#non_ca GooglePrivatecaCertificateAuthority#non_ca}
    */
    readonly nonCa?: boolean | cdktf.IResolvable;
    /**
    * When true, the "path length constraint" in Basic Constraints extension will be set to 0.
  If both 'max_issuer_path_length' and 'zero_max_issuer_path_length' are unset,
  the max path length will be omitted from the CA certificate.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#zero_max_issuer_path_length GooglePrivatecaCertificateAuthority#zero_max_issuer_path_length}
    */
    readonly zeroMaxIssuerPathLength?: boolean | cdktf.IResolvable;
}
export declare function googlePrivatecaCertificateAuthorityConfigX509ConfigCaOptionsToTerraform(struct?: GooglePrivatecaCertificateAuthorityConfigX509ConfigCaOptionsOutputReference | GooglePrivatecaCertificateAuthorityConfigX509ConfigCaOptions): any;
export declare class GooglePrivatecaCertificateAuthorityConfigX509ConfigCaOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePrivatecaCertificateAuthorityConfigX509ConfigCaOptions | undefined;
    set internalValue(value: GooglePrivatecaCertificateAuthorityConfigX509ConfigCaOptions | undefined);
    private _isCa?;
    get isCa(): boolean | cdktf.IResolvable;
    set isCa(value: boolean | cdktf.IResolvable);
    get isCaInput(): boolean | cdktf.IResolvable | undefined;
    private _maxIssuerPathLength?;
    get maxIssuerPathLength(): number;
    set maxIssuerPathLength(value: number);
    resetMaxIssuerPathLength(): void;
    get maxIssuerPathLengthInput(): number | undefined;
    private _nonCa?;
    get nonCa(): boolean | cdktf.IResolvable;
    set nonCa(value: boolean | cdktf.IResolvable);
    resetNonCa(): void;
    get nonCaInput(): boolean | cdktf.IResolvable | undefined;
    private _zeroMaxIssuerPathLength?;
    get zeroMaxIssuerPathLength(): boolean | cdktf.IResolvable;
    set zeroMaxIssuerPathLength(value: boolean | cdktf.IResolvable);
    resetZeroMaxIssuerPathLength(): void;
    get zeroMaxIssuerPathLengthInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageBaseKeyUsage {
    /**
    * The key may be used to sign certificates.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#cert_sign GooglePrivatecaCertificateAuthority#cert_sign}
    */
    readonly certSign?: boolean | cdktf.IResolvable;
    /**
    * The key may be used for cryptographic commitments. Note that this may also be referred to as "non-repudiation".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#content_commitment GooglePrivatecaCertificateAuthority#content_commitment}
    */
    readonly contentCommitment?: boolean | cdktf.IResolvable;
    /**
    * The key may be used sign certificate revocation lists.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#crl_sign GooglePrivatecaCertificateAuthority#crl_sign}
    */
    readonly crlSign?: boolean | cdktf.IResolvable;
    /**
    * The key may be used to encipher data.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#data_encipherment GooglePrivatecaCertificateAuthority#data_encipherment}
    */
    readonly dataEncipherment?: boolean | cdktf.IResolvable;
    /**
    * The key may be used to decipher only.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#decipher_only GooglePrivatecaCertificateAuthority#decipher_only}
    */
    readonly decipherOnly?: boolean | cdktf.IResolvable;
    /**
    * The key may be used for digital signatures.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#digital_signature GooglePrivatecaCertificateAuthority#digital_signature}
    */
    readonly digitalSignature?: boolean | cdktf.IResolvable;
    /**
    * The key may be used to encipher only.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#encipher_only GooglePrivatecaCertificateAuthority#encipher_only}
    */
    readonly encipherOnly?: boolean | cdktf.IResolvable;
    /**
    * The key may be used in a key agreement protocol.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#key_agreement GooglePrivatecaCertificateAuthority#key_agreement}
    */
    readonly keyAgreement?: boolean | cdktf.IResolvable;
    /**
    * The key may be used to encipher other keys.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#key_encipherment GooglePrivatecaCertificateAuthority#key_encipherment}
    */
    readonly keyEncipherment?: boolean | cdktf.IResolvable;
}
export declare function googlePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageBaseKeyUsageToTerraform(struct?: GooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageBaseKeyUsageOutputReference | GooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageBaseKeyUsage): any;
export declare class GooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageBaseKeyUsageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageBaseKeyUsage | undefined;
    set internalValue(value: GooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageBaseKeyUsage | undefined);
    private _certSign?;
    get certSign(): boolean | cdktf.IResolvable;
    set certSign(value: boolean | cdktf.IResolvable);
    resetCertSign(): void;
    get certSignInput(): boolean | cdktf.IResolvable | undefined;
    private _contentCommitment?;
    get contentCommitment(): boolean | cdktf.IResolvable;
    set contentCommitment(value: boolean | cdktf.IResolvable);
    resetContentCommitment(): void;
    get contentCommitmentInput(): boolean | cdktf.IResolvable | undefined;
    private _crlSign?;
    get crlSign(): boolean | cdktf.IResolvable;
    set crlSign(value: boolean | cdktf.IResolvable);
    resetCrlSign(): void;
    get crlSignInput(): boolean | cdktf.IResolvable | undefined;
    private _dataEncipherment?;
    get dataEncipherment(): boolean | cdktf.IResolvable;
    set dataEncipherment(value: boolean | cdktf.IResolvable);
    resetDataEncipherment(): void;
    get dataEnciphermentInput(): boolean | cdktf.IResolvable | undefined;
    private _decipherOnly?;
    get decipherOnly(): boolean | cdktf.IResolvable;
    set decipherOnly(value: boolean | cdktf.IResolvable);
    resetDecipherOnly(): void;
    get decipherOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _digitalSignature?;
    get digitalSignature(): boolean | cdktf.IResolvable;
    set digitalSignature(value: boolean | cdktf.IResolvable);
    resetDigitalSignature(): void;
    get digitalSignatureInput(): boolean | cdktf.IResolvable | undefined;
    private _encipherOnly?;
    get encipherOnly(): boolean | cdktf.IResolvable;
    set encipherOnly(value: boolean | cdktf.IResolvable);
    resetEncipherOnly(): void;
    get encipherOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _keyAgreement?;
    get keyAgreement(): boolean | cdktf.IResolvable;
    set keyAgreement(value: boolean | cdktf.IResolvable);
    resetKeyAgreement(): void;
    get keyAgreementInput(): boolean | cdktf.IResolvable | undefined;
    private _keyEncipherment?;
    get keyEncipherment(): boolean | cdktf.IResolvable;
    set keyEncipherment(value: boolean | cdktf.IResolvable);
    resetKeyEncipherment(): void;
    get keyEnciphermentInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageExtendedKeyUsage {
    /**
    * Corresponds to OID 1.3.6.1.5.5.7.3.2. Officially described as "TLS WWW client authentication", though regularly used for non-WWW TLS.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#client_auth GooglePrivatecaCertificateAuthority#client_auth}
    */
    readonly clientAuth?: boolean | cdktf.IResolvable;
    /**
    * Corresponds to OID 1.3.6.1.5.5.7.3.3. Officially described as "Signing of downloadable executable code client authentication".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#code_signing GooglePrivatecaCertificateAuthority#code_signing}
    */
    readonly codeSigning?: boolean | cdktf.IResolvable;
    /**
    * Corresponds to OID 1.3.6.1.5.5.7.3.4. Officially described as "Email protection".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#email_protection GooglePrivatecaCertificateAuthority#email_protection}
    */
    readonly emailProtection?: boolean | cdktf.IResolvable;
    /**
    * Corresponds to OID 1.3.6.1.5.5.7.3.9. Officially described as "Signing OCSP responses".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#ocsp_signing GooglePrivatecaCertificateAuthority#ocsp_signing}
    */
    readonly ocspSigning?: boolean | cdktf.IResolvable;
    /**
    * Corresponds to OID 1.3.6.1.5.5.7.3.1. Officially described as "TLS WWW server authentication", though regularly used for non-WWW TLS.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#server_auth GooglePrivatecaCertificateAuthority#server_auth}
    */
    readonly serverAuth?: boolean | cdktf.IResolvable;
    /**
    * Corresponds to OID 1.3.6.1.5.5.7.3.8. Officially described as "Binding the hash of an object to a time".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#time_stamping GooglePrivatecaCertificateAuthority#time_stamping}
    */
    readonly timeStamping?: boolean | cdktf.IResolvable;
}
export declare function googlePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageExtendedKeyUsageToTerraform(struct?: GooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageExtendedKeyUsageOutputReference | GooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageExtendedKeyUsage): any;
export declare class GooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageExtendedKeyUsageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageExtendedKeyUsage | undefined;
    set internalValue(value: GooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageExtendedKeyUsage | undefined);
    private _clientAuth?;
    get clientAuth(): boolean | cdktf.IResolvable;
    set clientAuth(value: boolean | cdktf.IResolvable);
    resetClientAuth(): void;
    get clientAuthInput(): boolean | cdktf.IResolvable | undefined;
    private _codeSigning?;
    get codeSigning(): boolean | cdktf.IResolvable;
    set codeSigning(value: boolean | cdktf.IResolvable);
    resetCodeSigning(): void;
    get codeSigningInput(): boolean | cdktf.IResolvable | undefined;
    private _emailProtection?;
    get emailProtection(): boolean | cdktf.IResolvable;
    set emailProtection(value: boolean | cdktf.IResolvable);
    resetEmailProtection(): void;
    get emailProtectionInput(): boolean | cdktf.IResolvable | undefined;
    private _ocspSigning?;
    get ocspSigning(): boolean | cdktf.IResolvable;
    set ocspSigning(value: boolean | cdktf.IResolvable);
    resetOcspSigning(): void;
    get ocspSigningInput(): boolean | cdktf.IResolvable | undefined;
    private _serverAuth?;
    get serverAuth(): boolean | cdktf.IResolvable;
    set serverAuth(value: boolean | cdktf.IResolvable);
    resetServerAuth(): void;
    get serverAuthInput(): boolean | cdktf.IResolvable | undefined;
    private _timeStamping?;
    get timeStamping(): boolean | cdktf.IResolvable;
    set timeStamping(value: boolean | cdktf.IResolvable);
    resetTimeStamping(): void;
    get timeStampingInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsages {
    /**
    * An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#object_id_path GooglePrivatecaCertificateAuthority#object_id_path}
    */
    readonly objectIdPath: number[];
}
export declare function googlePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsagesToTerraform(struct?: GooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsages | cdktf.IResolvable): any;
export declare class GooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsagesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsages | cdktf.IResolvable | undefined;
    set internalValue(value: GooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsages | cdktf.IResolvable | undefined);
    private _objectIdPath?;
    get objectIdPath(): number[];
    set objectIdPath(value: number[]);
    get objectIdPathInput(): number[] | undefined;
}
export declare class GooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsagesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsages[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsagesOutputReference;
}
export interface GooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsage {
    /**
    * base_key_usage block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#base_key_usage GooglePrivatecaCertificateAuthority#base_key_usage}
    */
    readonly baseKeyUsage: GooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageBaseKeyUsage;
    /**
    * extended_key_usage block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#extended_key_usage GooglePrivatecaCertificateAuthority#extended_key_usage}
    */
    readonly extendedKeyUsage: GooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageExtendedKeyUsage;
    /**
    * unknown_extended_key_usages block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#unknown_extended_key_usages GooglePrivatecaCertificateAuthority#unknown_extended_key_usages}
    */
    readonly unknownExtendedKeyUsages?: GooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsages[] | cdktf.IResolvable;
}
export declare function googlePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageToTerraform(struct?: GooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageOutputReference | GooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsage): any;
export declare class GooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsage | undefined;
    set internalValue(value: GooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsage | undefined);
    private _baseKeyUsage;
    get baseKeyUsage(): GooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageBaseKeyUsageOutputReference;
    putBaseKeyUsage(value: GooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageBaseKeyUsage): void;
    get baseKeyUsageInput(): GooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageBaseKeyUsage | undefined;
    private _extendedKeyUsage;
    get extendedKeyUsage(): GooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageExtendedKeyUsageOutputReference;
    putExtendedKeyUsage(value: GooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageExtendedKeyUsage): void;
    get extendedKeyUsageInput(): GooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageExtendedKeyUsage | undefined;
    private _unknownExtendedKeyUsages;
    get unknownExtendedKeyUsages(): GooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsagesList;
    putUnknownExtendedKeyUsages(value: GooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsages[] | cdktf.IResolvable): void;
    resetUnknownExtendedKeyUsages(): void;
    get unknownExtendedKeyUsagesInput(): cdktf.IResolvable | GooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsages[] | undefined;
}
export interface GooglePrivatecaCertificateAuthorityConfigX509ConfigNameConstraints {
    /**
    * Indicates whether or not the name constraints are marked critical.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#critical GooglePrivatecaCertificateAuthority#critical}
    */
    readonly critical: boolean | cdktf.IResolvable;
    /**
    * Contains excluded DNS names. Any DNS name that can be
  constructed by simply adding zero or more labels to
  the left-hand side of the name satisfies the name constraint.
  For example, 'example.com', 'www.example.com', 'www.sub.example.com'
  would satisfy 'example.com' while 'example1.com' does not.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#excluded_dns_names GooglePrivatecaCertificateAuthority#excluded_dns_names}
    */
    readonly excludedDnsNames?: string[];
    /**
    * Contains the excluded email addresses. The value can be a particular
  email address, a hostname to indicate all email addresses on that host or
  a domain with a leading period (e.g. '.example.com') to indicate
  all email addresses in that domain.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#excluded_email_addresses GooglePrivatecaCertificateAuthority#excluded_email_addresses}
    */
    readonly excludedEmailAddresses?: string[];
    /**
    * Contains the excluded IP ranges. For IPv4 addresses, the ranges
  are expressed using CIDR notation as specified in RFC 4632.
  For IPv6 addresses, the ranges are expressed in similar encoding as IPv4
  addresses.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#excluded_ip_ranges GooglePrivatecaCertificateAuthority#excluded_ip_ranges}
    */
    readonly excludedIpRanges?: string[];
    /**
    * Contains the excluded URIs that apply to the host part of the name.
  The value can be a hostname or a domain with a
  leading period (like '.example.com')
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#excluded_uris GooglePrivatecaCertificateAuthority#excluded_uris}
    */
    readonly excludedUris?: string[];
    /**
    * Contains permitted DNS names. Any DNS name that can be
  constructed by simply adding zero or more labels to
  the left-hand side of the name satisfies the name constraint.
  For example, 'example.com', 'www.example.com', 'www.sub.example.com'
  would satisfy 'example.com' while 'example1.com' does not.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#permitted_dns_names GooglePrivatecaCertificateAuthority#permitted_dns_names}
    */
    readonly permittedDnsNames?: string[];
    /**
    * Contains the permitted email addresses. The value can be a particular
  email address, a hostname to indicate all email addresses on that host or
  a domain with a leading period (e.g. '.example.com') to indicate
  all email addresses in that domain.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#permitted_email_addresses GooglePrivatecaCertificateAuthority#permitted_email_addresses}
    */
    readonly permittedEmailAddresses?: string[];
    /**
    * Contains the permitted IP ranges. For IPv4 addresses, the ranges
  are expressed using CIDR notation as specified in RFC 4632.
  For IPv6 addresses, the ranges are expressed in similar encoding as IPv4
  addresses.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#permitted_ip_ranges GooglePrivatecaCertificateAuthority#permitted_ip_ranges}
    */
    readonly permittedIpRanges?: string[];
    /**
    * Contains the permitted URIs that apply to the host part of the name.
  The value can be a hostname or a domain with a
  leading period (like '.example.com')
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#permitted_uris GooglePrivatecaCertificateAuthority#permitted_uris}
    */
    readonly permittedUris?: string[];
}
export declare function googlePrivatecaCertificateAuthorityConfigX509ConfigNameConstraintsToTerraform(struct?: GooglePrivatecaCertificateAuthorityConfigX509ConfigNameConstraintsOutputReference | GooglePrivatecaCertificateAuthorityConfigX509ConfigNameConstraints): any;
export declare class GooglePrivatecaCertificateAuthorityConfigX509ConfigNameConstraintsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePrivatecaCertificateAuthorityConfigX509ConfigNameConstraints | undefined;
    set internalValue(value: GooglePrivatecaCertificateAuthorityConfigX509ConfigNameConstraints | undefined);
    private _critical?;
    get critical(): boolean | cdktf.IResolvable;
    set critical(value: boolean | cdktf.IResolvable);
    get criticalInput(): boolean | cdktf.IResolvable | undefined;
    private _excludedDnsNames?;
    get excludedDnsNames(): string[];
    set excludedDnsNames(value: string[]);
    resetExcludedDnsNames(): void;
    get excludedDnsNamesInput(): string[] | undefined;
    private _excludedEmailAddresses?;
    get excludedEmailAddresses(): string[];
    set excludedEmailAddresses(value: string[]);
    resetExcludedEmailAddresses(): void;
    get excludedEmailAddressesInput(): string[] | undefined;
    private _excludedIpRanges?;
    get excludedIpRanges(): string[];
    set excludedIpRanges(value: string[]);
    resetExcludedIpRanges(): void;
    get excludedIpRangesInput(): string[] | undefined;
    private _excludedUris?;
    get excludedUris(): string[];
    set excludedUris(value: string[]);
    resetExcludedUris(): void;
    get excludedUrisInput(): string[] | undefined;
    private _permittedDnsNames?;
    get permittedDnsNames(): string[];
    set permittedDnsNames(value: string[]);
    resetPermittedDnsNames(): void;
    get permittedDnsNamesInput(): string[] | undefined;
    private _permittedEmailAddresses?;
    get permittedEmailAddresses(): string[];
    set permittedEmailAddresses(value: string[]);
    resetPermittedEmailAddresses(): void;
    get permittedEmailAddressesInput(): string[] | undefined;
    private _permittedIpRanges?;
    get permittedIpRanges(): string[];
    set permittedIpRanges(value: string[]);
    resetPermittedIpRanges(): void;
    get permittedIpRangesInput(): string[] | undefined;
    private _permittedUris?;
    get permittedUris(): string[];
    set permittedUris(value: string[]);
    resetPermittedUris(): void;
    get permittedUrisInput(): string[] | undefined;
}
export interface GooglePrivatecaCertificateAuthorityConfigX509ConfigPolicyIds {
    /**
    * An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#object_id_path GooglePrivatecaCertificateAuthority#object_id_path}
    */
    readonly objectIdPath: number[];
}
export declare function googlePrivatecaCertificateAuthorityConfigX509ConfigPolicyIdsToTerraform(struct?: GooglePrivatecaCertificateAuthorityConfigX509ConfigPolicyIds | cdktf.IResolvable): any;
export declare class GooglePrivatecaCertificateAuthorityConfigX509ConfigPolicyIdsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GooglePrivatecaCertificateAuthorityConfigX509ConfigPolicyIds | cdktf.IResolvable | undefined;
    set internalValue(value: GooglePrivatecaCertificateAuthorityConfigX509ConfigPolicyIds | cdktf.IResolvable | undefined);
    private _objectIdPath?;
    get objectIdPath(): number[];
    set objectIdPath(value: number[]);
    get objectIdPathInput(): number[] | undefined;
}
export declare class GooglePrivatecaCertificateAuthorityConfigX509ConfigPolicyIdsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GooglePrivatecaCertificateAuthorityConfigX509ConfigPolicyIds[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GooglePrivatecaCertificateAuthorityConfigX509ConfigPolicyIdsOutputReference;
}
export interface GooglePrivatecaCertificateAuthorityConfigX509Config {
    /**
    * Describes Online Certificate Status Protocol (OCSP) endpoint addresses that appear in the
  "Authority Information Access" extension in the certificate.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#aia_ocsp_servers GooglePrivatecaCertificateAuthority#aia_ocsp_servers}
    */
    readonly aiaOcspServers?: string[];
    /**
    * additional_extensions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#additional_extensions GooglePrivatecaCertificateAuthority#additional_extensions}
    */
    readonly additionalExtensions?: GooglePrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensions[] | cdktf.IResolvable;
    /**
    * ca_options block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#ca_options GooglePrivatecaCertificateAuthority#ca_options}
    */
    readonly caOptions: GooglePrivatecaCertificateAuthorityConfigX509ConfigCaOptions;
    /**
    * key_usage block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#key_usage GooglePrivatecaCertificateAuthority#key_usage}
    */
    readonly keyUsage: GooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsage;
    /**
    * name_constraints block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#name_constraints GooglePrivatecaCertificateAuthority#name_constraints}
    */
    readonly nameConstraints?: GooglePrivatecaCertificateAuthorityConfigX509ConfigNameConstraints;
    /**
    * policy_ids block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#policy_ids GooglePrivatecaCertificateAuthority#policy_ids}
    */
    readonly policyIds?: GooglePrivatecaCertificateAuthorityConfigX509ConfigPolicyIds[] | cdktf.IResolvable;
}
export declare function googlePrivatecaCertificateAuthorityConfigX509ConfigToTerraform(struct?: GooglePrivatecaCertificateAuthorityConfigX509ConfigOutputReference | GooglePrivatecaCertificateAuthorityConfigX509Config): any;
export declare class GooglePrivatecaCertificateAuthorityConfigX509ConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePrivatecaCertificateAuthorityConfigX509Config | undefined;
    set internalValue(value: GooglePrivatecaCertificateAuthorityConfigX509Config | undefined);
    private _aiaOcspServers?;
    get aiaOcspServers(): string[];
    set aiaOcspServers(value: string[]);
    resetAiaOcspServers(): void;
    get aiaOcspServersInput(): string[] | undefined;
    private _additionalExtensions;
    get additionalExtensions(): GooglePrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsList;
    putAdditionalExtensions(value: GooglePrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensions[] | cdktf.IResolvable): void;
    resetAdditionalExtensions(): void;
    get additionalExtensionsInput(): cdktf.IResolvable | GooglePrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensions[] | undefined;
    private _caOptions;
    get caOptions(): GooglePrivatecaCertificateAuthorityConfigX509ConfigCaOptionsOutputReference;
    putCaOptions(value: GooglePrivatecaCertificateAuthorityConfigX509ConfigCaOptions): void;
    get caOptionsInput(): GooglePrivatecaCertificateAuthorityConfigX509ConfigCaOptions | undefined;
    private _keyUsage;
    get keyUsage(): GooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsageOutputReference;
    putKeyUsage(value: GooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsage): void;
    get keyUsageInput(): GooglePrivatecaCertificateAuthorityConfigX509ConfigKeyUsage | undefined;
    private _nameConstraints;
    get nameConstraints(): GooglePrivatecaCertificateAuthorityConfigX509ConfigNameConstraintsOutputReference;
    putNameConstraints(value: GooglePrivatecaCertificateAuthorityConfigX509ConfigNameConstraints): void;
    resetNameConstraints(): void;
    get nameConstraintsInput(): GooglePrivatecaCertificateAuthorityConfigX509ConfigNameConstraints | undefined;
    private _policyIds;
    get policyIds(): GooglePrivatecaCertificateAuthorityConfigX509ConfigPolicyIdsList;
    putPolicyIds(value: GooglePrivatecaCertificateAuthorityConfigX509ConfigPolicyIds[] | cdktf.IResolvable): void;
    resetPolicyIds(): void;
    get policyIdsInput(): cdktf.IResolvable | GooglePrivatecaCertificateAuthorityConfigX509ConfigPolicyIds[] | undefined;
}
export interface GooglePrivatecaCertificateAuthorityConfigA {
    /**
    * subject_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#subject_config GooglePrivatecaCertificateAuthority#subject_config}
    */
    readonly subjectConfig: GooglePrivatecaCertificateAuthorityConfigSubjectConfig;
    /**
    * x509_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#x509_config GooglePrivatecaCertificateAuthority#x509_config}
    */
    readonly x509Config: GooglePrivatecaCertificateAuthorityConfigX509Config;
}
export declare function googlePrivatecaCertificateAuthorityConfigAToTerraform(struct?: GooglePrivatecaCertificateAuthorityConfigAOutputReference | GooglePrivatecaCertificateAuthorityConfigA): any;
export declare class GooglePrivatecaCertificateAuthorityConfigAOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePrivatecaCertificateAuthorityConfigA | undefined;
    set internalValue(value: GooglePrivatecaCertificateAuthorityConfigA | undefined);
    private _subjectConfig;
    get subjectConfig(): GooglePrivatecaCertificateAuthorityConfigSubjectConfigOutputReference;
    putSubjectConfig(value: GooglePrivatecaCertificateAuthorityConfigSubjectConfig): void;
    get subjectConfigInput(): GooglePrivatecaCertificateAuthorityConfigSubjectConfig | undefined;
    private _x509Config;
    get x509Config(): GooglePrivatecaCertificateAuthorityConfigX509ConfigOutputReference;
    putX509Config(value: GooglePrivatecaCertificateAuthorityConfigX509Config): void;
    get x509ConfigInput(): GooglePrivatecaCertificateAuthorityConfigX509Config | undefined;
}
export interface GooglePrivatecaCertificateAuthorityKeySpec {
    /**
    * The algorithm to use for creating a managed Cloud KMS key for a for a simplified
  experience. All managed keys will be have their ProtectionLevel as HSM. Possible values: ["SIGN_HASH_ALGORITHM_UNSPECIFIED", "RSA_PSS_2048_SHA256", "RSA_PSS_3072_SHA256", "RSA_PSS_4096_SHA256", "RSA_PKCS1_2048_SHA256", "RSA_PKCS1_3072_SHA256", "RSA_PKCS1_4096_SHA256", "EC_P256_SHA256", "EC_P384_SHA384"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#algorithm GooglePrivatecaCertificateAuthority#algorithm}
    */
    readonly algorithm?: string;
    /**
    * The resource name for an existing Cloud KMS CryptoKeyVersion in the format
  'projects/*\/locations/*\/keyRings/*\/cryptoKeys/*\/cryptoKeyVersions/*'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#cloud_kms_key_version GooglePrivatecaCertificateAuthority#cloud_kms_key_version}
    */
    readonly cloudKmsKeyVersion?: string;
}
export declare function googlePrivatecaCertificateAuthorityKeySpecToTerraform(struct?: GooglePrivatecaCertificateAuthorityKeySpecOutputReference | GooglePrivatecaCertificateAuthorityKeySpec): any;
export declare class GooglePrivatecaCertificateAuthorityKeySpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePrivatecaCertificateAuthorityKeySpec | undefined;
    set internalValue(value: GooglePrivatecaCertificateAuthorityKeySpec | undefined);
    private _algorithm?;
    get algorithm(): string;
    set algorithm(value: string);
    resetAlgorithm(): void;
    get algorithmInput(): string | undefined;
    private _cloudKmsKeyVersion?;
    get cloudKmsKeyVersion(): string;
    set cloudKmsKeyVersion(value: string);
    resetCloudKmsKeyVersion(): void;
    get cloudKmsKeyVersionInput(): string | undefined;
}
export interface GooglePrivatecaCertificateAuthoritySubordinateConfigPemIssuerChain {
    /**
    * Expected to be in leaf-to-root order according to RFC 5246.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#pem_certificates GooglePrivatecaCertificateAuthority#pem_certificates}
    */
    readonly pemCertificates?: string[];
}
export declare function googlePrivatecaCertificateAuthoritySubordinateConfigPemIssuerChainToTerraform(struct?: GooglePrivatecaCertificateAuthoritySubordinateConfigPemIssuerChainOutputReference | GooglePrivatecaCertificateAuthoritySubordinateConfigPemIssuerChain): any;
export declare class GooglePrivatecaCertificateAuthoritySubordinateConfigPemIssuerChainOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePrivatecaCertificateAuthoritySubordinateConfigPemIssuerChain | undefined;
    set internalValue(value: GooglePrivatecaCertificateAuthoritySubordinateConfigPemIssuerChain | undefined);
    private _pemCertificates?;
    get pemCertificates(): string[];
    set pemCertificates(value: string[]);
    resetPemCertificates(): void;
    get pemCertificatesInput(): string[] | undefined;
}
export interface GooglePrivatecaCertificateAuthoritySubordinateConfig {
    /**
    * This can refer to a CertificateAuthority that was used to create a
  subordinate CertificateAuthority. This field is used for information
  and usability purposes only. The resource name is in the format
  'projects/*\/locations/*\/caPools/*\/certificateAuthorities/*'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#certificate_authority GooglePrivatecaCertificateAuthority#certificate_authority}
    */
    readonly certificateAuthority?: string;
    /**
    * pem_issuer_chain block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#pem_issuer_chain GooglePrivatecaCertificateAuthority#pem_issuer_chain}
    */
    readonly pemIssuerChain?: GooglePrivatecaCertificateAuthoritySubordinateConfigPemIssuerChain;
}
export declare function googlePrivatecaCertificateAuthoritySubordinateConfigToTerraform(struct?: GooglePrivatecaCertificateAuthoritySubordinateConfigOutputReference | GooglePrivatecaCertificateAuthoritySubordinateConfig): any;
export declare class GooglePrivatecaCertificateAuthoritySubordinateConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePrivatecaCertificateAuthoritySubordinateConfig | undefined;
    set internalValue(value: GooglePrivatecaCertificateAuthoritySubordinateConfig | undefined);
    private _certificateAuthority?;
    get certificateAuthority(): string;
    set certificateAuthority(value: string);
    resetCertificateAuthority(): void;
    get certificateAuthorityInput(): string | undefined;
    private _pemIssuerChain;
    get pemIssuerChain(): GooglePrivatecaCertificateAuthoritySubordinateConfigPemIssuerChainOutputReference;
    putPemIssuerChain(value: GooglePrivatecaCertificateAuthoritySubordinateConfigPemIssuerChain): void;
    resetPemIssuerChain(): void;
    get pemIssuerChainInput(): GooglePrivatecaCertificateAuthoritySubordinateConfigPemIssuerChain | undefined;
}
export interface GooglePrivatecaCertificateAuthorityTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#create GooglePrivatecaCertificateAuthority#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#delete GooglePrivatecaCertificateAuthority#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority#update GooglePrivatecaCertificateAuthority#update}
    */
    readonly update?: string;
}
export declare function googlePrivatecaCertificateAuthorityTimeoutsToTerraform(struct?: GooglePrivatecaCertificateAuthorityTimeouts | cdktf.IResolvable): any;
export declare class GooglePrivatecaCertificateAuthorityTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePrivatecaCertificateAuthorityTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GooglePrivatecaCertificateAuthorityTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority google_privateca_certificate_authority}
*/
export declare class GooglePrivatecaCertificateAuthority extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_privateca_certificate_authority";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_privateca_certificate_authority google_privateca_certificate_authority} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GooglePrivatecaCertificateAuthorityConfig
    */
    constructor(scope: Construct, id: string, config: GooglePrivatecaCertificateAuthorityConfig);
    private _accessUrls;
    get accessUrls(): GooglePrivatecaCertificateAuthorityAccessUrlsList;
    private _certificateAuthorityId?;
    get certificateAuthorityId(): string;
    set certificateAuthorityId(value: string);
    get certificateAuthorityIdInput(): string | undefined;
    get createTime(): string;
    private _deletionProtection?;
    get deletionProtection(): boolean | cdktf.IResolvable;
    set deletionProtection(value: boolean | cdktf.IResolvable);
    resetDeletionProtection(): void;
    get deletionProtectionInput(): boolean | cdktf.IResolvable | undefined;
    private _desiredState?;
    get desiredState(): string;
    set desiredState(value: string);
    resetDesiredState(): void;
    get desiredStateInput(): string | undefined;
    private _gcsBucket?;
    get gcsBucket(): string;
    set gcsBucket(value: string);
    resetGcsBucket(): void;
    get gcsBucketInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ignoreActiveCertificatesOnDeletion?;
    get ignoreActiveCertificatesOnDeletion(): boolean | cdktf.IResolvable;
    set ignoreActiveCertificatesOnDeletion(value: boolean | cdktf.IResolvable);
    resetIgnoreActiveCertificatesOnDeletion(): void;
    get ignoreActiveCertificatesOnDeletionInput(): boolean | cdktf.IResolvable | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _lifetime?;
    get lifetime(): string;
    set lifetime(value: string);
    resetLifetime(): void;
    get lifetimeInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    private _pemCaCertificate?;
    get pemCaCertificate(): string;
    set pemCaCertificate(value: string);
    resetPemCaCertificate(): void;
    get pemCaCertificateInput(): string | undefined;
    get pemCaCertificates(): string[];
    private _pool?;
    get pool(): string;
    set pool(value: string);
    get poolInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _skipGracePeriod?;
    get skipGracePeriod(): boolean | cdktf.IResolvable;
    set skipGracePeriod(value: boolean | cdktf.IResolvable);
    resetSkipGracePeriod(): void;
    get skipGracePeriodInput(): boolean | cdktf.IResolvable | undefined;
    get state(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    get updateTime(): string;
    private _config;
    get config(): GooglePrivatecaCertificateAuthorityConfigAOutputReference;
    putConfig(value: GooglePrivatecaCertificateAuthorityConfigA): void;
    get configInput(): GooglePrivatecaCertificateAuthorityConfigA | undefined;
    private _keySpec;
    get keySpec(): GooglePrivatecaCertificateAuthorityKeySpecOutputReference;
    putKeySpec(value: GooglePrivatecaCertificateAuthorityKeySpec): void;
    get keySpecInput(): GooglePrivatecaCertificateAuthorityKeySpec | undefined;
    private _subordinateConfig;
    get subordinateConfig(): GooglePrivatecaCertificateAuthoritySubordinateConfigOutputReference;
    putSubordinateConfig(value: GooglePrivatecaCertificateAuthoritySubordinateConfig): void;
    resetSubordinateConfig(): void;
    get subordinateConfigInput(): GooglePrivatecaCertificateAuthoritySubordinateConfig | undefined;
    private _timeouts;
    get timeouts(): GooglePrivatecaCertificateAuthorityTimeoutsOutputReference;
    putTimeouts(value: GooglePrivatecaCertificateAuthorityTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GooglePrivatecaCertificateAuthorityTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
