import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleProjectAccessApprovalSettingsConfig extends cdktf.TerraformMetaArguments {
    /**
    * The asymmetric crypto key version to use for signing approval requests.
  Empty active_key_version indicates that a Google-managed key should be used for signing.
  This property will be ignored if set by an ancestor of the resource, and new non-empty values may not be set.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_project_access_approval_settings#active_key_version GoogleProjectAccessApprovalSettings#active_key_version}
    */
    readonly activeKeyVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_project_access_approval_settings#id GoogleProjectAccessApprovalSettings#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A list of email addresses to which notifications relating to approval requests should be sent.
  Notifications relating to a resource will be sent to all emails in the settings of ancestor
  resources of that resource. A maximum of 50 email addresses are allowed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_project_access_approval_settings#notification_emails GoogleProjectAccessApprovalSettings#notification_emails}
    */
    readonly notificationEmails?: string[];
    /**
    * Deprecated in favor of 'project_id'
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_project_access_approval_settings#project GoogleProjectAccessApprovalSettings#project}
    */
    readonly project?: string;
    /**
    * ID of the project of the access approval settings.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_project_access_approval_settings#project_id GoogleProjectAccessApprovalSettings#project_id}
    */
    readonly projectId: string;
    /**
    * enrolled_services block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_project_access_approval_settings#enrolled_services GoogleProjectAccessApprovalSettings#enrolled_services}
    */
    readonly enrolledServices: GoogleProjectAccessApprovalSettingsEnrolledServices[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_project_access_approval_settings#timeouts GoogleProjectAccessApprovalSettings#timeouts}
    */
    readonly timeouts?: GoogleProjectAccessApprovalSettingsTimeouts;
}
export interface GoogleProjectAccessApprovalSettingsEnrolledServices {
    /**
    * The product for which Access Approval will be enrolled. Allowed values are listed (case-sensitive):
    all
    appengine.googleapis.com
    bigquery.googleapis.com
    bigtable.googleapis.com
    cloudkms.googleapis.com
    compute.googleapis.com
    dataflow.googleapis.com
    iam.googleapis.com
    pubsub.googleapis.com
    storage.googleapis.com
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_project_access_approval_settings#cloud_product GoogleProjectAccessApprovalSettings#cloud_product}
    */
    readonly cloudProduct: string;
    /**
    * The enrollment level of the service. Default value: "BLOCK_ALL" Possible values: ["BLOCK_ALL"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_project_access_approval_settings#enrollment_level GoogleProjectAccessApprovalSettings#enrollment_level}
    */
    readonly enrollmentLevel?: string;
}
export declare function googleProjectAccessApprovalSettingsEnrolledServicesToTerraform(struct?: GoogleProjectAccessApprovalSettingsEnrolledServices | cdktf.IResolvable): any;
export declare class GoogleProjectAccessApprovalSettingsEnrolledServicesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleProjectAccessApprovalSettingsEnrolledServices | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleProjectAccessApprovalSettingsEnrolledServices | cdktf.IResolvable | undefined);
    private _cloudProduct?;
    get cloudProduct(): string;
    set cloudProduct(value: string);
    get cloudProductInput(): string | undefined;
    private _enrollmentLevel?;
    get enrollmentLevel(): string;
    set enrollmentLevel(value: string);
    resetEnrollmentLevel(): void;
    get enrollmentLevelInput(): string | undefined;
}
export declare class GoogleProjectAccessApprovalSettingsEnrolledServicesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleProjectAccessApprovalSettingsEnrolledServices[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleProjectAccessApprovalSettingsEnrolledServicesOutputReference;
}
export interface GoogleProjectAccessApprovalSettingsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_project_access_approval_settings#create GoogleProjectAccessApprovalSettings#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_project_access_approval_settings#delete GoogleProjectAccessApprovalSettings#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_project_access_approval_settings#update GoogleProjectAccessApprovalSettings#update}
    */
    readonly update?: string;
}
export declare function googleProjectAccessApprovalSettingsTimeoutsToTerraform(struct?: GoogleProjectAccessApprovalSettingsTimeouts | cdktf.IResolvable): any;
export declare class GoogleProjectAccessApprovalSettingsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleProjectAccessApprovalSettingsTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleProjectAccessApprovalSettingsTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_project_access_approval_settings google_project_access_approval_settings}
*/
export declare class GoogleProjectAccessApprovalSettings extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_project_access_approval_settings";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_project_access_approval_settings google_project_access_approval_settings} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleProjectAccessApprovalSettingsConfig
    */
    constructor(scope: Construct, id: string, config: GoogleProjectAccessApprovalSettingsConfig);
    private _activeKeyVersion?;
    get activeKeyVersion(): string;
    set activeKeyVersion(value: string);
    resetActiveKeyVersion(): void;
    get activeKeyVersionInput(): string | undefined;
    get ancestorHasActiveKeyVersion(): cdktf.IResolvable;
    get enrolledAncestor(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get invalidKeyVersion(): cdktf.IResolvable;
    get name(): string;
    private _notificationEmails?;
    get notificationEmails(): string[];
    set notificationEmails(value: string[]);
    resetNotificationEmails(): void;
    get notificationEmailsInput(): string[] | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _enrolledServices;
    get enrolledServices(): GoogleProjectAccessApprovalSettingsEnrolledServicesList;
    putEnrolledServices(value: GoogleProjectAccessApprovalSettingsEnrolledServices[] | cdktf.IResolvable): void;
    get enrolledServicesInput(): cdktf.IResolvable | GoogleProjectAccessApprovalSettingsEnrolledServices[] | undefined;
    private _timeouts;
    get timeouts(): GoogleProjectAccessApprovalSettingsTimeoutsOutputReference;
    putTimeouts(value: GoogleProjectAccessApprovalSettingsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleProjectAccessApprovalSettingsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
