import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleProjectIamAuditConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_project_iam_audit_config#id GoogleProjectIamAuditConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_project_iam_audit_config#project GoogleProjectIamAuditConfig#project}
    */
    readonly project: string;
    /**
    * Service which will be enabled for audit logging. The special value allServices covers all services.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_project_iam_audit_config#service GoogleProjectIamAuditConfig#service}
    */
    readonly service: string;
    /**
    * audit_log_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_project_iam_audit_config#audit_log_config GoogleProjectIamAuditConfig#audit_log_config}
    */
    readonly auditLogConfig: GoogleProjectIamAuditConfigAuditLogConfig[] | cdktf.IResolvable;
}
export interface GoogleProjectIamAuditConfigAuditLogConfig {
    /**
    * Identities that do not cause logging for this type of permission. Each entry can have one of the following values:user:{emailid}: An email address that represents a specific Google account. For example, alice@gmail.com or joe@example.com. serviceAccount:{emailid}: An email address that represents a service account. For example, my-other-app@appspot.gserviceaccount.com. group:{emailid}: An email address that represents a Google group. For example, admins@example.com. domain:{domain}: A G Suite domain (primary, instead of alias) name that represents all the users of that domain. For example, google.com or example.com.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_project_iam_audit_config#exempted_members GoogleProjectIamAuditConfig#exempted_members}
    */
    readonly exemptedMembers?: string[];
    /**
    * Permission type for which logging is to be configured. Must be one of DATA_READ, DATA_WRITE, or ADMIN_READ.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_project_iam_audit_config#log_type GoogleProjectIamAuditConfig#log_type}
    */
    readonly logType: string;
}
export declare function googleProjectIamAuditConfigAuditLogConfigToTerraform(struct?: GoogleProjectIamAuditConfigAuditLogConfig | cdktf.IResolvable): any;
export declare class GoogleProjectIamAuditConfigAuditLogConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleProjectIamAuditConfigAuditLogConfig | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleProjectIamAuditConfigAuditLogConfig | cdktf.IResolvable | undefined);
    private _exemptedMembers?;
    get exemptedMembers(): string[];
    set exemptedMembers(value: string[]);
    resetExemptedMembers(): void;
    get exemptedMembersInput(): string[] | undefined;
    private _logType?;
    get logType(): string;
    set logType(value: string);
    get logTypeInput(): string | undefined;
}
export declare class GoogleProjectIamAuditConfigAuditLogConfigList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleProjectIamAuditConfigAuditLogConfig[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleProjectIamAuditConfigAuditLogConfigOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_project_iam_audit_config google_project_iam_audit_config}
*/
export declare class GoogleProjectIamAuditConfig extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_project_iam_audit_config";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_project_iam_audit_config google_project_iam_audit_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleProjectIamAuditConfigConfig
    */
    constructor(scope: Construct, id: string, config: GoogleProjectIamAuditConfigConfig);
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    private _service?;
    get service(): string;
    set service(value: string);
    get serviceInput(): string | undefined;
    private _auditLogConfig;
    get auditLogConfig(): GoogleProjectIamAuditConfigAuditLogConfigList;
    putAuditLogConfig(value: GoogleProjectIamAuditConfigAuditLogConfig[] | cdktf.IResolvable): void;
    get auditLogConfigInput(): cdktf.IResolvable | GoogleProjectIamAuditConfigAuditLogConfig[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
