import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleProjectConfig extends cdktf.TerraformMetaArguments {
    /**
    * Create the 'default' network automatically.  Default true. If set to false, the default network will be deleted.  Note that, for quota purposes, you will still need to have 1 network slot available to create the project successfully, even if you set auto_create_network to false, since the network will exist momentarily.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_project#auto_create_network GoogleProject#auto_create_network}
    */
    readonly autoCreateNetwork?: boolean | cdktf.IResolvable;
    /**
    * The alphanumeric ID of the billing account this project belongs to. The user or service account performing this operation with Terraform must have Billing Account Administrator privileges (roles/billing.admin) in the organization. See Google Cloud Billing API Access Control for more details.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_project#billing_account GoogleProject#billing_account}
    */
    readonly billingAccount?: string;
    /**
    * The numeric ID of the folder this project should be created under. Only one of org_id or folder_id may be specified. If the folder_id is specified, then the project is created under the specified folder. Changing this forces the project to be migrated to the newly specified folder.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_project#folder_id GoogleProject#folder_id}
    */
    readonly folderId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_project#id GoogleProject#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A set of key/value label pairs to assign to the project.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_project#labels GoogleProject#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The display name of the project.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_project#name GoogleProject#name}
    */
    readonly name: string;
    /**
    * The numeric ID of the organization this project belongs to. Changing this forces a new project to be created.  Only one of org_id or folder_id may be specified. If the org_id is specified then the project is created at the top level. Changing this forces the project to be migrated to the newly specified organization.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_project#org_id GoogleProject#org_id}
    */
    readonly orgId?: string;
    /**
    * The project ID. Changing this forces a new project to be created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_project#project_id GoogleProject#project_id}
    */
    readonly projectId: string;
    /**
    * If true, the Terraform resource can be deleted without deleting the Project via the Google API.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_project#skip_delete GoogleProject#skip_delete}
    */
    readonly skipDelete?: boolean | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_project#timeouts GoogleProject#timeouts}
    */
    readonly timeouts?: GoogleProjectTimeouts;
}
export interface GoogleProjectTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_project#create GoogleProject#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_project#delete GoogleProject#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_project#read GoogleProject#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_project#update GoogleProject#update}
    */
    readonly update?: string;
}
export declare function googleProjectTimeoutsToTerraform(struct?: GoogleProjectTimeouts | cdktf.IResolvable): any;
export declare class GoogleProjectTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleProjectTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleProjectTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_project google_project}
*/
export declare class GoogleProject extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_project";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_project google_project} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleProjectConfig
    */
    constructor(scope: Construct, id: string, config: GoogleProjectConfig);
    private _autoCreateNetwork?;
    get autoCreateNetwork(): boolean | cdktf.IResolvable;
    set autoCreateNetwork(value: boolean | cdktf.IResolvable);
    resetAutoCreateNetwork(): void;
    get autoCreateNetworkInput(): boolean | cdktf.IResolvable | undefined;
    private _billingAccount?;
    get billingAccount(): string;
    set billingAccount(value: string);
    resetBillingAccount(): void;
    get billingAccountInput(): string | undefined;
    private _folderId?;
    get folderId(): string;
    set folderId(value: string);
    resetFolderId(): void;
    get folderIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get number(): string;
    private _orgId?;
    get orgId(): string;
    set orgId(value: string);
    resetOrgId(): void;
    get orgIdInput(): string | undefined;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _skipDelete?;
    get skipDelete(): boolean | cdktf.IResolvable;
    set skipDelete(value: boolean | cdktf.IResolvable);
    resetSkipDelete(): void;
    get skipDeleteInput(): boolean | cdktf.IResolvable | undefined;
    private _timeouts;
    get timeouts(): GoogleProjectTimeoutsOutputReference;
    putTimeouts(value: GoogleProjectTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleProjectTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
