import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GooglePubsubLiteSubscriptionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_pubsub_lite_subscription#id GooglePubsubLiteSubscription#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the subscription.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_pubsub_lite_subscription#name GooglePubsubLiteSubscription#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_pubsub_lite_subscription#project GooglePubsubLiteSubscription#project}
    */
    readonly project?: string;
    /**
    * The region of the pubsub lite topic.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_pubsub_lite_subscription#region GooglePubsubLiteSubscription#region}
    */
    readonly region?: string;
    /**
    * A reference to a Topic resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_pubsub_lite_subscription#topic GooglePubsubLiteSubscription#topic}
    */
    readonly topic: string;
    /**
    * The zone of the pubsub lite topic.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_pubsub_lite_subscription#zone GooglePubsubLiteSubscription#zone}
    */
    readonly zone?: string;
    /**
    * delivery_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_pubsub_lite_subscription#delivery_config GooglePubsubLiteSubscription#delivery_config}
    */
    readonly deliveryConfig?: GooglePubsubLiteSubscriptionDeliveryConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_pubsub_lite_subscription#timeouts GooglePubsubLiteSubscription#timeouts}
    */
    readonly timeouts?: GooglePubsubLiteSubscriptionTimeouts;
}
export interface GooglePubsubLiteSubscriptionDeliveryConfig {
    /**
    * When this subscription should send messages to subscribers relative to messages persistence in storage. Possible values: ["DELIVER_IMMEDIATELY", "DELIVER_AFTER_STORED", "DELIVERY_REQUIREMENT_UNSPECIFIED"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_pubsub_lite_subscription#delivery_requirement GooglePubsubLiteSubscription#delivery_requirement}
    */
    readonly deliveryRequirement: string;
}
export declare function googlePubsubLiteSubscriptionDeliveryConfigToTerraform(struct?: GooglePubsubLiteSubscriptionDeliveryConfigOutputReference | GooglePubsubLiteSubscriptionDeliveryConfig): any;
export declare class GooglePubsubLiteSubscriptionDeliveryConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePubsubLiteSubscriptionDeliveryConfig | undefined;
    set internalValue(value: GooglePubsubLiteSubscriptionDeliveryConfig | undefined);
    private _deliveryRequirement?;
    get deliveryRequirement(): string;
    set deliveryRequirement(value: string);
    get deliveryRequirementInput(): string | undefined;
}
export interface GooglePubsubLiteSubscriptionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_pubsub_lite_subscription#create GooglePubsubLiteSubscription#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_pubsub_lite_subscription#delete GooglePubsubLiteSubscription#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_pubsub_lite_subscription#update GooglePubsubLiteSubscription#update}
    */
    readonly update?: string;
}
export declare function googlePubsubLiteSubscriptionTimeoutsToTerraform(struct?: GooglePubsubLiteSubscriptionTimeouts | cdktf.IResolvable): any;
export declare class GooglePubsubLiteSubscriptionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePubsubLiteSubscriptionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GooglePubsubLiteSubscriptionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_pubsub_lite_subscription google_pubsub_lite_subscription}
*/
export declare class GooglePubsubLiteSubscription extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_pubsub_lite_subscription";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_pubsub_lite_subscription google_pubsub_lite_subscription} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GooglePubsubLiteSubscriptionConfig
    */
    constructor(scope: Construct, id: string, config: GooglePubsubLiteSubscriptionConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _topic?;
    get topic(): string;
    set topic(value: string);
    get topicInput(): string | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _deliveryConfig;
    get deliveryConfig(): GooglePubsubLiteSubscriptionDeliveryConfigOutputReference;
    putDeliveryConfig(value: GooglePubsubLiteSubscriptionDeliveryConfig): void;
    resetDeliveryConfig(): void;
    get deliveryConfigInput(): GooglePubsubLiteSubscriptionDeliveryConfig | undefined;
    private _timeouts;
    get timeouts(): GooglePubsubLiteSubscriptionTimeoutsOutputReference;
    putTimeouts(value: GooglePubsubLiteSubscriptionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GooglePubsubLiteSubscriptionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
