import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GooglePubsubSchemaConfig extends cdktf.TerraformMetaArguments {
    /**
    * The definition of the schema.
  This should contain a string representing the full definition of the schema
  that is a valid schema definition of the type specified in type.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_pubsub_schema#definition GooglePubsubSchema#definition}
    */
    readonly definition?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_pubsub_schema#id GooglePubsubSchema#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The ID to use for the schema, which will become the final component of the schema's resource name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_pubsub_schema#name GooglePubsubSchema#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_pubsub_schema#project GooglePubsubSchema#project}
    */
    readonly project?: string;
    /**
    * The type of the schema definition Default value: "TYPE_UNSPECIFIED" Possible values: ["TYPE_UNSPECIFIED", "PROTOCOL_BUFFER", "AVRO"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_pubsub_schema#type GooglePubsubSchema#type}
    */
    readonly type?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_pubsub_schema#timeouts GooglePubsubSchema#timeouts}
    */
    readonly timeouts?: GooglePubsubSchemaTimeouts;
}
export interface GooglePubsubSchemaTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_pubsub_schema#create GooglePubsubSchema#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_pubsub_schema#delete GooglePubsubSchema#delete}
    */
    readonly delete?: string;
}
export declare function googlePubsubSchemaTimeoutsToTerraform(struct?: GooglePubsubSchemaTimeouts | cdktf.IResolvable): any;
export declare class GooglePubsubSchemaTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GooglePubsubSchemaTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GooglePubsubSchemaTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_pubsub_schema google_pubsub_schema}
*/
export declare class GooglePubsubSchema extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_pubsub_schema";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_pubsub_schema google_pubsub_schema} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GooglePubsubSchemaConfig
    */
    constructor(scope: Construct, id: string, config: GooglePubsubSchemaConfig);
    private _definition?;
    get definition(): string;
    set definition(value: string);
    resetDefinition(): void;
    get definitionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _timeouts;
    get timeouts(): GooglePubsubSchemaTimeoutsOutputReference;
    putTimeouts(value: GooglePubsubSchemaTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GooglePubsubSchemaTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
