import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleSccSourceConfig extends cdktf.TerraformMetaArguments {
    /**
    * The description of the source (max of 1024 characters).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_scc_source#description GoogleSccSource#description}
    */
    readonly description?: string;
    /**
    * The source’s display name. A source’s display name must be unique
  amongst its siblings, for example, two sources with the same parent
  can't share the same display name. The display name must start and end
  with a letter or digit, may contain letters, digits, spaces, hyphens,
  and underscores, and can be no longer than 32 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_scc_source#display_name GoogleSccSource#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_scc_source#id GoogleSccSource#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The organization whose Cloud Security Command Center the Source
  lives in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_scc_source#organization GoogleSccSource#organization}
    */
    readonly organization: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_scc_source#timeouts GoogleSccSource#timeouts}
    */
    readonly timeouts?: GoogleSccSourceTimeouts;
}
export interface GoogleSccSourceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_scc_source#create GoogleSccSource#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_scc_source#delete GoogleSccSource#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_scc_source#update GoogleSccSource#update}
    */
    readonly update?: string;
}
export declare function googleSccSourceTimeoutsToTerraform(struct?: GoogleSccSourceTimeouts | cdktf.IResolvable): any;
export declare class GoogleSccSourceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSccSourceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleSccSourceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_scc_source google_scc_source}
*/
export declare class GoogleSccSource extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_scc_source";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_scc_source google_scc_source} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleSccSourceConfig
    */
    constructor(scope: Construct, id: string, config: GoogleSccSourceConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _organization?;
    get organization(): string;
    set organization(value: string);
    get organizationInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleSccSourceTimeoutsOutputReference;
    putTimeouts(value: GoogleSccSourceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleSccSourceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
