import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleSecurityScannerScanConfigConfig extends cdktf.TerraformMetaArguments {
    /**
    * The blacklist URL patterns as described in
  https://cloud.google.com/security-scanner/docs/excluded-urls
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_security_scanner_scan_config#blacklist_patterns GoogleSecurityScannerScanConfig#blacklist_patterns}
    */
    readonly blacklistPatterns?: string[];
    /**
    * The user provider display name of the ScanConfig.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_security_scanner_scan_config#display_name GoogleSecurityScannerScanConfig#display_name}
    */
    readonly displayName: string;
    /**
    * Controls export of scan configurations and results to Cloud Security Command Center. Default value: "ENABLED" Possible values: ["ENABLED", "DISABLED"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_security_scanner_scan_config#export_to_security_command_center GoogleSecurityScannerScanConfig#export_to_security_command_center}
    */
    readonly exportToSecurityCommandCenter?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_security_scanner_scan_config#id GoogleSecurityScannerScanConfig#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The maximum QPS during scanning. A valid value ranges from 5 to 20 inclusively.
  Defaults to 15.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_security_scanner_scan_config#max_qps GoogleSecurityScannerScanConfig#max_qps}
    */
    readonly maxQps?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_security_scanner_scan_config#project GoogleSecurityScannerScanConfig#project}
    */
    readonly project?: string;
    /**
    * The starting URLs from which the scanner finds site pages.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_security_scanner_scan_config#starting_urls GoogleSecurityScannerScanConfig#starting_urls}
    */
    readonly startingUrls: string[];
    /**
    * Set of Cloud Platforms targeted by the scan. If empty, APP_ENGINE will be used as a default. Possible values: ["APP_ENGINE", "COMPUTE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_security_scanner_scan_config#target_platforms GoogleSecurityScannerScanConfig#target_platforms}
    */
    readonly targetPlatforms?: string[];
    /**
    * Type of the user agents used for scanning Default value: "CHROME_LINUX" Possible values: ["USER_AGENT_UNSPECIFIED", "CHROME_LINUX", "CHROME_ANDROID", "SAFARI_IPHONE"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_security_scanner_scan_config#user_agent GoogleSecurityScannerScanConfig#user_agent}
    */
    readonly userAgent?: string;
    /**
    * authentication block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_security_scanner_scan_config#authentication GoogleSecurityScannerScanConfig#authentication}
    */
    readonly authentication?: GoogleSecurityScannerScanConfigAuthentication;
    /**
    * schedule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_security_scanner_scan_config#schedule GoogleSecurityScannerScanConfig#schedule}
    */
    readonly schedule?: GoogleSecurityScannerScanConfigSchedule;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_security_scanner_scan_config#timeouts GoogleSecurityScannerScanConfig#timeouts}
    */
    readonly timeouts?: GoogleSecurityScannerScanConfigTimeouts;
}
export interface GoogleSecurityScannerScanConfigAuthenticationCustomAccount {
    /**
    * The login form URL of the website.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_security_scanner_scan_config#login_url GoogleSecurityScannerScanConfig#login_url}
    */
    readonly loginUrl: string;
    /**
    * The password of the custom account. The credential is stored encrypted
  in GCP.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_security_scanner_scan_config#password GoogleSecurityScannerScanConfig#password}
    */
    readonly password: string;
    /**
    * The user name of the custom account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_security_scanner_scan_config#username GoogleSecurityScannerScanConfig#username}
    */
    readonly username: string;
}
export declare function googleSecurityScannerScanConfigAuthenticationCustomAccountToTerraform(struct?: GoogleSecurityScannerScanConfigAuthenticationCustomAccountOutputReference | GoogleSecurityScannerScanConfigAuthenticationCustomAccount): any;
export declare class GoogleSecurityScannerScanConfigAuthenticationCustomAccountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSecurityScannerScanConfigAuthenticationCustomAccount | undefined;
    set internalValue(value: GoogleSecurityScannerScanConfigAuthenticationCustomAccount | undefined);
    private _loginUrl?;
    get loginUrl(): string;
    set loginUrl(value: string);
    get loginUrlInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface GoogleSecurityScannerScanConfigAuthenticationGoogleAccount {
    /**
    * The password of the Google account. The credential is stored encrypted
  in GCP.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_security_scanner_scan_config#password GoogleSecurityScannerScanConfig#password}
    */
    readonly password: string;
    /**
    * The user name of the Google account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_security_scanner_scan_config#username GoogleSecurityScannerScanConfig#username}
    */
    readonly username: string;
}
export declare function googleSecurityScannerScanConfigAuthenticationGoogleAccountToTerraform(struct?: GoogleSecurityScannerScanConfigAuthenticationGoogleAccountOutputReference | GoogleSecurityScannerScanConfigAuthenticationGoogleAccount): any;
export declare class GoogleSecurityScannerScanConfigAuthenticationGoogleAccountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSecurityScannerScanConfigAuthenticationGoogleAccount | undefined;
    set internalValue(value: GoogleSecurityScannerScanConfigAuthenticationGoogleAccount | undefined);
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
}
export interface GoogleSecurityScannerScanConfigAuthentication {
    /**
    * custom_account block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_security_scanner_scan_config#custom_account GoogleSecurityScannerScanConfig#custom_account}
    */
    readonly customAccount?: GoogleSecurityScannerScanConfigAuthenticationCustomAccount;
    /**
    * google_account block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_security_scanner_scan_config#google_account GoogleSecurityScannerScanConfig#google_account}
    */
    readonly googleAccount?: GoogleSecurityScannerScanConfigAuthenticationGoogleAccount;
}
export declare function googleSecurityScannerScanConfigAuthenticationToTerraform(struct?: GoogleSecurityScannerScanConfigAuthenticationOutputReference | GoogleSecurityScannerScanConfigAuthentication): any;
export declare class GoogleSecurityScannerScanConfigAuthenticationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSecurityScannerScanConfigAuthentication | undefined;
    set internalValue(value: GoogleSecurityScannerScanConfigAuthentication | undefined);
    private _customAccount;
    get customAccount(): GoogleSecurityScannerScanConfigAuthenticationCustomAccountOutputReference;
    putCustomAccount(value: GoogleSecurityScannerScanConfigAuthenticationCustomAccount): void;
    resetCustomAccount(): void;
    get customAccountInput(): GoogleSecurityScannerScanConfigAuthenticationCustomAccount | undefined;
    private _googleAccount;
    get googleAccount(): GoogleSecurityScannerScanConfigAuthenticationGoogleAccountOutputReference;
    putGoogleAccount(value: GoogleSecurityScannerScanConfigAuthenticationGoogleAccount): void;
    resetGoogleAccount(): void;
    get googleAccountInput(): GoogleSecurityScannerScanConfigAuthenticationGoogleAccount | undefined;
}
export interface GoogleSecurityScannerScanConfigSchedule {
    /**
    * The duration of time between executions in days
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_security_scanner_scan_config#interval_duration_days GoogleSecurityScannerScanConfig#interval_duration_days}
    */
    readonly intervalDurationDays: number;
    /**
    * A timestamp indicates when the next run will be scheduled. The value is refreshed
  by the server after each run. If unspecified, it will default to current server time,
  which means the scan will be scheduled to start immediately.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_security_scanner_scan_config#schedule_time GoogleSecurityScannerScanConfig#schedule_time}
    */
    readonly scheduleTime?: string;
}
export declare function googleSecurityScannerScanConfigScheduleToTerraform(struct?: GoogleSecurityScannerScanConfigScheduleOutputReference | GoogleSecurityScannerScanConfigSchedule): any;
export declare class GoogleSecurityScannerScanConfigScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSecurityScannerScanConfigSchedule | undefined;
    set internalValue(value: GoogleSecurityScannerScanConfigSchedule | undefined);
    private _intervalDurationDays?;
    get intervalDurationDays(): number;
    set intervalDurationDays(value: number);
    get intervalDurationDaysInput(): number | undefined;
    private _scheduleTime?;
    get scheduleTime(): string;
    set scheduleTime(value: string);
    resetScheduleTime(): void;
    get scheduleTimeInput(): string | undefined;
}
export interface GoogleSecurityScannerScanConfigTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_security_scanner_scan_config#create GoogleSecurityScannerScanConfig#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_security_scanner_scan_config#delete GoogleSecurityScannerScanConfig#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_security_scanner_scan_config#update GoogleSecurityScannerScanConfig#update}
    */
    readonly update?: string;
}
export declare function googleSecurityScannerScanConfigTimeoutsToTerraform(struct?: GoogleSecurityScannerScanConfigTimeouts | cdktf.IResolvable): any;
export declare class GoogleSecurityScannerScanConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSecurityScannerScanConfigTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleSecurityScannerScanConfigTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_security_scanner_scan_config google_security_scanner_scan_config}
*/
export declare class GoogleSecurityScannerScanConfig extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_security_scanner_scan_config";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_security_scanner_scan_config google_security_scanner_scan_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleSecurityScannerScanConfigConfig
    */
    constructor(scope: Construct, id: string, config: GoogleSecurityScannerScanConfigConfig);
    private _blacklistPatterns?;
    get blacklistPatterns(): string[];
    set blacklistPatterns(value: string[]);
    resetBlacklistPatterns(): void;
    get blacklistPatternsInput(): string[] | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _exportToSecurityCommandCenter?;
    get exportToSecurityCommandCenter(): string;
    set exportToSecurityCommandCenter(value: string);
    resetExportToSecurityCommandCenter(): void;
    get exportToSecurityCommandCenterInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _maxQps?;
    get maxQps(): number;
    set maxQps(value: number);
    resetMaxQps(): void;
    get maxQpsInput(): number | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _startingUrls?;
    get startingUrls(): string[];
    set startingUrls(value: string[]);
    get startingUrlsInput(): string[] | undefined;
    private _targetPlatforms?;
    get targetPlatforms(): string[];
    set targetPlatforms(value: string[]);
    resetTargetPlatforms(): void;
    get targetPlatformsInput(): string[] | undefined;
    private _userAgent?;
    get userAgent(): string;
    set userAgent(value: string);
    resetUserAgent(): void;
    get userAgentInput(): string | undefined;
    private _authentication;
    get authentication(): GoogleSecurityScannerScanConfigAuthenticationOutputReference;
    putAuthentication(value: GoogleSecurityScannerScanConfigAuthentication): void;
    resetAuthentication(): void;
    get authenticationInput(): GoogleSecurityScannerScanConfigAuthentication | undefined;
    private _schedule;
    get schedule(): GoogleSecurityScannerScanConfigScheduleOutputReference;
    putSchedule(value: GoogleSecurityScannerScanConfigSchedule): void;
    resetSchedule(): void;
    get scheduleInput(): GoogleSecurityScannerScanConfigSchedule | undefined;
    private _timeouts;
    get timeouts(): GoogleSecurityScannerScanConfigTimeoutsOutputReference;
    putTimeouts(value: GoogleSecurityScannerScanConfigTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleSecurityScannerScanConfigTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
