import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleServiceAccountIamBindingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_service_account_iam_binding#id GoogleServiceAccountIamBinding#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_service_account_iam_binding#members GoogleServiceAccountIamBinding#members}
    */
    readonly members: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_service_account_iam_binding#role GoogleServiceAccountIamBinding#role}
    */
    readonly role: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_service_account_iam_binding#service_account_id GoogleServiceAccountIamBinding#service_account_id}
    */
    readonly serviceAccountId: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_service_account_iam_binding#condition GoogleServiceAccountIamBinding#condition}
    */
    readonly condition?: GoogleServiceAccountIamBindingCondition;
}
export interface GoogleServiceAccountIamBindingCondition {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_service_account_iam_binding#description GoogleServiceAccountIamBinding#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_service_account_iam_binding#expression GoogleServiceAccountIamBinding#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_service_account_iam_binding#title GoogleServiceAccountIamBinding#title}
    */
    readonly title: string;
}
export declare function googleServiceAccountIamBindingConditionToTerraform(struct?: GoogleServiceAccountIamBindingConditionOutputReference | GoogleServiceAccountIamBindingCondition): any;
export declare class GoogleServiceAccountIamBindingConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleServiceAccountIamBindingCondition | undefined;
    set internalValue(value: GoogleServiceAccountIamBindingCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_service_account_iam_binding google_service_account_iam_binding}
*/
export declare class GoogleServiceAccountIamBinding extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_service_account_iam_binding";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_service_account_iam_binding google_service_account_iam_binding} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleServiceAccountIamBindingConfig
    */
    constructor(scope: Construct, id: string, config: GoogleServiceAccountIamBindingConfig);
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _members?;
    get members(): string[];
    set members(value: string[]);
    get membersInput(): string[] | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _serviceAccountId?;
    get serviceAccountId(): string;
    set serviceAccountId(value: string);
    get serviceAccountIdInput(): string | undefined;
    private _condition;
    get condition(): GoogleServiceAccountIamBindingConditionOutputReference;
    putCondition(value: GoogleServiceAccountIamBindingCondition): void;
    resetCondition(): void;
    get conditionInput(): GoogleServiceAccountIamBindingCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
