import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleSqlSslCertConfig extends cdktf.TerraformMetaArguments {
    /**
    * The common name to be used in the certificate to identify the client. Constrained to [a-zA-Z.-_ ]+. Changing this forces a new resource to be created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_sql_ssl_cert#common_name GoogleSqlSslCert#common_name}
    */
    readonly commonName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_sql_ssl_cert#id GoogleSqlSslCert#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the Cloud SQL instance. Changing this forces a new resource to be created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_sql_ssl_cert#instance GoogleSqlSslCert#instance}
    */
    readonly instance: string;
    /**
    * The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_sql_ssl_cert#project GoogleSqlSslCert#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_sql_ssl_cert#timeouts GoogleSqlSslCert#timeouts}
    */
    readonly timeouts?: GoogleSqlSslCertTimeouts;
}
export interface GoogleSqlSslCertTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_sql_ssl_cert#create GoogleSqlSslCert#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_sql_ssl_cert#delete GoogleSqlSslCert#delete}
    */
    readonly delete?: string;
}
export declare function googleSqlSslCertTimeoutsToTerraform(struct?: GoogleSqlSslCertTimeouts | cdktf.IResolvable): any;
export declare class GoogleSqlSslCertTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSqlSslCertTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleSqlSslCertTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_sql_ssl_cert google_sql_ssl_cert}
*/
export declare class GoogleSqlSslCert extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_sql_ssl_cert";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_sql_ssl_cert google_sql_ssl_cert} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleSqlSslCertConfig
    */
    constructor(scope: Construct, id: string, config: GoogleSqlSslCertConfig);
    get cert(): string;
    get certSerialNumber(): string;
    private _commonName?;
    get commonName(): string;
    set commonName(value: string);
    get commonNameInput(): string | undefined;
    get createTime(): string;
    get expirationTime(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instance?;
    get instance(): string;
    set instance(value: string);
    get instanceInput(): string | undefined;
    get privateKey(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get serverCaCert(): string;
    get sha1Fingerprint(): string;
    private _timeouts;
    get timeouts(): GoogleSqlSslCertTimeoutsOutputReference;
    putTimeouts(value: GoogleSqlSslCertTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleSqlSslCertTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
