import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleSqlUserConfig extends cdktf.TerraformMetaArguments {
    /**
    * The deletion policy for the user. Setting ABANDON allows the resource
                  to be abandoned rather than deleted. This is useful for Postgres, where users cannot be deleted from the API if they
                  have been granted SQL roles. Possible values are: "ABANDON".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_sql_user#deletion_policy GoogleSqlUser#deletion_policy}
    */
    readonly deletionPolicy?: string;
    /**
    * The host the user can connect from. This is only supported for MySQL instances. Don't set this field for PostgreSQL instances. Can be an IP address. Changing this forces a new resource to be created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_sql_user#host GoogleSqlUser#host}
    */
    readonly host?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_sql_user#id GoogleSqlUser#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the Cloud SQL instance. Changing this forces a new resource to be created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_sql_user#instance GoogleSqlUser#instance}
    */
    readonly instance: string;
    /**
    * The name of the user. Changing this forces a new resource to be created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_sql_user#name GoogleSqlUser#name}
    */
    readonly name: string;
    /**
    * The password for the user. Can be updated. For Postgres instances this is a Required field, unless type is set to
                  either CLOUD_IAM_USER or CLOUD_IAM_SERVICE_ACCOUNT.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_sql_user#password GoogleSqlUser#password}
    */
    readonly password?: string;
    /**
    * The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_sql_user#project GoogleSqlUser#project}
    */
    readonly project?: string;
    /**
    * The user type. It determines the method to authenticate the user during login.
                  The default is the database's built-in user type. Flags include "BUILT_IN", "CLOUD_IAM_USER", or "CLOUD_IAM_SERVICE_ACCOUNT".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_sql_user#type GoogleSqlUser#type}
    */
    readonly type?: string;
    /**
    * password_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_sql_user#password_policy GoogleSqlUser#password_policy}
    */
    readonly passwordPolicy?: GoogleSqlUserPasswordPolicy;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_sql_user#timeouts GoogleSqlUser#timeouts}
    */
    readonly timeouts?: GoogleSqlUserTimeouts;
}
export interface GoogleSqlUserSqlServerUserDetails {
}
export declare function googleSqlUserSqlServerUserDetailsToTerraform(struct?: GoogleSqlUserSqlServerUserDetails): any;
export declare class GoogleSqlUserSqlServerUserDetailsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleSqlUserSqlServerUserDetails | undefined;
    set internalValue(value: GoogleSqlUserSqlServerUserDetails | undefined);
    get disabled(): cdktf.IResolvable;
    get serverRoles(): string[];
}
export declare class GoogleSqlUserSqlServerUserDetailsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleSqlUserSqlServerUserDetailsOutputReference;
}
export interface GoogleSqlUserPasswordPolicyStatus {
}
export declare function googleSqlUserPasswordPolicyStatusToTerraform(struct?: GoogleSqlUserPasswordPolicyStatus): any;
export declare class GoogleSqlUserPasswordPolicyStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleSqlUserPasswordPolicyStatus | undefined;
    set internalValue(value: GoogleSqlUserPasswordPolicyStatus | undefined);
    get locked(): cdktf.IResolvable;
    get passwordExpirationTime(): string;
}
export declare class GoogleSqlUserPasswordPolicyStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleSqlUserPasswordPolicyStatusOutputReference;
}
export interface GoogleSqlUserPasswordPolicy {
    /**
    * Number of failed attempts allowed before the user get locked.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_sql_user#allowed_failed_attempts GoogleSqlUser#allowed_failed_attempts}
    */
    readonly allowedFailedAttempts?: number;
    /**
    * If true, the check that will lock user after too many failed login attempts will be enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_sql_user#enable_failed_attempts_check GoogleSqlUser#enable_failed_attempts_check}
    */
    readonly enableFailedAttemptsCheck?: boolean | cdktf.IResolvable;
    /**
    * If true, the user must specify the current password before changing the password. This flag is supported only for MySQL.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_sql_user#enable_password_verification GoogleSqlUser#enable_password_verification}
    */
    readonly enablePasswordVerification?: boolean | cdktf.IResolvable;
    /**
    * Password expiration duration with one week grace period.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_sql_user#password_expiration_duration GoogleSqlUser#password_expiration_duration}
    */
    readonly passwordExpirationDuration?: string;
}
export declare function googleSqlUserPasswordPolicyToTerraform(struct?: GoogleSqlUserPasswordPolicyOutputReference | GoogleSqlUserPasswordPolicy): any;
export declare class GoogleSqlUserPasswordPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSqlUserPasswordPolicy | undefined;
    set internalValue(value: GoogleSqlUserPasswordPolicy | undefined);
    private _allowedFailedAttempts?;
    get allowedFailedAttempts(): number;
    set allowedFailedAttempts(value: number);
    resetAllowedFailedAttempts(): void;
    get allowedFailedAttemptsInput(): number | undefined;
    private _enableFailedAttemptsCheck?;
    get enableFailedAttemptsCheck(): boolean | cdktf.IResolvable;
    set enableFailedAttemptsCheck(value: boolean | cdktf.IResolvable);
    resetEnableFailedAttemptsCheck(): void;
    get enableFailedAttemptsCheckInput(): boolean | cdktf.IResolvable | undefined;
    private _enablePasswordVerification?;
    get enablePasswordVerification(): boolean | cdktf.IResolvable;
    set enablePasswordVerification(value: boolean | cdktf.IResolvable);
    resetEnablePasswordVerification(): void;
    get enablePasswordVerificationInput(): boolean | cdktf.IResolvable | undefined;
    private _passwordExpirationDuration?;
    get passwordExpirationDuration(): string;
    set passwordExpirationDuration(value: string);
    resetPasswordExpirationDuration(): void;
    get passwordExpirationDurationInput(): string | undefined;
    private _status;
    get status(): GoogleSqlUserPasswordPolicyStatusList;
}
export interface GoogleSqlUserTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_sql_user#create GoogleSqlUser#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_sql_user#delete GoogleSqlUser#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_sql_user#update GoogleSqlUser#update}
    */
    readonly update?: string;
}
export declare function googleSqlUserTimeoutsToTerraform(struct?: GoogleSqlUserTimeouts | cdktf.IResolvable): any;
export declare class GoogleSqlUserTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleSqlUserTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleSqlUserTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_sql_user google_sql_user}
*/
export declare class GoogleSqlUser extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_sql_user";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_sql_user google_sql_user} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleSqlUserConfig
    */
    constructor(scope: Construct, id: string, config: GoogleSqlUserConfig);
    private _deletionPolicy?;
    get deletionPolicy(): string;
    set deletionPolicy(value: string);
    resetDeletionPolicy(): void;
    get deletionPolicyInput(): string | undefined;
    private _host?;
    get host(): string;
    set host(value: string);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _instance?;
    get instance(): string;
    set instance(value: string);
    get instanceInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _sqlServerUserDetails;
    get sqlServerUserDetails(): GoogleSqlUserSqlServerUserDetailsList;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _passwordPolicy;
    get passwordPolicy(): GoogleSqlUserPasswordPolicyOutputReference;
    putPasswordPolicy(value: GoogleSqlUserPasswordPolicy): void;
    resetPasswordPolicy(): void;
    get passwordPolicyInput(): GoogleSqlUserPasswordPolicy | undefined;
    private _timeouts;
    get timeouts(): GoogleSqlUserTimeoutsOutputReference;
    putTimeouts(value: GoogleSqlUserTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleSqlUserTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
