import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleStorageBucketObjectConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the containing bucket.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket_object#bucket GoogleStorageBucketObject#bucket}
    */
    readonly bucket: string;
    /**
    * Cache-Control directive to specify caching behavior of object data. If omitted and object is accessible to all anonymous users, the default will be public, max-age=3600
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket_object#cache_control GoogleStorageBucketObject#cache_control}
    */
    readonly cacheControl?: string;
    /**
    * Data as string to be uploaded. Must be defined if source is not. Note: The content field is marked as sensitive. To view the raw contents of the object, please define an output.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket_object#content GoogleStorageBucketObject#content}
    */
    readonly content?: string;
    /**
    * Content-Disposition of the object data.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket_object#content_disposition GoogleStorageBucketObject#content_disposition}
    */
    readonly contentDisposition?: string;
    /**
    * Content-Encoding of the object data.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket_object#content_encoding GoogleStorageBucketObject#content_encoding}
    */
    readonly contentEncoding?: string;
    /**
    * Content-Language of the object data.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket_object#content_language GoogleStorageBucketObject#content_language}
    */
    readonly contentLanguage?: string;
    /**
    * Content-Type of the object data. Defaults to "application/octet-stream" or "text/plain; charset=utf-8".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket_object#content_type GoogleStorageBucketObject#content_type}
    */
    readonly contentType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket_object#detect_md5hash GoogleStorageBucketObject#detect_md5hash}
    */
    readonly detectMd5Hash?: string;
    /**
    * Whether an object is under event-based hold. Event-based hold is a way to retain objects until an event occurs, which is signified by the hold's release (i.e. this value is set to false). After being released (set to false), such objects will be subject to bucket-level retention (if any).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket_object#event_based_hold GoogleStorageBucketObject#event_based_hold}
    */
    readonly eventBasedHold?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket_object#id GoogleStorageBucketObject#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Resource name of the Cloud KMS key that will be used to encrypt the object. Overrides the object metadata's kmsKeyName value, if any.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket_object#kms_key_name GoogleStorageBucketObject#kms_key_name}
    */
    readonly kmsKeyName?: string;
    /**
    * User-provided metadata, in key/value pairs.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket_object#metadata GoogleStorageBucketObject#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * The name of the object. If you're interpolating the name of this object, see output_name instead.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket_object#name GoogleStorageBucketObject#name}
    */
    readonly name: string;
    /**
    * A path to the data you want to upload. Must be defined if content is not.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket_object#source GoogleStorageBucketObject#source}
    */
    readonly source?: string;
    /**
    * The StorageClass of the new bucket object. Supported values include: MULTI_REGIONAL, REGIONAL, NEARLINE, COLDLINE, ARCHIVE. If not provided, this defaults to the bucket's default storage class or to a standard class.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket_object#storage_class GoogleStorageBucketObject#storage_class}
    */
    readonly storageClass?: string;
    /**
    * Whether an object is under temporary hold. While this flag is set to true, the object is protected against deletion and overwrites.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket_object#temporary_hold GoogleStorageBucketObject#temporary_hold}
    */
    readonly temporaryHold?: boolean | cdktf.IResolvable;
    /**
    * customer_encryption block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket_object#customer_encryption GoogleStorageBucketObject#customer_encryption}
    */
    readonly customerEncryption?: GoogleStorageBucketObjectCustomerEncryption;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket_object#timeouts GoogleStorageBucketObject#timeouts}
    */
    readonly timeouts?: GoogleStorageBucketObjectTimeouts;
}
export interface GoogleStorageBucketObjectCustomerEncryption {
    /**
    * The encryption algorithm. Default: AES256
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket_object#encryption_algorithm GoogleStorageBucketObject#encryption_algorithm}
    */
    readonly encryptionAlgorithm?: string;
    /**
    * Base64 encoded customer supplied encryption key.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket_object#encryption_key GoogleStorageBucketObject#encryption_key}
    */
    readonly encryptionKey: string;
}
export declare function googleStorageBucketObjectCustomerEncryptionToTerraform(struct?: GoogleStorageBucketObjectCustomerEncryptionOutputReference | GoogleStorageBucketObjectCustomerEncryption): any;
export declare class GoogleStorageBucketObjectCustomerEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleStorageBucketObjectCustomerEncryption | undefined;
    set internalValue(value: GoogleStorageBucketObjectCustomerEncryption | undefined);
    private _encryptionAlgorithm?;
    get encryptionAlgorithm(): string;
    set encryptionAlgorithm(value: string);
    resetEncryptionAlgorithm(): void;
    get encryptionAlgorithmInput(): string | undefined;
    private _encryptionKey?;
    get encryptionKey(): string;
    set encryptionKey(value: string);
    get encryptionKeyInput(): string | undefined;
}
export interface GoogleStorageBucketObjectTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket_object#create GoogleStorageBucketObject#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket_object#delete GoogleStorageBucketObject#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket_object#update GoogleStorageBucketObject#update}
    */
    readonly update?: string;
}
export declare function googleStorageBucketObjectTimeoutsToTerraform(struct?: GoogleStorageBucketObjectTimeouts | cdktf.IResolvable): any;
export declare class GoogleStorageBucketObjectTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleStorageBucketObjectTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleStorageBucketObjectTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket_object google_storage_bucket_object}
*/
export declare class GoogleStorageBucketObject extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_storage_bucket_object";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket_object google_storage_bucket_object} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleStorageBucketObjectConfig
    */
    constructor(scope: Construct, id: string, config: GoogleStorageBucketObjectConfig);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    private _cacheControl?;
    get cacheControl(): string;
    set cacheControl(value: string);
    resetCacheControl(): void;
    get cacheControlInput(): string | undefined;
    private _content?;
    get content(): string;
    set content(value: string);
    resetContent(): void;
    get contentInput(): string | undefined;
    private _contentDisposition?;
    get contentDisposition(): string;
    set contentDisposition(value: string);
    resetContentDisposition(): void;
    get contentDispositionInput(): string | undefined;
    private _contentEncoding?;
    get contentEncoding(): string;
    set contentEncoding(value: string);
    resetContentEncoding(): void;
    get contentEncodingInput(): string | undefined;
    private _contentLanguage?;
    get contentLanguage(): string;
    set contentLanguage(value: string);
    resetContentLanguage(): void;
    get contentLanguageInput(): string | undefined;
    private _contentType?;
    get contentType(): string;
    set contentType(value: string);
    resetContentType(): void;
    get contentTypeInput(): string | undefined;
    get crc32C(): string;
    private _detectMd5Hash?;
    get detectMd5Hash(): string;
    set detectMd5Hash(value: string);
    resetDetectMd5Hash(): void;
    get detectMd5HashInput(): string | undefined;
    private _eventBasedHold?;
    get eventBasedHold(): boolean | cdktf.IResolvable;
    set eventBasedHold(value: boolean | cdktf.IResolvable);
    resetEventBasedHold(): void;
    get eventBasedHoldInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    resetKmsKeyName(): void;
    get kmsKeyNameInput(): string | undefined;
    get md5Hash(): string;
    get mediaLink(): string;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get outputName(): string;
    get selfLink(): string;
    private _source?;
    get source(): string;
    set source(value: string);
    resetSource(): void;
    get sourceInput(): string | undefined;
    private _storageClass?;
    get storageClass(): string;
    set storageClass(value: string);
    resetStorageClass(): void;
    get storageClassInput(): string | undefined;
    private _temporaryHold?;
    get temporaryHold(): boolean | cdktf.IResolvable;
    set temporaryHold(value: boolean | cdktf.IResolvable);
    resetTemporaryHold(): void;
    get temporaryHoldInput(): boolean | cdktf.IResolvable | undefined;
    private _customerEncryption;
    get customerEncryption(): GoogleStorageBucketObjectCustomerEncryptionOutputReference;
    putCustomerEncryption(value: GoogleStorageBucketObjectCustomerEncryption): void;
    resetCustomerEncryption(): void;
    get customerEncryptionInput(): GoogleStorageBucketObjectCustomerEncryption | undefined;
    private _timeouts;
    get timeouts(): GoogleStorageBucketObjectTimeoutsOutputReference;
    putTimeouts(value: GoogleStorageBucketObjectTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleStorageBucketObjectTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
