import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleStorageBucketConfig extends cdktf.TerraformMetaArguments {
    /**
    * Whether or not to automatically apply an eventBasedHold to new objects added to the bucket.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#default_event_based_hold GoogleStorageBucket#default_event_based_hold}
    */
    readonly defaultEventBasedHold?: boolean | cdktf.IResolvable;
    /**
    * When deleting a bucket, this boolean option will delete all contained objects. If you try to delete a bucket that contains objects, Terraform will fail that run.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#force_destroy GoogleStorageBucket#force_destroy}
    */
    readonly forceDestroy?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#id GoogleStorageBucket#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A set of key/value label pairs to assign to the bucket.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#labels GoogleStorageBucket#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The Google Cloud Storage location
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#location GoogleStorageBucket#location}
    */
    readonly location: string;
    /**
    * The name of the bucket.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#name GoogleStorageBucket#name}
    */
    readonly name: string;
    /**
    * The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#project GoogleStorageBucket#project}
    */
    readonly project?: string;
    /**
    * Prevents public access to a bucket.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#public_access_prevention GoogleStorageBucket#public_access_prevention}
    */
    readonly publicAccessPrevention?: string;
    /**
    * Enables Requester Pays on a storage bucket.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#requester_pays GoogleStorageBucket#requester_pays}
    */
    readonly requesterPays?: boolean | cdktf.IResolvable;
    /**
    * The Storage Class of the new bucket. Supported values include: STANDARD, MULTI_REGIONAL, REGIONAL, NEARLINE, COLDLINE, ARCHIVE.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#storage_class GoogleStorageBucket#storage_class}
    */
    readonly storageClass?: string;
    /**
    * Enables uniform bucket-level access on a bucket.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#uniform_bucket_level_access GoogleStorageBucket#uniform_bucket_level_access}
    */
    readonly uniformBucketLevelAccess?: boolean | cdktf.IResolvable;
    /**
    * autoclass block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#autoclass GoogleStorageBucket#autoclass}
    */
    readonly autoclass?: GoogleStorageBucketAutoclass;
    /**
    * cors block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#cors GoogleStorageBucket#cors}
    */
    readonly cors?: GoogleStorageBucketCors[] | cdktf.IResolvable;
    /**
    * custom_placement_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#custom_placement_config GoogleStorageBucket#custom_placement_config}
    */
    readonly customPlacementConfig?: GoogleStorageBucketCustomPlacementConfig;
    /**
    * encryption block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#encryption GoogleStorageBucket#encryption}
    */
    readonly encryption?: GoogleStorageBucketEncryption;
    /**
    * lifecycle_rule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#lifecycle_rule GoogleStorageBucket#lifecycle_rule}
    */
    readonly lifecycleRule?: GoogleStorageBucketLifecycleRule[] | cdktf.IResolvable;
    /**
    * logging block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#logging GoogleStorageBucket#logging}
    */
    readonly logging?: GoogleStorageBucketLogging;
    /**
    * retention_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#retention_policy GoogleStorageBucket#retention_policy}
    */
    readonly retentionPolicy?: GoogleStorageBucketRetentionPolicy;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#timeouts GoogleStorageBucket#timeouts}
    */
    readonly timeouts?: GoogleStorageBucketTimeouts;
    /**
    * versioning block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#versioning GoogleStorageBucket#versioning}
    */
    readonly versioning?: GoogleStorageBucketVersioning;
    /**
    * website block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#website GoogleStorageBucket#website}
    */
    readonly website?: GoogleStorageBucketWebsite;
}
export interface GoogleStorageBucketAutoclass {
    /**
    * While set to true, autoclass automatically transitions objects in your bucket to appropriate storage classes based on each object's access pattern.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#enabled GoogleStorageBucket#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleStorageBucketAutoclassToTerraform(struct?: GoogleStorageBucketAutoclassOutputReference | GoogleStorageBucketAutoclass): any;
export declare class GoogleStorageBucketAutoclassOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleStorageBucketAutoclass | undefined;
    set internalValue(value: GoogleStorageBucketAutoclass | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleStorageBucketCors {
    /**
    * The value, in seconds, to return in the Access-Control-Max-Age header used in preflight responses.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#max_age_seconds GoogleStorageBucket#max_age_seconds}
    */
    readonly maxAgeSeconds?: number;
    /**
    * The list of HTTP methods on which to include CORS response headers, (GET, OPTIONS, POST, etc) Note: "*" is permitted in the list of methods, and means "any method".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#method GoogleStorageBucket#method}
    */
    readonly method?: string[];
    /**
    * The list of Origins eligible to receive CORS response headers. Note: "*" is permitted in the list of origins, and means "any Origin".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#origin GoogleStorageBucket#origin}
    */
    readonly origin?: string[];
    /**
    * The list of HTTP headers other than the simple response headers to give permission for the user-agent to share across domains.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#response_header GoogleStorageBucket#response_header}
    */
    readonly responseHeader?: string[];
}
export declare function googleStorageBucketCorsToTerraform(struct?: GoogleStorageBucketCors | cdktf.IResolvable): any;
export declare class GoogleStorageBucketCorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleStorageBucketCors | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleStorageBucketCors | cdktf.IResolvable | undefined);
    private _maxAgeSeconds?;
    get maxAgeSeconds(): number;
    set maxAgeSeconds(value: number);
    resetMaxAgeSeconds(): void;
    get maxAgeSecondsInput(): number | undefined;
    private _method?;
    get method(): string[];
    set method(value: string[]);
    resetMethod(): void;
    get methodInput(): string[] | undefined;
    private _origin?;
    get origin(): string[];
    set origin(value: string[]);
    resetOrigin(): void;
    get originInput(): string[] | undefined;
    private _responseHeader?;
    get responseHeader(): string[];
    set responseHeader(value: string[]);
    resetResponseHeader(): void;
    get responseHeaderInput(): string[] | undefined;
}
export declare class GoogleStorageBucketCorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleStorageBucketCors[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleStorageBucketCorsOutputReference;
}
export interface GoogleStorageBucketCustomPlacementConfig {
    /**
    * The list of individual regions that comprise a dual-region bucket. See the docs for a list of acceptable regions. Note: If any of the data_locations changes, it will recreate the bucket.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#data_locations GoogleStorageBucket#data_locations}
    */
    readonly dataLocations: string[];
}
export declare function googleStorageBucketCustomPlacementConfigToTerraform(struct?: GoogleStorageBucketCustomPlacementConfigOutputReference | GoogleStorageBucketCustomPlacementConfig): any;
export declare class GoogleStorageBucketCustomPlacementConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleStorageBucketCustomPlacementConfig | undefined;
    set internalValue(value: GoogleStorageBucketCustomPlacementConfig | undefined);
    private _dataLocations?;
    get dataLocations(): string[];
    set dataLocations(value: string[]);
    get dataLocationsInput(): string[] | undefined;
}
export interface GoogleStorageBucketEncryption {
    /**
    * A Cloud KMS key that will be used to encrypt objects inserted into this bucket, if no encryption method is specified. You must pay attention to whether the crypto key is available in the location that this bucket is created in. See the docs for more details.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#default_kms_key_name GoogleStorageBucket#default_kms_key_name}
    */
    readonly defaultKmsKeyName: string;
}
export declare function googleStorageBucketEncryptionToTerraform(struct?: GoogleStorageBucketEncryptionOutputReference | GoogleStorageBucketEncryption): any;
export declare class GoogleStorageBucketEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleStorageBucketEncryption | undefined;
    set internalValue(value: GoogleStorageBucketEncryption | undefined);
    private _defaultKmsKeyName?;
    get defaultKmsKeyName(): string;
    set defaultKmsKeyName(value: string);
    get defaultKmsKeyNameInput(): string | undefined;
}
export interface GoogleStorageBucketLifecycleRuleAction {
    /**
    * The target Storage Class of objects affected by this Lifecycle Rule. Supported values include: MULTI_REGIONAL, REGIONAL, NEARLINE, COLDLINE, ARCHIVE.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#storage_class GoogleStorageBucket#storage_class}
    */
    readonly storageClass?: string;
    /**
    * The type of the action of this Lifecycle Rule. Supported values include: Delete, SetStorageClass and AbortIncompleteMultipartUpload.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#type GoogleStorageBucket#type}
    */
    readonly type: string;
}
export declare function googleStorageBucketLifecycleRuleActionToTerraform(struct?: GoogleStorageBucketLifecycleRuleActionOutputReference | GoogleStorageBucketLifecycleRuleAction): any;
export declare class GoogleStorageBucketLifecycleRuleActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleStorageBucketLifecycleRuleAction | undefined;
    set internalValue(value: GoogleStorageBucketLifecycleRuleAction | undefined);
    private _storageClass?;
    get storageClass(): string;
    set storageClass(value: string);
    resetStorageClass(): void;
    get storageClassInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface GoogleStorageBucketLifecycleRuleCondition {
    /**
    * Minimum age of an object in days to satisfy this condition.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#age GoogleStorageBucket#age}
    */
    readonly age?: number;
    /**
    * Creation date of an object in RFC 3339 (e.g. 2017-06-13) to satisfy this condition.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#created_before GoogleStorageBucket#created_before}
    */
    readonly createdBefore?: string;
    /**
    * Creation date of an object in RFC 3339 (e.g. 2017-06-13) to satisfy this condition.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#custom_time_before GoogleStorageBucket#custom_time_before}
    */
    readonly customTimeBefore?: string;
    /**
    * Number of days elapsed since the user-specified timestamp set on an object.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#days_since_custom_time GoogleStorageBucket#days_since_custom_time}
    */
    readonly daysSinceCustomTime?: number;
    /**
    * Number of days elapsed since the noncurrent timestamp of an object. This
                                          condition is relevant only for versioned objects.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#days_since_noncurrent_time GoogleStorageBucket#days_since_noncurrent_time}
    */
    readonly daysSinceNoncurrentTime?: number;
    /**
    * One or more matching name prefixes to satisfy this condition.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#matches_prefix GoogleStorageBucket#matches_prefix}
    */
    readonly matchesPrefix?: string[];
    /**
    * Storage Class of objects to satisfy this condition. Supported values include: MULTI_REGIONAL, REGIONAL, NEARLINE, COLDLINE, ARCHIVE, STANDARD, DURABLE_REDUCED_AVAILABILITY.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#matches_storage_class GoogleStorageBucket#matches_storage_class}
    */
    readonly matchesStorageClass?: string[];
    /**
    * One or more matching name suffixes to satisfy this condition.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#matches_suffix GoogleStorageBucket#matches_suffix}
    */
    readonly matchesSuffix?: string[];
    /**
    * Creation date of an object in RFC 3339 (e.g. 2017-06-13) to satisfy this condition.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#noncurrent_time_before GoogleStorageBucket#noncurrent_time_before}
    */
    readonly noncurrentTimeBefore?: string;
    /**
    * Relevant only for versioned objects. The number of newer versions of an object to satisfy this condition.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#num_newer_versions GoogleStorageBucket#num_newer_versions}
    */
    readonly numNewerVersions?: number;
    /**
    * Match to live and/or archived objects. Unversioned buckets have only live objects. Supported values include: "LIVE", "ARCHIVED", "ANY".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#with_state GoogleStorageBucket#with_state}
    */
    readonly withState?: string;
}
export declare function googleStorageBucketLifecycleRuleConditionToTerraform(struct?: GoogleStorageBucketLifecycleRuleConditionOutputReference | GoogleStorageBucketLifecycleRuleCondition): any;
export declare class GoogleStorageBucketLifecycleRuleConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleStorageBucketLifecycleRuleCondition | undefined;
    set internalValue(value: GoogleStorageBucketLifecycleRuleCondition | undefined);
    private _age?;
    get age(): number;
    set age(value: number);
    resetAge(): void;
    get ageInput(): number | undefined;
    private _createdBefore?;
    get createdBefore(): string;
    set createdBefore(value: string);
    resetCreatedBefore(): void;
    get createdBeforeInput(): string | undefined;
    private _customTimeBefore?;
    get customTimeBefore(): string;
    set customTimeBefore(value: string);
    resetCustomTimeBefore(): void;
    get customTimeBeforeInput(): string | undefined;
    private _daysSinceCustomTime?;
    get daysSinceCustomTime(): number;
    set daysSinceCustomTime(value: number);
    resetDaysSinceCustomTime(): void;
    get daysSinceCustomTimeInput(): number | undefined;
    private _daysSinceNoncurrentTime?;
    get daysSinceNoncurrentTime(): number;
    set daysSinceNoncurrentTime(value: number);
    resetDaysSinceNoncurrentTime(): void;
    get daysSinceNoncurrentTimeInput(): number | undefined;
    private _matchesPrefix?;
    get matchesPrefix(): string[];
    set matchesPrefix(value: string[]);
    resetMatchesPrefix(): void;
    get matchesPrefixInput(): string[] | undefined;
    private _matchesStorageClass?;
    get matchesStorageClass(): string[];
    set matchesStorageClass(value: string[]);
    resetMatchesStorageClass(): void;
    get matchesStorageClassInput(): string[] | undefined;
    private _matchesSuffix?;
    get matchesSuffix(): string[];
    set matchesSuffix(value: string[]);
    resetMatchesSuffix(): void;
    get matchesSuffixInput(): string[] | undefined;
    private _noncurrentTimeBefore?;
    get noncurrentTimeBefore(): string;
    set noncurrentTimeBefore(value: string);
    resetNoncurrentTimeBefore(): void;
    get noncurrentTimeBeforeInput(): string | undefined;
    private _numNewerVersions?;
    get numNewerVersions(): number;
    set numNewerVersions(value: number);
    resetNumNewerVersions(): void;
    get numNewerVersionsInput(): number | undefined;
    private _withState?;
    get withState(): string;
    set withState(value: string);
    resetWithState(): void;
    get withStateInput(): string | undefined;
}
export interface GoogleStorageBucketLifecycleRule {
    /**
    * action block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#action GoogleStorageBucket#action}
    */
    readonly action: GoogleStorageBucketLifecycleRuleAction;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#condition GoogleStorageBucket#condition}
    */
    readonly condition: GoogleStorageBucketLifecycleRuleCondition;
}
export declare function googleStorageBucketLifecycleRuleToTerraform(struct?: GoogleStorageBucketLifecycleRule | cdktf.IResolvable): any;
export declare class GoogleStorageBucketLifecycleRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleStorageBucketLifecycleRule | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleStorageBucketLifecycleRule | cdktf.IResolvable | undefined);
    private _action;
    get action(): GoogleStorageBucketLifecycleRuleActionOutputReference;
    putAction(value: GoogleStorageBucketLifecycleRuleAction): void;
    get actionInput(): GoogleStorageBucketLifecycleRuleAction | undefined;
    private _condition;
    get condition(): GoogleStorageBucketLifecycleRuleConditionOutputReference;
    putCondition(value: GoogleStorageBucketLifecycleRuleCondition): void;
    get conditionInput(): GoogleStorageBucketLifecycleRuleCondition | undefined;
}
export declare class GoogleStorageBucketLifecycleRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleStorageBucketLifecycleRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleStorageBucketLifecycleRuleOutputReference;
}
export interface GoogleStorageBucketLogging {
    /**
    * The bucket that will receive log objects.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#log_bucket GoogleStorageBucket#log_bucket}
    */
    readonly logBucket: string;
    /**
    * The object prefix for log objects. If it's not provided, by default Google Cloud Storage sets this to this bucket's name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#log_object_prefix GoogleStorageBucket#log_object_prefix}
    */
    readonly logObjectPrefix?: string;
}
export declare function googleStorageBucketLoggingToTerraform(struct?: GoogleStorageBucketLoggingOutputReference | GoogleStorageBucketLogging): any;
export declare class GoogleStorageBucketLoggingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleStorageBucketLogging | undefined;
    set internalValue(value: GoogleStorageBucketLogging | undefined);
    private _logBucket?;
    get logBucket(): string;
    set logBucket(value: string);
    get logBucketInput(): string | undefined;
    private _logObjectPrefix?;
    get logObjectPrefix(): string;
    set logObjectPrefix(value: string);
    resetLogObjectPrefix(): void;
    get logObjectPrefixInput(): string | undefined;
}
export interface GoogleStorageBucketRetentionPolicy {
    /**
    * If set to true, the bucket will be locked and permanently restrict edits to the bucket's retention policy.  Caution: Locking a bucket is an irreversible action.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#is_locked GoogleStorageBucket#is_locked}
    */
    readonly isLocked?: boolean | cdktf.IResolvable;
    /**
    * The period of time, in seconds, that objects in the bucket must be retained and cannot be deleted, overwritten, or archived. The value must be less than 3,155,760,000 seconds.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#retention_period GoogleStorageBucket#retention_period}
    */
    readonly retentionPeriod: number;
}
export declare function googleStorageBucketRetentionPolicyToTerraform(struct?: GoogleStorageBucketRetentionPolicyOutputReference | GoogleStorageBucketRetentionPolicy): any;
export declare class GoogleStorageBucketRetentionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleStorageBucketRetentionPolicy | undefined;
    set internalValue(value: GoogleStorageBucketRetentionPolicy | undefined);
    private _isLocked?;
    get isLocked(): boolean | cdktf.IResolvable;
    set isLocked(value: boolean | cdktf.IResolvable);
    resetIsLocked(): void;
    get isLockedInput(): boolean | cdktf.IResolvable | undefined;
    private _retentionPeriod?;
    get retentionPeriod(): number;
    set retentionPeriod(value: number);
    get retentionPeriodInput(): number | undefined;
}
export interface GoogleStorageBucketTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#create GoogleStorageBucket#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#read GoogleStorageBucket#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#update GoogleStorageBucket#update}
    */
    readonly update?: string;
}
export declare function googleStorageBucketTimeoutsToTerraform(struct?: GoogleStorageBucketTimeouts | cdktf.IResolvable): any;
export declare class GoogleStorageBucketTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleStorageBucketTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleStorageBucketTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface GoogleStorageBucketVersioning {
    /**
    * While set to true, versioning is fully enabled for this bucket.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#enabled GoogleStorageBucket#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function googleStorageBucketVersioningToTerraform(struct?: GoogleStorageBucketVersioningOutputReference | GoogleStorageBucketVersioning): any;
export declare class GoogleStorageBucketVersioningOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleStorageBucketVersioning | undefined;
    set internalValue(value: GoogleStorageBucketVersioning | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleStorageBucketWebsite {
    /**
    * Behaves as the bucket's directory index where missing objects are treated as potential directories.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#main_page_suffix GoogleStorageBucket#main_page_suffix}
    */
    readonly mainPageSuffix?: string;
    /**
    * The custom object to return when a requested resource is not found.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket#not_found_page GoogleStorageBucket#not_found_page}
    */
    readonly notFoundPage?: string;
}
export declare function googleStorageBucketWebsiteToTerraform(struct?: GoogleStorageBucketWebsiteOutputReference | GoogleStorageBucketWebsite): any;
export declare class GoogleStorageBucketWebsiteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleStorageBucketWebsite | undefined;
    set internalValue(value: GoogleStorageBucketWebsite | undefined);
    private _mainPageSuffix?;
    get mainPageSuffix(): string;
    set mainPageSuffix(value: string);
    resetMainPageSuffix(): void;
    get mainPageSuffixInput(): string | undefined;
    private _notFoundPage?;
    get notFoundPage(): string;
    set notFoundPage(value: string);
    resetNotFoundPage(): void;
    get notFoundPageInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket google_storage_bucket}
*/
export declare class GoogleStorageBucket extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_storage_bucket";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_bucket google_storage_bucket} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleStorageBucketConfig
    */
    constructor(scope: Construct, id: string, config: GoogleStorageBucketConfig);
    private _defaultEventBasedHold?;
    get defaultEventBasedHold(): boolean | cdktf.IResolvable;
    set defaultEventBasedHold(value: boolean | cdktf.IResolvable);
    resetDefaultEventBasedHold(): void;
    get defaultEventBasedHoldInput(): boolean | cdktf.IResolvable | undefined;
    private _forceDestroy?;
    get forceDestroy(): boolean | cdktf.IResolvable;
    set forceDestroy(value: boolean | cdktf.IResolvable);
    resetForceDestroy(): void;
    get forceDestroyInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _publicAccessPrevention?;
    get publicAccessPrevention(): string;
    set publicAccessPrevention(value: string);
    resetPublicAccessPrevention(): void;
    get publicAccessPreventionInput(): string | undefined;
    private _requesterPays?;
    get requesterPays(): boolean | cdktf.IResolvable;
    set requesterPays(value: boolean | cdktf.IResolvable);
    resetRequesterPays(): void;
    get requesterPaysInput(): boolean | cdktf.IResolvable | undefined;
    get selfLink(): string;
    private _storageClass?;
    get storageClass(): string;
    set storageClass(value: string);
    resetStorageClass(): void;
    get storageClassInput(): string | undefined;
    private _uniformBucketLevelAccess?;
    get uniformBucketLevelAccess(): boolean | cdktf.IResolvable;
    set uniformBucketLevelAccess(value: boolean | cdktf.IResolvable);
    resetUniformBucketLevelAccess(): void;
    get uniformBucketLevelAccessInput(): boolean | cdktf.IResolvable | undefined;
    get url(): string;
    private _autoclass;
    get autoclass(): GoogleStorageBucketAutoclassOutputReference;
    putAutoclass(value: GoogleStorageBucketAutoclass): void;
    resetAutoclass(): void;
    get autoclassInput(): GoogleStorageBucketAutoclass | undefined;
    private _cors;
    get cors(): GoogleStorageBucketCorsList;
    putCors(value: GoogleStorageBucketCors[] | cdktf.IResolvable): void;
    resetCors(): void;
    get corsInput(): cdktf.IResolvable | GoogleStorageBucketCors[] | undefined;
    private _customPlacementConfig;
    get customPlacementConfig(): GoogleStorageBucketCustomPlacementConfigOutputReference;
    putCustomPlacementConfig(value: GoogleStorageBucketCustomPlacementConfig): void;
    resetCustomPlacementConfig(): void;
    get customPlacementConfigInput(): GoogleStorageBucketCustomPlacementConfig | undefined;
    private _encryption;
    get encryption(): GoogleStorageBucketEncryptionOutputReference;
    putEncryption(value: GoogleStorageBucketEncryption): void;
    resetEncryption(): void;
    get encryptionInput(): GoogleStorageBucketEncryption | undefined;
    private _lifecycleRule;
    get lifecycleRule(): GoogleStorageBucketLifecycleRuleList;
    putLifecycleRule(value: GoogleStorageBucketLifecycleRule[] | cdktf.IResolvable): void;
    resetLifecycleRule(): void;
    get lifecycleRuleInput(): cdktf.IResolvable | GoogleStorageBucketLifecycleRule[] | undefined;
    private _logging;
    get logging(): GoogleStorageBucketLoggingOutputReference;
    putLogging(value: GoogleStorageBucketLogging): void;
    resetLogging(): void;
    get loggingInput(): GoogleStorageBucketLogging | undefined;
    private _retentionPolicy;
    get retentionPolicy(): GoogleStorageBucketRetentionPolicyOutputReference;
    putRetentionPolicy(value: GoogleStorageBucketRetentionPolicy): void;
    resetRetentionPolicy(): void;
    get retentionPolicyInput(): GoogleStorageBucketRetentionPolicy | undefined;
    private _timeouts;
    get timeouts(): GoogleStorageBucketTimeoutsOutputReference;
    putTimeouts(value: GoogleStorageBucketTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleStorageBucketTimeouts | undefined;
    private _versioning;
    get versioning(): GoogleStorageBucketVersioningOutputReference;
    putVersioning(value: GoogleStorageBucketVersioning): void;
    resetVersioning(): void;
    get versioningInput(): GoogleStorageBucketVersioning | undefined;
    private _website;
    get website(): GoogleStorageBucketWebsiteOutputReference;
    putWebsite(value: GoogleStorageBucketWebsite): void;
    resetWebsite(): void;
    get websiteInput(): GoogleStorageBucketWebsite | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
