import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleStorageTransferAgentPoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies the client-specified AgentPool description.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_agent_pool#display_name GoogleStorageTransferAgentPool#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_agent_pool#id GoogleStorageTransferAgentPool#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The ID of the agent pool to create.
  
  The agentPoolId must meet the following requirements:
  * Length of 128 characters or less.
  * Not start with the string goog.
  * Start with a lowercase ASCII character, followed by:
    * Zero or more: lowercase Latin alphabet characters, numerals, hyphens (-), periods (.), underscores (_), or tildes (~).
    * One or more numerals or lowercase ASCII characters.
  
  As expressed by the regular expression: ^(?!goog)[a-z]([a-z0-9-._~]*[a-z0-9])?$.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_agent_pool#name GoogleStorageTransferAgentPool#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_agent_pool#project GoogleStorageTransferAgentPool#project}
    */
    readonly project?: string;
    /**
    * bandwidth_limit block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_agent_pool#bandwidth_limit GoogleStorageTransferAgentPool#bandwidth_limit}
    */
    readonly bandwidthLimit?: GoogleStorageTransferAgentPoolBandwidthLimit;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_agent_pool#timeouts GoogleStorageTransferAgentPool#timeouts}
    */
    readonly timeouts?: GoogleStorageTransferAgentPoolTimeouts;
}
export interface GoogleStorageTransferAgentPoolBandwidthLimit {
    /**
    * Bandwidth rate in megabytes per second, distributed across all the agents in the pool.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_agent_pool#limit_mbps GoogleStorageTransferAgentPool#limit_mbps}
    */
    readonly limitMbps: string;
}
export declare function googleStorageTransferAgentPoolBandwidthLimitToTerraform(struct?: GoogleStorageTransferAgentPoolBandwidthLimitOutputReference | GoogleStorageTransferAgentPoolBandwidthLimit): any;
export declare class GoogleStorageTransferAgentPoolBandwidthLimitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleStorageTransferAgentPoolBandwidthLimit | undefined;
    set internalValue(value: GoogleStorageTransferAgentPoolBandwidthLimit | undefined);
    private _limitMbps?;
    get limitMbps(): string;
    set limitMbps(value: string);
    get limitMbpsInput(): string | undefined;
}
export interface GoogleStorageTransferAgentPoolTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_agent_pool#create GoogleStorageTransferAgentPool#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_agent_pool#delete GoogleStorageTransferAgentPool#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_agent_pool#update GoogleStorageTransferAgentPool#update}
    */
    readonly update?: string;
}
export declare function googleStorageTransferAgentPoolTimeoutsToTerraform(struct?: GoogleStorageTransferAgentPoolTimeouts | cdktf.IResolvable): any;
export declare class GoogleStorageTransferAgentPoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleStorageTransferAgentPoolTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleStorageTransferAgentPoolTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_agent_pool google_storage_transfer_agent_pool}
*/
export declare class GoogleStorageTransferAgentPool extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_storage_transfer_agent_pool";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_agent_pool google_storage_transfer_agent_pool} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleStorageTransferAgentPoolConfig
    */
    constructor(scope: Construct, id: string, config: GoogleStorageTransferAgentPoolConfig);
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get state(): string;
    private _bandwidthLimit;
    get bandwidthLimit(): GoogleStorageTransferAgentPoolBandwidthLimitOutputReference;
    putBandwidthLimit(value: GoogleStorageTransferAgentPoolBandwidthLimit): void;
    resetBandwidthLimit(): void;
    get bandwidthLimitInput(): GoogleStorageTransferAgentPoolBandwidthLimit | undefined;
    private _timeouts;
    get timeouts(): GoogleStorageTransferAgentPoolTimeoutsOutputReference;
    putTimeouts(value: GoogleStorageTransferAgentPoolTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleStorageTransferAgentPoolTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
