import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleStorageTransferJobConfig extends cdktf.TerraformMetaArguments {
    /**
    * Unique description to identify the Transfer Job.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#description GoogleStorageTransferJob#description}
    */
    readonly description: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#id GoogleStorageTransferJob#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#project GoogleStorageTransferJob#project}
    */
    readonly project?: string;
    /**
    * Status of the job. Default: ENABLED. NOTE: The effect of the new job status takes place during a subsequent job run. For example, if you change the job status from ENABLED to DISABLED, and an operation spawned by the transfer is running, the status change would not affect the current operation.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#status GoogleStorageTransferJob#status}
    */
    readonly status?: string;
    /**
    * notification_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#notification_config GoogleStorageTransferJob#notification_config}
    */
    readonly notificationConfig?: GoogleStorageTransferJobNotificationConfig;
    /**
    * schedule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#schedule GoogleStorageTransferJob#schedule}
    */
    readonly schedule?: GoogleStorageTransferJobSchedule;
    /**
    * transfer_spec block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#transfer_spec GoogleStorageTransferJob#transfer_spec}
    */
    readonly transferSpec: GoogleStorageTransferJobTransferSpec;
}
export interface GoogleStorageTransferJobNotificationConfig {
    /**
    * Event types for which a notification is desired. If empty, send notifications for all event types. The valid types are "TRANSFER_OPERATION_SUCCESS", "TRANSFER_OPERATION_FAILED", "TRANSFER_OPERATION_ABORTED".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#event_types GoogleStorageTransferJob#event_types}
    */
    readonly eventTypes?: string[];
    /**
    * The desired format of the notification message payloads. One of "NONE" or "JSON".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#payload_format GoogleStorageTransferJob#payload_format}
    */
    readonly payloadFormat: string;
    /**
    * The Topic.name of the Pub/Sub topic to which to publish notifications.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#pubsub_topic GoogleStorageTransferJob#pubsub_topic}
    */
    readonly pubsubTopic: string;
}
export declare function googleStorageTransferJobNotificationConfigToTerraform(struct?: GoogleStorageTransferJobNotificationConfigOutputReference | GoogleStorageTransferJobNotificationConfig): any;
export declare class GoogleStorageTransferJobNotificationConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleStorageTransferJobNotificationConfig | undefined;
    set internalValue(value: GoogleStorageTransferJobNotificationConfig | undefined);
    private _eventTypes?;
    get eventTypes(): string[];
    set eventTypes(value: string[]);
    resetEventTypes(): void;
    get eventTypesInput(): string[] | undefined;
    private _payloadFormat?;
    get payloadFormat(): string;
    set payloadFormat(value: string);
    get payloadFormatInput(): string | undefined;
    private _pubsubTopic?;
    get pubsubTopic(): string;
    set pubsubTopic(value: string);
    get pubsubTopicInput(): string | undefined;
}
export interface GoogleStorageTransferJobScheduleScheduleEndDate {
    /**
    * Day of month. Must be from 1 to 31 and valid for the year and month.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#day GoogleStorageTransferJob#day}
    */
    readonly day: number;
    /**
    * Month of year. Must be from 1 to 12.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#month GoogleStorageTransferJob#month}
    */
    readonly month: number;
    /**
    * Year of date. Must be from 1 to 9999.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#year GoogleStorageTransferJob#year}
    */
    readonly year: number;
}
export declare function googleStorageTransferJobScheduleScheduleEndDateToTerraform(struct?: GoogleStorageTransferJobScheduleScheduleEndDateOutputReference | GoogleStorageTransferJobScheduleScheduleEndDate): any;
export declare class GoogleStorageTransferJobScheduleScheduleEndDateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleStorageTransferJobScheduleScheduleEndDate | undefined;
    set internalValue(value: GoogleStorageTransferJobScheduleScheduleEndDate | undefined);
    private _day?;
    get day(): number;
    set day(value: number);
    get dayInput(): number | undefined;
    private _month?;
    get month(): number;
    set month(value: number);
    get monthInput(): number | undefined;
    private _year?;
    get year(): number;
    set year(value: number);
    get yearInput(): number | undefined;
}
export interface GoogleStorageTransferJobScheduleScheduleStartDate {
    /**
    * Day of month. Must be from 1 to 31 and valid for the year and month.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#day GoogleStorageTransferJob#day}
    */
    readonly day: number;
    /**
    * Month of year. Must be from 1 to 12.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#month GoogleStorageTransferJob#month}
    */
    readonly month: number;
    /**
    * Year of date. Must be from 1 to 9999.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#year GoogleStorageTransferJob#year}
    */
    readonly year: number;
}
export declare function googleStorageTransferJobScheduleScheduleStartDateToTerraform(struct?: GoogleStorageTransferJobScheduleScheduleStartDateOutputReference | GoogleStorageTransferJobScheduleScheduleStartDate): any;
export declare class GoogleStorageTransferJobScheduleScheduleStartDateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleStorageTransferJobScheduleScheduleStartDate | undefined;
    set internalValue(value: GoogleStorageTransferJobScheduleScheduleStartDate | undefined);
    private _day?;
    get day(): number;
    set day(value: number);
    get dayInput(): number | undefined;
    private _month?;
    get month(): number;
    set month(value: number);
    get monthInput(): number | undefined;
    private _year?;
    get year(): number;
    set year(value: number);
    get yearInput(): number | undefined;
}
export interface GoogleStorageTransferJobScheduleStartTimeOfDay {
    /**
    * Hours of day in 24 hour format. Should be from 0 to 23.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#hours GoogleStorageTransferJob#hours}
    */
    readonly hours: number;
    /**
    * Minutes of hour of day. Must be from 0 to 59.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#minutes GoogleStorageTransferJob#minutes}
    */
    readonly minutes: number;
    /**
    * Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#nanos GoogleStorageTransferJob#nanos}
    */
    readonly nanos: number;
    /**
    * Seconds of minutes of the time. Must normally be from 0 to 59.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#seconds GoogleStorageTransferJob#seconds}
    */
    readonly seconds: number;
}
export declare function googleStorageTransferJobScheduleStartTimeOfDayToTerraform(struct?: GoogleStorageTransferJobScheduleStartTimeOfDayOutputReference | GoogleStorageTransferJobScheduleStartTimeOfDay): any;
export declare class GoogleStorageTransferJobScheduleStartTimeOfDayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleStorageTransferJobScheduleStartTimeOfDay | undefined;
    set internalValue(value: GoogleStorageTransferJobScheduleStartTimeOfDay | undefined);
    private _hours?;
    get hours(): number;
    set hours(value: number);
    get hoursInput(): number | undefined;
    private _minutes?;
    get minutes(): number;
    set minutes(value: number);
    get minutesInput(): number | undefined;
    private _nanos?;
    get nanos(): number;
    set nanos(value: number);
    get nanosInput(): number | undefined;
    private _seconds?;
    get seconds(): number;
    set seconds(value: number);
    get secondsInput(): number | undefined;
}
export interface GoogleStorageTransferJobSchedule {
    /**
    * Interval between the start of each scheduled transfer. If unspecified, the default value is 24 hours. This value may not be less than 1 hour. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#repeat_interval GoogleStorageTransferJob#repeat_interval}
    */
    readonly repeatInterval?: string;
    /**
    * schedule_end_date block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#schedule_end_date GoogleStorageTransferJob#schedule_end_date}
    */
    readonly scheduleEndDate?: GoogleStorageTransferJobScheduleScheduleEndDate;
    /**
    * schedule_start_date block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#schedule_start_date GoogleStorageTransferJob#schedule_start_date}
    */
    readonly scheduleStartDate: GoogleStorageTransferJobScheduleScheduleStartDate;
    /**
    * start_time_of_day block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#start_time_of_day GoogleStorageTransferJob#start_time_of_day}
    */
    readonly startTimeOfDay?: GoogleStorageTransferJobScheduleStartTimeOfDay;
}
export declare function googleStorageTransferJobScheduleToTerraform(struct?: GoogleStorageTransferJobScheduleOutputReference | GoogleStorageTransferJobSchedule): any;
export declare class GoogleStorageTransferJobScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleStorageTransferJobSchedule | undefined;
    set internalValue(value: GoogleStorageTransferJobSchedule | undefined);
    private _repeatInterval?;
    get repeatInterval(): string;
    set repeatInterval(value: string);
    resetRepeatInterval(): void;
    get repeatIntervalInput(): string | undefined;
    private _scheduleEndDate;
    get scheduleEndDate(): GoogleStorageTransferJobScheduleScheduleEndDateOutputReference;
    putScheduleEndDate(value: GoogleStorageTransferJobScheduleScheduleEndDate): void;
    resetScheduleEndDate(): void;
    get scheduleEndDateInput(): GoogleStorageTransferJobScheduleScheduleEndDate | undefined;
    private _scheduleStartDate;
    get scheduleStartDate(): GoogleStorageTransferJobScheduleScheduleStartDateOutputReference;
    putScheduleStartDate(value: GoogleStorageTransferJobScheduleScheduleStartDate): void;
    get scheduleStartDateInput(): GoogleStorageTransferJobScheduleScheduleStartDate | undefined;
    private _startTimeOfDay;
    get startTimeOfDay(): GoogleStorageTransferJobScheduleStartTimeOfDayOutputReference;
    putStartTimeOfDay(value: GoogleStorageTransferJobScheduleStartTimeOfDay): void;
    resetStartTimeOfDay(): void;
    get startTimeOfDayInput(): GoogleStorageTransferJobScheduleStartTimeOfDay | undefined;
}
export interface GoogleStorageTransferJobTransferSpecAwsS3DataSourceAwsAccessKey {
    /**
    * AWS Key ID.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#access_key_id GoogleStorageTransferJob#access_key_id}
    */
    readonly accessKeyId: string;
    /**
    * AWS Secret Access Key.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#secret_access_key GoogleStorageTransferJob#secret_access_key}
    */
    readonly secretAccessKey: string;
}
export declare function googleStorageTransferJobTransferSpecAwsS3DataSourceAwsAccessKeyToTerraform(struct?: GoogleStorageTransferJobTransferSpecAwsS3DataSourceAwsAccessKeyOutputReference | GoogleStorageTransferJobTransferSpecAwsS3DataSourceAwsAccessKey): any;
export declare class GoogleStorageTransferJobTransferSpecAwsS3DataSourceAwsAccessKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleStorageTransferJobTransferSpecAwsS3DataSourceAwsAccessKey | undefined;
    set internalValue(value: GoogleStorageTransferJobTransferSpecAwsS3DataSourceAwsAccessKey | undefined);
    private _accessKeyId?;
    get accessKeyId(): string;
    set accessKeyId(value: string);
    get accessKeyIdInput(): string | undefined;
    private _secretAccessKey?;
    get secretAccessKey(): string;
    set secretAccessKey(value: string);
    get secretAccessKeyInput(): string | undefined;
}
export interface GoogleStorageTransferJobTransferSpecAwsS3DataSource {
    /**
    * S3 Bucket name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#bucket_name GoogleStorageTransferJob#bucket_name}
    */
    readonly bucketName: string;
    /**
    * The Amazon Resource Name (ARN) of the role to support temporary credentials via 'AssumeRoleWithWebIdentity'. For more information about ARNs, see [IAM ARNs](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns). When a role ARN is provided, Transfer Service fetches temporary credentials for the session using a 'AssumeRoleWithWebIdentity' call for the provided role using the [GoogleServiceAccount][] for this project.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#role_arn GoogleStorageTransferJob#role_arn}
    */
    readonly roleArn?: string;
    /**
    * aws_access_key block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#aws_access_key GoogleStorageTransferJob#aws_access_key}
    */
    readonly awsAccessKey?: GoogleStorageTransferJobTransferSpecAwsS3DataSourceAwsAccessKey;
}
export declare function googleStorageTransferJobTransferSpecAwsS3DataSourceToTerraform(struct?: GoogleStorageTransferJobTransferSpecAwsS3DataSourceOutputReference | GoogleStorageTransferJobTransferSpecAwsS3DataSource): any;
export declare class GoogleStorageTransferJobTransferSpecAwsS3DataSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleStorageTransferJobTransferSpecAwsS3DataSource | undefined;
    set internalValue(value: GoogleStorageTransferJobTransferSpecAwsS3DataSource | undefined);
    private _bucketName?;
    get bucketName(): string;
    set bucketName(value: string);
    get bucketNameInput(): string | undefined;
    private _roleArn?;
    get roleArn(): string;
    set roleArn(value: string);
    resetRoleArn(): void;
    get roleArnInput(): string | undefined;
    private _awsAccessKey;
    get awsAccessKey(): GoogleStorageTransferJobTransferSpecAwsS3DataSourceAwsAccessKeyOutputReference;
    putAwsAccessKey(value: GoogleStorageTransferJobTransferSpecAwsS3DataSourceAwsAccessKey): void;
    resetAwsAccessKey(): void;
    get awsAccessKeyInput(): GoogleStorageTransferJobTransferSpecAwsS3DataSourceAwsAccessKey | undefined;
}
export interface GoogleStorageTransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentials {
    /**
    * Azure shared access signature.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#sas_token GoogleStorageTransferJob#sas_token}
    */
    readonly sasToken: string;
}
export declare function googleStorageTransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentialsToTerraform(struct?: GoogleStorageTransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentialsOutputReference | GoogleStorageTransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentials): any;
export declare class GoogleStorageTransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentialsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleStorageTransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentials | undefined;
    set internalValue(value: GoogleStorageTransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentials | undefined);
    private _sasToken?;
    get sasToken(): string;
    set sasToken(value: string);
    get sasTokenInput(): string | undefined;
}
export interface GoogleStorageTransferJobTransferSpecAzureBlobStorageDataSource {
    /**
    * The container to transfer from the Azure Storage account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#container GoogleStorageTransferJob#container}
    */
    readonly container: string;
    /**
    * Root path to transfer objects. Must be an empty string or full path name that ends with a '/'. This field is treated as an object prefix. As such, it should generally not begin with a '/'.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#path GoogleStorageTransferJob#path}
    */
    readonly path?: string;
    /**
    * The name of the Azure Storage account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#storage_account GoogleStorageTransferJob#storage_account}
    */
    readonly storageAccount: string;
    /**
    * azure_credentials block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#azure_credentials GoogleStorageTransferJob#azure_credentials}
    */
    readonly azureCredentials: GoogleStorageTransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentials;
}
export declare function googleStorageTransferJobTransferSpecAzureBlobStorageDataSourceToTerraform(struct?: GoogleStorageTransferJobTransferSpecAzureBlobStorageDataSourceOutputReference | GoogleStorageTransferJobTransferSpecAzureBlobStorageDataSource): any;
export declare class GoogleStorageTransferJobTransferSpecAzureBlobStorageDataSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleStorageTransferJobTransferSpecAzureBlobStorageDataSource | undefined;
    set internalValue(value: GoogleStorageTransferJobTransferSpecAzureBlobStorageDataSource | undefined);
    private _container?;
    get container(): string;
    set container(value: string);
    get containerInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _storageAccount?;
    get storageAccount(): string;
    set storageAccount(value: string);
    get storageAccountInput(): string | undefined;
    private _azureCredentials;
    get azureCredentials(): GoogleStorageTransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentialsOutputReference;
    putAzureCredentials(value: GoogleStorageTransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentials): void;
    get azureCredentialsInput(): GoogleStorageTransferJobTransferSpecAzureBlobStorageDataSourceAzureCredentials | undefined;
}
export interface GoogleStorageTransferJobTransferSpecGcsDataSink {
    /**
    * Google Cloud Storage bucket name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#bucket_name GoogleStorageTransferJob#bucket_name}
    */
    readonly bucketName: string;
    /**
    * Google Cloud Storage path in bucket to transfer
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#path GoogleStorageTransferJob#path}
    */
    readonly path?: string;
}
export declare function googleStorageTransferJobTransferSpecGcsDataSinkToTerraform(struct?: GoogleStorageTransferJobTransferSpecGcsDataSinkOutputReference | GoogleStorageTransferJobTransferSpecGcsDataSink): any;
export declare class GoogleStorageTransferJobTransferSpecGcsDataSinkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleStorageTransferJobTransferSpecGcsDataSink | undefined;
    set internalValue(value: GoogleStorageTransferJobTransferSpecGcsDataSink | undefined);
    private _bucketName?;
    get bucketName(): string;
    set bucketName(value: string);
    get bucketNameInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
}
export interface GoogleStorageTransferJobTransferSpecGcsDataSource {
    /**
    * Google Cloud Storage bucket name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#bucket_name GoogleStorageTransferJob#bucket_name}
    */
    readonly bucketName: string;
    /**
    * Google Cloud Storage path in bucket to transfer
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#path GoogleStorageTransferJob#path}
    */
    readonly path?: string;
}
export declare function googleStorageTransferJobTransferSpecGcsDataSourceToTerraform(struct?: GoogleStorageTransferJobTransferSpecGcsDataSourceOutputReference | GoogleStorageTransferJobTransferSpecGcsDataSource): any;
export declare class GoogleStorageTransferJobTransferSpecGcsDataSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleStorageTransferJobTransferSpecGcsDataSource | undefined;
    set internalValue(value: GoogleStorageTransferJobTransferSpecGcsDataSource | undefined);
    private _bucketName?;
    get bucketName(): string;
    set bucketName(value: string);
    get bucketNameInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
}
export interface GoogleStorageTransferJobTransferSpecHttpDataSource {
    /**
    * The URL that points to the file that stores the object list entries. This file must allow public access. Currently, only URLs with HTTP and HTTPS schemes are supported.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#list_url GoogleStorageTransferJob#list_url}
    */
    readonly listUrl: string;
}
export declare function googleStorageTransferJobTransferSpecHttpDataSourceToTerraform(struct?: GoogleStorageTransferJobTransferSpecHttpDataSourceOutputReference | GoogleStorageTransferJobTransferSpecHttpDataSource): any;
export declare class GoogleStorageTransferJobTransferSpecHttpDataSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleStorageTransferJobTransferSpecHttpDataSource | undefined;
    set internalValue(value: GoogleStorageTransferJobTransferSpecHttpDataSource | undefined);
    private _listUrl?;
    get listUrl(): string;
    set listUrl(value: string);
    get listUrlInput(): string | undefined;
}
export interface GoogleStorageTransferJobTransferSpecObjectConditions {
    /**
    * exclude_prefixes must follow the requirements described for include_prefixes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#exclude_prefixes GoogleStorageTransferJob#exclude_prefixes}
    */
    readonly excludePrefixes?: string[];
    /**
    * If include_refixes is specified, objects that satisfy the object conditions must have names that start with one of the include_prefixes and that do not start with any of the exclude_prefixes. If include_prefixes is not specified, all objects except those that have names starting with one of the exclude_prefixes must satisfy the object conditions.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#include_prefixes GoogleStorageTransferJob#include_prefixes}
    */
    readonly includePrefixes?: string[];
    /**
    * If specified, only objects with a "last modification time" before this timestamp and objects that don't have a "last modification time" are transferred. A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#last_modified_before GoogleStorageTransferJob#last_modified_before}
    */
    readonly lastModifiedBefore?: string;
    /**
    * If specified, only objects with a "last modification time" on or after this timestamp and objects that don't have a "last modification time" are transferred. A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits. Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#last_modified_since GoogleStorageTransferJob#last_modified_since}
    */
    readonly lastModifiedSince?: string;
    /**
    * A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#max_time_elapsed_since_last_modification GoogleStorageTransferJob#max_time_elapsed_since_last_modification}
    */
    readonly maxTimeElapsedSinceLastModification?: string;
    /**
    * A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#min_time_elapsed_since_last_modification GoogleStorageTransferJob#min_time_elapsed_since_last_modification}
    */
    readonly minTimeElapsedSinceLastModification?: string;
}
export declare function googleStorageTransferJobTransferSpecObjectConditionsToTerraform(struct?: GoogleStorageTransferJobTransferSpecObjectConditionsOutputReference | GoogleStorageTransferJobTransferSpecObjectConditions): any;
export declare class GoogleStorageTransferJobTransferSpecObjectConditionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleStorageTransferJobTransferSpecObjectConditions | undefined;
    set internalValue(value: GoogleStorageTransferJobTransferSpecObjectConditions | undefined);
    private _excludePrefixes?;
    get excludePrefixes(): string[];
    set excludePrefixes(value: string[]);
    resetExcludePrefixes(): void;
    get excludePrefixesInput(): string[] | undefined;
    private _includePrefixes?;
    get includePrefixes(): string[];
    set includePrefixes(value: string[]);
    resetIncludePrefixes(): void;
    get includePrefixesInput(): string[] | undefined;
    private _lastModifiedBefore?;
    get lastModifiedBefore(): string;
    set lastModifiedBefore(value: string);
    resetLastModifiedBefore(): void;
    get lastModifiedBeforeInput(): string | undefined;
    private _lastModifiedSince?;
    get lastModifiedSince(): string;
    set lastModifiedSince(value: string);
    resetLastModifiedSince(): void;
    get lastModifiedSinceInput(): string | undefined;
    private _maxTimeElapsedSinceLastModification?;
    get maxTimeElapsedSinceLastModification(): string;
    set maxTimeElapsedSinceLastModification(value: string);
    resetMaxTimeElapsedSinceLastModification(): void;
    get maxTimeElapsedSinceLastModificationInput(): string | undefined;
    private _minTimeElapsedSinceLastModification?;
    get minTimeElapsedSinceLastModification(): string;
    set minTimeElapsedSinceLastModification(value: string);
    resetMinTimeElapsedSinceLastModification(): void;
    get minTimeElapsedSinceLastModificationInput(): string | undefined;
}
export interface GoogleStorageTransferJobTransferSpecPosixDataSink {
    /**
    * Root directory path to the filesystem.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#root_directory GoogleStorageTransferJob#root_directory}
    */
    readonly rootDirectory: string;
}
export declare function googleStorageTransferJobTransferSpecPosixDataSinkToTerraform(struct?: GoogleStorageTransferJobTransferSpecPosixDataSinkOutputReference | GoogleStorageTransferJobTransferSpecPosixDataSink): any;
export declare class GoogleStorageTransferJobTransferSpecPosixDataSinkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleStorageTransferJobTransferSpecPosixDataSink | undefined;
    set internalValue(value: GoogleStorageTransferJobTransferSpecPosixDataSink | undefined);
    private _rootDirectory?;
    get rootDirectory(): string;
    set rootDirectory(value: string);
    get rootDirectoryInput(): string | undefined;
}
export interface GoogleStorageTransferJobTransferSpecPosixDataSource {
    /**
    * Root directory path to the filesystem.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#root_directory GoogleStorageTransferJob#root_directory}
    */
    readonly rootDirectory: string;
}
export declare function googleStorageTransferJobTransferSpecPosixDataSourceToTerraform(struct?: GoogleStorageTransferJobTransferSpecPosixDataSourceOutputReference | GoogleStorageTransferJobTransferSpecPosixDataSource): any;
export declare class GoogleStorageTransferJobTransferSpecPosixDataSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleStorageTransferJobTransferSpecPosixDataSource | undefined;
    set internalValue(value: GoogleStorageTransferJobTransferSpecPosixDataSource | undefined);
    private _rootDirectory?;
    get rootDirectory(): string;
    set rootDirectory(value: string);
    get rootDirectoryInput(): string | undefined;
}
export interface GoogleStorageTransferJobTransferSpecTransferOptions {
    /**
    * Whether objects should be deleted from the source after they are transferred to the sink. Note that this option and delete_objects_unique_in_sink are mutually exclusive.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#delete_objects_from_source_after_transfer GoogleStorageTransferJob#delete_objects_from_source_after_transfer}
    */
    readonly deleteObjectsFromSourceAfterTransfer?: boolean | cdktf.IResolvable;
    /**
    * Whether objects that exist only in the sink should be deleted. Note that this option and delete_objects_from_source_after_transfer are mutually exclusive.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#delete_objects_unique_in_sink GoogleStorageTransferJob#delete_objects_unique_in_sink}
    */
    readonly deleteObjectsUniqueInSink?: boolean | cdktf.IResolvable;
    /**
    * Whether overwriting objects that already exist in the sink is allowed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#overwrite_objects_already_existing_in_sink GoogleStorageTransferJob#overwrite_objects_already_existing_in_sink}
    */
    readonly overwriteObjectsAlreadyExistingInSink?: boolean | cdktf.IResolvable;
    /**
    * When to overwrite objects that already exist in the sink. If not set, overwrite behavior is determined by overwriteObjectsAlreadyExistingInSink.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#overwrite_when GoogleStorageTransferJob#overwrite_when}
    */
    readonly overwriteWhen?: string;
}
export declare function googleStorageTransferJobTransferSpecTransferOptionsToTerraform(struct?: GoogleStorageTransferJobTransferSpecTransferOptionsOutputReference | GoogleStorageTransferJobTransferSpecTransferOptions): any;
export declare class GoogleStorageTransferJobTransferSpecTransferOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleStorageTransferJobTransferSpecTransferOptions | undefined;
    set internalValue(value: GoogleStorageTransferJobTransferSpecTransferOptions | undefined);
    private _deleteObjectsFromSourceAfterTransfer?;
    get deleteObjectsFromSourceAfterTransfer(): boolean | cdktf.IResolvable;
    set deleteObjectsFromSourceAfterTransfer(value: boolean | cdktf.IResolvable);
    resetDeleteObjectsFromSourceAfterTransfer(): void;
    get deleteObjectsFromSourceAfterTransferInput(): boolean | cdktf.IResolvable | undefined;
    private _deleteObjectsUniqueInSink?;
    get deleteObjectsUniqueInSink(): boolean | cdktf.IResolvable;
    set deleteObjectsUniqueInSink(value: boolean | cdktf.IResolvable);
    resetDeleteObjectsUniqueInSink(): void;
    get deleteObjectsUniqueInSinkInput(): boolean | cdktf.IResolvable | undefined;
    private _overwriteObjectsAlreadyExistingInSink?;
    get overwriteObjectsAlreadyExistingInSink(): boolean | cdktf.IResolvable;
    set overwriteObjectsAlreadyExistingInSink(value: boolean | cdktf.IResolvable);
    resetOverwriteObjectsAlreadyExistingInSink(): void;
    get overwriteObjectsAlreadyExistingInSinkInput(): boolean | cdktf.IResolvable | undefined;
    private _overwriteWhen?;
    get overwriteWhen(): string;
    set overwriteWhen(value: string);
    resetOverwriteWhen(): void;
    get overwriteWhenInput(): string | undefined;
}
export interface GoogleStorageTransferJobTransferSpec {
    /**
    * Specifies the agent pool name associated with the posix data source. When unspecified, the default name is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#sink_agent_pool_name GoogleStorageTransferJob#sink_agent_pool_name}
    */
    readonly sinkAgentPoolName?: string;
    /**
    * Specifies the agent pool name associated with the posix data source. When unspecified, the default name is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#source_agent_pool_name GoogleStorageTransferJob#source_agent_pool_name}
    */
    readonly sourceAgentPoolName?: string;
    /**
    * aws_s3_data_source block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#aws_s3_data_source GoogleStorageTransferJob#aws_s3_data_source}
    */
    readonly awsS3DataSource?: GoogleStorageTransferJobTransferSpecAwsS3DataSource;
    /**
    * azure_blob_storage_data_source block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#azure_blob_storage_data_source GoogleStorageTransferJob#azure_blob_storage_data_source}
    */
    readonly azureBlobStorageDataSource?: GoogleStorageTransferJobTransferSpecAzureBlobStorageDataSource;
    /**
    * gcs_data_sink block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#gcs_data_sink GoogleStorageTransferJob#gcs_data_sink}
    */
    readonly gcsDataSink?: GoogleStorageTransferJobTransferSpecGcsDataSink;
    /**
    * gcs_data_source block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#gcs_data_source GoogleStorageTransferJob#gcs_data_source}
    */
    readonly gcsDataSource?: GoogleStorageTransferJobTransferSpecGcsDataSource;
    /**
    * http_data_source block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#http_data_source GoogleStorageTransferJob#http_data_source}
    */
    readonly httpDataSource?: GoogleStorageTransferJobTransferSpecHttpDataSource;
    /**
    * object_conditions block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#object_conditions GoogleStorageTransferJob#object_conditions}
    */
    readonly objectConditions?: GoogleStorageTransferJobTransferSpecObjectConditions;
    /**
    * posix_data_sink block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#posix_data_sink GoogleStorageTransferJob#posix_data_sink}
    */
    readonly posixDataSink?: GoogleStorageTransferJobTransferSpecPosixDataSink;
    /**
    * posix_data_source block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#posix_data_source GoogleStorageTransferJob#posix_data_source}
    */
    readonly posixDataSource?: GoogleStorageTransferJobTransferSpecPosixDataSource;
    /**
    * transfer_options block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job#transfer_options GoogleStorageTransferJob#transfer_options}
    */
    readonly transferOptions?: GoogleStorageTransferJobTransferSpecTransferOptions;
}
export declare function googleStorageTransferJobTransferSpecToTerraform(struct?: GoogleStorageTransferJobTransferSpecOutputReference | GoogleStorageTransferJobTransferSpec): any;
export declare class GoogleStorageTransferJobTransferSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleStorageTransferJobTransferSpec | undefined;
    set internalValue(value: GoogleStorageTransferJobTransferSpec | undefined);
    private _sinkAgentPoolName?;
    get sinkAgentPoolName(): string;
    set sinkAgentPoolName(value: string);
    resetSinkAgentPoolName(): void;
    get sinkAgentPoolNameInput(): string | undefined;
    private _sourceAgentPoolName?;
    get sourceAgentPoolName(): string;
    set sourceAgentPoolName(value: string);
    resetSourceAgentPoolName(): void;
    get sourceAgentPoolNameInput(): string | undefined;
    private _awsS3DataSource;
    get awsS3DataSource(): GoogleStorageTransferJobTransferSpecAwsS3DataSourceOutputReference;
    putAwsS3DataSource(value: GoogleStorageTransferJobTransferSpecAwsS3DataSource): void;
    resetAwsS3DataSource(): void;
    get awsS3DataSourceInput(): GoogleStorageTransferJobTransferSpecAwsS3DataSource | undefined;
    private _azureBlobStorageDataSource;
    get azureBlobStorageDataSource(): GoogleStorageTransferJobTransferSpecAzureBlobStorageDataSourceOutputReference;
    putAzureBlobStorageDataSource(value: GoogleStorageTransferJobTransferSpecAzureBlobStorageDataSource): void;
    resetAzureBlobStorageDataSource(): void;
    get azureBlobStorageDataSourceInput(): GoogleStorageTransferJobTransferSpecAzureBlobStorageDataSource | undefined;
    private _gcsDataSink;
    get gcsDataSink(): GoogleStorageTransferJobTransferSpecGcsDataSinkOutputReference;
    putGcsDataSink(value: GoogleStorageTransferJobTransferSpecGcsDataSink): void;
    resetGcsDataSink(): void;
    get gcsDataSinkInput(): GoogleStorageTransferJobTransferSpecGcsDataSink | undefined;
    private _gcsDataSource;
    get gcsDataSource(): GoogleStorageTransferJobTransferSpecGcsDataSourceOutputReference;
    putGcsDataSource(value: GoogleStorageTransferJobTransferSpecGcsDataSource): void;
    resetGcsDataSource(): void;
    get gcsDataSourceInput(): GoogleStorageTransferJobTransferSpecGcsDataSource | undefined;
    private _httpDataSource;
    get httpDataSource(): GoogleStorageTransferJobTransferSpecHttpDataSourceOutputReference;
    putHttpDataSource(value: GoogleStorageTransferJobTransferSpecHttpDataSource): void;
    resetHttpDataSource(): void;
    get httpDataSourceInput(): GoogleStorageTransferJobTransferSpecHttpDataSource | undefined;
    private _objectConditions;
    get objectConditions(): GoogleStorageTransferJobTransferSpecObjectConditionsOutputReference;
    putObjectConditions(value: GoogleStorageTransferJobTransferSpecObjectConditions): void;
    resetObjectConditions(): void;
    get objectConditionsInput(): GoogleStorageTransferJobTransferSpecObjectConditions | undefined;
    private _posixDataSink;
    get posixDataSink(): GoogleStorageTransferJobTransferSpecPosixDataSinkOutputReference;
    putPosixDataSink(value: GoogleStorageTransferJobTransferSpecPosixDataSink): void;
    resetPosixDataSink(): void;
    get posixDataSinkInput(): GoogleStorageTransferJobTransferSpecPosixDataSink | undefined;
    private _posixDataSource;
    get posixDataSource(): GoogleStorageTransferJobTransferSpecPosixDataSourceOutputReference;
    putPosixDataSource(value: GoogleStorageTransferJobTransferSpecPosixDataSource): void;
    resetPosixDataSource(): void;
    get posixDataSourceInput(): GoogleStorageTransferJobTransferSpecPosixDataSource | undefined;
    private _transferOptions;
    get transferOptions(): GoogleStorageTransferJobTransferSpecTransferOptionsOutputReference;
    putTransferOptions(value: GoogleStorageTransferJobTransferSpecTransferOptions): void;
    resetTransferOptions(): void;
    get transferOptionsInput(): GoogleStorageTransferJobTransferSpecTransferOptions | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job google_storage_transfer_job}
*/
export declare class GoogleStorageTransferJob extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_storage_transfer_job";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_storage_transfer_job google_storage_transfer_job} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleStorageTransferJobConfig
    */
    constructor(scope: Construct, id: string, config: GoogleStorageTransferJobConfig);
    get creationTime(): string;
    get deletionTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get lastModificationTime(): string;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _status?;
    get status(): string;
    set status(value: string);
    resetStatus(): void;
    get statusInput(): string | undefined;
    private _notificationConfig;
    get notificationConfig(): GoogleStorageTransferJobNotificationConfigOutputReference;
    putNotificationConfig(value: GoogleStorageTransferJobNotificationConfig): void;
    resetNotificationConfig(): void;
    get notificationConfigInput(): GoogleStorageTransferJobNotificationConfig | undefined;
    private _schedule;
    get schedule(): GoogleStorageTransferJobScheduleOutputReference;
    putSchedule(value: GoogleStorageTransferJobSchedule): void;
    resetSchedule(): void;
    get scheduleInput(): GoogleStorageTransferJobSchedule | undefined;
    private _transferSpec;
    get transferSpec(): GoogleStorageTransferJobTransferSpecOutputReference;
    putTransferSpec(value: GoogleStorageTransferJobTransferSpec): void;
    get transferSpecInput(): GoogleStorageTransferJobTransferSpec | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
