import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleTagsTagBindingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_tags_tag_binding#id GoogleTagsTagBinding#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The full resource name of the resource the TagValue is bound to. E.g. //cloudresourcemanager.googleapis.com/projects/123
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_tags_tag_binding#parent GoogleTagsTagBinding#parent}
    */
    readonly parent: string;
    /**
    * The TagValue of the TagBinding. Must be of the form tagValues/456.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_tags_tag_binding#tag_value GoogleTagsTagBinding#tag_value}
    */
    readonly tagValue: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_tags_tag_binding#timeouts GoogleTagsTagBinding#timeouts}
    */
    readonly timeouts?: GoogleTagsTagBindingTimeouts;
}
export interface GoogleTagsTagBindingTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_tags_tag_binding#create GoogleTagsTagBinding#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_tags_tag_binding#delete GoogleTagsTagBinding#delete}
    */
    readonly delete?: string;
}
export declare function googleTagsTagBindingTimeoutsToTerraform(struct?: GoogleTagsTagBindingTimeouts | cdktf.IResolvable): any;
export declare class GoogleTagsTagBindingTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleTagsTagBindingTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleTagsTagBindingTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_tags_tag_binding google_tags_tag_binding}
*/
export declare class GoogleTagsTagBinding extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_tags_tag_binding";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_tags_tag_binding google_tags_tag_binding} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleTagsTagBindingConfig
    */
    constructor(scope: Construct, id: string, config: GoogleTagsTagBindingConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _parent?;
    get parent(): string;
    set parent(value: string);
    get parentInput(): string | undefined;
    private _tagValue?;
    get tagValue(): string;
    set tagValue(value: string);
    get tagValueInput(): string | undefined;
    private _timeouts;
    get timeouts(): GoogleTagsTagBindingTimeoutsOutputReference;
    putTimeouts(value: GoogleTagsTagBindingTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleTagsTagBindingTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
