import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleTpuNodeConfig extends cdktf.TerraformMetaArguments {
    /**
    * The type of hardware accelerators associated with this node.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_tpu_node#accelerator_type GoogleTpuNode#accelerator_type}
    */
    readonly acceleratorType: string;
    /**
    * The CIDR block that the TPU node will use when selecting an IP
  address. This CIDR block must be a /29 block; the Compute Engine
  networks API forbids a smaller block, and using a larger block would
  be wasteful (a node can only consume one IP address).
  
  Errors will occur if the CIDR block has already been used for a
  currently existing TPU node, the CIDR block conflicts with any
  subnetworks in the user's provided network, or the provided network
  is peered with another network that is using that CIDR block.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_tpu_node#cidr_block GoogleTpuNode#cidr_block}
    */
    readonly cidrBlock?: string;
    /**
    * The user-supplied description of the TPU. Maximum of 512 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_tpu_node#description GoogleTpuNode#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_tpu_node#id GoogleTpuNode#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Resource labels to represent user provided metadata.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_tpu_node#labels GoogleTpuNode#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The immutable name of the TPU.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_tpu_node#name GoogleTpuNode#name}
    */
    readonly name: string;
    /**
    * The name of a network to peer the TPU node to. It must be a
  preexisting Compute Engine network inside of the project on which
  this API has been activated. If none is provided, "default" will be
  used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_tpu_node#network GoogleTpuNode#network}
    */
    readonly network?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_tpu_node#project GoogleTpuNode#project}
    */
    readonly project?: string;
    /**
    * The version of Tensorflow running in the Node.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_tpu_node#tensorflow_version GoogleTpuNode#tensorflow_version}
    */
    readonly tensorflowVersion: string;
    /**
    * Whether the VPC peering for the node is set up through Service Networking API.
  The VPC Peering should be set up before provisioning the node. If this field is set,
  cidr_block field should not be specified. If the network that you want to peer the
  TPU Node to is a Shared VPC network, the node must be created with this this field enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_tpu_node#use_service_networking GoogleTpuNode#use_service_networking}
    */
    readonly useServiceNetworking?: boolean | cdktf.IResolvable;
    /**
    * The GCP location for the TPU. If it is not provided, the provider zone is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_tpu_node#zone GoogleTpuNode#zone}
    */
    readonly zone?: string;
    /**
    * scheduling_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_tpu_node#scheduling_config GoogleTpuNode#scheduling_config}
    */
    readonly schedulingConfig?: GoogleTpuNodeSchedulingConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_tpu_node#timeouts GoogleTpuNode#timeouts}
    */
    readonly timeouts?: GoogleTpuNodeTimeouts;
}
export interface GoogleTpuNodeNetworkEndpoints {
}
export declare function googleTpuNodeNetworkEndpointsToTerraform(struct?: GoogleTpuNodeNetworkEndpoints): any;
export declare class GoogleTpuNodeNetworkEndpointsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleTpuNodeNetworkEndpoints | undefined;
    set internalValue(value: GoogleTpuNodeNetworkEndpoints | undefined);
    get ipAddress(): string;
    get port(): number;
}
export declare class GoogleTpuNodeNetworkEndpointsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleTpuNodeNetworkEndpointsOutputReference;
}
export interface GoogleTpuNodeSchedulingConfig {
    /**
    * Defines whether the TPU instance is preemptible.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_tpu_node#preemptible GoogleTpuNode#preemptible}
    */
    readonly preemptible: boolean | cdktf.IResolvable;
}
export declare function googleTpuNodeSchedulingConfigToTerraform(struct?: GoogleTpuNodeSchedulingConfigOutputReference | GoogleTpuNodeSchedulingConfig): any;
export declare class GoogleTpuNodeSchedulingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleTpuNodeSchedulingConfig | undefined;
    set internalValue(value: GoogleTpuNodeSchedulingConfig | undefined);
    private _preemptible?;
    get preemptible(): boolean | cdktf.IResolvable;
    set preemptible(value: boolean | cdktf.IResolvable);
    get preemptibleInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleTpuNodeTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_tpu_node#create GoogleTpuNode#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_tpu_node#delete GoogleTpuNode#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_tpu_node#update GoogleTpuNode#update}
    */
    readonly update?: string;
}
export declare function googleTpuNodeTimeoutsToTerraform(struct?: GoogleTpuNodeTimeouts | cdktf.IResolvable): any;
export declare class GoogleTpuNodeTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleTpuNodeTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleTpuNodeTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_tpu_node google_tpu_node}
*/
export declare class GoogleTpuNode extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_tpu_node";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_tpu_node google_tpu_node} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleTpuNodeConfig
    */
    constructor(scope: Construct, id: string, config: GoogleTpuNodeConfig);
    private _acceleratorType?;
    get acceleratorType(): string;
    set acceleratorType(value: string);
    get acceleratorTypeInput(): string | undefined;
    private _cidrBlock?;
    get cidrBlock(): string;
    set cidrBlock(value: string);
    resetCidrBlock(): void;
    get cidrBlockInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _networkEndpoints;
    get networkEndpoints(): GoogleTpuNodeNetworkEndpointsList;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get serviceAccount(): string;
    private _tensorflowVersion?;
    get tensorflowVersion(): string;
    set tensorflowVersion(value: string);
    get tensorflowVersionInput(): string | undefined;
    private _useServiceNetworking?;
    get useServiceNetworking(): boolean | cdktf.IResolvable;
    set useServiceNetworking(value: boolean | cdktf.IResolvable);
    resetUseServiceNetworking(): void;
    get useServiceNetworkingInput(): boolean | cdktf.IResolvable | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _schedulingConfig;
    get schedulingConfig(): GoogleTpuNodeSchedulingConfigOutputReference;
    putSchedulingConfig(value: GoogleTpuNodeSchedulingConfig): void;
    resetSchedulingConfig(): void;
    get schedulingConfigInput(): GoogleTpuNodeSchedulingConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleTpuNodeTimeoutsOutputReference;
    putTimeouts(value: GoogleTpuNodeTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleTpuNodeTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
