import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleVertexAiFeaturestoreEntitytypeIamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_featurestore_entitytype_iam_member#entitytype GoogleVertexAiFeaturestoreEntitytypeIamMember#entitytype}
    */
    readonly entitytype: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_featurestore_entitytype_iam_member#featurestore GoogleVertexAiFeaturestoreEntitytypeIamMember#featurestore}
    */
    readonly featurestore: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_featurestore_entitytype_iam_member#id GoogleVertexAiFeaturestoreEntitytypeIamMember#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_featurestore_entitytype_iam_member#member GoogleVertexAiFeaturestoreEntitytypeIamMember#member}
    */
    readonly member: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_featurestore_entitytype_iam_member#role GoogleVertexAiFeaturestoreEntitytypeIamMember#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_featurestore_entitytype_iam_member#condition GoogleVertexAiFeaturestoreEntitytypeIamMember#condition}
    */
    readonly condition?: GoogleVertexAiFeaturestoreEntitytypeIamMemberCondition;
}
export interface GoogleVertexAiFeaturestoreEntitytypeIamMemberCondition {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_featurestore_entitytype_iam_member#description GoogleVertexAiFeaturestoreEntitytypeIamMember#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_featurestore_entitytype_iam_member#expression GoogleVertexAiFeaturestoreEntitytypeIamMember#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_featurestore_entitytype_iam_member#title GoogleVertexAiFeaturestoreEntitytypeIamMember#title}
    */
    readonly title: string;
}
export declare function googleVertexAiFeaturestoreEntitytypeIamMemberConditionToTerraform(struct?: GoogleVertexAiFeaturestoreEntitytypeIamMemberConditionOutputReference | GoogleVertexAiFeaturestoreEntitytypeIamMemberCondition): any;
export declare class GoogleVertexAiFeaturestoreEntitytypeIamMemberConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVertexAiFeaturestoreEntitytypeIamMemberCondition | undefined;
    set internalValue(value: GoogleVertexAiFeaturestoreEntitytypeIamMemberCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_featurestore_entitytype_iam_member google_vertex_ai_featurestore_entitytype_iam_member}
*/
export declare class GoogleVertexAiFeaturestoreEntitytypeIamMember extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_vertex_ai_featurestore_entitytype_iam_member";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_featurestore_entitytype_iam_member google_vertex_ai_featurestore_entitytype_iam_member} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleVertexAiFeaturestoreEntitytypeIamMemberConfig
    */
    constructor(scope: Construct, id: string, config: GoogleVertexAiFeaturestoreEntitytypeIamMemberConfig);
    private _entitytype?;
    get entitytype(): string;
    set entitytype(value: string);
    get entitytypeInput(): string | undefined;
    get etag(): string;
    private _featurestore?;
    get featurestore(): string;
    set featurestore(value: string);
    get featurestoreInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _member?;
    get member(): string;
    set member(value: string);
    get memberInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition;
    get condition(): GoogleVertexAiFeaturestoreEntitytypeIamMemberConditionOutputReference;
    putCondition(value: GoogleVertexAiFeaturestoreEntitytypeIamMemberCondition): void;
    resetCondition(): void;
    get conditionInput(): GoogleVertexAiFeaturestoreEntitytypeIamMemberCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
