import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleVertexAiIndexConfig extends cdktf.TerraformMetaArguments {
    /**
    * The description of the Index.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_index#description GoogleVertexAiIndex#description}
    */
    readonly description?: string;
    /**
    * The display name of the Index. The name can be up to 128 characters long and can consist of any UTF-8 characters.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_index#display_name GoogleVertexAiIndex#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_index#id GoogleVertexAiIndex#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The update method to use with this Index. The value must be the followings. If not set, BATCH_UPDATE will be used by default.
  * BATCH_UPDATE: user can call indexes.patch with files on Cloud Storage of datapoints to update.
  * STREAM_UPDATE: user can call indexes.upsertDatapoints/DeleteDatapoints to update the Index and the updates will be applied in corresponding DeployedIndexes in nearly real-time.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_index#index_update_method GoogleVertexAiIndex#index_update_method}
    */
    readonly indexUpdateMethod?: string;
    /**
    * The labels with user-defined metadata to organize your Indexes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_index#labels GoogleVertexAiIndex#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_index#project GoogleVertexAiIndex#project}
    */
    readonly project?: string;
    /**
    * The region of the index. eg us-central1
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_index#region GoogleVertexAiIndex#region}
    */
    readonly region?: string;
    /**
    * metadata block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_index#metadata GoogleVertexAiIndex#metadata}
    */
    readonly metadata?: GoogleVertexAiIndexMetadata;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_index#timeouts GoogleVertexAiIndex#timeouts}
    */
    readonly timeouts?: GoogleVertexAiIndexTimeouts;
}
export interface GoogleVertexAiIndexDeployedIndexes {
}
export declare function googleVertexAiIndexDeployedIndexesToTerraform(struct?: GoogleVertexAiIndexDeployedIndexes): any;
export declare class GoogleVertexAiIndexDeployedIndexesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleVertexAiIndexDeployedIndexes | undefined;
    set internalValue(value: GoogleVertexAiIndexDeployedIndexes | undefined);
    get deployedIndexId(): string;
    get indexEndpoint(): string;
}
export declare class GoogleVertexAiIndexDeployedIndexesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleVertexAiIndexDeployedIndexesOutputReference;
}
export interface GoogleVertexAiIndexIndexStats {
}
export declare function googleVertexAiIndexIndexStatsToTerraform(struct?: GoogleVertexAiIndexIndexStats): any;
export declare class GoogleVertexAiIndexIndexStatsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleVertexAiIndexIndexStats | undefined;
    set internalValue(value: GoogleVertexAiIndexIndexStats | undefined);
    get shardsCount(): number;
    get vectorsCount(): string;
}
export declare class GoogleVertexAiIndexIndexStatsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleVertexAiIndexIndexStatsOutputReference;
}
export interface GoogleVertexAiIndexMetadataConfigAlgorithmConfigBruteForceConfig {
}
export declare function googleVertexAiIndexMetadataConfigAlgorithmConfigBruteForceConfigToTerraform(struct?: GoogleVertexAiIndexMetadataConfigAlgorithmConfigBruteForceConfigOutputReference | GoogleVertexAiIndexMetadataConfigAlgorithmConfigBruteForceConfig): any;
export declare class GoogleVertexAiIndexMetadataConfigAlgorithmConfigBruteForceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVertexAiIndexMetadataConfigAlgorithmConfigBruteForceConfig | undefined;
    set internalValue(value: GoogleVertexAiIndexMetadataConfigAlgorithmConfigBruteForceConfig | undefined);
}
export interface GoogleVertexAiIndexMetadataConfigAlgorithmConfigTreeAhConfig {
    /**
    * Number of embeddings on each leaf node. The default value is 1000 if not set.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_index#leaf_node_embedding_count GoogleVertexAiIndex#leaf_node_embedding_count}
    */
    readonly leafNodeEmbeddingCount?: number;
    /**
    * The default percentage of leaf nodes that any query may be searched. Must be in
  range 1-100, inclusive. The default value is 10 (means 10%) if not set.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_index#leaf_nodes_to_search_percent GoogleVertexAiIndex#leaf_nodes_to_search_percent}
    */
    readonly leafNodesToSearchPercent?: number;
}
export declare function googleVertexAiIndexMetadataConfigAlgorithmConfigTreeAhConfigToTerraform(struct?: GoogleVertexAiIndexMetadataConfigAlgorithmConfigTreeAhConfigOutputReference | GoogleVertexAiIndexMetadataConfigAlgorithmConfigTreeAhConfig): any;
export declare class GoogleVertexAiIndexMetadataConfigAlgorithmConfigTreeAhConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVertexAiIndexMetadataConfigAlgorithmConfigTreeAhConfig | undefined;
    set internalValue(value: GoogleVertexAiIndexMetadataConfigAlgorithmConfigTreeAhConfig | undefined);
    private _leafNodeEmbeddingCount?;
    get leafNodeEmbeddingCount(): number;
    set leafNodeEmbeddingCount(value: number);
    resetLeafNodeEmbeddingCount(): void;
    get leafNodeEmbeddingCountInput(): number | undefined;
    private _leafNodesToSearchPercent?;
    get leafNodesToSearchPercent(): number;
    set leafNodesToSearchPercent(value: number);
    resetLeafNodesToSearchPercent(): void;
    get leafNodesToSearchPercentInput(): number | undefined;
}
export interface GoogleVertexAiIndexMetadataConfigAlgorithmConfig {
    /**
    * brute_force_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_index#brute_force_config GoogleVertexAiIndex#brute_force_config}
    */
    readonly bruteForceConfig?: GoogleVertexAiIndexMetadataConfigAlgorithmConfigBruteForceConfig;
    /**
    * tree_ah_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_index#tree_ah_config GoogleVertexAiIndex#tree_ah_config}
    */
    readonly treeAhConfig?: GoogleVertexAiIndexMetadataConfigAlgorithmConfigTreeAhConfig;
}
export declare function googleVertexAiIndexMetadataConfigAlgorithmConfigToTerraform(struct?: GoogleVertexAiIndexMetadataConfigAlgorithmConfigOutputReference | GoogleVertexAiIndexMetadataConfigAlgorithmConfig): any;
export declare class GoogleVertexAiIndexMetadataConfigAlgorithmConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVertexAiIndexMetadataConfigAlgorithmConfig | undefined;
    set internalValue(value: GoogleVertexAiIndexMetadataConfigAlgorithmConfig | undefined);
    private _bruteForceConfig;
    get bruteForceConfig(): GoogleVertexAiIndexMetadataConfigAlgorithmConfigBruteForceConfigOutputReference;
    putBruteForceConfig(value: GoogleVertexAiIndexMetadataConfigAlgorithmConfigBruteForceConfig): void;
    resetBruteForceConfig(): void;
    get bruteForceConfigInput(): GoogleVertexAiIndexMetadataConfigAlgorithmConfigBruteForceConfig | undefined;
    private _treeAhConfig;
    get treeAhConfig(): GoogleVertexAiIndexMetadataConfigAlgorithmConfigTreeAhConfigOutputReference;
    putTreeAhConfig(value: GoogleVertexAiIndexMetadataConfigAlgorithmConfigTreeAhConfig): void;
    resetTreeAhConfig(): void;
    get treeAhConfigInput(): GoogleVertexAiIndexMetadataConfigAlgorithmConfigTreeAhConfig | undefined;
}
export interface GoogleVertexAiIndexMetadataConfig {
    /**
    * The default number of neighbors to find via approximate search before exact reordering is
  performed. Exact reordering is a procedure where results returned by an
  approximate search algorithm are reordered via a more expensive distance computation.
  Required if tree-AH algorithm is used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_index#approximate_neighbors_count GoogleVertexAiIndex#approximate_neighbors_count}
    */
    readonly approximateNeighborsCount?: number;
    /**
    * The number of dimensions of the input vectors.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_index#dimensions GoogleVertexAiIndex#dimensions}
    */
    readonly dimensions: number;
    /**
    * The distance measure used in nearest neighbor search. The value must be one of the followings:
  * SQUARED_L2_DISTANCE: Euclidean (L_2) Distance
  * L1_DISTANCE: Manhattan (L_1) Distance
  * COSINE_DISTANCE: Cosine Distance. Defined as 1 - cosine similarity.
  * DOT_PRODUCT_DISTANCE: Dot Product Distance. Defined as a negative of the dot product
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_index#distance_measure_type GoogleVertexAiIndex#distance_measure_type}
    */
    readonly distanceMeasureType?: string;
    /**
    * Type of normalization to be carried out on each vector. The value must be one of the followings:
  * UNIT_L2_NORM: Unit L2 normalization type
  * NONE: No normalization type is specified.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_index#feature_norm_type GoogleVertexAiIndex#feature_norm_type}
    */
    readonly featureNormType?: string;
    /**
    * algorithm_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_index#algorithm_config GoogleVertexAiIndex#algorithm_config}
    */
    readonly algorithmConfig?: GoogleVertexAiIndexMetadataConfigAlgorithmConfig;
}
export declare function googleVertexAiIndexMetadataConfigToTerraform(struct?: GoogleVertexAiIndexMetadataConfigOutputReference | GoogleVertexAiIndexMetadataConfig): any;
export declare class GoogleVertexAiIndexMetadataConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVertexAiIndexMetadataConfig | undefined;
    set internalValue(value: GoogleVertexAiIndexMetadataConfig | undefined);
    private _approximateNeighborsCount?;
    get approximateNeighborsCount(): number;
    set approximateNeighborsCount(value: number);
    resetApproximateNeighborsCount(): void;
    get approximateNeighborsCountInput(): number | undefined;
    private _dimensions?;
    get dimensions(): number;
    set dimensions(value: number);
    get dimensionsInput(): number | undefined;
    private _distanceMeasureType?;
    get distanceMeasureType(): string;
    set distanceMeasureType(value: string);
    resetDistanceMeasureType(): void;
    get distanceMeasureTypeInput(): string | undefined;
    private _featureNormType?;
    get featureNormType(): string;
    set featureNormType(value: string);
    resetFeatureNormType(): void;
    get featureNormTypeInput(): string | undefined;
    private _algorithmConfig;
    get algorithmConfig(): GoogleVertexAiIndexMetadataConfigAlgorithmConfigOutputReference;
    putAlgorithmConfig(value: GoogleVertexAiIndexMetadataConfigAlgorithmConfig): void;
    resetAlgorithmConfig(): void;
    get algorithmConfigInput(): GoogleVertexAiIndexMetadataConfigAlgorithmConfig | undefined;
}
export interface GoogleVertexAiIndexMetadata {
    /**
    * Allows inserting, updating  or deleting the contents of the Matching Engine Index.
  The string must be a valid Cloud Storage directory path. If this
  field is set when calling IndexService.UpdateIndex, then no other
  Index field can be also updated as part of the same call.
  The expected structure and format of the files this URI points to is
  described at https://cloud.google.com/vertex-ai/docs/matching-engine/using-matching-engine#input-data-format
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_index#contents_delta_uri GoogleVertexAiIndex#contents_delta_uri}
    */
    readonly contentsDeltaUri?: string;
    /**
    * If this field is set together with contentsDeltaUri when calling IndexService.UpdateIndex,
  then existing content of the Index will be replaced by the data from the contentsDeltaUri.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_index#is_complete_overwrite GoogleVertexAiIndex#is_complete_overwrite}
    */
    readonly isCompleteOverwrite?: boolean | cdktf.IResolvable;
    /**
    * config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_index#config GoogleVertexAiIndex#config}
    */
    readonly config?: GoogleVertexAiIndexMetadataConfig;
}
export declare function googleVertexAiIndexMetadataToTerraform(struct?: GoogleVertexAiIndexMetadataOutputReference | GoogleVertexAiIndexMetadata): any;
export declare class GoogleVertexAiIndexMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVertexAiIndexMetadata | undefined;
    set internalValue(value: GoogleVertexAiIndexMetadata | undefined);
    private _contentsDeltaUri?;
    get contentsDeltaUri(): string;
    set contentsDeltaUri(value: string);
    resetContentsDeltaUri(): void;
    get contentsDeltaUriInput(): string | undefined;
    private _isCompleteOverwrite?;
    get isCompleteOverwrite(): boolean | cdktf.IResolvable;
    set isCompleteOverwrite(value: boolean | cdktf.IResolvable);
    resetIsCompleteOverwrite(): void;
    get isCompleteOverwriteInput(): boolean | cdktf.IResolvable | undefined;
    private _config;
    get config(): GoogleVertexAiIndexMetadataConfigOutputReference;
    putConfig(value: GoogleVertexAiIndexMetadataConfig): void;
    resetConfig(): void;
    get configInput(): GoogleVertexAiIndexMetadataConfig | undefined;
}
export interface GoogleVertexAiIndexTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_index#create GoogleVertexAiIndex#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_index#delete GoogleVertexAiIndex#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_index#update GoogleVertexAiIndex#update}
    */
    readonly update?: string;
}
export declare function googleVertexAiIndexTimeoutsToTerraform(struct?: GoogleVertexAiIndexTimeouts | cdktf.IResolvable): any;
export declare class GoogleVertexAiIndexTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVertexAiIndexTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleVertexAiIndexTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_index google_vertex_ai_index}
*/
export declare class GoogleVertexAiIndex extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_vertex_ai_index";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_index google_vertex_ai_index} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleVertexAiIndexConfig
    */
    constructor(scope: Construct, id: string, config: GoogleVertexAiIndexConfig);
    get createTime(): string;
    private _deployedIndexes;
    get deployedIndexes(): GoogleVertexAiIndexDeployedIndexesList;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _indexStats;
    get indexStats(): GoogleVertexAiIndexIndexStatsList;
    private _indexUpdateMethod?;
    get indexUpdateMethod(): string;
    set indexUpdateMethod(value: string);
    resetIndexUpdateMethod(): void;
    get indexUpdateMethodInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    get metadataSchemaUri(): string;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get updateTime(): string;
    private _metadata;
    get metadata(): GoogleVertexAiIndexMetadataOutputReference;
    putMetadata(value: GoogleVertexAiIndexMetadata): void;
    resetMetadata(): void;
    get metadataInput(): GoogleVertexAiIndexMetadata | undefined;
    private _timeouts;
    get timeouts(): GoogleVertexAiIndexTimeoutsOutputReference;
    putTimeouts(value: GoogleVertexAiIndexTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleVertexAiIndexTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
