import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleVertexAiMetadataStoreConfig extends cdktf.TerraformMetaArguments {
    /**
    * Description of the MetadataStore.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_metadata_store#description GoogleVertexAiMetadataStore#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_metadata_store#id GoogleVertexAiMetadataStore#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the MetadataStore. This value may be up to 60 characters, and valid characters are [a-z0-9_]. The first character cannot be a number.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_metadata_store#name GoogleVertexAiMetadataStore#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_metadata_store#project GoogleVertexAiMetadataStore#project}
    */
    readonly project?: string;
    /**
    * The region of the Metadata Store. eg us-central1
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_metadata_store#region GoogleVertexAiMetadataStore#region}
    */
    readonly region?: string;
    /**
    * encryption_spec block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_metadata_store#encryption_spec GoogleVertexAiMetadataStore#encryption_spec}
    */
    readonly encryptionSpec?: GoogleVertexAiMetadataStoreEncryptionSpec;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_metadata_store#timeouts GoogleVertexAiMetadataStore#timeouts}
    */
    readonly timeouts?: GoogleVertexAiMetadataStoreTimeouts;
}
export interface GoogleVertexAiMetadataStoreState {
}
export declare function googleVertexAiMetadataStoreStateToTerraform(struct?: GoogleVertexAiMetadataStoreState): any;
export declare class GoogleVertexAiMetadataStoreStateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleVertexAiMetadataStoreState | undefined;
    set internalValue(value: GoogleVertexAiMetadataStoreState | undefined);
    get diskUtilizationBytes(): string;
}
export declare class GoogleVertexAiMetadataStoreStateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleVertexAiMetadataStoreStateOutputReference;
}
export interface GoogleVertexAiMetadataStoreEncryptionSpec {
    /**
    * Required. The Cloud KMS resource identifier of the customer managed encryption key used to protect a resource.
  Has the form: projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key. The key needs to be in the same region as where the resource is created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_metadata_store#kms_key_name GoogleVertexAiMetadataStore#kms_key_name}
    */
    readonly kmsKeyName?: string;
}
export declare function googleVertexAiMetadataStoreEncryptionSpecToTerraform(struct?: GoogleVertexAiMetadataStoreEncryptionSpecOutputReference | GoogleVertexAiMetadataStoreEncryptionSpec): any;
export declare class GoogleVertexAiMetadataStoreEncryptionSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVertexAiMetadataStoreEncryptionSpec | undefined;
    set internalValue(value: GoogleVertexAiMetadataStoreEncryptionSpec | undefined);
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    resetKmsKeyName(): void;
    get kmsKeyNameInput(): string | undefined;
}
export interface GoogleVertexAiMetadataStoreTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_metadata_store#create GoogleVertexAiMetadataStore#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_metadata_store#delete GoogleVertexAiMetadataStore#delete}
    */
    readonly delete?: string;
}
export declare function googleVertexAiMetadataStoreTimeoutsToTerraform(struct?: GoogleVertexAiMetadataStoreTimeouts | cdktf.IResolvable): any;
export declare class GoogleVertexAiMetadataStoreTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVertexAiMetadataStoreTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleVertexAiMetadataStoreTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_metadata_store google_vertex_ai_metadata_store}
*/
export declare class GoogleVertexAiMetadataStore extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_vertex_ai_metadata_store";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_metadata_store google_vertex_ai_metadata_store} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleVertexAiMetadataStoreConfig = {}
    */
    constructor(scope: Construct, id: string, config?: GoogleVertexAiMetadataStoreConfig);
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _state;
    get state(): GoogleVertexAiMetadataStoreStateList;
    get updateTime(): string;
    private _encryptionSpec;
    get encryptionSpec(): GoogleVertexAiMetadataStoreEncryptionSpecOutputReference;
    putEncryptionSpec(value: GoogleVertexAiMetadataStoreEncryptionSpec): void;
    resetEncryptionSpec(): void;
    get encryptionSpecInput(): GoogleVertexAiMetadataStoreEncryptionSpec | undefined;
    private _timeouts;
    get timeouts(): GoogleVertexAiMetadataStoreTimeoutsOutputReference;
    putTimeouts(value: GoogleVertexAiMetadataStoreTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleVertexAiMetadataStoreTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
