import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleVertexAiTensorboardConfig extends cdktf.TerraformMetaArguments {
    /**
    * Description of this Tensorboard.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_tensorboard#description GoogleVertexAiTensorboard#description}
    */
    readonly description?: string;
    /**
    * User provided name of this Tensorboard.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_tensorboard#display_name GoogleVertexAiTensorboard#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_tensorboard#id GoogleVertexAiTensorboard#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The labels with user-defined metadata to organize your Tensorboards.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_tensorboard#labels GoogleVertexAiTensorboard#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_tensorboard#project GoogleVertexAiTensorboard#project}
    */
    readonly project?: string;
    /**
    * The region of the tensorboard. eg us-central1
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_tensorboard#region GoogleVertexAiTensorboard#region}
    */
    readonly region?: string;
    /**
    * encryption_spec block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_tensorboard#encryption_spec GoogleVertexAiTensorboard#encryption_spec}
    */
    readonly encryptionSpec?: GoogleVertexAiTensorboardEncryptionSpec;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_tensorboard#timeouts GoogleVertexAiTensorboard#timeouts}
    */
    readonly timeouts?: GoogleVertexAiTensorboardTimeouts;
}
export interface GoogleVertexAiTensorboardEncryptionSpec {
    /**
    * The Cloud KMS resource identifier of the customer managed encryption key used to protect a resource.
  Has the form: projects/my-project/locations/my-region/keyRings/my-kr/cryptoKeys/my-key. The key needs to be in the same region as where the resource is created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_tensorboard#kms_key_name GoogleVertexAiTensorboard#kms_key_name}
    */
    readonly kmsKeyName: string;
}
export declare function googleVertexAiTensorboardEncryptionSpecToTerraform(struct?: GoogleVertexAiTensorboardEncryptionSpecOutputReference | GoogleVertexAiTensorboardEncryptionSpec): any;
export declare class GoogleVertexAiTensorboardEncryptionSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVertexAiTensorboardEncryptionSpec | undefined;
    set internalValue(value: GoogleVertexAiTensorboardEncryptionSpec | undefined);
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    get kmsKeyNameInput(): string | undefined;
}
export interface GoogleVertexAiTensorboardTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_tensorboard#create GoogleVertexAiTensorboard#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_tensorboard#delete GoogleVertexAiTensorboard#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_tensorboard#update GoogleVertexAiTensorboard#update}
    */
    readonly update?: string;
}
export declare function googleVertexAiTensorboardTimeoutsToTerraform(struct?: GoogleVertexAiTensorboardTimeouts | cdktf.IResolvable): any;
export declare class GoogleVertexAiTensorboardTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleVertexAiTensorboardTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleVertexAiTensorboardTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_tensorboard google_vertex_ai_tensorboard}
*/
export declare class GoogleVertexAiTensorboard extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_vertex_ai_tensorboard";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_vertex_ai_tensorboard google_vertex_ai_tensorboard} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleVertexAiTensorboardConfig
    */
    constructor(scope: Construct, id: string, config: GoogleVertexAiTensorboardConfig);
    get blobStoragePathPrefix(): string;
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    get runCount(): string;
    get updateTime(): string;
    private _encryptionSpec;
    get encryptionSpec(): GoogleVertexAiTensorboardEncryptionSpecOutputReference;
    putEncryptionSpec(value: GoogleVertexAiTensorboardEncryptionSpec): void;
    resetEncryptionSpec(): void;
    get encryptionSpecInput(): GoogleVertexAiTensorboardEncryptionSpec | undefined;
    private _timeouts;
    get timeouts(): GoogleVertexAiTensorboardTimeoutsOutputReference;
    putTimeouts(value: GoogleVertexAiTensorboardTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleVertexAiTensorboardTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
