import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleWorkstationsWorkstationClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Client-specified annotations. This is distinct from labels.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_cluster#annotations GoogleWorkstationsWorkstationCluster#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Human-readable name for this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_cluster#display_name GoogleWorkstationsWorkstationCluster#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_cluster#id GoogleWorkstationsWorkstationCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Client-specified labels that are applied to the resource and that are also propagated to the underlying Compute Engine resources.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_cluster#labels GoogleWorkstationsWorkstationCluster#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The location where the workstation cluster should reside.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_cluster#location GoogleWorkstationsWorkstationCluster#location}
    */
    readonly location?: string;
    /**
    * The relative resource name of the VPC network on which the instance can be accessed.
  It is specified in the following form: "projects/{projectNumber}/global/networks/{network_id}".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_cluster#network GoogleWorkstationsWorkstationCluster#network}
    */
    readonly network: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_cluster#project GoogleWorkstationsWorkstationCluster#project}
    */
    readonly project?: string;
    /**
    * Name of the Compute Engine subnetwork in which instances associated with this cluster will be created.
  Must be part of the subnetwork specified for this cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_cluster#subnetwork GoogleWorkstationsWorkstationCluster#subnetwork}
    */
    readonly subnetwork: string;
    /**
    * The ID of the workstation cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_cluster#workstation_cluster_id GoogleWorkstationsWorkstationCluster#workstation_cluster_id}
    */
    readonly workstationClusterId: string;
    /**
    * private_cluster_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_cluster#private_cluster_config GoogleWorkstationsWorkstationCluster#private_cluster_config}
    */
    readonly privateClusterConfig?: GoogleWorkstationsWorkstationClusterPrivateClusterConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_cluster#timeouts GoogleWorkstationsWorkstationCluster#timeouts}
    */
    readonly timeouts?: GoogleWorkstationsWorkstationClusterTimeouts;
}
export interface GoogleWorkstationsWorkstationClusterConditions {
}
export declare function googleWorkstationsWorkstationClusterConditionsToTerraform(struct?: GoogleWorkstationsWorkstationClusterConditions): any;
export declare class GoogleWorkstationsWorkstationClusterConditionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleWorkstationsWorkstationClusterConditions | undefined;
    set internalValue(value: GoogleWorkstationsWorkstationClusterConditions | undefined);
    get code(): number;
    private _details;
    get details(): cdktf.StringMapList;
    get message(): string;
}
export declare class GoogleWorkstationsWorkstationClusterConditionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleWorkstationsWorkstationClusterConditionsOutputReference;
}
export interface GoogleWorkstationsWorkstationClusterPrivateClusterConfig {
    /**
    * Whether Workstations endpoint is private.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_cluster#enable_private_endpoint GoogleWorkstationsWorkstationCluster#enable_private_endpoint}
    */
    readonly enablePrivateEndpoint: boolean | cdktf.IResolvable;
}
export declare function googleWorkstationsWorkstationClusterPrivateClusterConfigToTerraform(struct?: GoogleWorkstationsWorkstationClusterPrivateClusterConfigOutputReference | GoogleWorkstationsWorkstationClusterPrivateClusterConfig): any;
export declare class GoogleWorkstationsWorkstationClusterPrivateClusterConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleWorkstationsWorkstationClusterPrivateClusterConfig | undefined;
    set internalValue(value: GoogleWorkstationsWorkstationClusterPrivateClusterConfig | undefined);
    get clusterHostname(): string;
    private _enablePrivateEndpoint?;
    get enablePrivateEndpoint(): boolean | cdktf.IResolvable;
    set enablePrivateEndpoint(value: boolean | cdktf.IResolvable);
    get enablePrivateEndpointInput(): boolean | cdktf.IResolvable | undefined;
    get serviceAttachmentUri(): string;
}
export interface GoogleWorkstationsWorkstationClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_cluster#create GoogleWorkstationsWorkstationCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_cluster#delete GoogleWorkstationsWorkstationCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_cluster#update GoogleWorkstationsWorkstationCluster#update}
    */
    readonly update?: string;
}
export declare function googleWorkstationsWorkstationClusterTimeoutsToTerraform(struct?: GoogleWorkstationsWorkstationClusterTimeouts | cdktf.IResolvable): any;
export declare class GoogleWorkstationsWorkstationClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleWorkstationsWorkstationClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleWorkstationsWorkstationClusterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_cluster google_workstations_workstation_cluster}
*/
export declare class GoogleWorkstationsWorkstationCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_workstations_workstation_cluster";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_cluster google_workstations_workstation_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleWorkstationsWorkstationClusterConfig
    */
    constructor(scope: Construct, id: string, config: GoogleWorkstationsWorkstationClusterConfig);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _conditions;
    get conditions(): GoogleWorkstationsWorkstationClusterConditionsList;
    get createTime(): string;
    get degraded(): cdktf.IResolvable;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    get name(): string;
    private _network?;
    get network(): string;
    set network(value: string);
    get networkInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _subnetwork?;
    get subnetwork(): string;
    set subnetwork(value: string);
    get subnetworkInput(): string | undefined;
    get uid(): string;
    private _workstationClusterId?;
    get workstationClusterId(): string;
    set workstationClusterId(value: string);
    get workstationClusterIdInput(): string | undefined;
    private _privateClusterConfig;
    get privateClusterConfig(): GoogleWorkstationsWorkstationClusterPrivateClusterConfigOutputReference;
    putPrivateClusterConfig(value: GoogleWorkstationsWorkstationClusterPrivateClusterConfig): void;
    resetPrivateClusterConfig(): void;
    get privateClusterConfigInput(): GoogleWorkstationsWorkstationClusterPrivateClusterConfig | undefined;
    private _timeouts;
    get timeouts(): GoogleWorkstationsWorkstationClusterTimeoutsOutputReference;
    putTimeouts(value: GoogleWorkstationsWorkstationClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleWorkstationsWorkstationClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
