import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GoogleWorkstationsWorkstationConfigAConfig extends cdktf.TerraformMetaArguments {
    /**
    * Client-specified annotations. This is distinct from labels.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_config#annotations GoogleWorkstationsWorkstationConfigA#annotations}
    */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
    * Human-readable name for this resource.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_config#display_name GoogleWorkstationsWorkstationConfigA#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_config#id GoogleWorkstationsWorkstationConfigA#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Client-specified labels that are applied to the resource and that are also propagated to the underlying Compute Engine resources.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_config#labels GoogleWorkstationsWorkstationConfigA#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The location where the workstation cluster config should reside.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_config#location GoogleWorkstationsWorkstationConfigA#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_config#project GoogleWorkstationsWorkstationConfigA#project}
    */
    readonly project?: string;
    /**
    * The name of the workstation cluster.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_config#workstation_cluster_id GoogleWorkstationsWorkstationConfigA#workstation_cluster_id}
    */
    readonly workstationClusterId: string;
    /**
    * The ID of the workstation cluster config.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_config#workstation_config_id GoogleWorkstationsWorkstationConfigA#workstation_config_id}
    */
    readonly workstationConfigId: string;
    /**
    * container block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_config#container GoogleWorkstationsWorkstationConfigA#container}
    */
    readonly container?: GoogleWorkstationsWorkstationConfigContainer;
    /**
    * encryption_key block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_config#encryption_key GoogleWorkstationsWorkstationConfigA#encryption_key}
    */
    readonly encryptionKey?: GoogleWorkstationsWorkstationConfigEncryptionKey;
    /**
    * host block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_config#host GoogleWorkstationsWorkstationConfigA#host}
    */
    readonly host?: GoogleWorkstationsWorkstationConfigHost;
    /**
    * persistent_directories block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_config#persistent_directories GoogleWorkstationsWorkstationConfigA#persistent_directories}
    */
    readonly persistentDirectories?: GoogleWorkstationsWorkstationConfigPersistentDirectories[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_config#timeouts GoogleWorkstationsWorkstationConfigA#timeouts}
    */
    readonly timeouts?: GoogleWorkstationsWorkstationConfigTimeouts;
}
export interface GoogleWorkstationsWorkstationConfigConditions {
}
export declare function googleWorkstationsWorkstationConfigConditionsToTerraform(struct?: GoogleWorkstationsWorkstationConfigConditions): any;
export declare class GoogleWorkstationsWorkstationConfigConditionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleWorkstationsWorkstationConfigConditions | undefined;
    set internalValue(value: GoogleWorkstationsWorkstationConfigConditions | undefined);
    get code(): number;
    private _details;
    get details(): cdktf.StringMapList;
    get message(): string;
}
export declare class GoogleWorkstationsWorkstationConfigConditionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleWorkstationsWorkstationConfigConditionsOutputReference;
}
export interface GoogleWorkstationsWorkstationConfigContainer {
    /**
    * Arguments passed to the entrypoint.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_config#args GoogleWorkstationsWorkstationConfigA#args}
    */
    readonly args?: string[];
    /**
    * If set, overrides the default ENTRYPOINT specified by the image.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_config#command GoogleWorkstationsWorkstationConfigA#command}
    */
    readonly command?: string[];
    /**
    * Environment variables passed to the container.
  The elements are of the form "KEY=VALUE" for the environment variable "KEY" being given the value "VALUE".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_config#env GoogleWorkstationsWorkstationConfigA#env}
    */
    readonly env?: {
        [key: string]: string;
    };
    /**
    * Docker image defining the container. This image must be accessible by the config"s service account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_config#image GoogleWorkstationsWorkstationConfigA#image}
    */
    readonly image?: string;
    /**
    * If set, overrides the USER specified in the image with the given uid.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_config#run_as_user GoogleWorkstationsWorkstationConfigA#run_as_user}
    */
    readonly runAsUser?: number;
    /**
    * If set, overrides the default DIR specified by the image.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_config#working_dir GoogleWorkstationsWorkstationConfigA#working_dir}
    */
    readonly workingDir?: string;
}
export declare function googleWorkstationsWorkstationConfigContainerToTerraform(struct?: GoogleWorkstationsWorkstationConfigContainerOutputReference | GoogleWorkstationsWorkstationConfigContainer): any;
export declare class GoogleWorkstationsWorkstationConfigContainerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleWorkstationsWorkstationConfigContainer | undefined;
    set internalValue(value: GoogleWorkstationsWorkstationConfigContainer | undefined);
    private _args?;
    get args(): string[];
    set args(value: string[]);
    resetArgs(): void;
    get argsInput(): string[] | undefined;
    private _command?;
    get command(): string[];
    set command(value: string[]);
    resetCommand(): void;
    get commandInput(): string[] | undefined;
    private _env?;
    get env(): {
        [key: string]: string;
    };
    set env(value: {
        [key: string]: string;
    });
    resetEnv(): void;
    get envInput(): {
        [key: string]: string;
    } | undefined;
    private _image?;
    get image(): string;
    set image(value: string);
    resetImage(): void;
    get imageInput(): string | undefined;
    private _runAsUser?;
    get runAsUser(): number;
    set runAsUser(value: number);
    resetRunAsUser(): void;
    get runAsUserInput(): number | undefined;
    private _workingDir?;
    get workingDir(): string;
    set workingDir(value: string);
    resetWorkingDir(): void;
    get workingDirInput(): string | undefined;
}
export interface GoogleWorkstationsWorkstationConfigEncryptionKey {
    /**
    * The name of the Google Cloud KMS encryption key.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_config#kms_key GoogleWorkstationsWorkstationConfigA#kms_key}
    */
    readonly kmsKey: string;
    /**
    * The service account to use with the specified KMS key.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_config#kms_key_service_account GoogleWorkstationsWorkstationConfigA#kms_key_service_account}
    */
    readonly kmsKeyServiceAccount: string;
}
export declare function googleWorkstationsWorkstationConfigEncryptionKeyToTerraform(struct?: GoogleWorkstationsWorkstationConfigEncryptionKeyOutputReference | GoogleWorkstationsWorkstationConfigEncryptionKey): any;
export declare class GoogleWorkstationsWorkstationConfigEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleWorkstationsWorkstationConfigEncryptionKey | undefined;
    set internalValue(value: GoogleWorkstationsWorkstationConfigEncryptionKey | undefined);
    private _kmsKey?;
    get kmsKey(): string;
    set kmsKey(value: string);
    get kmsKeyInput(): string | undefined;
    private _kmsKeyServiceAccount?;
    get kmsKeyServiceAccount(): string;
    set kmsKeyServiceAccount(value: string);
    get kmsKeyServiceAccountInput(): string | undefined;
}
export interface GoogleWorkstationsWorkstationConfigHostGceInstanceConfidentialInstanceConfig {
    /**
    * Whether the instance has confidential compute enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_config#enable_confidential_compute GoogleWorkstationsWorkstationConfigA#enable_confidential_compute}
    */
    readonly enableConfidentialCompute?: boolean | cdktf.IResolvable;
}
export declare function googleWorkstationsWorkstationConfigHostGceInstanceConfidentialInstanceConfigToTerraform(struct?: GoogleWorkstationsWorkstationConfigHostGceInstanceConfidentialInstanceConfigOutputReference | GoogleWorkstationsWorkstationConfigHostGceInstanceConfidentialInstanceConfig): any;
export declare class GoogleWorkstationsWorkstationConfigHostGceInstanceConfidentialInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleWorkstationsWorkstationConfigHostGceInstanceConfidentialInstanceConfig | undefined;
    set internalValue(value: GoogleWorkstationsWorkstationConfigHostGceInstanceConfidentialInstanceConfig | undefined);
    private _enableConfidentialCompute?;
    get enableConfidentialCompute(): boolean | cdktf.IResolvable;
    set enableConfidentialCompute(value: boolean | cdktf.IResolvable);
    resetEnableConfidentialCompute(): void;
    get enableConfidentialComputeInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleWorkstationsWorkstationConfigHostGceInstanceShieldedInstanceConfig {
    /**
    * Whether the instance has integrity monitoring enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_config#enable_integrity_monitoring GoogleWorkstationsWorkstationConfigA#enable_integrity_monitoring}
    */
    readonly enableIntegrityMonitoring?: boolean | cdktf.IResolvable;
    /**
    * Whether the instance has Secure Boot enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_config#enable_secure_boot GoogleWorkstationsWorkstationConfigA#enable_secure_boot}
    */
    readonly enableSecureBoot?: boolean | cdktf.IResolvable;
    /**
    * Whether the instance has the vTPM enabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_config#enable_vtpm GoogleWorkstationsWorkstationConfigA#enable_vtpm}
    */
    readonly enableVtpm?: boolean | cdktf.IResolvable;
}
export declare function googleWorkstationsWorkstationConfigHostGceInstanceShieldedInstanceConfigToTerraform(struct?: GoogleWorkstationsWorkstationConfigHostGceInstanceShieldedInstanceConfigOutputReference | GoogleWorkstationsWorkstationConfigHostGceInstanceShieldedInstanceConfig): any;
export declare class GoogleWorkstationsWorkstationConfigHostGceInstanceShieldedInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleWorkstationsWorkstationConfigHostGceInstanceShieldedInstanceConfig | undefined;
    set internalValue(value: GoogleWorkstationsWorkstationConfigHostGceInstanceShieldedInstanceConfig | undefined);
    private _enableIntegrityMonitoring?;
    get enableIntegrityMonitoring(): boolean | cdktf.IResolvable;
    set enableIntegrityMonitoring(value: boolean | cdktf.IResolvable);
    resetEnableIntegrityMonitoring(): void;
    get enableIntegrityMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _enableSecureBoot?;
    get enableSecureBoot(): boolean | cdktf.IResolvable;
    set enableSecureBoot(value: boolean | cdktf.IResolvable);
    resetEnableSecureBoot(): void;
    get enableSecureBootInput(): boolean | cdktf.IResolvable | undefined;
    private _enableVtpm?;
    get enableVtpm(): boolean | cdktf.IResolvable;
    set enableVtpm(value: boolean | cdktf.IResolvable);
    resetEnableVtpm(): void;
    get enableVtpmInput(): boolean | cdktf.IResolvable | undefined;
}
export interface GoogleWorkstationsWorkstationConfigHostGceInstance {
    /**
    * Size of the boot disk in GB.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_config#boot_disk_size_gb GoogleWorkstationsWorkstationConfigA#boot_disk_size_gb}
    */
    readonly bootDiskSizeGb?: number;
    /**
    * Whether instances have no public IP address.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_config#disable_public_ip_addresses GoogleWorkstationsWorkstationConfigA#disable_public_ip_addresses}
    */
    readonly disablePublicIpAddresses?: boolean | cdktf.IResolvable;
    /**
    * The name of a Compute Engine machine type.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_config#machine_type GoogleWorkstationsWorkstationConfigA#machine_type}
    */
    readonly machineType?: string;
    /**
    * Number of instances to pool for faster workstation startup.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_config#pool_size GoogleWorkstationsWorkstationConfigA#pool_size}
    */
    readonly poolSize?: number;
    /**
    * Email address of the service account that will be used on VM instances used to support this config. This service account must have permission to pull the specified container image. If not set, VMs will run without a service account, in which case the image must be publicly accessible.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_config#service_account GoogleWorkstationsWorkstationConfigA#service_account}
    */
    readonly serviceAccount?: string;
    /**
    * Network tags to add to the Compute Engine machines backing the Workstations.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_config#tags GoogleWorkstationsWorkstationConfigA#tags}
    */
    readonly tags?: string[];
    /**
    * confidential_instance_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_config#confidential_instance_config GoogleWorkstationsWorkstationConfigA#confidential_instance_config}
    */
    readonly confidentialInstanceConfig?: GoogleWorkstationsWorkstationConfigHostGceInstanceConfidentialInstanceConfig;
    /**
    * shielded_instance_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_config#shielded_instance_config GoogleWorkstationsWorkstationConfigA#shielded_instance_config}
    */
    readonly shieldedInstanceConfig?: GoogleWorkstationsWorkstationConfigHostGceInstanceShieldedInstanceConfig;
}
export declare function googleWorkstationsWorkstationConfigHostGceInstanceToTerraform(struct?: GoogleWorkstationsWorkstationConfigHostGceInstanceOutputReference | GoogleWorkstationsWorkstationConfigHostGceInstance): any;
export declare class GoogleWorkstationsWorkstationConfigHostGceInstanceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleWorkstationsWorkstationConfigHostGceInstance | undefined;
    set internalValue(value: GoogleWorkstationsWorkstationConfigHostGceInstance | undefined);
    private _bootDiskSizeGb?;
    get bootDiskSizeGb(): number;
    set bootDiskSizeGb(value: number);
    resetBootDiskSizeGb(): void;
    get bootDiskSizeGbInput(): number | undefined;
    private _disablePublicIpAddresses?;
    get disablePublicIpAddresses(): boolean | cdktf.IResolvable;
    set disablePublicIpAddresses(value: boolean | cdktf.IResolvable);
    resetDisablePublicIpAddresses(): void;
    get disablePublicIpAddressesInput(): boolean | cdktf.IResolvable | undefined;
    private _machineType?;
    get machineType(): string;
    set machineType(value: string);
    resetMachineType(): void;
    get machineTypeInput(): string | undefined;
    private _poolSize?;
    get poolSize(): number;
    set poolSize(value: number);
    resetPoolSize(): void;
    get poolSizeInput(): number | undefined;
    private _serviceAccount?;
    get serviceAccount(): string;
    set serviceAccount(value: string);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _confidentialInstanceConfig;
    get confidentialInstanceConfig(): GoogleWorkstationsWorkstationConfigHostGceInstanceConfidentialInstanceConfigOutputReference;
    putConfidentialInstanceConfig(value: GoogleWorkstationsWorkstationConfigHostGceInstanceConfidentialInstanceConfig): void;
    resetConfidentialInstanceConfig(): void;
    get confidentialInstanceConfigInput(): GoogleWorkstationsWorkstationConfigHostGceInstanceConfidentialInstanceConfig | undefined;
    private _shieldedInstanceConfig;
    get shieldedInstanceConfig(): GoogleWorkstationsWorkstationConfigHostGceInstanceShieldedInstanceConfigOutputReference;
    putShieldedInstanceConfig(value: GoogleWorkstationsWorkstationConfigHostGceInstanceShieldedInstanceConfig): void;
    resetShieldedInstanceConfig(): void;
    get shieldedInstanceConfigInput(): GoogleWorkstationsWorkstationConfigHostGceInstanceShieldedInstanceConfig | undefined;
}
export interface GoogleWorkstationsWorkstationConfigHost {
    /**
    * gce_instance block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_config#gce_instance GoogleWorkstationsWorkstationConfigA#gce_instance}
    */
    readonly gceInstance?: GoogleWorkstationsWorkstationConfigHostGceInstance;
}
export declare function googleWorkstationsWorkstationConfigHostToTerraform(struct?: GoogleWorkstationsWorkstationConfigHostOutputReference | GoogleWorkstationsWorkstationConfigHost): any;
export declare class GoogleWorkstationsWorkstationConfigHostOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleWorkstationsWorkstationConfigHost | undefined;
    set internalValue(value: GoogleWorkstationsWorkstationConfigHost | undefined);
    private _gceInstance;
    get gceInstance(): GoogleWorkstationsWorkstationConfigHostGceInstanceOutputReference;
    putGceInstance(value: GoogleWorkstationsWorkstationConfigHostGceInstance): void;
    resetGceInstance(): void;
    get gceInstanceInput(): GoogleWorkstationsWorkstationConfigHostGceInstance | undefined;
}
export interface GoogleWorkstationsWorkstationConfigPersistentDirectoriesGcePd {
    /**
    * Type of the disk to use.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_config#disk_type GoogleWorkstationsWorkstationConfigA#disk_type}
    */
    readonly diskType?: string;
    /**
    * Type of file system that the disk should be formatted with. The workstation image must support this file system type. Must be empty if sourceSnapshot is set.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_config#fs_type GoogleWorkstationsWorkstationConfigA#fs_type}
    */
    readonly fsType?: string;
    /**
    * What should happen to the disk after the workstation is deleted. Defaults to DELETE. Possible values: ["RECLAIM_POLICY_UNSPECIFIED", "DELETE", "RETAIN"]
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_config#reclaim_policy GoogleWorkstationsWorkstationConfigA#reclaim_policy}
    */
    readonly reclaimPolicy?: string;
    /**
    * Size of the disk in GB. Must be empty if sourceSnapshot is set.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_config#size_gb GoogleWorkstationsWorkstationConfigA#size_gb}
    */
    readonly sizeGb?: number;
}
export declare function googleWorkstationsWorkstationConfigPersistentDirectoriesGcePdToTerraform(struct?: GoogleWorkstationsWorkstationConfigPersistentDirectoriesGcePdOutputReference | GoogleWorkstationsWorkstationConfigPersistentDirectoriesGcePd): any;
export declare class GoogleWorkstationsWorkstationConfigPersistentDirectoriesGcePdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleWorkstationsWorkstationConfigPersistentDirectoriesGcePd | undefined;
    set internalValue(value: GoogleWorkstationsWorkstationConfigPersistentDirectoriesGcePd | undefined);
    private _diskType?;
    get diskType(): string;
    set diskType(value: string);
    resetDiskType(): void;
    get diskTypeInput(): string | undefined;
    private _fsType?;
    get fsType(): string;
    set fsType(value: string);
    resetFsType(): void;
    get fsTypeInput(): string | undefined;
    private _reclaimPolicy?;
    get reclaimPolicy(): string;
    set reclaimPolicy(value: string);
    resetReclaimPolicy(): void;
    get reclaimPolicyInput(): string | undefined;
    private _sizeGb?;
    get sizeGb(): number;
    set sizeGb(value: number);
    resetSizeGb(): void;
    get sizeGbInput(): number | undefined;
}
export interface GoogleWorkstationsWorkstationConfigPersistentDirectories {
    /**
    * Location of this directory in the running workstation.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_config#mount_path GoogleWorkstationsWorkstationConfigA#mount_path}
    */
    readonly mountPath?: string;
    /**
    * gce_pd block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_config#gce_pd GoogleWorkstationsWorkstationConfigA#gce_pd}
    */
    readonly gcePd?: GoogleWorkstationsWorkstationConfigPersistentDirectoriesGcePd;
}
export declare function googleWorkstationsWorkstationConfigPersistentDirectoriesToTerraform(struct?: GoogleWorkstationsWorkstationConfigPersistentDirectories | cdktf.IResolvable): any;
export declare class GoogleWorkstationsWorkstationConfigPersistentDirectoriesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GoogleWorkstationsWorkstationConfigPersistentDirectories | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleWorkstationsWorkstationConfigPersistentDirectories | cdktf.IResolvable | undefined);
    private _mountPath?;
    get mountPath(): string;
    set mountPath(value: string);
    resetMountPath(): void;
    get mountPathInput(): string | undefined;
    private _gcePd;
    get gcePd(): GoogleWorkstationsWorkstationConfigPersistentDirectoriesGcePdOutputReference;
    putGcePd(value: GoogleWorkstationsWorkstationConfigPersistentDirectoriesGcePd): void;
    resetGcePd(): void;
    get gcePdInput(): GoogleWorkstationsWorkstationConfigPersistentDirectoriesGcePd | undefined;
}
export declare class GoogleWorkstationsWorkstationConfigPersistentDirectoriesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: GoogleWorkstationsWorkstationConfigPersistentDirectories[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GoogleWorkstationsWorkstationConfigPersistentDirectoriesOutputReference;
}
export interface GoogleWorkstationsWorkstationConfigTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_config#create GoogleWorkstationsWorkstationConfigA#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_config#delete GoogleWorkstationsWorkstationConfigA#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_config#update GoogleWorkstationsWorkstationConfigA#update}
    */
    readonly update?: string;
}
export declare function googleWorkstationsWorkstationConfigTimeoutsToTerraform(struct?: GoogleWorkstationsWorkstationConfigTimeouts | cdktf.IResolvable): any;
export declare class GoogleWorkstationsWorkstationConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GoogleWorkstationsWorkstationConfigTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: GoogleWorkstationsWorkstationConfigTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_config google_workstations_workstation_config}
*/
export declare class GoogleWorkstationsWorkstationConfigA extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_workstations_workstation_config";
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/google-beta/4.62.0/docs/resources/google_workstations_workstation_config google_workstations_workstation_config} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GoogleWorkstationsWorkstationConfigAConfig
    */
    constructor(scope: Construct, id: string, config: GoogleWorkstationsWorkstationConfigAConfig);
    private _annotations?;
    get annotations(): {
        [key: string]: string;
    };
    set annotations(value: {
        [key: string]: string;
    });
    resetAnnotations(): void;
    get annotationsInput(): {
        [key: string]: string;
    } | undefined;
    private _conditions;
    get conditions(): GoogleWorkstationsWorkstationConfigConditionsList;
    get createTime(): string;
    get degraded(): cdktf.IResolvable;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get uid(): string;
    private _workstationClusterId?;
    get workstationClusterId(): string;
    set workstationClusterId(value: string);
    get workstationClusterIdInput(): string | undefined;
    private _workstationConfigId?;
    get workstationConfigId(): string;
    set workstationConfigId(value: string);
    get workstationConfigIdInput(): string | undefined;
    private _container;
    get container(): GoogleWorkstationsWorkstationConfigContainerOutputReference;
    putContainer(value: GoogleWorkstationsWorkstationConfigContainer): void;
    resetContainer(): void;
    get containerInput(): GoogleWorkstationsWorkstationConfigContainer | undefined;
    private _encryptionKey;
    get encryptionKey(): GoogleWorkstationsWorkstationConfigEncryptionKeyOutputReference;
    putEncryptionKey(value: GoogleWorkstationsWorkstationConfigEncryptionKey): void;
    resetEncryptionKey(): void;
    get encryptionKeyInput(): GoogleWorkstationsWorkstationConfigEncryptionKey | undefined;
    private _host;
    get host(): GoogleWorkstationsWorkstationConfigHostOutputReference;
    putHost(value: GoogleWorkstationsWorkstationConfigHost): void;
    resetHost(): void;
    get hostInput(): GoogleWorkstationsWorkstationConfigHost | undefined;
    private _persistentDirectories;
    get persistentDirectories(): GoogleWorkstationsWorkstationConfigPersistentDirectoriesList;
    putPersistentDirectories(value: GoogleWorkstationsWorkstationConfigPersistentDirectories[] | cdktf.IResolvable): void;
    resetPersistentDirectories(): void;
    get persistentDirectoriesInput(): cdktf.IResolvable | GoogleWorkstationsWorkstationConfigPersistentDirectories[] | undefined;
    private _timeouts;
    get timeouts(): GoogleWorkstationsWorkstationConfigTimeoutsOutputReference;
    putTimeouts(value: GoogleWorkstationsWorkstationConfigTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | GoogleWorkstationsWorkstationConfigTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
