import { TypeScriptAppProject, TypeScriptProjectOptions } from "../typescript";
import { AwsCdkDeps, AwsCdkDepsCommonOptions } from "./awscdk-deps";
import { CdkConfig, CdkConfigCommonOptions } from "./cdk-config";
import { CdkTasks } from "./cdk-tasks";
import { LambdaFunctionCommonOptions } from "./lambda-function";
export interface AwsCdkTypeScriptAppOptions extends TypeScriptProjectOptions, CdkConfigCommonOptions, AwsCdkDepsCommonOptions {
    /**
     * The CDK app's entrypoint (relative to the source directory, which is
     * "src" by default).
     *
     * @default "main.ts"
     */
    readonly appEntrypoint?: string;
    /**
     * Automatically adds an `awscdk.LambdaFunction` for each `.lambda.ts` handler
     * in your source tree. If this is disabled, you can manually add an
     * `awscdk.AutoDiscover` component to your project.
     *
     * @default true
     */
    readonly lambdaAutoDiscover?: boolean;
    /**
     * Automatically adds an `cloudfront.experimental.EdgeFunction` for each
     * `.edge-lambda.ts` handler in your source tree. If this is disabled, you can
     * manually add an `awscdk.AutoDiscover` component to your project.
     *
     * @default true
     */
    readonly edgeLambdaAutoDiscover?: boolean;
    /**
     * Automatically adds an `awscdk.LambdaExtension` for each `.lambda-extension.ts`
     * entrypoint in your source tree. If this is disabled, you can manually add an
     * `awscdk.AutoDiscover` component to your project
     *
     * @default true
     */
    readonly lambdaExtensionAutoDiscover?: boolean;
    /**
     * Automatically discovers and creates integration tests for each `.integ.ts`
     * file in under your test directory.
     *
     * @default true
     */
    readonly integrationTestAutoDiscover?: boolean;
    /**
     * Common options for all AWS Lambda functions.
     *
     * @default - default options
     */
    readonly lambdaOptions?: LambdaFunctionCommonOptions;
}
/**
 * AWS CDK app in TypeScript
 *
 * @pjid awscdk-app-ts
 */
export declare class AwsCdkTypeScriptApp extends TypeScriptAppProject {
    /**
     * The CDK version this app is using.
     */
    get cdkVersion(): string;
    /**
     * The CDK app entrypoint
     */
    readonly appEntrypoint: string;
    /**
     * Common CDK tasks.
     */
    readonly cdkTasks: CdkTasks;
    /**
     * cdk.json configuration.
     */
    readonly cdkConfig: CdkConfig;
    readonly cdkDeps: AwsCdkDeps;
    constructor(options: AwsCdkTypeScriptAppOptions);
    /**
     * Adds an AWS CDK module dependencies
     * @param modules The list of modules to depend on
     */
    addCdkDependency(...modules: string[]): void;
}
