"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConstructLibraryCdk8s = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const semver = require("semver");
const cdk_1 = require("../cdk");
const auto_discover_1 = require("./auto-discover");
/**
 * CDK8s construct library project
 *
 * A multi-language (jsii) construct library which vends constructs designed to
 * use within the CDK for Kubernetes (CDK8s), with a friendly workflow and
 * automatic publishing to the construct catalog.
 *
 * @pjid cdk8s-construct
 */
class ConstructLibraryCdk8s extends cdk_1.ConstructLibrary {
    constructor(options) {
        super(options);
        if (!options.cdk8sVersion) {
            throw new Error("Required field cdk8sVersion is not specified.");
        }
        const cdk8sVersion = semver.parse(options.cdk8sVersion);
        if (!cdk8sVersion) {
            throw new Error(`"cdk8sVersion" cannot be parsed as a semver version: ${options.cdk8sVersion}`);
        }
        this.cdk8sVersion = options.cdk8sVersionPinning
            ? options.cdk8sVersion
            : `^${options.cdk8sVersion}`;
        const defaultConstructsVersion = cdk8sVersion.major === 1 ? "3.3.196" : "10.0.0";
        const resolvedConstructsVersion = options.constructsVersion ?? defaultConstructsVersion;
        const resolvedMajorConstructVersion = semver.parse(resolvedConstructsVersion)?.major;
        if (!resolvedMajorConstructVersion) {
            throw new Error(`"constructsVersion" cannot be parsed as a semver version: ${options.constructsVersion}`);
        }
        switch (cdk8sVersion.major) {
            case 1:
                if (resolvedMajorConstructVersion !== 3) {
                    throw new Error("cdk8s 1.x requires constructs 3.x");
                }
                break;
            case 2:
                if (resolvedMajorConstructVersion !== 10) {
                    throw new Error("cdk8s 2.x requires constructs 10.x");
                }
                break;
        }
        this.constructsVersion = options.constructsVersionPinning
            ? resolvedConstructsVersion
            : `^${resolvedConstructsVersion}`;
        this.addPeerDeps(`constructs@${this.constructsVersion}`, `cdk8s@${this.cdk8sVersion}`);
        new auto_discover_1.AutoDiscover(this, {
            testdir: this.testdir,
            tsconfigPath: this.tsconfigDev.fileName,
            integrationTestAutoDiscover: options.integrationTestAutoDiscover ?? true,
        });
    }
}
exports.ConstructLibraryCdk8s = ConstructLibraryCdk8s;
_a = JSII_RTTI_SYMBOL_1;
ConstructLibraryCdk8s[_a] = { fqn: "projen.cdk8s.ConstructLibraryCdk8s", version: "0.65.85" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2RrOHMtY29uc3RydWN0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL2NkazhzL2NkazhzLWNvbnN0cnVjdC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLGlDQUFpQztBQUNqQyxnQ0FBbUU7QUFDbkUsbURBQStDO0FBMkQvQzs7Ozs7Ozs7R0FRRztBQUNILE1BQWEscUJBQXNCLFNBQVEsc0JBQWdCO0lBV3pELFlBQVksT0FBcUM7UUFDL0MsS0FBSyxDQUFDLE9BQU8sQ0FBQyxDQUFDO1FBRWYsSUFBSSxDQUFDLE9BQU8sQ0FBQyxZQUFZLEVBQUU7WUFDekIsTUFBTSxJQUFJLEtBQUssQ0FBQywrQ0FBK0MsQ0FBQyxDQUFDO1NBQ2xFO1FBRUQsTUFBTSxZQUFZLEdBQUcsTUFBTSxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsWUFBWSxDQUFDLENBQUM7UUFDeEQsSUFBSSxDQUFDLFlBQVksRUFBRTtZQUNqQixNQUFNLElBQUksS0FBSyxDQUNiLHdEQUF3RCxPQUFPLENBQUMsWUFBWSxFQUFFLENBQy9FLENBQUM7U0FDSDtRQUVELElBQUksQ0FBQyxZQUFZLEdBQUcsT0FBTyxDQUFDLG1CQUFtQjtZQUM3QyxDQUFDLENBQUMsT0FBTyxDQUFDLFlBQVk7WUFDdEIsQ0FBQyxDQUFDLElBQUksT0FBTyxDQUFDLFlBQVksRUFBRSxDQUFDO1FBRS9CLE1BQU0sd0JBQXdCLEdBQzVCLFlBQVksQ0FBQyxLQUFLLEtBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDLFFBQVEsQ0FBQztRQUNsRCxNQUFNLHlCQUF5QixHQUM3QixPQUFPLENBQUMsaUJBQWlCLElBQUksd0JBQXdCLENBQUM7UUFDeEQsTUFBTSw2QkFBNkIsR0FBRyxNQUFNLENBQUMsS0FBSyxDQUNoRCx5QkFBeUIsQ0FDMUIsRUFBRSxLQUFLLENBQUM7UUFFVCxJQUFJLENBQUMsNkJBQTZCLEVBQUU7WUFDbEMsTUFBTSxJQUFJLEtBQUssQ0FDYiw2REFBNkQsT0FBTyxDQUFDLGlCQUFpQixFQUFFLENBQ3pGLENBQUM7U0FDSDtRQUVELFFBQVEsWUFBWSxDQUFDLEtBQUssRUFBRTtZQUMxQixLQUFLLENBQUM7Z0JBQ0osSUFBSSw2QkFBNkIsS0FBSyxDQUFDLEVBQUU7b0JBQ3ZDLE1BQU0sSUFBSSxLQUFLLENBQUMsbUNBQW1DLENBQUMsQ0FBQztpQkFDdEQ7Z0JBQ0QsTUFBTTtZQUNSLEtBQUssQ0FBQztnQkFDSixJQUFJLDZCQUE2QixLQUFLLEVBQUUsRUFBRTtvQkFDeEMsTUFBTSxJQUFJLEtBQUssQ0FBQyxvQ0FBb0MsQ0FBQyxDQUFDO2lCQUN2RDtnQkFDRCxNQUFNO1NBQ1Q7UUFFRCxJQUFJLENBQUMsaUJBQWlCLEdBQUcsT0FBTyxDQUFDLHdCQUF3QjtZQUN2RCxDQUFDLENBQUMseUJBQXlCO1lBQzNCLENBQUMsQ0FBQyxJQUFJLHlCQUF5QixFQUFFLENBQUM7UUFFcEMsSUFBSSxDQUFDLFdBQVcsQ0FDZCxjQUFjLElBQUksQ0FBQyxpQkFBaUIsRUFBRSxFQUN0QyxTQUFTLElBQUksQ0FBQyxZQUFZLEVBQUUsQ0FDN0IsQ0FBQztRQUVGLElBQUksNEJBQVksQ0FBQyxJQUFJLEVBQUU7WUFDckIsT0FBTyxFQUFFLElBQUksQ0FBQyxPQUFPO1lBQ3JCLFlBQVksRUFBRSxJQUFJLENBQUMsV0FBVyxDQUFDLFFBQVE7WUFDdkMsMkJBQTJCLEVBQUUsT0FBTyxDQUFDLDJCQUEyQixJQUFJLElBQUk7U0FDekUsQ0FBQyxDQUFDO0lBQ0wsQ0FBQzs7QUF0RUgsc0RBdUVDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgc2VtdmVyIGZyb20gXCJzZW12ZXJcIjtcbmltcG9ydCB7IENvbnN0cnVjdExpYnJhcnksIENvbnN0cnVjdExpYnJhcnlPcHRpb25zIH0gZnJvbSBcIi4uL2Nka1wiO1xuaW1wb3J0IHsgQXV0b0Rpc2NvdmVyIH0gZnJvbSBcIi4vYXV0by1kaXNjb3ZlclwiO1xuXG5leHBvcnQgaW50ZXJmYWNlIENvbnN0cnVjdExpYnJhcnlDZGs4c09wdGlvbnMgZXh0ZW5kcyBDb25zdHJ1Y3RMaWJyYXJ5T3B0aW9ucyB7XG4gIC8qKlxuICAgKiBNaW5pbXVtIHRhcmdldCB2ZXJzaW9uIHRoaXMgbGlicmFyeSBpcyB0ZXN0ZWQgYWdhaW5zdC5cbiAgICpcbiAgICogQGRlZmF1bHQgXCIxLjQuMTBcIlxuICAgKiBAZmVhdHVyZWRcbiAgICovXG4gIHJlYWRvbmx5IGNkazhzVmVyc2lvbjogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBjb25zdHJ1Y3RzIHZlcmlvblxuICAgKlxuICAgKiBAZGVmYXVsdCBcIjMuMy4xOTZcIlxuICAgKi9cblxuICByZWFkb25seSBjb25zdHJ1Y3RzVmVyc2lvbj86IHN0cmluZztcblxuICAvKipcbiAgICogVXNlIHBpbm5lZCB2ZXJzaW9uIGluc3RlYWQgb2YgY2FyZXQgdmVyc2lvbiBmb3IgQ0RLOHMuXG4gICAqXG4gICAqIFlvdSBjYW4gdXNlIHRoaXMgdG8gcHJldmVudCB5YXJuIHRvIG1peCB2ZXJzaW9ucyBmb3IgeW91ciBDREs4cyBwYWNrYWdlIGFuZCB0byBwcmV2ZW50IGF1dG8tdXBkYXRlcy5cbiAgICogSWYgeW91IHVzZSBleHBlcmltZW50YWwgZmVhdHVyZXMgdGhpcyB3aWxsIGxldCB5b3UgZGVmaW5lIHRoZSBtb21lbnQgeW91IGluY2x1ZGUgYnJlYWtpbmcgY2hhbmdlcy5cbiAgICpcbiAgICogQGRlZmF1bHQgZmFsc2VcbiAgICovXG4gIHJlYWRvbmx5IGNkazhzVmVyc2lvblBpbm5pbmc/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBVc2UgcGlubmVkIHZlcnNpb24gaW5zdGVhZCBvZiBjYXJldCB2ZXJzaW9uIGZvciBjb25zdHJ1Y3RzLlxuICAgKlxuICAgKiBZb3UgY2FuIHVzZSB0aGlzIHRvIHByZXZlbnQgeWFybiB0byBtaXggdmVyc2lvbnMgZm9yIHlvdXIgY29uc3J1Y3RzIHBhY2thZ2UgYW5kIHRvIHByZXZlbnQgYXV0by11cGRhdGVzLlxuICAgKiBJZiB5b3UgdXNlIGV4cGVyaW1lbnRhbCBmZWF0dXJlcyB0aGlzIHdpbGwgbGV0IHlvdSBkZWZpbmUgdGhlIG1vbWVudCB5b3UgaW5jbHVkZSBicmVha2luZyBjaGFuZ2VzLlxuICAgKlxuICAgKiBAZGVmYXVsdCBmYWxzZVxuICAgKi9cbiAgcmVhZG9ubHkgY29uc3RydWN0c1ZlcnNpb25QaW5uaW5nPzogYm9vbGVhbjtcblxuICAvKipcbiAgICogVXNlIHBpbm5lZCB2ZXJzaW9uIGluc3RlYWQgb2YgY2FyZXQgdmVyc2lvbiBmb3IgY2RrOHMtcGx1cy0xNy5cbiAgICpcbiAgICogWW91IGNhbiB1c2UgdGhpcyB0byBwcmV2ZW50IHlhcm4gdG8gbWl4IHZlcnNpb25zIGZvciB5b3VyIENESzhzIHBhY2thZ2UgYW5kIHRvIHByZXZlbnQgYXV0by11cGRhdGVzLlxuICAgKiBJZiB5b3UgdXNlIGV4cGVyaW1lbnRhbCBmZWF0dXJlcyB0aGlzIHdpbGwgbGV0IHlvdSBkZWZpbmUgdGhlIG1vbWVudCB5b3UgaW5jbHVkZSBicmVha2luZyBjaGFuZ2VzLlxuICAgKlxuICAgKiBAZGVmYXVsdCBmYWxzZVxuICAgKi9cbiAgcmVhZG9ubHkgY2RrOHNQbHVzVmVyc2lvblBpbm5pbmc/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBBdXRvbWF0aWNhbGx5IGFkZHMgYW4gYGNkazhzLkludGVncmF0aW9uVGVzdGAgZm9yIGVhY2ggYC5pbnRlZy50c2AgYXBwXG4gICAqIGluIHlvdXIgdGVzdCBkaXJlY3RvcnkuIElmIHRoaXMgaXMgZGlzYWJsZWQsIHlvdSBjYW4gbWFudWFsbHkgYWRkIGFuXG4gICAqIGBjZGs4cy5BdXRvRGlzY292ZXJgIGNvbXBvbmVudCB0byB5b3VyIHByb2plY3QuXG4gICAqXG4gICAqIEBkZWZhdWx0IHRydWVcbiAgICovXG4gIHJlYWRvbmx5IGludGVncmF0aW9uVGVzdEF1dG9EaXNjb3Zlcj86IGJvb2xlYW47XG59XG5cbi8qKlxuICogQ0RLOHMgY29uc3RydWN0IGxpYnJhcnkgcHJvamVjdFxuICpcbiAqIEEgbXVsdGktbGFuZ3VhZ2UgKGpzaWkpIGNvbnN0cnVjdCBsaWJyYXJ5IHdoaWNoIHZlbmRzIGNvbnN0cnVjdHMgZGVzaWduZWQgdG9cbiAqIHVzZSB3aXRoaW4gdGhlIENESyBmb3IgS3ViZXJuZXRlcyAoQ0RLOHMpLCB3aXRoIGEgZnJpZW5kbHkgd29ya2Zsb3cgYW5kXG4gKiBhdXRvbWF0aWMgcHVibGlzaGluZyB0byB0aGUgY29uc3RydWN0IGNhdGFsb2cuXG4gKlxuICogQHBqaWQgY2RrOHMtY29uc3RydWN0XG4gKi9cbmV4cG9ydCBjbGFzcyBDb25zdHJ1Y3RMaWJyYXJ5Q2RrOHMgZXh0ZW5kcyBDb25zdHJ1Y3RMaWJyYXJ5IHtcbiAgLyoqXG4gICAqIFRoZSBDREs4cyB2ZXJzaW9uIHRoaXMgYXBwIGlzIHVzaW5nLlxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IGNkazhzVmVyc2lvbjogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgY29uc3RydWN0cyB2ZXJzaW9uIHRoaXMgYXBwIGlzIHVzaW5nLlxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IGNvbnN0cnVjdHNWZXJzaW9uOiBzdHJpbmc7XG5cbiAgY29uc3RydWN0b3Iob3B0aW9uczogQ29uc3RydWN0TGlicmFyeUNkazhzT3B0aW9ucykge1xuICAgIHN1cGVyKG9wdGlvbnMpO1xuXG4gICAgaWYgKCFvcHRpb25zLmNkazhzVmVyc2lvbikge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKFwiUmVxdWlyZWQgZmllbGQgY2RrOHNWZXJzaW9uIGlzIG5vdCBzcGVjaWZpZWQuXCIpO1xuICAgIH1cblxuICAgIGNvbnN0IGNkazhzVmVyc2lvbiA9IHNlbXZlci5wYXJzZShvcHRpb25zLmNkazhzVmVyc2lvbik7XG4gICAgaWYgKCFjZGs4c1ZlcnNpb24pIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcihcbiAgICAgICAgYFwiY2RrOHNWZXJzaW9uXCIgY2Fubm90IGJlIHBhcnNlZCBhcyBhIHNlbXZlciB2ZXJzaW9uOiAke29wdGlvbnMuY2RrOHNWZXJzaW9ufWBcbiAgICAgICk7XG4gICAgfVxuXG4gICAgdGhpcy5jZGs4c1ZlcnNpb24gPSBvcHRpb25zLmNkazhzVmVyc2lvblBpbm5pbmdcbiAgICAgID8gb3B0aW9ucy5jZGs4c1ZlcnNpb25cbiAgICAgIDogYF4ke29wdGlvbnMuY2RrOHNWZXJzaW9ufWA7XG5cbiAgICBjb25zdCBkZWZhdWx0Q29uc3RydWN0c1ZlcnNpb24gPVxuICAgICAgY2RrOHNWZXJzaW9uLm1ham9yID09PSAxID8gXCIzLjMuMTk2XCIgOiBcIjEwLjAuMFwiO1xuICAgIGNvbnN0IHJlc29sdmVkQ29uc3RydWN0c1ZlcnNpb24gPVxuICAgICAgb3B0aW9ucy5jb25zdHJ1Y3RzVmVyc2lvbiA/PyBkZWZhdWx0Q29uc3RydWN0c1ZlcnNpb247XG4gICAgY29uc3QgcmVzb2x2ZWRNYWpvckNvbnN0cnVjdFZlcnNpb24gPSBzZW12ZXIucGFyc2UoXG4gICAgICByZXNvbHZlZENvbnN0cnVjdHNWZXJzaW9uXG4gICAgKT8ubWFqb3I7XG5cbiAgICBpZiAoIXJlc29sdmVkTWFqb3JDb25zdHJ1Y3RWZXJzaW9uKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoXG4gICAgICAgIGBcImNvbnN0cnVjdHNWZXJzaW9uXCIgY2Fubm90IGJlIHBhcnNlZCBhcyBhIHNlbXZlciB2ZXJzaW9uOiAke29wdGlvbnMuY29uc3RydWN0c1ZlcnNpb259YFxuICAgICAgKTtcbiAgICB9XG5cbiAgICBzd2l0Y2ggKGNkazhzVmVyc2lvbi5tYWpvcikge1xuICAgICAgY2FzZSAxOlxuICAgICAgICBpZiAocmVzb2x2ZWRNYWpvckNvbnN0cnVjdFZlcnNpb24gIT09IDMpIHtcbiAgICAgICAgICB0aHJvdyBuZXcgRXJyb3IoXCJjZGs4cyAxLnggcmVxdWlyZXMgY29uc3RydWN0cyAzLnhcIik7XG4gICAgICAgIH1cbiAgICAgICAgYnJlYWs7XG4gICAgICBjYXNlIDI6XG4gICAgICAgIGlmIChyZXNvbHZlZE1ham9yQ29uc3RydWN0VmVyc2lvbiAhPT0gMTApIHtcbiAgICAgICAgICB0aHJvdyBuZXcgRXJyb3IoXCJjZGs4cyAyLnggcmVxdWlyZXMgY29uc3RydWN0cyAxMC54XCIpO1xuICAgICAgICB9XG4gICAgICAgIGJyZWFrO1xuICAgIH1cblxuICAgIHRoaXMuY29uc3RydWN0c1ZlcnNpb24gPSBvcHRpb25zLmNvbnN0cnVjdHNWZXJzaW9uUGlubmluZ1xuICAgICAgPyByZXNvbHZlZENvbnN0cnVjdHNWZXJzaW9uXG4gICAgICA6IGBeJHtyZXNvbHZlZENvbnN0cnVjdHNWZXJzaW9ufWA7XG5cbiAgICB0aGlzLmFkZFBlZXJEZXBzKFxuICAgICAgYGNvbnN0cnVjdHNAJHt0aGlzLmNvbnN0cnVjdHNWZXJzaW9ufWAsXG4gICAgICBgY2RrOHNAJHt0aGlzLmNkazhzVmVyc2lvbn1gXG4gICAgKTtcblxuICAgIG5ldyBBdXRvRGlzY292ZXIodGhpcywge1xuICAgICAgdGVzdGRpcjogdGhpcy50ZXN0ZGlyLFxuICAgICAgdHNjb25maWdQYXRoOiB0aGlzLnRzY29uZmlnRGV2LmZpbGVOYW1lLFxuICAgICAgaW50ZWdyYXRpb25UZXN0QXV0b0Rpc2NvdmVyOiBvcHRpb25zLmludGVncmF0aW9uVGVzdEF1dG9EaXNjb3ZlciA/PyB0cnVlLFxuICAgIH0pO1xuICB9XG59XG4iXX0=