"use strict";
// @see https://circleci.com/docs/2.0/configuration-reference
Object.defineProperty(exports, "__esModule", { value: true });
exports.PipelineParameterType = exports.JobWhen = exports.ResourceClass = exports.JobType = void 0;
/**
 * A job may have a type of approval indicating it must be manually approved before downstream jobs may proceed
 * @see https://circleci.com/docs/2.0/configuration-reference/#type
 */
var JobType;
(function (JobType) {
    JobType["APPROVAL"] = "approval";
})(JobType = exports.JobType || (exports.JobType = {}));
/**
 * The resource_class feature allows configuring CPU and RAM resources for each job.
 * Different resource classes are available for different executors, as described in the tables below.
 * @see https://circleci.com/docs/2.0/configuration-reference/#resourceclass
 */
var ResourceClass;
(function (ResourceClass) {
    ResourceClass["SMALL"] = "small";
    ResourceClass["MEDIUM"] = "medium";
    ResourceClass["MEDIUM_PLUS"] = "medium+";
    ResourceClass["LARGE_X"] = "xlarge";
    ResourceClass["LARGE_2X"] = "2xlarge";
    ResourceClass["LARGE_2X_PLUS"] = "2xlarge+";
})(ResourceClass = exports.ResourceClass || (exports.ResourceClass = {}));
/**
 * Specify when to enable or disable the step.
 * @see https://circleci.com/docs/2.0/configuration-reference/#steps
 */
var JobWhen;
(function (JobWhen) {
    JobWhen["ALWAYS"] = "always";
    JobWhen["ON_SUCCESS"] = "on_success";
    JobWhen["ON_FAIL"] = "on_fail";
})(JobWhen = exports.JobWhen || (exports.JobWhen = {}));
/**
 * Pipeline parameter types
 * @see https://circleci.com/docs/2.0/reusing-config#parameter-syntax
 */
var PipelineParameterType;
(function (PipelineParameterType) {
    PipelineParameterType["STRING"] = "string";
    PipelineParameterType["BOOLEAN"] = "boolean";
    PipelineParameterType["INTEGER"] = "integer";
    PipelineParameterType["ENUM"] = "enum";
})(PipelineParameterType = exports.PipelineParameterType || (exports.PipelineParameterType = {}));
//# sourceMappingURL=data:application/json;base64,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