import { IResolver, FileBase } from "./file";
import { Project } from "./project";
/**
 * Assign attributes to file names in a git repository.
 *
 * @see https://git-scm.com/docs/gitattributes
 */
export declare class GitAttributesFile extends FileBase {
    private readonly attributes;
    constructor(project: Project);
    /**
     * Maps a set of attributes to a set of files.
     * @param glob Glob pattern to match files in the repo
     * @param attributes Attributes to assign to these files.
     */
    addAttributes(glob: string, ...attributes: string[]): void;
    protected synthesizeContent(_: IResolver): string | undefined;
}
