import { GitIdentity } from ".";
/**
 * Name of the artifact produced by the build job. Its contains the entire
 * working directory.
 */
export declare const BUILD_ARTIFACT_NAME = "build-artifact";
/**
 * Represents the github-actions user.
 *
 * Use this when you need to perform a commit as part of your workflow.
 */
export declare const DEFAULT_GITHUB_ACTIONS_USER: GitIdentity;
/**
 * Name of the permission back up file to include in the build artifact
 * to work around a GitHub Action bug that does not preserve file mode
 * permissions across upload and download actions.
 *
 * See {@link https://github.com/actions/upload-artifact/issues/38}
 */
export declare const PERMISSION_BACKUP_FILE = "permissions-backup.acl";
