import { Component } from "../component";
import { GitHub } from "./github";
/**
 * The Mergify conditional operators that can be used are: `or` and `and`.
 * Note: The number of nested conditions is limited to 3.
 * @see https://docs.mergify.io/conditions/#combining-conditions-with-operators
 */
export interface MergifyConditionalOperator {
    readonly or?: MergifyCondition[];
    readonly and?: MergifyCondition[];
}
export declare type MergifyCondition = string | MergifyConditionalOperator;
export interface MergifyRule {
    /**
     * The name of the rule. This is not used by the engine directly,
     * but is used when reporting information about a rule.
     */
    readonly name: string;
    /**
     * A list of Conditions string that must match against the
     * pull request for the rule to be applied.
     * @see https://docs.mergify.io/conditions/#conditions
     */
    readonly conditions: MergifyCondition[];
    /**
     * A dictionary made of Actions that will be executed on the
     * matching pull requests.
     * @see https://docs.mergify.io/actions/#actions
     */
    readonly actions: {
        [action: string]: any;
    };
}
export interface MergifyQueue {
    /**
     * The name of the queue.
     */
    readonly name: string;
    /**
     * A list of Conditions string that must match against the
     * pull request for the pull request to be added to the queue.
     * @see https://docs.mergify.com/conditions/#conditions
     */
    readonly conditions: MergifyCondition[];
}
export interface MergifyOptions {
    readonly rules?: MergifyRule[];
    readonly queues?: MergifyQueue[];
}
export declare class Mergify extends Component {
    private readonly rules;
    private readonly queues;
    private yamlFile?;
    constructor(github: GitHub, options?: MergifyOptions);
    private createYamlFile;
    addRule(rule: MergifyRule): void;
    addQueue(queue: MergifyQueue): void;
}
