import { TextFile } from "../textfile";
import { GitHub } from "./github";
/**
 * Options for `PullRequestTemplate`.
 */
export interface PullRequestTemplateOptions {
    /**
     * The contents of the template. You can use `addLine()` to add additional lines.
     *
     * @default - a standard default template will be created.
     */
    readonly lines?: string[];
}
/**
 * Template for GitHub pull requests.
 */
export declare class PullRequestTemplate extends TextFile {
    constructor(github: GitHub, options?: PullRequestTemplateOptions);
}
