import { GitIdentity } from ".";
import { JobStep } from "./workflows-model";
/**
 * A set of utility functions for creating GitHub actions in workflows.
 */
export declare class WorkflowActions {
    /**
     * Creates a .patch file from the current git diff and uploads it as an
     * artifact. Use `checkoutWithPatch` to download and apply in another job.
     *
     * If a patch was uploaded,
     *
     * @param options Options
     * @returns Job steps
     */
    static createUploadGitPatch(options: CreateUploadGitPatchOptions): JobStep[];
    /**
     * Checks out a repository and applies a git patch that was created using
     * `createUploadGitPatch`.
     *
     * @param options Options
     * @returns Job steps
     */
    static checkoutWithPatch(options?: CheckoutWithPatchOptions): JobStep[];
    /**
     * Configures the git identity (user name and email).
     * @param id The identity to use
     * @returns Job steps
     */
    static setGitIdentity(id: GitIdentity): JobStep[];
}
/**
 * Options for `checkoutWithPatch`.
 */
export interface CheckoutWithPatchOptions {
    /**
     * A GitHub token to use when checking out the repository.
     *
     * If the intent is to push changes back to the branch, then you must use a
     * PAT with `repo` (and possibly `workflows`) permissions.
     * @default - the default GITHUB_TOKEN is implicitly used
     */
    readonly token?: string;
    /**
     * Branch or tag name.
     * @default - the default branch is implicitly used
     */
    readonly ref?: string;
    /**
     * The repository (owner/repo) to use.
     * @default - the default repository is implicitly used
     */
    readonly repository?: string;
}
/**
 * Options for `createUploadGitPatch`.
 */
export interface CreateUploadGitPatchOptions {
    /**
     * The step ID which produces the output which indicates if a patch was created.
     */
    readonly stepId: string;
    /**
     * The name of the output to emit. It will be set to `true` if there was a diff.
     */
    readonly outputName: string;
    /**
     * Fail if a mutation was found and print this error message.
     * @default - do not fail upon mutation
     */
    readonly mutationError?: string;
}
