import { Project } from "..";
import { Component } from "../component";
import { NodeProject } from "../javascript";
import { Task } from "../task";
export interface EslintOptions {
    /**
     * Path to `tsconfig.json` which should be used by eslint.
     * @default "./tsconfig.json"
     */
    readonly tsconfigPath?: string;
    /**
     * Directories with source files to lint (e.g. [ "src" ])
     */
    readonly dirs: string[];
    /**
     * Directories with source files that include tests and build tools. These
     * sources are linted but may also import packages from `devDependencies`.
     * @default []
     */
    readonly devdirs?: string[];
    /**
     * File types that should be linted (e.g. [ ".js", ".ts" ])
     * @default [".ts"]
     */
    readonly fileExtensions?: string[];
    /**
     * List of file patterns that should not be linted, using the same syntax
     * as .gitignore patterns.
     *
     * @default [ '*.js', '*.d.ts', 'node_modules/', '*.generated.ts', 'coverage' ]
     */
    readonly ignorePatterns?: string[];
    /**
     * Projenrc file to lint. Use empty string to disable.
     * @default PROJEN_RC
     */
    readonly lintProjenRcFile?: string;
    /**
     * Should we lint .projenrc.js
     * @default true
     * @deprecated use lintProjenRcFile instead
     */
    readonly lintProjenRc?: boolean;
    /**
     * Enable prettier for code formatting
     * @default false
     */
    readonly prettier?: boolean;
    /**
     * Enable import alias for module paths
     * @default undefined
     */
    readonly aliasMap?: {
        [key: string]: string;
    };
    /**
     * Enable import alias for module paths
     * @default undefined
     */
    readonly aliasExtensions?: string[];
    /**
     * Always try to resolve types under `<root>@types` directory even it doesn't contain any source code.
     * This prevents `import/no-unresolved` eslint errors when importing a `@types/*` module that would otherwise remain unresolved.
     * @default true
     */
    readonly tsAlwaysTryTypes?: boolean;
    /**
     * Write eslint configuration as YAML instead of JSON
     * @default false
     */
    readonly yaml?: boolean;
}
/**
 * eslint rules override
 */
export interface EslintOverride {
    /**
     * Files or file patterns on which to apply the override
     */
    readonly files: string[];
    /**
     * The overriden rules
     */
    readonly rules?: {
        [rule: string]: any;
    };
    /**
     * The overridden parser
     */
    readonly parser?: string;
}
/**
 * Represents eslint configuration.
 */
export declare class Eslint extends Component {
    /**
     * Returns the singletone Eslint component of a project or undefined if there is none.
     */
    static of(project: Project): Eslint | undefined;
    /**
     * eslint rules.
     */
    readonly rules: {
        [rule: string]: any[];
    };
    /**
     * eslint overrides.
     */
    readonly overrides: EslintOverride[];
    /**
     * eslint task.
     */
    readonly eslintTask: Task;
    /**
     * Direct access to the eslint configuration (escape hatch)
     */
    readonly config: any;
    /**
     * File patterns that should not be linted
     */
    readonly ignorePatterns: string[];
    private _formattingRules;
    private readonly _allowDevDeps;
    private readonly _plugins;
    private readonly _extends;
    private readonly nodeProject;
    constructor(project: NodeProject, options: EslintOptions);
    /**
     * Add an eslint rule.
     */
    addRules(rules: {
        [rule: string]: any;
    }): void;
    /**
     * Adds an eslint plugin
     * @param plugins The names of plugins to add
     */
    addPlugins(...plugins: string[]): void;
    /**
     * Add an eslint override.
     */
    addOverride(override: EslintOverride): void;
    /**
     * Do not lint these files.
     */
    addIgnorePattern(pattern: string): void;
    /**
     * Adds an `extends` item to the eslint configuration.
     * @param extendList The list of "extends" to add.
     */
    addExtends(...extendList: string[]): void;
    /**
     * Add a glob file pattern which allows importing dev dependencies.
     * @param pattern glob pattern.
     */
    allowDevDeps(pattern: string): void;
    /**
     * Enables prettier for code formatting.
     */
    private enablePrettier;
    private renderDevDepsAllowList;
}
