"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Prettier = exports.TrailingComma = exports.QuoteProps = exports.ProseWrap = exports.HTMLWhitespaceSensitivity = exports.EndOfLine = exports.EmbeddedLanguageFormatting = exports.ArrowParens = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const ignore_file_1 = require("../ignore-file");
const json_1 = require("../json");
const source_code_1 = require("../source-code");
var ArrowParens;
(function (ArrowParens) {
    /**
     * Always include parens. Example: `(x) => x`
     */
    ArrowParens["ALWAYS"] = "always";
    /**
     * Omit parens when possible. Example: `x => x`
     */
    ArrowParens["AVOID"] = "avoid";
})(ArrowParens = exports.ArrowParens || (exports.ArrowParens = {}));
var EmbeddedLanguageFormatting;
(function (EmbeddedLanguageFormatting) {
    /**
     * Format embedded code if Prettier can automatically identify it.
     */
    EmbeddedLanguageFormatting["AUTO"] = "auto";
    /**
     * Never automatically format embedded code.
     */
    EmbeddedLanguageFormatting["OFF"] = "off";
})(EmbeddedLanguageFormatting = exports.EmbeddedLanguageFormatting || (exports.EmbeddedLanguageFormatting = {}));
var EndOfLine;
(function (EndOfLine) {
    /**
     * Maintain existing (mixed values within one file are normalised by looking
     * at what's used after the first line)
     */
    EndOfLine["AUTO"] = "auto";
    /**
     * Carriage Return character only (\r), used very rarely
     */
    EndOfLine["CR"] = "cr";
    /**
     * Carriage Return + Line Feed characters (\r\n), common on Windows
     */
    EndOfLine["CRLF"] = "crlf";
    /**
     * Line Feed only (\n), common on Linux and macOS as well as inside git repos
     */
    EndOfLine["LF"] = "lf";
})(EndOfLine = exports.EndOfLine || (exports.EndOfLine = {}));
var HTMLWhitespaceSensitivity;
(function (HTMLWhitespaceSensitivity) {
    /**
     * Respect the default value of CSS display property.
     */
    HTMLWhitespaceSensitivity["CSS"] = "css";
    /**
     * Whitespaces are considered insignificant.
     */
    HTMLWhitespaceSensitivity["IGNORE"] = "ignore";
    /**
     * Whitespaces are considered significant.
     */
    HTMLWhitespaceSensitivity["STRICT"] = "strict";
})(HTMLWhitespaceSensitivity = exports.HTMLWhitespaceSensitivity || (exports.HTMLWhitespaceSensitivity = {}));
var ProseWrap;
(function (ProseWrap) {
    /**
     * Wrap prose if it exceeds the print width.
     */
    ProseWrap["ALWAYS"] = "always";
    /**
     * Do not wrap prose.
     */
    ProseWrap["NEVER"] = "never";
    /**
     * Wrap prose as-is.
     */
    ProseWrap["PRESERVE"] = "preserve";
})(ProseWrap = exports.ProseWrap || (exports.ProseWrap = {}));
var QuoteProps;
(function (QuoteProps) {
    /**
     * Only add quotes around object properties where required.
     */
    QuoteProps["ASNEEDED"] = "as-needed";
    /**
     * If at least one property in an object requires quotes, quote all properties.
     */
    QuoteProps["CONSISTENT"] = "consistent";
    /**
     * Respect the input use of quotes in object properties.
     */
    QuoteProps["PRESERVE"] = "preserve";
})(QuoteProps = exports.QuoteProps || (exports.QuoteProps = {}));
var TrailingComma;
(function (TrailingComma) {
    /**
     * Trailing commas wherever possible (including function arguments).
     */
    TrailingComma["ALL"] = "all";
    /**
     * Trailing commas where valid in ES5 (objects, arrays, etc.)
     */
    TrailingComma["ES5"] = "es5";
    /**
     * No trailing commas.
     */
    TrailingComma["NONE"] = "none";
})(TrailingComma = exports.TrailingComma || (exports.TrailingComma = {}));
/**
 * Represents prettier configuration.
 */
class Prettier extends component_1.Component {
    constructor(project, options) {
        super(project);
        this._overrides = options.overrides ?? [];
        if (options.ignoreFile ?? true) {
            this.ignoreFile = new ignore_file_1.IgnoreFile(project, ".prettierignore");
        }
        project.addDevDeps("prettier");
        this.settings = {
            ...options.settings,
        };
        new json_1.JsonFile(project, ".prettierrc.json", {
            obj: () => ({ ...this.settings, overrides: [...this._overrides] }),
            marker: false,
        });
    }
    static of(project) {
        const isPrettier = (c) => c instanceof Prettier;
        return project.components.find(isPrettier);
    }
    /**
     * Add a prettier override
     * @see https://prettier.io/docs/en/configuration.html#configuration-overrides
     * @param {PrettierOverride} override
     */
    addOverride(override) {
        this.overrides.push(override);
    }
    /**
     * Defines Prettier ignore Patterns
     * these patterns will be added to the file .prettierignore
     *
     * @param pattern filepatterns so exclude from prettier formatting
     */
    addIgnorePattern(pattern) {
        this.ignoreFile?.addPatterns(pattern);
    }
    /**
     *  Access to the Prettieroverrides to extend those
     */
    get overrides() {
        return [...this._overrides];
    }
    preSynthesize() {
        // Add automatically generated SourceCode files to .prettierignore as they may not be formatted correctly.
        const isSourceCode = (c) => c instanceof source_code_1.SourceCode;
        this.project.components.filter(isSourceCode).forEach((c) => {
            this.addIgnorePattern(c.filePath);
        });
    }
}
exports.Prettier = Prettier;
_a = JSII_RTTI_SYMBOL_1;
Prettier[_a] = { fqn: "projen.javascript.Prettier", version: "0.65.85" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicHJldHRpZXIuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvamF2YXNjcmlwdC9wcmV0dGllci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLDRDQUF5QztBQUN6QyxnREFBNEM7QUFFNUMsa0NBQW1DO0FBRW5DLGdEQUE0QztBQW1NNUMsSUFBWSxXQVVYO0FBVkQsV0FBWSxXQUFXO0lBQ3JCOztPQUVHO0lBQ0gsZ0NBQWlCLENBQUE7SUFFakI7O09BRUc7SUFDSCw4QkFBZSxDQUFBO0FBQ2pCLENBQUMsRUFWVyxXQUFXLEdBQVgsbUJBQVcsS0FBWCxtQkFBVyxRQVV0QjtBQUVELElBQVksMEJBVVg7QUFWRCxXQUFZLDBCQUEwQjtJQUNwQzs7T0FFRztJQUNILDJDQUFhLENBQUE7SUFFYjs7T0FFRztJQUNILHlDQUFXLENBQUE7QUFDYixDQUFDLEVBVlcsMEJBQTBCLEdBQTFCLGtDQUEwQixLQUExQixrQ0FBMEIsUUFVckM7QUFFRCxJQUFZLFNBcUJYO0FBckJELFdBQVksU0FBUztJQUNuQjs7O09BR0c7SUFDSCwwQkFBYSxDQUFBO0lBRWI7O09BRUc7SUFDSCxzQkFBUyxDQUFBO0lBRVQ7O09BRUc7SUFDSCwwQkFBYSxDQUFBO0lBRWI7O09BRUc7SUFDSCxzQkFBUyxDQUFBO0FBQ1gsQ0FBQyxFQXJCVyxTQUFTLEdBQVQsaUJBQVMsS0FBVCxpQkFBUyxRQXFCcEI7QUFFRCxJQUFZLHlCQWVYO0FBZkQsV0FBWSx5QkFBeUI7SUFDbkM7O09BRUc7SUFDSCx3Q0FBVyxDQUFBO0lBRVg7O09BRUc7SUFDSCw4Q0FBaUIsQ0FBQTtJQUVqQjs7T0FFRztJQUNILDhDQUFpQixDQUFBO0FBQ25CLENBQUMsRUFmVyx5QkFBeUIsR0FBekIsaUNBQXlCLEtBQXpCLGlDQUF5QixRQWVwQztBQXdCRCxJQUFZLFNBZVg7QUFmRCxXQUFZLFNBQVM7SUFDbkI7O09BRUc7SUFDSCw4QkFBaUIsQ0FBQTtJQUVqQjs7T0FFRztJQUNILDRCQUFlLENBQUE7SUFFZjs7T0FFRztJQUNILGtDQUFxQixDQUFBO0FBQ3ZCLENBQUMsRUFmVyxTQUFTLEdBQVQsaUJBQVMsS0FBVCxpQkFBUyxRQWVwQjtBQUVELElBQVksVUFlWDtBQWZELFdBQVksVUFBVTtJQUNwQjs7T0FFRztJQUNILG9DQUFzQixDQUFBO0lBRXRCOztPQUVHO0lBQ0gsdUNBQXlCLENBQUE7SUFFekI7O09BRUc7SUFDSCxtQ0FBcUIsQ0FBQTtBQUN2QixDQUFDLEVBZlcsVUFBVSxHQUFWLGtCQUFVLEtBQVYsa0JBQVUsUUFlckI7QUFFRCxJQUFZLGFBZVg7QUFmRCxXQUFZLGFBQWE7SUFDdkI7O09BRUc7SUFDSCw0QkFBVyxDQUFBO0lBRVg7O09BRUc7SUFDSCw0QkFBVyxDQUFBO0lBRVg7O09BRUc7SUFDSCw4QkFBYSxDQUFBO0FBQ2YsQ0FBQyxFQWZXLGFBQWEsR0FBYixxQkFBYSxLQUFiLHFCQUFhLFFBZXhCO0FBRUQ7O0dBRUc7QUFDSCxNQUFhLFFBQVMsU0FBUSxxQkFBUztJQXNCckMsWUFBWSxPQUFvQixFQUFFLE9BQXdCO1FBQ3hELEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUVmLElBQUksQ0FBQyxVQUFVLEdBQUcsT0FBTyxDQUFDLFNBQVMsSUFBSSxFQUFFLENBQUM7UUFFMUMsSUFBSSxPQUFPLENBQUMsVUFBVSxJQUFJLElBQUksRUFBRTtZQUM5QixJQUFJLENBQUMsVUFBVSxHQUFHLElBQUksd0JBQVUsQ0FBQyxPQUFPLEVBQUUsaUJBQWlCLENBQUMsQ0FBQztTQUM5RDtRQUVELE9BQU8sQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLENBQUM7UUFFL0IsSUFBSSxDQUFDLFFBQVEsR0FBRztZQUNkLEdBQUcsT0FBTyxDQUFDLFFBQVE7U0FDcEIsQ0FBQztRQUVGLElBQUksZUFBUSxDQUFDLE9BQU8sRUFBRSxrQkFBa0IsRUFBRTtZQUN4QyxHQUFHLEVBQUUsR0FBRyxFQUFFLENBQUMsQ0FBQyxFQUFFLEdBQUcsSUFBSSxDQUFDLFFBQVEsRUFBRSxTQUFTLEVBQUUsQ0FBQyxHQUFHLElBQUksQ0FBQyxVQUFVLENBQUMsRUFBRSxDQUFDO1lBQ2xFLE1BQU0sRUFBRSxLQUFLO1NBQ2QsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztJQXhDTSxNQUFNLENBQUMsRUFBRSxDQUFDLE9BQWdCO1FBQy9CLE1BQU0sVUFBVSxHQUFHLENBQUMsQ0FBWSxFQUFpQixFQUFFLENBQUMsQ0FBQyxZQUFZLFFBQVEsQ0FBQztRQUMxRSxPQUFPLE9BQU8sQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQzdDLENBQUM7SUF1Q0Q7Ozs7T0FJRztJQUNJLFdBQVcsQ0FBQyxRQUEwQjtRQUMzQyxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsQ0FBQztJQUNoQyxDQUFDO0lBRUQ7Ozs7O09BS0c7SUFDSSxnQkFBZ0IsQ0FBQyxPQUFlO1FBQ3JDLElBQUksQ0FBQyxVQUFVLEVBQUUsV0FBVyxDQUFDLE9BQU8sQ0FBQyxDQUFDO0lBQ3hDLENBQUM7SUFFRDs7T0FFRztJQUNILElBQVcsU0FBUztRQUNsQixPQUFPLENBQUMsR0FBRyxJQUFJLENBQUMsVUFBVSxDQUFDLENBQUM7SUFDOUIsQ0FBQztJQUVNLGFBQWE7UUFDbEIsMEdBQTBHO1FBQzFHLE1BQU0sWUFBWSxHQUFHLENBQUMsQ0FBWSxFQUFtQixFQUFFLENBQ3JELENBQUMsWUFBWSx3QkFBVSxDQUFDO1FBQzFCLElBQUksQ0FBQyxPQUFPLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxZQUFZLENBQUMsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRTtZQUN6RCxJQUFJLENBQUMsZ0JBQWdCLENBQUMsQ0FBQyxDQUFDLFFBQVEsQ0FBQyxDQUFDO1FBQ3BDLENBQUMsQ0FBQyxDQUFDO0lBQ0wsQ0FBQzs7QUE1RUgsNEJBNkVDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ29tcG9uZW50IH0gZnJvbSBcIi4uL2NvbXBvbmVudFwiO1xuaW1wb3J0IHsgSWdub3JlRmlsZSB9IGZyb20gXCIuLi9pZ25vcmUtZmlsZVwiO1xuaW1wb3J0IHsgTm9kZVByb2plY3QgfSBmcm9tIFwiLi4vamF2YXNjcmlwdFwiO1xuaW1wb3J0IHsgSnNvbkZpbGUgfSBmcm9tIFwiLi4vanNvblwiO1xuaW1wb3J0IHsgUHJvamVjdCB9IGZyb20gXCIuLi9wcm9qZWN0XCI7XG5pbXBvcnQgeyBTb3VyY2VDb2RlIH0gZnJvbSBcIi4uL3NvdXJjZS1jb2RlXCI7XG4vKipcbiAqIE9wdGlvbnMgZm9yIFByZXR0aWVyXG4gKlxuICovXG5leHBvcnQgaW50ZXJmYWNlIFByZXR0aWVyT3B0aW9ucyB7XG4gIC8qKlxuICAgKiBEZWZpbmVzIGFuIC5wcmV0dGllcklnbm9yZSBmaWxlXG4gICAqXG4gICAqIEBkZWZhdWx0IHRydWVcbiAgICovXG4gIHJlYWRvbmx5IGlnbm9yZUZpbGU/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBQcmV0dGllciBzZXR0aW5ncy5cbiAgICogQGRlZmF1bHQgLSBkZWZhdWx0IHNldHRpbmdzXG4gICAqL1xuICByZWFkb25seSBzZXR0aW5ncz86IFByZXR0aWVyU2V0dGluZ3M7XG5cbiAgLyoqXG4gICAqIFByb3ZpZGUgYSBsaXN0IG9mIHBhdHRlcm5zIHRvIG92ZXJyaWRlIHByZXR0aWVyIGNvbmZpZ3VyYXRpb24uXG4gICAqXG4gICAqIEBkZWZhdWx0IFtdXG4gICAqIEBzZWUgaHR0cHM6Ly9wcmV0dGllci5pby9kb2NzL2VuL2NvbmZpZ3VyYXRpb24uaHRtbCNjb25maWd1cmF0aW9uLW92ZXJyaWRlc1xuICAgKi9cbiAgcmVhZG9ubHkgb3ZlcnJpZGVzPzogUHJldHRpZXJPdmVycmlkZVtdO1xufVxuLyoqXG4gKiBPcHRpb25zIHRvIHNldCBpbiBQcmV0dGllciBkaXJlY3RseSBvciB0aHJvdWdoIG92ZXJyaWRlc1xuICpcbiAqIEBzZWUgaHR0cHM6Ly9wcmV0dGllci5pby9kb2NzL2VuL29wdGlvbnMuaHRtbFxuICovXG5leHBvcnQgaW50ZXJmYWNlIFByZXR0aWVyU2V0dGluZ3Mge1xuICAvKipcbiAgICogSW5jbHVkZSBwYXJlbnRoZXNlcyBhcm91bmQgYSBzb2xlIGFycm93IGZ1bmN0aW9uIHBhcmFtZXRlci5cbiAgICpcbiAgICogQGRlZmF1bHQgQXJyb3dQYXJlbnMuQUxXQVlTXG4gICAqL1xuICByZWFkb25seSBhcnJvd1BhcmVucz86IEFycm93UGFyZW5zO1xuICAvKipcbiAgICogUHV0ID4gb2Ygb3BlbmluZyB0YWdzIG9uIHRoZSBsYXN0IGxpbmUgaW5zdGVhZCBvZiBvbiBhIG5ldyBsaW5lLlxuICAgKlxuICAgKiBAZGVmYXVsdCBmYWxzZVxuICAgKi9cbiAgcmVhZG9ubHkgYnJhY2tldFNhbWVMaW5lPzogYm9vbGVhbjtcbiAgLyoqXG4gICAqIFByaW50IHNwYWNlcyBiZXR3ZWVuIGJyYWNrZXRzLlxuICAgKlxuICAgKiBAZGVmYXVsdCB0cnVlXG4gICAqL1xuICByZWFkb25seSBicmFja2V0U3BhY2luZz86IGJvb2xlYW47XG4gIC8qKlxuICAgKiBQcmludCAodG8gc3RkZXJyKSB3aGVyZSBhIGN1cnNvciBhdCB0aGUgZ2l2ZW4gcG9zaXRpb24gd291bGQgbW92ZSB0byBhZnRlciBmb3JtYXR0aW5nLlxuICAgKiBUaGlzIG9wdGlvbiBjYW5ub3QgYmUgdXNlZCB3aXRoIC0tcmFuZ2Utc3RhcnQgYW5kIC0tcmFuZ2UtZW5kLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtMVxuICAgKi9cbiAgcmVhZG9ubHkgY3Vyc29yT2Zmc2V0PzogbnVtYmVyO1xuICAvKipcbiAgICogQ29udHJvbCBob3cgUHJldHRpZXIgZm9ybWF0cyBxdW90ZWQgY29kZSBlbWJlZGRlZCBpbiB0aGUgZmlsZS5cbiAgICpcbiAgICogQGRlZmF1bHQgRW1iZWRkZWRMYW5ndWFnZUZvcm1hdHRpbmcuQVVUT1xuICAgKi9cbiAgcmVhZG9ubHkgZW1iZWRkZWRMYW5ndWFnZUZvcm1hdHRpbmc/OiBFbWJlZGRlZExhbmd1YWdlRm9ybWF0dGluZztcbiAgLyoqXG4gICAqIFdoaWNoIGVuZCBvZiBsaW5lIGNoYXJhY3RlcnMgdG8gYXBwbHkuXG4gICAqXG4gICAqIEBkZWZhdWx0IEVuZE9mTGluZS5MRlxuICAgKi9cbiAgcmVhZG9ubHkgZW5kT2ZMaW5lPzogRW5kT2ZMaW5lO1xuICAvKipcbiAgICogU3BlY2lmeSB0aGUgaW5wdXQgZmlsZXBhdGguIFRoaXMgd2lsbCBiZSB1c2VkIHRvIGRvIHBhcnNlciBpbmZlcmVuY2UuXG4gICAqIEBkZWZhdWx0IG5vbmVcbiAgICovXG4gIHJlYWRvbmx5IGZpbGVwYXRoPzogc3RyaW5nO1xuICAvKipcbiAgICogSG93IHRvIGhhbmRsZSB3aGl0ZXNwYWNlcyBpbiBIVE1MLlxuICAgKlxuICAgKiBAZGVmYXVsdCBIVE1MV2hpdGVzcGFjZVNlbnNpdGl2aXR5LkNTU1xuICAgKi9cbiAgcmVhZG9ubHkgaHRtbFdoaXRlc3BhY2VTZW5zaXRpdml0eT86IEhUTUxXaGl0ZXNwYWNlU2Vuc2l0aXZpdHk7XG4gIC8qKlxuICAgKiBJbnNlcnQgQGZvcm1hdCBwcmFnbWEgaW50byBmaWxlJ3MgZmlyc3QgZG9jYmxvY2sgY29tbWVudC5cbiAgICpcbiAgICogQGRlZmF1bHQgZmFsc2VcbiAgICovXG4gIHJlYWRvbmx5IGluc2VydFByYWdtYT86IGJvb2xlYW47XG4gIC8qKlxuICAgKiBVc2Ugc2luZ2xlIHF1b3RlcyBpbiBKU1guXG4gICAqXG4gICAqIEBkZWZhdWx0IGZhbHNlXG4gICAqL1xuICByZWFkb25seSBqc3hTaW5nbGVRdW90ZT86IGJvb2xlYW47XG4gIC8qKlxuICAgKiBXaGljaCBwYXJzZXIgdG8gdXNlLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIFByZXR0aWVyIGF1dG9tYXRpY2FsbHkgaW5mZXJzIHRoZSBwYXJzZXIgZnJvbSB0aGUgaW5wdXQgZmlsZSBwYXRoLCBzbyB5b3Ugc2hvdWxkbuKAmXQgaGF2ZSB0byBjaGFuZ2UgdGhpcyBzZXR0aW5nLlxuICAgKi9cbiAgcmVhZG9ubHkgcGFyc2VyPzogc3RyaW5nO1xuICAvKipcbiAgICogQWRkIGEgcGx1Z2luLiBNdWx0aXBsZSBwbHVnaW5zIGNhbiBiZSBwYXNzZWQgYXMgc2VwYXJhdGUgYC0tcGx1Z2luYHMuXG4gICAqXG4gICAqIEBkZWZhdWx0IFtdXG4gICAqL1xuICByZWFkb25seSBwbHVnaW5zPzogc3RyaW5nW107XG4gIC8qKlxuICAgKiBDdXN0b20gZGlyZWN0b3J5IHRoYXQgY29udGFpbnMgcHJldHRpZXIgcGx1Z2lucyBpbiBub2RlX21vZHVsZXMgc3ViZGlyZWN0b3J5LlxuICAgKiBPdmVycmlkZXMgZGVmYXVsdCBiZWhhdmlvciB3aGVuIHBsdWdpbnMgYXJlIHNlYXJjaGVkIHJlbGF0aXZlbHkgdG8gdGhlIGxvY2F0aW9uIG9mXG4gICAqIFByZXR0aWVyLlxuICAgKiBNdWx0aXBsZSB2YWx1ZXMgYXJlIGFjY2VwdGVkLlxuICAgKlxuICAgKiBAZGVmYXVsdCBbXVxuICAgKi9cbiAgcmVhZG9ubHkgcGx1Z2luU2VhcmNoRGlycz86IHN0cmluZ1tdO1xuICAvKipcbiAgICogVGhlIGxpbmUgbGVuZ3RoIHdoZXJlIFByZXR0aWVyIHdpbGwgdHJ5IHdyYXAuXG4gICAqXG4gICAqIEBkZWZhdWx0IDgwXG4gICAqL1xuICByZWFkb25seSBwcmludFdpZHRoPzogbnVtYmVyO1xuICAvKipcbiAgICogSG93IHRvIHdyYXAgcHJvc2UuXG4gICAqXG4gICAqIEBkZWZhdWx0IFByb3NlV3JhcC5QUkVTRVJWRVxuICAgKi9cbiAgcmVhZG9ubHkgcHJvc2VXcmFwPzogUHJvc2VXcmFwO1xuICAvKipcbiAgICogQ2hhbmdlIHdoZW4gcHJvcGVydGllcyBpbiBvYmplY3RzIGFyZSBxdW90ZWQuXG4gICAqXG4gICAqIEBkZWZhdWx0IFF1b3RlUHJvcHMuQVNORUVERURcbiAgICovXG4gIHJlYWRvbmx5IHF1b3RlUHJvcHM/OiBRdW90ZVByb3BzO1xuICAvKipcbiAgICogRm9ybWF0IGNvZGUgZW5kaW5nIGF0IGEgZ2l2ZW4gY2hhcmFjdGVyIG9mZnNldCAoZXhjbHVzaXZlKS5cbiAgICogVGhlIHJhbmdlIHdpbGwgZXh0ZW5kIGZvcndhcmRzIHRvIHRoZSBlbmQgb2YgdGhlIHNlbGVjdGVkIHN0YXRlbWVudC5cbiAgICogVGhpcyBvcHRpb24gY2Fubm90IGJlIHVzZWQgd2l0aCAtLWN1cnNvci1vZmZzZXQuXG4gICAqXG4gICAqIEBkZWZhdWx0IG51bGxcbiAgICovXG4gIHJlYWRvbmx5IHJhbmdlRW5kPzogbnVtYmVyO1xuICAvKipcbiAgICogRm9ybWF0IGNvZGUgc3RhcnRpbmcgYXQgYSBnaXZlbiBjaGFyYWN0ZXIgb2Zmc2V0LlxuICAgKiBUaGUgcmFuZ2Ugd2lsbCBleHRlbmQgYmFja3dhcmRzIHRvIHRoZSBzdGFydCBvZiB0aGUgZmlyc3QgbGluZSBjb250YWluaW5nIHRoZSBzZWxlY3RlZFxuICAgKiBzdGF0ZW1lbnQuXG4gICAqIFRoaXMgb3B0aW9uIGNhbm5vdCBiZSB1c2VkIHdpdGggLS1jdXJzb3Itb2Zmc2V0LlxuICAgKlxuICAgKiBAZGVmYXVsdCAwXG4gICAqL1xuICByZWFkb25seSByYW5nZVN0YXJ0PzogbnVtYmVyO1xuICAvKipcbiAgICogUmVxdWlyZSBlaXRoZXIgJ0BwcmV0dGllcicgb3IgJ0Bmb3JtYXQnIHRvIGJlIHByZXNlbnQgaW4gdGhlIGZpbGUncyBmaXJzdCBkb2NibG9ja1xuICAgKiBjb21tZW50XG4gICAqIGluIG9yZGVyIGZvciBpdCB0byBiZSBmb3JtYXR0ZWQuXG4gICAqXG4gICAqIEBkZWZhdWx0IGZhbHNlXG4gICAqL1xuICByZWFkb25seSByZXF1aXJlUHJhZ21hPzogYm9vbGVhbjtcbiAgLyoqXG4gICAqIFByaW50IHNlbWljb2xvbnMuXG4gICAqXG4gICAqIEBkZWZhdWx0IHRydWVcbiAgICovXG4gIHJlYWRvbmx5IHNlbWk/OiBib29sZWFuO1xuICAvKipcbiAgICogVXNlIHNpbmdsZSBxdW90ZXMgaW5zdGVhZCBvZiBkb3VibGUgcXVvdGVzLlxuICAgKlxuICAgKiBAZGVmYXVsdCBmYWxzZVxuICAgKi9cbiAgcmVhZG9ubHkgc2luZ2xlUXVvdGU/OiBib29sZWFuO1xuICAvKipcbiAgICogTnVtYmVyIG9mIHNwYWNlcyBwZXIgaW5kZW50YXRpb24gbGV2ZWwuXG4gICAqXG4gICAqIEBkZWZhdWx0IDJcbiAgICovXG4gIHJlYWRvbmx5IHRhYldpZHRoPzogbnVtYmVyO1xuICAvKipcbiAgICogUHJpbnQgdHJhaWxpbmcgY29tbWFzIHdoZXJldmVyIHBvc3NpYmxlIHdoZW4gbXVsdGktbGluZS5cbiAgICpcbiAgICogQGRlZmF1bHQgVHJhaWxpbmdDb21tYS5FUzVcbiAgICovXG4gIHJlYWRvbmx5IHRyYWlsaW5nQ29tbWE/OiBUcmFpbGluZ0NvbW1hO1xuICAvKipcbiAgICogSW5kZW50IHdpdGggdGFicyBpbnN0ZWFkIG9mIHNwYWNlcy5cbiAgICpcbiAgICogQGRlZmF1bHQgZmFsc2VcbiAgICovXG4gIHJlYWRvbmx5IHVzZVRhYnM/OiBib29sZWFuO1xuICAvKipcbiAgICogSW5kZW50IHNjcmlwdCBhbmQgc3R5bGUgdGFncyBpbiBWdWUgZmlsZXMuXG4gICAqXG4gICAqIEBkZWZhdWx0IGZhbHNlXG4gICAqL1xuICByZWFkb25seSB2dWVJbmRlbnRTY3JpcHRBbmRTdHlsZT86IGJvb2xlYW47XG59XG5cbmV4cG9ydCBlbnVtIEFycm93UGFyZW5zIHtcbiAgLyoqXG4gICAqIEFsd2F5cyBpbmNsdWRlIHBhcmVucy4gRXhhbXBsZTogYCh4KSA9PiB4YFxuICAgKi9cbiAgQUxXQVlTID0gXCJhbHdheXNcIixcblxuICAvKipcbiAgICogT21pdCBwYXJlbnMgd2hlbiBwb3NzaWJsZS4gRXhhbXBsZTogYHggPT4geGBcbiAgICovXG4gIEFWT0lEID0gXCJhdm9pZFwiLFxufVxuXG5leHBvcnQgZW51bSBFbWJlZGRlZExhbmd1YWdlRm9ybWF0dGluZyB7XG4gIC8qKlxuICAgKiBGb3JtYXQgZW1iZWRkZWQgY29kZSBpZiBQcmV0dGllciBjYW4gYXV0b21hdGljYWxseSBpZGVudGlmeSBpdC5cbiAgICovXG4gIEFVVE8gPSBcImF1dG9cIixcblxuICAvKipcbiAgICogTmV2ZXIgYXV0b21hdGljYWxseSBmb3JtYXQgZW1iZWRkZWQgY29kZS5cbiAgICovXG4gIE9GRiA9IFwib2ZmXCIsXG59XG5cbmV4cG9ydCBlbnVtIEVuZE9mTGluZSB7XG4gIC8qKlxuICAgKiBNYWludGFpbiBleGlzdGluZyAobWl4ZWQgdmFsdWVzIHdpdGhpbiBvbmUgZmlsZSBhcmUgbm9ybWFsaXNlZCBieSBsb29raW5nXG4gICAqIGF0IHdoYXQncyB1c2VkIGFmdGVyIHRoZSBmaXJzdCBsaW5lKVxuICAgKi9cbiAgQVVUTyA9IFwiYXV0b1wiLFxuXG4gIC8qKlxuICAgKiBDYXJyaWFnZSBSZXR1cm4gY2hhcmFjdGVyIG9ubHkgKFxcciksIHVzZWQgdmVyeSByYXJlbHlcbiAgICovXG4gIENSID0gXCJjclwiLFxuXG4gIC8qKlxuICAgKiBDYXJyaWFnZSBSZXR1cm4gKyBMaW5lIEZlZWQgY2hhcmFjdGVycyAoXFxyXFxuKSwgY29tbW9uIG9uIFdpbmRvd3NcbiAgICovXG4gIENSTEYgPSBcImNybGZcIixcblxuICAvKipcbiAgICogTGluZSBGZWVkIG9ubHkgKFxcbiksIGNvbW1vbiBvbiBMaW51eCBhbmQgbWFjT1MgYXMgd2VsbCBhcyBpbnNpZGUgZ2l0IHJlcG9zXG4gICAqL1xuICBMRiA9IFwibGZcIixcbn1cblxuZXhwb3J0IGVudW0gSFRNTFdoaXRlc3BhY2VTZW5zaXRpdml0eSB7XG4gIC8qKlxuICAgKiBSZXNwZWN0IHRoZSBkZWZhdWx0IHZhbHVlIG9mIENTUyBkaXNwbGF5IHByb3BlcnR5LlxuICAgKi9cbiAgQ1NTID0gXCJjc3NcIixcblxuICAvKipcbiAgICogV2hpdGVzcGFjZXMgYXJlIGNvbnNpZGVyZWQgaW5zaWduaWZpY2FudC5cbiAgICovXG4gIElHTk9SRSA9IFwiaWdub3JlXCIsXG5cbiAgLyoqXG4gICAqIFdoaXRlc3BhY2VzIGFyZSBjb25zaWRlcmVkIHNpZ25pZmljYW50LlxuICAgKi9cbiAgU1RSSUNUID0gXCJzdHJpY3RcIixcbn1cblxuZXhwb3J0IGludGVyZmFjZSBQcmV0dGllck92ZXJyaWRlIHtcbiAgLyoqXG4gICAqIEV4Y2x1ZGUgdGhlc2UgZmlsZXMgZnJvbSB0aGlzIG92ZXJyaWRlLlxuICAgKi9cbiAgcmVhZG9ubHkgZXhjbHVkZUZpbGVzPzogRmlsZXM7XG4gIC8qKlxuICAgKiBJbmNsdWRlIHRoZXNlIGZpbGVzIGluIHRoaXMgb3ZlcnJpZGUuXG4gICAqL1xuICByZWFkb25seSBmaWxlczogRmlsZXM7XG4gIC8qKlxuICAgKiBUaGUgb3B0aW9ucyB0byBhcHBseSBmb3IgdGhpcyBvdmVycmlkZS5cbiAgICovXG4gIHJlYWRvbmx5IHNldHRpbmdzOiBQcmV0dGllclNldHRpbmdzO1xufVxuXG4vKipcbiAqIEV4Y2x1ZGUgdGhlc2UgZmlsZXMgZnJvbSB0aGlzIG92ZXJyaWRlLlxuICpcbiAqIEluY2x1ZGUgdGhlc2UgZmlsZXMgaW4gdGhpcyBvdmVycmlkZS5cbiAqL1xuZXhwb3J0IHR5cGUgRmlsZXMgPSBzdHJpbmdbXSB8IHN0cmluZztcblxuZXhwb3J0IGVudW0gUHJvc2VXcmFwIHtcbiAgLyoqXG4gICAqIFdyYXAgcHJvc2UgaWYgaXQgZXhjZWVkcyB0aGUgcHJpbnQgd2lkdGguXG4gICAqL1xuICBBTFdBWVMgPSBcImFsd2F5c1wiLFxuXG4gIC8qKlxuICAgKiBEbyBub3Qgd3JhcCBwcm9zZS5cbiAgICovXG4gIE5FVkVSID0gXCJuZXZlclwiLFxuXG4gIC8qKlxuICAgKiBXcmFwIHByb3NlIGFzLWlzLlxuICAgKi9cbiAgUFJFU0VSVkUgPSBcInByZXNlcnZlXCIsXG59XG5cbmV4cG9ydCBlbnVtIFF1b3RlUHJvcHMge1xuICAvKipcbiAgICogT25seSBhZGQgcXVvdGVzIGFyb3VuZCBvYmplY3QgcHJvcGVydGllcyB3aGVyZSByZXF1aXJlZC5cbiAgICovXG4gIEFTTkVFREVEID0gXCJhcy1uZWVkZWRcIixcblxuICAvKipcbiAgICogSWYgYXQgbGVhc3Qgb25lIHByb3BlcnR5IGluIGFuIG9iamVjdCByZXF1aXJlcyBxdW90ZXMsIHF1b3RlIGFsbCBwcm9wZXJ0aWVzLlxuICAgKi9cbiAgQ09OU0lTVEVOVCA9IFwiY29uc2lzdGVudFwiLFxuXG4gIC8qKlxuICAgKiBSZXNwZWN0IHRoZSBpbnB1dCB1c2Ugb2YgcXVvdGVzIGluIG9iamVjdCBwcm9wZXJ0aWVzLlxuICAgKi9cbiAgUFJFU0VSVkUgPSBcInByZXNlcnZlXCIsXG59XG5cbmV4cG9ydCBlbnVtIFRyYWlsaW5nQ29tbWEge1xuICAvKipcbiAgICogVHJhaWxpbmcgY29tbWFzIHdoZXJldmVyIHBvc3NpYmxlIChpbmNsdWRpbmcgZnVuY3Rpb24gYXJndW1lbnRzKS5cbiAgICovXG4gIEFMTCA9IFwiYWxsXCIsXG5cbiAgLyoqXG4gICAqIFRyYWlsaW5nIGNvbW1hcyB3aGVyZSB2YWxpZCBpbiBFUzUgKG9iamVjdHMsIGFycmF5cywgZXRjLilcbiAgICovXG4gIEVTNSA9IFwiZXM1XCIsXG5cbiAgLyoqXG4gICAqIE5vIHRyYWlsaW5nIGNvbW1hcy5cbiAgICovXG4gIE5PTkUgPSBcIm5vbmVcIixcbn1cblxuLyoqXG4gKiBSZXByZXNlbnRzIHByZXR0aWVyIGNvbmZpZ3VyYXRpb24uXG4gKi9cbmV4cG9ydCBjbGFzcyBQcmV0dGllciBleHRlbmRzIENvbXBvbmVudCB7XG4gIHB1YmxpYyBzdGF0aWMgb2YocHJvamVjdDogUHJvamVjdCk6IFByZXR0aWVyIHwgdW5kZWZpbmVkIHtcbiAgICBjb25zdCBpc1ByZXR0aWVyID0gKGM6IENvbXBvbmVudCk6IGMgaXMgUHJldHRpZXIgPT4gYyBpbnN0YW5jZW9mIFByZXR0aWVyO1xuICAgIHJldHVybiBwcm9qZWN0LmNvbXBvbmVudHMuZmluZChpc1ByZXR0aWVyKTtcbiAgfVxuICAvKipcbiAgICogRGlyZWN0IGFjY2VzcyB0byB0aGUgcHJldHRpZXIgc2V0dGluZ3NcbiAgICovXG4gIHB1YmxpYyByZWFkb25seSBzZXR0aW5nczogUHJldHRpZXJTZXR0aW5ncztcblxuICAvKipcbiAgICogVGhlIC5wcmV0dGllcklnbm9yZSBmaWxlLlxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IGlnbm9yZUZpbGU/OiBJZ25vcmVGaWxlO1xuXG4gIC8qKlxuICAgKiBEaXJlY3QgYWNjZXNzIHRvIHRoZSBwcmV0dGllciBvdmVycmlkZXNcbiAgICpcbiAgICogQGludGVybmFsXG4gICAqL1xuICBwcml2YXRlIHJlYWRvbmx5IF9vdmVycmlkZXM6IFByZXR0aWVyT3ZlcnJpZGVbXTtcblxuICBjb25zdHJ1Y3Rvcihwcm9qZWN0OiBOb2RlUHJvamVjdCwgb3B0aW9uczogUHJldHRpZXJPcHRpb25zKSB7XG4gICAgc3VwZXIocHJvamVjdCk7XG5cbiAgICB0aGlzLl9vdmVycmlkZXMgPSBvcHRpb25zLm92ZXJyaWRlcyA/PyBbXTtcblxuICAgIGlmIChvcHRpb25zLmlnbm9yZUZpbGUgPz8gdHJ1ZSkge1xuICAgICAgdGhpcy5pZ25vcmVGaWxlID0gbmV3IElnbm9yZUZpbGUocHJvamVjdCwgXCIucHJldHRpZXJpZ25vcmVcIik7XG4gICAgfVxuXG4gICAgcHJvamVjdC5hZGREZXZEZXBzKFwicHJldHRpZXJcIik7XG5cbiAgICB0aGlzLnNldHRpbmdzID0ge1xuICAgICAgLi4ub3B0aW9ucy5zZXR0aW5ncyxcbiAgICB9O1xuXG4gICAgbmV3IEpzb25GaWxlKHByb2plY3QsIFwiLnByZXR0aWVycmMuanNvblwiLCB7XG4gICAgICBvYmo6ICgpID0+ICh7IC4uLnRoaXMuc2V0dGluZ3MsIG92ZXJyaWRlczogWy4uLnRoaXMuX292ZXJyaWRlc10gfSksXG4gICAgICBtYXJrZXI6IGZhbHNlLFxuICAgIH0pO1xuICB9XG5cbiAgLyoqXG4gICAqIEFkZCBhIHByZXR0aWVyIG92ZXJyaWRlXG4gICAqIEBzZWUgaHR0cHM6Ly9wcmV0dGllci5pby9kb2NzL2VuL2NvbmZpZ3VyYXRpb24uaHRtbCNjb25maWd1cmF0aW9uLW92ZXJyaWRlc1xuICAgKiBAcGFyYW0ge1ByZXR0aWVyT3ZlcnJpZGV9IG92ZXJyaWRlXG4gICAqL1xuICBwdWJsaWMgYWRkT3ZlcnJpZGUob3ZlcnJpZGU6IFByZXR0aWVyT3ZlcnJpZGUpIHtcbiAgICB0aGlzLm92ZXJyaWRlcy5wdXNoKG92ZXJyaWRlKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBEZWZpbmVzIFByZXR0aWVyIGlnbm9yZSBQYXR0ZXJuc1xuICAgKiB0aGVzZSBwYXR0ZXJucyB3aWxsIGJlIGFkZGVkIHRvIHRoZSBmaWxlIC5wcmV0dGllcmlnbm9yZVxuICAgKlxuICAgKiBAcGFyYW0gcGF0dGVybiBmaWxlcGF0dGVybnMgc28gZXhjbHVkZSBmcm9tIHByZXR0aWVyIGZvcm1hdHRpbmdcbiAgICovXG4gIHB1YmxpYyBhZGRJZ25vcmVQYXR0ZXJuKHBhdHRlcm46IHN0cmluZykge1xuICAgIHRoaXMuaWdub3JlRmlsZT8uYWRkUGF0dGVybnMocGF0dGVybik7XG4gIH1cblxuICAvKipcbiAgICogIEFjY2VzcyB0byB0aGUgUHJldHRpZXJvdmVycmlkZXMgdG8gZXh0ZW5kIHRob3NlXG4gICAqL1xuICBwdWJsaWMgZ2V0IG92ZXJyaWRlcygpIHtcbiAgICByZXR1cm4gWy4uLnRoaXMuX292ZXJyaWRlc107XG4gIH1cblxuICBwdWJsaWMgcHJlU3ludGhlc2l6ZSgpIHtcbiAgICAvLyBBZGQgYXV0b21hdGljYWxseSBnZW5lcmF0ZWQgU291cmNlQ29kZSBmaWxlcyB0byAucHJldHRpZXJpZ25vcmUgYXMgdGhleSBtYXkgbm90IGJlIGZvcm1hdHRlZCBjb3JyZWN0bHkuXG4gICAgY29uc3QgaXNTb3VyY2VDb2RlID0gKGM6IENvbXBvbmVudCk6IGMgaXMgU291cmNlQ29kZSA9PlxuICAgICAgYyBpbnN0YW5jZW9mIFNvdXJjZUNvZGU7XG4gICAgdGhpcy5wcm9qZWN0LmNvbXBvbmVudHMuZmlsdGVyKGlzU291cmNlQ29kZSkuZm9yRWFjaCgoYykgPT4ge1xuICAgICAgdGhpcy5hZGRJZ25vcmVQYXR0ZXJuKGMuZmlsZVBhdGgpO1xuICAgIH0pO1xuICB9XG59XG4iXX0=