"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JsonPatch = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// copied fro https://github.com/cdk8s-team/cdk8s-core/blob/6b317a7a6a2504e228bc56bf96fc98829f88c2be/src/json-patch.ts
// under Apache 2.0 license
const fast_json_patch_1 = require("fast-json-patch");
/**
 * Utility for applying RFC-6902 JSON-Patch to a document.
 *
 * Use the the `JsonPatch.apply(doc, ...ops)` function to apply a set of
 * operations to a JSON document and return the result.
 *
 * Operations can be created using the factory methods `JsonPatch.add()`,
 * `JsonPatch.remove()`, etc.
 *
 * @example
 *
 *const output = JsonPatch.apply(input,
 *  JsonPatch.replace('/world/hi/there', 'goodbye'),
 *  JsonPatch.add('/world/foo/', 'boom'),
 *  JsonPatch.remove('/hello'));
 *
 */
class JsonPatch {
    constructor(operation) {
        this.operation = operation;
    }
    /**
     * Applies a set of JSON-Patch (RFC-6902) operations to `document` and returns the result.
     * @param document The document to patch
     * @param ops The operations to apply
     * @returns The result document
     */
    static apply(document, ...ops) {
        const result = fast_json_patch_1.applyPatch(document, ops.map((o) => o._toJson()));
        return result.newDocument;
    }
    /**
     * Adds a value to an object or inserts it into an array. In the case of an
     * array, the value is inserted before the given index. The - character can be
     * used instead of an index to insert at the end of an array.
     *
     * @example JsonPatch.add('/biscuits/1', { "name": "Ginger Nut" })
     */
    static add(path, value) {
        return new JsonPatch({ op: "add", path, value });
    }
    /**
     * Removes a value from an object or array.
     *
     * @example JsonPatch.remove('/biscuits')
     * @example JsonPatch.remove('/biscuits/0')
     */
    static remove(path) {
        return new JsonPatch({ op: "remove", path });
    }
    /**
     * Replaces a value. Equivalent to a “remove” followed by an “add”.
     *
     * @example JsonPatch.replace('/biscuits/0/name', 'Chocolate Digestive')
     */
    static replace(path, value) {
        return new JsonPatch({ op: "replace", path, value });
    }
    /**
     * Copies a value from one location to another within the JSON document. Both
     * from and path are JSON Pointers.
     *
     * @example JsonPatch.copy('/biscuits/0', '/best_biscuit')
     */
    static copy(from, path) {
        return new JsonPatch({ op: "copy", from, path });
    }
    /**
     * Moves a value from one location to the other. Both from and path are JSON Pointers.
     *
     * @example JsonPatch.move('/biscuits', '/cookies')
     */
    static move(from, path) {
        return new JsonPatch({ op: "move", from, path });
    }
    /**
     * Tests that the specified value is set in the document. If the test fails,
     * then the patch as a whole should not apply.
     *
     * @example JsonPatch.test('/best_biscuit/name', 'Choco Leibniz')
     */
    static test(path, value) {
        return new JsonPatch({ op: "test", path, value });
    }
    /**
     * Returns the JSON representation of this JSON patch operation.
     *
     * @internal
     */
    _toJson() {
        return this.operation;
    }
}
exports.JsonPatch = JsonPatch;
_a = JSII_RTTI_SYMBOL_1;
JsonPatch[_a] = { fqn: "projen.JsonPatch", version: "0.65.85" };
//# sourceMappingURL=data:application/json;base64,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