import { Component } from "../component";
import { TypeScriptProject } from "../typescript";
export interface ProjenrcOptions {
    /**
     * The name of the projenrc file.
     * @default ".projenrc.ts"
     */
    readonly filename?: string;
    /**
     * A directory tree that may contain *.ts files that can be referenced from
     * your projenrc typescript file.
     *
     * @default "projenrc"
     */
    readonly projenCodeDir?: string;
}
/**
 * Sets up a typescript project to use TypeScript for projenrc.
 */
export declare class Projenrc extends Component {
    private readonly rcfile;
    constructor(project: TypeScriptProject, options?: ProjenrcOptions);
    private generateProjenrc;
}
