"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VsCodeRecommendedExtensions = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const json_1 = require("../json");
/**
 * VS Code Workspace recommended extensions
 * Source: https://code.visualstudio.com/docs/editor/extension-marketplace#_workspace-recommended-extensions
 */
class VsCodeRecommendedExtensions extends component_1.Component {
    constructor(vscode) {
        super(vscode.project);
        /**
         * List of extensions which should be recommended for users of this workspace.
         * The identifier of an extension is always '${publisher}.${name}'. For example: 'ms-python.python'.
         *
         * @default - no recommendations are made
         */
        this.recommendations = [];
        /**
         * List of extensions recommended by VS Code that should not be recommended for users of this workspace.
         * The identifier of an extension is always '${publisher}.${name}'. For example: 'ms-python.python'.
         *
         * @default - no recommendations are marked unwanted
         */
        this.unwantedRecommendations = [];
        new json_1.JsonFile(vscode.project, ".vscode/extensions.json", {
            omitEmpty: true,
            allowComments: true,
            obj: {
                recommendations: this.recommendations,
                unwantedRecommendations: this.unwantedRecommendations,
            },
        });
    }
    /**
     * Adds a list of VS Code extensions as recommendations for this workspace.
     *
     * @param extensions The extension IDs
     */
    addRecommendations(...extensions) {
        this.recommendations.push(...extensions);
    }
    /**
     * Marks a list of VS Code extensions as unwanted recommendations for this workspace.
     * VS Code should not be recommend these extensions for users of this workspace.
     *
     * @param extensions The extension IDs
     */
    addUnwantedRecommendations(...extensions) {
        this.unwantedRecommendations.push(...extensions);
    }
}
exports.VsCodeRecommendedExtensions = VsCodeRecommendedExtensions;
_a = JSII_RTTI_SYMBOL_1;
VsCodeRecommendedExtensions[_a] = { fqn: "projen.vscode.VsCodeRecommendedExtensions", version: "0.65.85" };
//# sourceMappingURL=data:application/json;base64,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